<?php
/**
 * The file contains class that has functionality related to Frontend.
 *
 * @file class-mobix-frontend.php
 * @package MOBIX
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

if ( ! class_exists( 'Mobix_FrontEnd' ) ) {
	/**
	 * Class Mobix_FrontEnd
	 * This class displays SMS history on order page, enqueue css and js, send SMS on order status changed.
	 */
	class Mobix_FrontEnd {

		/**
		 * Mobix_FrontEnd constructor.
		 */
		public function __construct() {
			
			add_filter( 'wc_get_template', array( $this, 'load_custom_template' ), 10, 5 );
			add_action( 'wp_enqueue_scripts', array( $this, 'enqueue_scripts' ) );
		}

		/**
		 * Enqueue scripts for the front end.
		 */
		public function enqueue_scripts() {
			Global $mobix_otp;
			if(is_account_page() ){
				
			wp_enqueue_style( 'ml-frontend-style', MOBIX_URI . 'assets/css/frontend.min.css', array(), '1.0', 'all' );
			wp_enqueue_style( 'mobix-flags', MOBIX_URI.'/countries/flags.css', array(), '1.0', 'all'  );
			wp_enqueue_script( 'ml-frontend-js', MOBIX_URI . 'assets/js/frontend.js', array( 'jquery' ), '1.0', true );
					add_action('wp_head',array($this,'mobix_custom_style'));

					$phone = get_user_meta( get_current_user_id(), 'billing_phone', true );
					if ( ! empty( $phone ) ) {
						$data_arr['userPhone'] = $phone;
					}

					$data_arr['parentPage']  = '.woocommerce-checkout';
					$data_arr['currentPage'] = 'checkout';
					if ( is_account_page() ) {
						$data_arr['parentPage']  = '.woocommerce-MyAccount-content';
						$data_arr['currentPage'] = 'account';
					}
					$data_arr['utilsScript'] = MOBIX_URI . 'assets/js/utils.js';
					$data_arr['ajax_url']    = admin_url( 'admin-ajax.php' );
					$remove_zero = ! empty( $mobix_otp['remove-zero'] ) ? $mobix_otp['remove-zero'] : 1;
					$otp_resend = ! empty( $mobix_otp['otp-resend-wait'] ) ? $mobix_otp['otp-resend-wait'] : 20;
					$otp_digits = ! empty( $mobix_otp['otp-digits'] ) ? $mobix_otp['otp-digits'] : 4;
					$data_arr['strings'] = array(
						'enter_otp'    => "لطفا کد یکبار مصرف $otp_digits  رقمی را وارد نمایید!",
						'resend_otp_in' => esc_html__('Resend OTP in:', 'mobix'),
						'resend' => esc_html__('Resend', 'mobix'),
						'remove_zero' => $remove_zero,
						'otp_resend' => intval($otp_resend),
						'otp_digits' => intval($otp_digits ),
						'change_phone' => esc_html__('Change Phone?', 'mobix'),
						'otp_sent_to' => esc_html__('A OTP (One Time Passcode) has been sent to ', 'mobix'),
						'enter_otp_to_field' => esc_html__('Please enter the OTP in the field below to verify your phone.', 'mobix'),
						'didt_recieved_otp' => esc_html__("Didn't receive OTP? Resend in", 'mobix'),
						'seconds' => esc_html__("seconds", 'mobix'),
						'continue' => esc_html__("Continue", 'mobix'),
						'resend_otp_now' => esc_html__("Didn't receive OTP? Resend Now", 'mobix'),
						'faild_to_send_otp' => esc_html__('Failed to send OTP to', 'mobix'),
						'please_try_again' => esc_html__('Please try again.', 'mobix'),
						'possible_reason' => esc_html__('Possible Reason.', 'mobix'),
						'is_required_field' => esc_html__('is a required field.', 'mobix'),
						'create_an_account' => esc_html__('Create an Account', 'mobix'),
						'continue_to_next_step' => esc_html__('Continue to Next Step', 'mobix'),
						'billing' => esc_html__('Billing', 'mobix'),
						'shipping' => esc_html__('Shipping', 'mobix'),
						'invalid_number' => esc_html__('Invalid number', 'mobix'),
						'invalid_country_code' => esc_html__('Invalid country code', 'mobix'),
						'phone_number_too_short' => esc_html__('Phone number too short', 'mobix'),
						'phone_number_too_long' => esc_html__('Phone number too long', 'mobix'),
						'phone_validation_error' => esc_html__('Phone validation error', 'mobix'),
						'internal_error' => esc_html__('Internal Error', 'mobix'),
						'is_not_a_valid_phone' => esc_html__('is not a valid phone number. Please enter a valid Phone Number. E.g:', 'mobix'),
					);

					wp_localize_script( 'ml-frontend-js', 'mobix', $data_arr );
				if($mobix_otp['register-default-form'] === '1'){
					if( isset( $_GET['action']) && $_GET['action'] == "register"){
						wp_dequeue_script( 'ml-frontend-js' );
					}
				}
			}
		}

		/**
		 * Load custom template.
		 *
		 * @param string $template Current template.
		 * @param string $template_name Template name.
		 * @param array  $args          Arguments. (default: array).
		 * @param string $template_path Template path. (default: '').
		 * @param string $default_path  Default path. (default: '').
		 * @return string
		 */
		public function load_custom_template( $template, $template_name, $args, $template_path, $default_path ) {
			if ( 'myaccount/form-login.php' === $template_name ) {
				$tmp = MOBIX_DIR . 'templates/woocommerce/' . $template_name;

				if ( file_exists( $tmp ) ) {
					$template = $tmp;
				}
			}

			return $template;
		}
		public function mobix_custom_style(){
			$mobix_otp = get_option( 'mobixOtp' );
			echo'<style>' . $mobix_otp["style-css"]. '</style>';
		}
	}

	new Mobix_FrontEnd();
}
