<?php

class Mobix_farazsms extends MobixSms {

	protected static $_instance = null;


	public static function get_instance() {
		if ( is_null( self::$_instance ) ) {
			self::$_instance = new self();
		}

		return self::$_instance;
	}

	public static function nusoap() {
		require_once plugin_dir_path( __FILE__ ) . 'lib/nusoap.php';
	}
	public function send() {
		Global $mobix_otp;
			$api_url = 'http://ippanel.com/class/sms/wsdlservice/server.php?wsdl';
			$messageContent = $this->message;	
			$to             = $this->to;
			$username 		= $mobix_otp['otp_farazsms']['username'];
			$password 		= $mobix_otp['otp_farazsms']['password'];
			$from     		= $mobix_otp['otp_farazsms']['sender'];
			$pid      		= $mobix_otp['otp_farazsms']['pid'];

			self::nusoap();

			$client                   = new nusoap_client( $api_url );
			$client->soap_defencoding = 'UTF-8';
			$client->decode_utf8      = true;
			$action  = 'sendPatternSms';
			$args = [
				'fromNum'      => $from,
				'toNum'        => $to,
				'user'         => $username,
				'pass'         => $password,
				'pattern_code' => $pid,
				'input_data'   => array("otp" => $messageContent),
			];


			$result = $client->call( $action, $args );
			$response = json_decode($result);
			if ( 0 === $response || strlen($response) >= 5) {
				set_transient( $to, $messageContent, 600 );
				$status = 'success';
			} else {
				$status = 'failed';
				$msg    = '4' === $response ->status ? __(' : Bad Credentials', 'mobix') : __('error code: ','mobix') . $result;
			}
			wp_send_json_success(
				array(
					'status' => $status,
					'msg'    => $msg,
				)
			);
	}
}
?>
