<?php
//Exit if accessed directly
if(!defined('ABSPATH')){
	return;
}
$country_phone_codes = (array) include MOBIX_DIR.'/countries/phone.php';
$phone_codes = array();
foreach ( $country_phone_codes as $cc => $pc ) {
	if( !$pc || is_array( $pc ) ) continue;
	$phone_codes[ $pc ] = $cc.' '.$pc;
}

// Control core classes for avoid errors
if( class_exists( 'CSF' ) ) {

  //
  // Set a unique slug-like ID
  $prefix = 'mobixOtp';

  //
  // Create options
  CSF::createOptions( $prefix, array(
    'menu_title' => __('تنظیمات موبیکس','mobix'),
    'menu_slug'  => 'mobixOtp',
  ) );

  //
  // Create a section
  CSF::createSection( $prefix, array(
    'title'  => 'همگانی',
    'fields' => array(

      //
      // A text field
		
	array(
	  'id'    => 'remove-zero',
	  'type'  => 'switcher',
	  'default' => true,
	  'title' => __('حذف صفراز شماره','mobix'),
	  'label' => __('حذف صفر از ابتدای شماره موبایل','mobix'),
	),
		
	/*** sub head ***/
	array(
	  'type'    => 'subheading',
	  'content' => __('تنظیمات کد یکبار مصرف','mobix'),
	),
		array(
          'id'    => 'otp-digits',
          'type'  => 'text',
          'title' => __('تعداد ارقام کد تایید','mobix'),
		  'default' => 4,
        ),
		array(
          'id'    => 'otp-resend-wait',
          'type'  => 'text',
          'title' => __('زمان انتظار ارسال مجدد کدیکبار مصرف','mobix'),
		  'default' => '20',
        ),
	
	/*** sub head ***/
	array(
	  'type'    => 'subheading',
	  'content' => __('تنظیمات فرم','mobix'),
	),	
		array(
		  'id'    => 'register-country',
		  'type'  => 'switcher',
		  'default' => true,
		  'title' => __('کدکشور','mobix'),
		  'label' => __('یک شماره تلفن معتبر نیاز به کد کشور دارد. اگر غیرفعال باشد، کد پیش‌فرض انتخاب شده در زیر به عنوان کد کشور تنظیم می‌شود.','mobix'),
		),
		array(
		  'id' 			=> 'register-country-custom',
          'type'        => 'select',
          'title'       => __('کدکشور','mobix'),
          'placeholder' => __('انتخاب نمایید','mobix'),
		  'default'		=> '+98',
          'options'     => $phone_codes
        ),
		array(
		  'id'    => 'register-default-form',
		  'type'  => 'switcher',
		  'default' => true,
		  'title' => __('ثبت نام با فرم پیشفرض','mobix'),
		  'label' => __('امکان ثبت نام با فرم پیشفرض ووکامرس فعال باشد؟','mobix'),
		),
		array(
		  'id'    => 'login-default-form',
		  'type'  => 'switcher',
		  'default' => true,
		  'title' => __('ورود با فرم پیشفرض','mobix'),
		  'label' => __('امکان ورود با فرم پیشفرض فعال باشد؟','mobix'),
		),
		array(
          'id'    => 'otp_metakey',
          'type'  => 'textarea',
          'title' => __('متا دیتای کاربر برای چک کردن شماره موبایل','mobix'),
		  'default' => __('billing_phone,digits_phone,mobix_phone_display','mobix'),
        ),
	array(
	  'type'    => 'subheading',
	  'content' => __('متن ها','mobix'),
	),	
	array(
	  'id'    => 'mobix_reg_email',
	  'type'  => 'text',
	  'title' => __('متن دکمه ثبت نام با ایمیل','mobix'),
	  'default' => 'ثبت نام با ایمیل',
	),
	array(
	  'id'    => 'mobix_log_email',
	  'type'  => 'text',
	  'title' => __('متن دکمه ورود با ایمیل','mobix'),
	  'default' => 'ورود با ایمیل',
	),array(
	  'id'    => 'mobix_phone',
	  'type'  => 'text',
	  'title' => __('متن دکمه ثبت نام و ورود با کد یکبار مصرف','mobix'),
	  'default' => 'ثبت نام و ورود با کد یکبار مصرف',
	),
	array(
	  'type'    => 'subheading',
	  'content' => __('رنگبندی','mobix'),
	),
	array(
	  'id'      => 'mobix_log_color',
	  'type'    => 'color',
	  'title'   => __('رنگ دکمه ورود با ایمیل','digix'),
	  'default' => '#ffa500',
	),
	array(
	  'id'      => 'mobix_reg_color',
	  'type'    => 'color',
	  'title'   => __('رنگ دکمه ثبت نام با ایمیل','digix'),
	  'default' => '#0000ff',
	),
	
	
	
    )
	
  ) );
  

  //
  // Create a section
  CSF::createSection( $prefix, array(
    'title'  => 'اپراتور',
    'fields' => array(

      // A textarea field
		array(
			'id'          => 'operator',
			'type'        => 'select',
			'title'       => __('وب سرویس','mobix'),
			'placeholder' => __('ارائه دهنده وب سرویس را انتخاب نمایید','mobix'),
			'options'     => array(
				'smsir'    	=> __('ایده پردازان (sms.ir)','mobix'),
				'farazsms'      => __('فراز اس ام اس','mobix'),
				'melipayamak'   => __('ملی پیامک','mobix'),
				'kavenegar'    	=> __('کاوه نگار','mobix'),
				'maxsms'    	=> __('مکس اس ام اس','mobix'),
				'ippanel'    	=> __('آی پی پنل','mobix'),
			),
		),
		array(
		  'id'     => 'otp_smsir',
		  'type'   => 'fieldset',
		  'title'  => __('ایده پردازان (sms.ir)','mobix'),
		  'dependency' => array( 'operator', '==', 'smsir' ),
		  'fields' => array(
			array(
			  'id'    => 'api',
			  'type'  => 'text',
			  'title' => __('کلید دسترسی(api)','mobix'),
			),
			array(
			  'id'    => 'pid',
			  'type'  => 'text',
			  'title' => __('کد پترن','mobix'),
			),
		  ),
		),
		array(
		  'id'     => 'otp_farazsms',
		  'type'   => 'fieldset',
		  'title'  => 'فراز اس ام اس',
		  'dependency' => array( 'operator', '==', 'farazsms' ),
		  'fields' => array(
			array(
			  'id'    => 'username',
			  'type'  => 'text',
			  'title' => __('نام کاربری','mobix'),
			),
			array(
			  'id'    => 'password',
			  'type'  => 'text',
			  'title' => __('پسورد','mobix'),
			),
			array(
			  'id'    => 'sender',
			  'type'  => 'text',
			  'title' => __('شماره ارسال کننده','mobix'),
			),
			array(
			  'id'    => 'pid',
			  'type'  => 'text',
			  'title' => __('کد پترن','mobix'),
			),
		  ),
		),
		array(
		  'id'     => 'otp_melipayamak',
		  'type'   => 'fieldset',
		  'title'  => __('ملی پیامک','mobix'),
		  'dependency' => array( 'operator', '==', 'melipayamak' ),
		  'fields' => array(
			array(
			  'id'    => 'username',
			  'type'  => 'text',
			  'title' => __('نام کاربری','mobix'),
			),
			array(
			  'id'    => 'password',
			  'type'  => 'text',
			  'title' => __('پسورد','mobix'),
			),
			array(
			  'id'    => 'sender',
			  'type'  => 'text',
			  'title' => __('شماره ارسال کننده','mobix'),
			),
			array(
			  'id'    => 'pid',
			  'type'  => 'text',
			  'title' => __('کد پترن','mobix'),
			),
		  ),
		),
		array(
		  'id'     => 'otp_kavenegar',
		  'type'   => 'fieldset',
		  'title'  => __('کاوه نگار','mobix'),
		  'dependency' => array( 'operator', '==', 'kavenegar' ),
		  'fields' => array(
			array(
			  'id'    => 'api',
			  'type'  => 'text',
			  'title' => __('کلید دسترسی(api)','mobix'),
			),
			array(
			  'id'    => 'sender',
			  'type'  => 'text',
			  'title' => __('شماره ارسال کننده','mobix'),
			),
			array(
			  'id'    => 'pattern',
			  'type'  => 'text',
			  'title' => __('کد پترن','mobix'),
			),
		  ),
		),
		array(
		  'id'     => 'otp_maxsms',
		  'type'   => 'fieldset',
		  'title'  => __('مکس اس ام اس','mobix'),
		  'dependency' => array( 'operator', '==', 'maxsms' ),
		  'fields' => array(
			array(
			  'id'    => 'username',
			  'type'  => 'text',
			  'title' => __('نام کاربری','mobix'),
			),
			array(
			  'id'    => 'password',
			  'type'  => 'text',
			  'title' => __('پسورد','mobix'),
			),
			array(
			  'id'    => 'sender',
			  'type'  => 'text',
			  'title' => __('شماره ارسال کننده','mobix'),
			),
			array(
			  'id'    => 'pid',
			  'type'  => 'text',
			  'title' => __('کد پترن','mobix'),
			),
		  ),
		),
		array(
		  'id'     => 'otp_ippanel',
		  'type'   => 'fieldset',
		  'title'  => __('آی پی پنل','mobix'),
		  'dependency' => array( 'operator', '==', 'ippanel' ),
		  'fields' => array(
			array(
			  'id'    => 'username',
			  'type'  => 'text',
			  'title' => __('نام کاربری','mobix'),
			),
			array(
			  'id'    => 'password',
			  'type'  => 'text',
			  'title' => __('پسورد','mobix'),
			),
			array(
			  'id'    => 'sender',
			  'type'  => 'text',
			  'title' => __('شماره ارسال کننده','mobix'),
			),
			array(
			  'id'    => 'pid',
			  'type'  => 'text',
			  'title' => __('کد پترن','mobix'),
			),
		  ),
		),
    )
  ) );
  CSF::createSection( $prefix, array(
      'title'  => __('استایل','mobix'),
      'fields' => array(
  
			// field
			array(
			  'id'       => 'style-css',
			  'type'     => 'code_editor',
			  'title'    => __('درج کد های دلخواه','mobix'),
			  'subtitle' => 'کد استایل ( css )',
			  'settings' => array(
				'theme'  => 'mbo',
				'mode'   => 'css',
				),
			),
  
      )
    ) );

}

$mobix_otp = get_option( 'mobixOtp' );
global $mobix_otp;