<section class="digix-wc-register digix-form">

	<h2><?php esc_html_e( 'Register', 'woocommerce' ); ?></h2>
	<?php if ( isset( $options['general-logo'] ) && !empty( $options['general-logo'] ) ):?>
		<a href="<?php echo esc_url( home_url() ); ?>" class="im-uri" itemscope itemtype="http://schema.org/Organization" itemprop="url">
						
			<img src="<?php echo $options['general-logo']; ?>" alt="<?php echo $options['general-title']; ?>" class="img-fluid" itemprop="logo">
		
		</a>
	<?php endif; ?>
	<form method="post" class="woocommerce-form woocommerce-form-register register" <?php do_action( 'woocommerce_register_form_tag' ); ?> >

		<?php do_action( 'woocommerce_register_form_start' ); ?>

		<?php if ( 'no' === get_option( 'woocommerce_registration_generate_username' ) ) : ?>

			<p class="woocommerce-form-row woocommerce-form-row--wide form-row form-row-wide">
				<label for="reg_username"><?php esc_html_e( 'Username', 'woocommerce' ); ?>&nbsp;<span class="required">*</span><i class="icon-user"></i></label>
				<input type="text" class="woocommerce-Input woocommerce-Input--text input-text" name="username" id="reg_username" autocomplete="username" value="<?php echo ( ! empty( $_POST['username'] ) ) ? esc_attr( wp_unslash( $_POST['username'] ) ) : ''; ?>" /><?php // @codingStandardsIgnoreLine ?>
			</p>

		<?php endif; ?>

		<p class="woocommerce-form-row woocommerce-form-row--wide form-row form-row-wide">
			<label for="reg_email"><?php esc_html_e( 'Email address', 'woocommerce' ); ?>&nbsp;<span class="required">*</span><i class="icon-mail"></i></label>
			<input type="email" class="woocommerce-Input woocommerce-Input--text input-text" name="email" id="reg_email" autocomplete="email" value="<?php echo ( ! empty( $_POST['email'] ) ) ? esc_attr( wp_unslash( $_POST['email'] ) ) : ''; ?>" /><?php // @codingStandardsIgnoreLine ?>
		</p>

		<?php if ( 'no' === get_option( 'woocommerce_registration_generate_password' ) ) : ?>

			<p class="woocommerce-form-row woocommerce-form-row--wide form-row form-row-wide">
				<label for="reg_password"><?php esc_html_e( 'Password', 'woocommerce' ); ?>&nbsp;<span class="required">*</span><i class="icon-key"></i></label>
				<input type="password" class="woocommerce-Input woocommerce-Input--text input-text" name="password" id="reg_password" autocomplete="new-password" />
			</p>

		<?php else : ?>

			<p><?php esc_html_e( 'A link to set a new password will be sent to your email address.', 'woocommerce' ); ?></p>

		<?php endif; ?>

		<?php do_action( 'woocommerce_register_form' ); ?>

		<p class="woocommerce-form-row form-row">
			<?php wp_nonce_field( 'woocommerce-register', 'woocommerce-register-nonce' ); ?>
			<button style="margin-bottom:15px;" type="submit" class="woocommerce-Button woocommerce-button button<?php echo esc_attr( wc_wp_theme_get_element_class_name( 'button' ) ? ' ' . wc_wp_theme_get_element_class_name( 'button' ) : '' ); ?> woocommerce-form-register__submit" name="register" value="<?php esc_attr_e( 'Register', 'woocommerce' ); ?>"><?php esc_html_e( 'Register', 'woocommerce' ); ?></button>
		</p>
		
		<?php do_action( 'woocommerce_register_form_end' ); ?>
	</form>
	<div class="digix-default-form">
		<?php 
		$login = get_permalink( get_option('woocommerce_myaccount_page_id') ) . '?action=login';
		$phone = get_permalink( get_option('woocommerce_myaccount_page_id') );
		if($mobix_otp['login-default-form'] === '1'){
			echo "<a class='lg' href='" . $login. "' style='color:".$mobix_otp['mobix_log_color'].";border-color:".$mobix_otp['mobix_log_color'].";'>" . $mobix_otp['mobix_log_email']. "</a>";
		}
		echo "<a class='rg' href='" . $phone. "' style='color:".$mobix_otp['mobix_reg_color'].";border-color:".$mobix_otp['mobix_reg_color'].";'>" . $mobix_otp['mobix_phone']. "</a>";
		?>
	</div>
</section>