<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( ! class_exists( 'WC_Shipping_Iran_Peyk' ) ) {
	class WC_Shipping_Iran_Peyk extends WC_Shipping_Method {
		
		/**
		 * Constructor for shipping class
		 *
		 * @access public
		 * @return void
		 */
		public function __construct() {
			$this->id                 = 'iran_peyk_shipping'; // Id for your shipping method. Should be uunique.
			$this->method_title       = 'پیک موتوری';  // Title shown in admin
			$this->method_description = '<h3>روش حمل پیک موتوری برای ووکامرس</h3>
			<p style="text-align: justify;">این روش پیک موتوری را فعال می کند. با توجه به اینکه تعدد نرخ ها بسیار زیاد است، در این روش مبلغ کرایه در مقصد دریافت می شود. با تنظیم استان و شهر مبدا به عنوان مبدا ارسال کننده، چنانچه استان و شهر مقصد با استان و شهر مبدا یکی باشد، این روش در هنگام سفارش فعال خواهد شد. در صورتی که می خواهید تا کل استان را در نظر بگیرید، نام شهر را خالی بگذارید و استان را تعیین کنید.
			<a href="https://parsmizban.com" target="_blank">جهت مشاهده دیگر افزونه های ایجاد شده ما و دیگر سرویس های ما اینجا را کلیک نمائید.</a></p>'; // Description shown in admin
			$this->init();
		}

		/**
		 * Init your settings
		 *
		 * @access public
		 * @return void
		 */
		function init() {
			// Load the settings API
			$this->init_form_fields(); // This is part of the settings API. Override the method to add your own settings
			$this->init_settings(); // This is part of the settings API. Loads settings you previously init.

			// Define user set variables
			$this->enabled					= $this->get_option( 'enabled' );
			$this->title							= $this->get_option( 'title' );
			$this->source_state			= $this->get_option( 'source_state' );
			$this->source_city				= $this->get_option( 'source_city' );
			$this->fix_price					= $this->get_option( 'fix_price' );
			$this->current_currency		= get_woocommerce_currency(); // IRR or IRT or IRHT
			$this->current_weight_unit	= get_option('woocommerce_weight_unit'); // g or kg

			// Save settings in admin if you have any defined
			add_action( 'woocommerce_update_options_shipping_' . $this->id, array( $this, 'process_admin_options' ) );
		}

		/**
		 * Initialise Gateway Settings Form Fields
		 *
		 * @access public
		 * @return void
		 */
		public function init_form_fields() {
			$this->form_fields = array(
				'enabled' => array(
					'title' 		=> 'فعال/غیر فعال',
					'type' 			=> 'checkbox',
					'label' 		=> 'فعال کردن این روش حمل و نقل',
					'default' 		=> 'no',
				),
				'title' => array(
					'title' 		=> 'عنوان روش',
					'type' 			=> 'text',
					'description' 	=> 'این گزینه عنوان را کنترل می کند که کاربر در طول تسویه حساب مشاهده می کند. در صورتی که هزینه ثابتی را برای پیک در نظر گرفته اید و می خواهید در هنگام سفارش، هزینه پیک را دریافت نمایید، عبارت (هزینه پیک، هنگام تحویل بسته دریافت میشود) را حذف نمایید.',
					'default'		=> 'پیک موتوری (هزینه پیک، هنگام تحویل بسته دریافت میشود)',
					'desc_tip'		=> true
				),
				'source_state' => array(
					'title' 		=> 'استان مبدا (فروشنده)',
					'type' 			=> 'select',
					'description' 	=> 'لطفا در این قسمت استانی که پیک در آنجا فعال می باشد را انتخاب نمایید',
					'default'		=> 'THR',
					'desc_tip'		=> true,
					'options' 		=> array(
						'EAZ' => 'آذربایجان شرقی',
						'WAZ' => 'آذربایجان غربی',
						'ADL' => 'اردبیل',
						'ESF' => 'اصفهان',
						'ABZ' => 'البرز',
						'ILM' => 'ایلام',
						'BHR' => 'بوشهر',
						'THR' => 'تهران',
						'CHB' => 'چهارمحال و بختیاری',
						'SKH' => 'خراسان جنوبی',
						'RKH' => 'خراسان رضوی',
						'NKH' => 'خراسان شمالی',
						'KHZ' => 'خوزستان',
						'ZJN' => 'زنجان',
						'SMN' => 'سمنان',
						'SBN' => 'سیستان و بلوچستان',
						'FRS' => 'فارس',
						'GZN' => 'قزوین',
						'QHM' => 'قم',
						'KRD' => 'کردستان',
						'KRN' => 'کرمان',
						'KRH' => 'کرمانشاه',
						'KBD' => 'کهگیلویه و بویراحمد',
						'GLS' => 'گلستان',
						'GIL' => 'گیلان',
						'LRS' => 'لرستان',
						'MZN' => 'مازندران',
						'MKZ' => 'مرکزی',
						'HRZ' => 'هرمزگان',
						'HDN' => 'همدان',
						'YZD' => 'یزد',
					)
				),
				'source_city' => array(
					'title' 		=> 'شهر مبدا (فروشنده)',
					'type' 			=> 'text',
					'description' 	=> 'ارسال پیک فقط در این شهر فعال می باشد.',
					'default'		=> '',
					'desc_tip'		=> true
				),
				'fix_price' => array(
					'title' 		=> 'کرایه ثابت (مبلغ به ریال)',
					'type' 			=> 'text',
					'description' 	=> 'در صورتی که مایلید تا کرایه ثابتی برای پیک موتوری در نظر بگیرید، این مقدار را به ریال وارد نمایید، در غیر اینصورت اگر می خواهید مبلغ به صورت پس کرایه در هنگام تحویل بسته محاسبه شود، این مقدار را خالی بگذارید',
					'default'		=> '',
					'desc_tip'		=> true
				),
			);
		}

		/**
		 * calculate_shipping function.
		 *
		 * @access public
		 * @param mixed $package
		 * @return void
		 */
		public function calculate_shipping( $package = array() ) {
			global $woocommerce;
			$shipping_total = 0;
			
			// find destination state
			if( $package['destination']['country'] == 'IR' ) {//Iran country
				$this->destination_state = $package['destination']['state'];
				if($this->destination_state == $this->source_state or $package['destination']['state'] == '') {
					$this->destination_city = $package['destination']['city'];
					
					$this->source_city = str_replace('ي','ی', $this->source_city);
					$this->source_city = str_replace('ك','ک', $this->source_city);
					$this->source_city = str_replace('آ','ا', $this->source_city);
					$this->source_city = str_replace(' ','', $this->source_city);
					
					$this->destination_city = str_replace('ي','ی', $this->destination_city);
					$this->destination_city = str_replace('ك','ک', $this->destination_city);
					$this->destination_city = str_replace('آ','ا', $this->destination_city);
					$this->destination_city = str_replace(' ','', $this->destination_city);
					
					// if cities are same or not
					if ($this->source_city == $this->destination_city or $this->source_city == '' or $this->destination_city == '' ){

						if ($this->fix_price != '' and $this->fix_price = intval($this->fix_price) ){
							$shipping_total = $this->fix_price;
						}
						
						// convert currency to current selected currency
						if ( $this->current_currency == 'IRT' ) {
							$shipping_total = ceil ( $shipping_total / 10 );
						} elseif ( $this->current_currency == 'IRHT' ) {
							$shipping_total = ceil ( $shipping_total / 10000 );
						}
					
						if($this->source_city != ''){
							$this->title .= ' (فقط مخصوص شهر ' . $this->source_city . ')';
						}elseif($this->source_state != ''){
							$this->title .= ' (فقط مخصوص استان ' . $this->form_fields['source_state']['options'][$this->source_state] . ')';
						}
						
						// Register the rate
						$rate = array(
							'id' => $this->id,
							'label' => $this->title,
							'cost' => $shipping_total,
							'calc_tax' => 'per_order'
						);
						$this->add_rate( $rate );

					}

				}
				
			}
		}
	}
}

function iran_peyk_shipping( $methods ) {
	$methods[] = 'WC_Shipping_Iran_Peyk';
	return $methods;
}

add_filter( 'woocommerce_shipping_methods', 'iran_peyk_shipping' );
