<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( ! class_exists( 'WC_Shipping_Iran_Sefareshi' ) ) {
	class WC_Shipping_Iran_Sefareshi extends WC_Shipping_Method {
		
		/**
		 * Constructor for shipping class
		 *
		 * @access public
		 * @return void
		 */
		public function __construct() {
			$this->id                 = 'iran_sefareshi_shipping'; // Id for your shipping method. Should be uunique.
			$this->method_title       = 'پست سفارشی';  // Title shown in admin
			$this->method_description = '<h3>روش پست سفارشی ایران برای ووکامرس</h3>
			<p style="text-align: justify;">این روش مبلغ پستی را بر اساس نرخ پستی سال ۱۳۹۸ (آخرین نرخ محاسبه فعلی) محاسبه می کند. نحوه محاسبه بر اساس نرخ پستی بر اساس وزن، مبلغ بیمه، مالیات پستی و مسافت از مبدا تا مقصد بر اساس موقعیت دو استان نسبت به هم می باشد. لازم به ذکر است که مبلغ محاسباتی به صورت اتوماتیک بر اساس واحد پول ایران و واحد وزن تعیین شده در تنظیمات ووکامرس شما محاسبه و به صورت اتوماتیک به واحد های تعیین شده تبدیل میشود. واحد های پول قابل قبول، ریال، تومان و هزار تومان است و واحد های وزنی مورد قبول، گرم و کیلوگرم می باشد. توجه داشته باشید که نرخ های دیگر از جمله، هزینه پاکت، هزینه جعبه، بسته بندی، تمبر، مرسولات شکستنی، اضافه نرخ ها از مقر فرستنده، نرخ قبول خارج از وقت اداری، استعلام رهگیری الکترونیکی، شناسه الکترونیکی و دیگر موارد اختیاری در این نرخ محاسبه نشده اند و کاملا اختیاری می باشند. (باجه های پستی باید فقط با درخواست ارسال کننده این نرخ ها را اضافه کنند). در صورتی که نیاز به اضافه کردن مبلغ خاصی به این نرخ دارید می توانید از گزینه های هزینه های اضافی، به صورت مبلغ و یا درصد اضافه نمائید.
			<a href="https://parsmizban.com" target="_blank">جهت مشاهده دیگر افزونه های ایجاد شده ما و دیگر سرویس های ما اینجا را کلیک نمائید.</a></p>'; // Description shown in admin
			$this->init();
		}

		/**
		 * Init your settings
		 *
		 * @access public
		 * @return void
		 */
		function init() {
			// Load the settings API
			$this->init_form_fields(); // This is part of the settings API. Override the method to add your own settings
			$this->init_settings(); // This is part of the settings API. Loads settings you previously init.

			// Define user set variables
			$this->enabled					= $this->get_option( 'enabled' );
			$this->title							= $this->get_option( 'title' );
			$this->extra_cost				= intval( $this->get_option( 'extra_cost' ) );
			$this->extra_cost_percent	= intval( $this->get_option( 'extra_cost_percent' ) );
			$this->source_state			= $this->get_option( 'source_state' );
			$this->free_for_price			= $this->get_option( 'free_for_price' );
			$this->current_currency		= get_woocommerce_currency(); // IRR or IRT or IRHT
			$this->current_weight_unit	= get_option('woocommerce_weight_unit'); // g or kg

			// Save settings in admin if you have any defined
			add_action( 'woocommerce_update_options_shipping_' . $this->id, array( $this, 'process_admin_options' ) );
		}

		/**
		 * Initialise Gateway Settings Form Fields
		 *
		 * @access public
		 * @return void
		 */
		public function init_form_fields() {
			$this->form_fields = array(
				'enabled' => array(
					'title' 		=> 'فعال/غیر فعال',
					'type' 			=> 'checkbox',
					'label' 		=> 'فعال کردن این روش حمل و نقل',
					'default' 		=> 'no',
				),
				'title' => array(
					'title' 		=> 'عنوان روش',
					'type' 			=> 'text',
					'description' 	=> 'این گزینه عنوان را کنترل می کند که کاربر در طول تسویه حساب مشاهده می کند.',
					'default'		=> 'پست سفارشی',
					'desc_tip'		=> true
				),
				'extra_cost' => array(
					'title' 		=> 'هزینه های اضافی به ریال',
					'type' 			=> 'text',
					'description' 	=> 'در این قسمت هزینه های اضافی علاوه بر نرخ پستی را می توانید وارد نمائید ، از قبیل هزینه های بسته بندی و غیره - مبلغ ثابت را به ریال وارد نمائید.',
					'default'		=> '',
					'desc_tip'		=> true
				),
				'extra_cost_percent' => array(
					'title' 		=> 'هزینه های اضافی به درصد',
					'type' 			=> 'text',
					'description' 	=> 'در این قسمت هزینه های اضافی علاوه بر نرخ پستی را می توانید به درصد وارد نمائید - در این قسمت فقط عدد را وارد نمائید برای مثال برای 2% ، عدد 2 را وارد نمائید',
					'default'		=> '',
					'desc_tip'		=> true
				),
				'free_for_price' => array(
					'title' 		=> 'ارسال رایگان برای مجموع سفارش (مبلغ به ریال)',
					'type' 			=> 'text',
					'description' 	=> 'اگر مجموع سفارش برابر یا بیشتر از این مقدار شد، رایگان حساب شود.',
					'default'		=> '',
					'desc_tip'		=> true
				),
				'source_state' => array(
					'title' 		=> 'استان مبدا (فروشنده)',
					'type' 			=> 'select',
					'description' 	=> 'لطفا در این قسمت استانی که محصولات از آنجا ارسال می شوند را انتخاب نمائید',
					'default'		=> 'THR',
					'desc_tip'		=> true,
					'options' 		=> array(
						'EAZ' => 'آذربایجان شرقی',
						'WAZ' => 'آذربایجان غربی',
						'ADL' => 'اردبیل',
						'ESF' => 'اصفهان',
						'ABZ' => 'البرز',
						'ILM' => 'ایلام',
						'BHR' => 'بوشهر',
						'THR' => 'تهران',
						'CHB' => 'چهارمحال و بختیاری',
						'SKH' => 'خراسان جنوبی',
						'RKH' => 'خراسان رضوی',
						'NKH' => 'خراسان شمالی',
						'KHZ' => 'خوزستان',
						'ZJN' => 'زنجان',
						'SMN' => 'سمنان',
						'SBN' => 'سیستان و بلوچستان',
						'FRS' => 'فارس',
						'GZN' => 'قزوین',
						'QHM' => 'قم',
						'KRD' => 'کردستان',
						'KRN' => 'کرمان',
						'KRH' => 'کرمانشاه',
						'KBD' => 'کهگیلویه و بویراحمد',
						'GLS' => 'گلستان',
						'GIL' => 'گیلان',
						'LRS' => 'لرستان',
						'MZN' => 'مازندران',
						'MKZ' => 'مرکزی',
						'HRZ' => 'هرمزگان',
						'HDN' => 'همدان',
						'YZD' => 'یزد',
					)
				)
			);
		}

		/**
		 * check if states are beside each other
		 *
		 * @access public
		 * @param string $source
		 * @param string destination
		 * @return string
		 * in     = same
		 * beside = beside
		 * out    = non beside
		 */
		public function check_states_beside( $source, $destination){
			$isbeside["EAZ"]["WAZ"] = true;
			$isbeside["EAZ"]["ADL"] = true;
			$isbeside["EAZ"]["ZJN"] = true;
			
			$isbeside["WAZ"]["EAZ"] = true;
			$isbeside["WAZ"]["KRD"] = true;
			$isbeside["WAZ"]["ZJN"] = true;

			$isbeside["ADL"]["EAZ"] = true;
			$isbeside["ADL"]["GIL"] = true;
			$isbeside["ADL"]["ZJN"] = true;
			
			$isbeside["ESF"]["CHB"] = true;
			$isbeside["ESF"]["LRS"] = true;
			$isbeside["ESF"]["KBD"] = true;
			$isbeside["ESF"]["MKZ"] = true;
			$isbeside["ESF"]["QHM"] = true;
			$isbeside["ESF"]["SMN"] = true;
			$isbeside["ESF"]["SKH"] = true;
			$isbeside["ESF"]["YZD"] = true;
			$isbeside["ESF"]["FRS"] = true;

			$isbeside["ABZ"]["THR"] = true;
			$isbeside["ABZ"]["MKZ"] = true;
			$isbeside["ABZ"]["GZN"] = true;
			$isbeside["ABZ"]["MZN"] = true;
			
			$isbeside["ILM"]["KRH"] = true;
			$isbeside["ILM"]["LRS"] = true;
			$isbeside["ILM"]["KHZ"] = true;
			
			$isbeside["BHR"]["KBD"] = true;
			$isbeside["BHR"]["KHZ"] = true;
			$isbeside["BHR"]["FRS"] = true;
			$isbeside["BHR"]["HRZ"] = true;
			
			$isbeside["THR"]["ABZ"] = true;
			$isbeside["THR"]["MKZ"] = true;
			$isbeside["THR"]["QHM"] = true;
			$isbeside["THR"]["MZN"] = true;
			$isbeside["THR"]["SMN"] = true;
			
			$isbeside["CHB"]["KBD"] = true;
			$isbeside["CHB"]["KHZ"] = true;
			$isbeside["CHB"]["LRS"] = true;
			$isbeside["CHB"]["ESF"] = true;
			
			$isbeside["SKH"]["SBN"] = true;
			$isbeside["SKH"]["KRN"] = true;
			$isbeside["SKH"]["YZD"] = true;
			$isbeside["SKH"]["ESF"] = true;
			$isbeside["SKH"]["SMN"] = true;
			$isbeside["SKH"]["RKH"] = true;
			
			$isbeside["RKH"]["SKH"] = true;
			$isbeside["RKH"]["NKH"] = true;
			$isbeside["RKH"]["SMN"] = true;
			
			$isbeside["NKH"]["RKH"] = true;
			$isbeside["NKH"]["GLS"] = true;
			$isbeside["NKH"]["SMN"] = true;
			
			$isbeside["KHZ"]["ILM"] = true;
			$isbeside["KHZ"]["BHR"] = true;
			$isbeside["KHZ"]["LRS"] = true;
			$isbeside["KHZ"]["KBD"] = true;
			$isbeside["KHZ"]["CHB"] = true;
			
			$isbeside["ZJN"]["GIL"] = true;
			$isbeside["ZJN"]["ADL"] = true;
			$isbeside["ZJN"]["EAZ"] = true;
			$isbeside["ZJN"]["WAZ"] = true;
			$isbeside["ZJN"]["KRD"] = true;
			$isbeside["ZJN"]["HDN"] = true;
			$isbeside["ZJN"]["GZN"] = true;
			
			$isbeside["SMN"]["MZN"] = true;
			$isbeside["SMN"]["THR"] = true;
			$isbeside["SMN"]["QHM"] = true;
			$isbeside["SMN"]["ESF"] = true;
			$isbeside["SMN"]["NKH"] = true;
			$isbeside["SMN"]["RKH"] = true;
			$isbeside["SMN"]["SKH"] = true;
			
			$isbeside["SBN"]["SKH"] = true;
			$isbeside["SBN"]["KRN"] = true;
			$isbeside["SBN"]["HRZ"] = true;
			
			$isbeside["FRS"]["ESF"] = true;
			$isbeside["FRS"]["YZD"] = true;
			$isbeside["FRS"]["BHR"] = true;
			$isbeside["FRS"]["HRZ"] = true;
			$isbeside["FRS"]["KBD"] = true;
			$isbeside["FRS"]["KRN"] = true;
			
			$isbeside["GZN"]["ZJN"] = true;
			$isbeside["GZN"]["HDN"] = true;
			$isbeside["GZN"]["MKZ"] = true;
			$isbeside["GZN"]["ABZ"] = true;
			$isbeside["GZN"]["MZN"] = true;
			$isbeside["GZN"]["GIL"] = true;
			
			$isbeside["QHM"]["THR"] = true;
			$isbeside["QHM"]["MKZ"] = true;
			$isbeside["QHM"]["SMN"] = true;
			$isbeside["QHM"]["ESF"] = true;
			
			$isbeside["KRD"]["WAZ"] = true;
			$isbeside["KRD"]["KRH"] = true;
			$isbeside["KRD"]["HDN"] = true;
			$isbeside["KRD"]["ZJN"] = true;
			
			$isbeside["KRN"]["YZD"] = true;
			$isbeside["KRN"]["FRS"] = true;
			$isbeside["KRN"]["HRZ"] = true;
			$isbeside["KRN"]["SBN"] = true;
			$isbeside["KRN"]["SKH"] = true;
			
			$isbeside["KRH"]["KRD"] = true;
			$isbeside["KRH"]["HDN"] = true;
			$isbeside["KRH"]["LRS"] = true;
			$isbeside["KRH"]["ILM"] = true;
			
			$isbeside["KBD"]["CHB"] = true;
			$isbeside["KBD"]["KHZ"] = true;
			$isbeside["KBD"]["BHR"] = true;
			$isbeside["KBD"]["FRS"] = true;
			$isbeside["KBD"]["ESF"] = true;
			
			$isbeside["GLS"]["MZN"] = true;
			$isbeside["GLS"]["NKH"] = true;
			$isbeside["GLS"]["SMN"] = true;
			
			$isbeside["GIL"]["MZN"] = true;
			$isbeside["GIL"]["ADL"] = true;
			$isbeside["GIL"]["ZJN"] = true;
			$isbeside["GIL"]["GZN"] = true;
			
			$isbeside["LRS"]["ILM"] = true;
			$isbeside["LRS"]["KRH"] = true;
			$isbeside["LRS"]["HDN"] = true;
			$isbeside["LRS"]["MKZ"] = true;
			$isbeside["LRS"]["ESF"] = true;
			$isbeside["LRS"]["CHB"] = true;
			$isbeside["LRS"]["KHZ"] = true;
			
			$isbeside["MZN"]["GLS"] = true;
			$isbeside["MZN"]["SMN"] = true;
			$isbeside["MZN"]["THR"] = true;
			$isbeside["MZN"]["ABZ"] = true;
			$isbeside["MZN"]["ESF"] = true;
			$isbeside["MZN"]["GZN"] = true;
			$isbeside["MZN"]["GIL"] = true;
			
			$isbeside["MKZ"]["ESF"] = true;
			$isbeside["MKZ"]["QHM"] = true;
			$isbeside["MKZ"]["THR"] = true;
			$isbeside["MKZ"]["ABZ"] = true;
			$isbeside["MKZ"]["LRS"] = true;
			$isbeside["MKZ"]["GZN"] = true;
			$isbeside["MKZ"]["HDN"] = true;
			
			$isbeside["HRZ"]["BHR"] = true;
			$isbeside["HRZ"]["FRS"] = true;
			$isbeside["HRZ"]["KRN"] = true;
			$isbeside["HRZ"]["SBN"] = true;
			
			$isbeside["HDN"]["KRH"] = true;
			$isbeside["HDN"]["LRS"] = true;
			$isbeside["HDN"]["KRD"] = true;
			$isbeside["HDN"]["MKZ"] = true;
			$isbeside["HDN"]["GZN"] = true;
			$isbeside["HDN"]["ZJN"] = true;
			
			$isbeside["YZD"]["ESF"] = true;
			$isbeside["YZD"]["FRS"] = true;
			$isbeside["YZD"]["KRN"] = true;
			$isbeside["YZD"]["SKH"] = true;

			if (isset($isbeside[$source][$destination]) && $isbeside[$source][$destination] === true)
				return 'beside';
			elseif ( $source == $destination )
				return 'in';
			else return 'out';
		}

		/**
		 * calculate_shipping function.
		 *
		 * @access public
		 * @param mixed $package
		 * @return void
		 */
		public function calculate_shipping( $package = array() ) {
			global $woocommerce;
			$shipping_total = 0;
			
			$cart_weight = $woocommerce->cart->cart_contents_weight;

			// convert current currency to rial
			if ($this->current_currency =='IRT') {
				$package_cost = $package['contents_cost'] * 10;
			} elseif ($this->current_currency =='IRHT'){
				$package_cost = $package['contents_cost'] * 10000;
			}
			
			if($this->free_for_price != '' and $this->free_for_price = intval($this->free_for_price) and $package_cost >= $this->free_for_price){
				$shipping_total = 0;
			} else {
			
				//convert current weight unit to gram
				if ($this->current_weight_unit == 'kg') {
					$cart_weight = $cart_weight * 1000;
				}

				// Iran Post Prices (prices are in Rial)
				$rate_price['500']['in'] 			= 38000;
				$rate_price['500']['beside'] 	= 49000;
				$rate_price['500']['out'] 			= 53000;
				
				$rate_price['1000']['in'] 			= 50000;
				$rate_price['1000']['beside'] 	= 68000;
				$rate_price['1000']['out'] 		= 73000;
				
				$rate_price['2000']['in'] 			= 72000;
				$rate_price['2000']['beside'] 	= 88000;
				$rate_price['2000']['out'] 		= 95000;
				
				$rate_price['9999']['in'] 			=	27000;
				$rate_price['9999']['beside'] 	= 32000;
				$rate_price['9999']['out'] 		= 35000;
				
				// insurance (bime)
				$insurance = 6500;
				
				// post tax percent (#%)
				$post_tax = 9; // 9%
				
				// detect the weight plan
				if ( $cart_weight <= 500 )
					$weight_indicator = '500';
				elseif ( $cart_weight > 500 && $cart_weight <= 1000 )
					$weight_indicator = '1000';
				elseif ( $cart_weight > 1000 && $cart_weight <= 2000 )
					$weight_indicator = '2000';
				elseif ( $cart_weight > 2000 )
					$weight_indicator = '9999';

				// find destination state
				if ( $package['destination']['country'] == 'IR' ) {//Iran country
					$this->destination_state = $package['destination']['state']; //example: TE
											//$package['destination']['postcode'] //1234567890
											//$package['destination']['city']
				}

				// if states are beside or are same or not beside each other
				$checked_state = $this->check_states_beside( $this->source_state , $this->destination_state);
				
				// calculate
				if ( $weight_indicator != '9999' ) { // is less than 2000 grams
					$shipping_total = $rate_price[$weight_indicator][$checked_state];
				} elseif ( $weight_indicator == '9999' ) { // is more than 2000 grams
					$shipping_total = $rate_price['2000'][$checked_state] +
										( $rate_price['9999'][$checked_state] * ceil ( ( $cart_weight - 2000) / 1000 ) );
				}

				// invalid post code price
				// 25%
				$invalid_postcode = ceil ( ( $shipping_total * 25 ) / 100 );

				// check invalid post code
				switch ( $package['destination']['postcode'] ){
					case '1234567890':
					case '1111111111':
					case '2222222222':
					case '3333333333':
					case '4444444444':
					case '5555555555':
					case '6666666666':
					case '7777777777':
					case '8888888888':
					case '9999999999':
					case '0000000000':
					case '0987654321':
					case '1234567891':
					case '0123456789':
					case '7894561230':
					case ( strlen ( $package['destination']['postcode'] ) < 10 ):
					case ( strlen ( $package['destination']['postcode'] ) > 10 ):
						$shipping_total += $invalid_postcode;
						break;
				}

				// insurance (bime)
				$shipping_total += $insurance;
				
				// post tax
				$shipping_total += ceil( ( $shipping_total * $post_tax ) / 100 );

				// round to up for amounts fewer than 1000 rials
				$shipping_total = ( ceil ( $shipping_total / 1000 ) ) * 1000;
				
				$shipping_total		+=  ceil ( ( $shipping_total * $this->extra_cost_percent) / 100 );
				$this->extra_cost	= intval ($this->extra_cost);
				$shipping_total 		+= $this->extra_cost;

				// convert currency to current selected currency
				if ( $this->current_currency == 'IRT' ) {
					$shipping_total = ceil ( $shipping_total / 10 );
				} elseif ( $this->current_currency == 'IRHT' ) {
					$shipping_total = ceil ( $shipping_total / 10000 );
				}
			}
			
			// Register the rate
			$rate = array(
				'id' => $this->id,
				'label' => $this->title,
				'cost' => $shipping_total,
				'calc_tax' => 'per_order'
			);
			$this->add_rate( $rate );
		}
	}
}

function iran_sefareshi_shipping( $methods ) {
	$methods[] = 'WC_Shipping_Iran_Sefareshi';
	return $methods;
}

add_filter( 'woocommerce_shipping_methods', 'iran_sefareshi_shipping' );
