<?php
/**
 * Plugin Name: روش حمل و نقل پست پیشتاز، سفارشی، پیک موتوری و سایر شرکتهای ارسال مرسوله برای ووکامرس
 * Plugin URI: https://parsmizban.com/%D9%88%D9%88%DA%A9%D8%A7%D9%85%D8%B1%D8%B3-%D9%BE%D8%B3%D8%AA
 * Description: این افزونه وردپرس یک افزونه ووکامرس می باشد که روش حمل و نقل پست سفارشی و پیشتاز، پیک موتوری و سایر شرکتهای ارسال مرسوله را محاسبه و به سیستم اضافه می کند.
 * Version: 3.5
 * Author: پارس میزبان
 * Author URI: https://parsmizban.com
 * Requires at least: 4.4
 * Tested up to: 5.2.3
 *
 * Text Domain: iran-post-shipping
 * Domain Path: /languages/
 */

defined( 'ABSPATH' ) or die( 'No script kiddies please!' );

/**
 * Check if WooCommerce is active
 */
if ( ! function_exists('get_plugins') ){
	require_once( ABSPATH . 'wp-admin/includes/plugin.php' );
}
if ( is_plugin_active( 'woocommerce/woocommerce.php' ) ) {

	/**
	 * Class IranPostShipping
	 */
	class IranPostShipping {

		/**
		 * @var
		 */
		protected $plugin_name;
		/**
		 * @var
		 */
		protected $plugin_slug;
		/**
		 * @var
		 */
		protected $plugin_url;
		/**
		 * @var
		 */
		protected $plugin_version;

		/**
		 * Constructor.
		 */
		function __construct(){
			$this->set_plugin_info();
			register_activation_hook(__FILE__,		[ $this, 'activate' ]);
			register_deactivation_hook(__FILE__,	[ $this, 'deactivate' ]);
			register_uninstall_hook(__FILE__, __CLASS__ . '::uninstall');
			add_action('plugins_loaded',						[ $this, 'load_languages' ]);
			spl_autoload_register(							[ $this, 'autoloader' ]);
			add_action('wp_enqueue_scripts', 			[ $this, 'load_frontend_scripts' ], 11);
			add_action( 'woocommerce_shipping_init',	[ $this, 'woocommerce_iran_post_init' ] );
			if ( is_admin() ) {
				add_action('admin_enqueue_scripts', [ $this, 'load_admin_scripts' ], 110000000);
				$this->admin();
			} else {
				$this->run();
			}
		}

		/**
		 *
		 */
		function set_plugin_info(){
			$this->plugin_slug 		= basename(__FILE__, '.php');
			$this->plugin_url  		= plugins_url(null, __FILE__);
			if ( ! function_exists('get_plugins') ){
				require_once( ABSPATH . 'wp-admin/includes/plugin.php' );
			}
			$plugin_folder				= get_plugins('/' . plugin_basename(dirname(__FILE__)));
			$plugin_file					= basename(( __FILE__ ));
			$this->plugin_version	= $plugin_folder[ $plugin_file ]['Version'];
			$this->plugin_name		= $plugin_folder[ $plugin_file ]['Name'];
		}

		/**
		 *
		 */
		function woocommerce_iran_post_init() {
			include ('includes/peyk.php');
			include ('includes/sefareshi.php');
			include ('includes/pishtaz.php');
			include ('includes/paskeraye.php');
		}
		
		/**
		 *
		 */
		function activate() {

		}

		/**
		 *
		 */
		function deactivate() {

		}

		/**
		 *
		 */
		static function uninstall() {
			delete_option('best-editor');
		}

		/**
		 *
		 */
		function load_languages(){
			load_plugin_textdomain($this->plugin_slug, false, dirname(plugin_basename(__FILE__)) . '/languages/');
		}

		/**
		 * @param $class
		 */
		function autoloader( $class ){
			$class_file = realpath(dirname(__FILE__) . '/inc/classes/' . $class . '.php');
			if ( file_exists($class_file) ) {
				include( $class_file );
			}
		}

		/**
		 *
		 */
		function load_frontend_scripts(){

		}

		// Styles for Admin
		/**
		 *
		 */
		function load_admin_scripts(){

		}

		/**
		 *
		 */
		function admin() {
			//include( plugin_dir_path(__FILE__) . 'options.php' );
			add_action('admin_menu', [$this, 'register_iran_post_shipping_menu']);
		}
		
		/**
		* Register a custom menu page.
		*/
		function register_iran_post_shipping_menu() {
			add_menu_page(
				'روش‌های حمل ایران',
				'روش‌های حمل ایران',
				'manage_options',
				'admin.php?page=wc-settings&tab=shipping',
				'',
				plugins_url( 'woocommerce-iran-post-shipping/assets/postarm.png' ),
				56
			);
			
			add_submenu_page(
				'admin.php?page=wc-settings&tab=shipping',
				'پیک موتوری',
				'پیک موتوری',
				'manage_options',
				'admin.php?page=wc-settings&tab=shipping&section=iran_peyk_shipping',
				''
			);
			
			add_submenu_page(
				'admin.php?page=wc-settings&tab=shipping',
				'پست سفارشی',
				'پست سفارشی',
				'manage_options',
				'admin.php?page=wc-settings&tab=shipping&section=iran_sefareshi_shipping',
				''
			);

			add_submenu_page(
				'admin.php?page=wc-settings&tab=shipping',
				'پست پیشتاز',
				'پست پیشتاز',
				'manage_options',
				'admin.php?page=wc-settings&tab=shipping&section=iran_pishtaz_shipping',
				''
			);
			
			add_submenu_page(
				'admin.php?page=wc-settings&tab=shipping',
				'پس کرایه',
				'پس کرایه',
				'manage_options',
				'admin.php?page=wc-settings&tab=shipping&section=iran_paskeraye_shipping',
				''
			);

			add_submenu_page(
				'admin.php?page=wc-settings&tab=shipping',
				'افزونه‌های پارس میزبان',
				'افزونه‌های پارس میزبان',
				'manage_options',
				'plugin-install.php?s=parsmizban&tab=search&type=author',
				''
			);
			
			add_submenu_page(
				'admin.php?page=wc-settings&tab=shipping',
				'قالب های پارس میزبان',
				'قالب های پارس میزبان',
				'manage_options',
				'theme-install.php?search=dedidata',
				''
			);

			add_submenu_page(
				'admin.php?page=wc-settings&tab=shipping',
				'سایر امکانات پارس میزبان',
				'سایر امکانات پارس میزبان',
				'manage_options',
				'https://parsmizban.com',
				''
			);			
		}
		
		/**
		 *
		 */
		function run() {
		}
	}

	new IranPostShipping;

}