<?php
/**
 * The main template file
 *
 * This is the most generic template file in a WordPress theme
 * and one of the two required files for a theme (the other being style.css).
 * It is used to display a page when nothing more specific matches a query.
 * E.g., it puts together the home page when no home.php file exists.
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package Digix
 */

get_header();?>

<main class="main" role="main">
	<div class="container">
		<section class="notfound">
			<div class="main-404 text-center m-4">
				<h1><?php echo __('page not found!','digix'); ?></h1>
				<a class="btn btn-success" href="<?php echo esc_url( home_url() ); ?>"><?php echo __('Home','digix'); ?></a>
				<br><br><br>
				<img class="img-fluid" src="<?php echo DIGIX_IMG .'404.jpg'; ?>" alt="404">
			</div>
		</section>
	</div>
</main>

<?php get_footer(); ?>
