<?php

if ( ! class_exists( 'Digix_loadmorepost' ) ) :

class Digix_loadmorepost 
{

	function __construct()
	{
	  add_shortcode('Digix_postnavigation',array(&$this, 'Digix_postnavigation'));
      add_shortcode('Digix_loadmorepost',array(&$this, 'Digix_loadmorepost'));
	  add_action( 'wp_ajax_get_new_data_items', array(&$this, 'get_new_data_items' ));
	  add_action( 'wp_ajax_nopriv_get_new_data_items', array(&$this, 'get_new_data_items' ));
	}
	public function Digix_postnavigation()
	{?>
		<section class="post-navigation">
		<?php
			if (has_nav_menu('blog')) {
				wp_nav_menu(array(
					'theme_location' => 'blog',
					'container' => false,
					'menu_id' => 'blog-menu',
					'menu_class' => 'blog-menu',
					'depth' => 1,
				));
			} else {
				echo '<span class="menu-not-found">' . __('Go to appearance > Menus for create blog menu','digix') . '</span>';
			}
			?>
			<form role="search" method="get" id="wpls-searchform" class="search-form" action="<?php echo esc_url_raw( home_url() ); ?>">
				<input type="hidden" name="post_type" value="post">
				<input class="form-input" type="text" placeholder="<?php echo __('search in posts ...','digix'); ?>"  onfocus="if (this.value === '') {this.value = '';}" onblur="if (this.value === '')  {this.value = '';}" value="" name="s" id="search-input" autocapitalize="off" autocorrect="off" autocomplete="off" />
				<button class="btn form-button"><i class="icon-search"></i></button>
				<div class="spinner live-search-loading wpls-search-loader search-result" style="display: none;">
					<img src="<?php echo esc_url( admin_url( 'images/spinner-2x.gif' ) ); ?>" >
				</div>
			</form>
		</section>
	<?php
	}
	function Digix_loadmorepost($atts){
		$atts = shortcode_atts(
			array('cat_id' => false,'post_type' => false),
			$atts
		);		
		$post_type = $atts['post_type'];
		$cat_ID = $atts['cat_id'];		
        $rowperpage = '8';
		if($rowperpage<=0){$rowperpage=10;}
		if(post_type_exists( $post_type )){
			$post_type = $atts['post_type'];
			}else{$post_type ='';}
		if((!empty($post_type)) && (!empty($cat_ID))){
			$the_query = new WP_Query( 'cat='.$cat_ID && 'post_type='.$post_type );
			$allcount = $the_query->found_posts;
		}elseif(!empty($post_type)){
			$the_query = new WP_Query( 'post_type='.$post_type );
			$allcount = $the_query->found_posts;
		}elseif(!empty($cat_ID)){
			$the_query = new WP_Query( 'cat='.$cat_ID );
			$allcount = $the_query->found_posts;
		}else{
			$allcount = wp_count_posts('post')->publish;
		}
		if(empty($post_type)){$post_type = 'post';}
		$html ='';
		if($allcount>0):
	 $args = array(
		'numberposts'      => 8,
		'offset'           => 0,
		'orderby'          => 'date',
		'order'            => 'DESC',
		'post_type'        => 'post',
		'post_status'      => 'publish'
	   );
	$results = get_posts($args);
	echo'<div class="post-list">';
		foreach($results as $result){
		$posts_id = get_the_id();			
		$post_id = $result->ID;
            $permalink = get_the_permalink($post_id);
            $title = $result->post_title;
            $img_url = get_the_post_thumbnail_url($post_id);			
			if(empty($img_url)){
			$fullcontent = $result->post_content;
			$regex = '/src="([^"]*)"/';
			preg_match_all( $regex, $fullcontent, $matches );
			$matches = array_reverse($matches);
			$img_url = $matches[0][0];
			}			
            $post_date = $result->post_date;
            $date1=date_create($post_date);
            $date = date_format($date1,"F d, Y");
			$categoies=get_the_category($post_id);	
			$cat_html='';
			foreach($categoies as $category){
			$term_id = $category->term_id;
			$cat_name = $category->name;
			$category_link = get_category_link($term_id);
			$cat_html .='<a href="'.$category_link.'">'.$cat_name.'</a>';
			    }
			global $post;
			$author_id = $result->post_author;
			$author_id = get_the_author_meta( 'ID' );
			$date2 = $post_date;
			$timestamp2 = strtotime($date2);
			?>
			<article class="post-item">
					<div class="item-wrapper">
						<figure class="thumbnail  position-relative">						
							<a href="<?php echo $permalink; ?>" title="<?php the_title_attribute(); ?>" rel="bookmark" class="d-block  img-style" style="background: url('<?php echo $img_url; ?>')">
							</a>
						</figure>
						<div class="item-content">
							<h3><a href="<?php echo $permalink; ?>"><?php echo $title; ?></a></h3>
							<div class="item-detailes">
								<div class="item-heart">
									<?php $like_count =get_post_meta( $post_id, "_post_like_count", true );  if( $like_count <= '0' && $like_count == '' ){echo'0';}else{echo get_post_meta( $post_id, "_post_like_count", true );}?><i class="icon-heart"></i>
								</div>	
								<div class="item-date">
									<span><i class="icon-tinder"></i><?php echo digix_wp_get_views($post_id); ?></span>					
									<span><i class="icon-calendar"></i><?php echo dx_jdate('Y/m/d', $timestamp2);?></span>
								</div>
								
							</div>
							<div class="item-info">
								<div><?php echo get_avatar( get_the_author_meta( 'ID' ), 25 ); ?><span><?php echo get_the_author_meta( 'display_name', get_the_author_meta('ID')  ); ?></span></div>
								<div>
									<?php if ( function_exists('rmp_get_visual_rating') && rmp_get_visual_rating($post_id) ) { ?>
										<span class="post-rate">
											<div class="average-rate"><span class="average-rate"><?php echo str_replace('/',',',rmp_get_avg_rating($post_id)); ?></span>/5</div>
											<div class="average-stars"><?php echo rmp_get_visual_rating($post_id); ?></div>
										</span>
									<?php } ?>
								</div>
							</div>
						</div>
					</div>
				</article>
			<?php 
	}
		echo'</div>';
	if($allcount > $rowperpage):
	$loadMore = __('load more','digix');
	$html .= '<div class="wp_btn_more"><button class="wp_load-more">'.$loadMore.'</button>
		 <input type="hidden" id="wp_page_posts" value="'.$rowperpage.'">
		 <input type="hidden" id="wp_post_show" value="'.$rowperpage.'">
		 <input type="hidden" id="wp_all" value="'. $allcount .'">
		 <input type="hidden" id="wp_posType" value="'. $post_type .'">
		 <input type="hidden" id="wp_cat_id" value="'. $cat_ID .'"></div>';
		 endif;		
		else:
		$html .= '<div class="wp_no_posts">There is no post on the back-end. Please add the post first !!!</div>';
		endif;
		echo $html;
	 }
	 
	function get_new_data_items(){
        $from_limit = sanitize_text_field($_POST['from_limit']);
		$limit_to = sanitize_text_field($_POST['limit_to']);
		$cat_id = sanitize_text_field($_POST['cat_id']);
		$post_type = sanitize_text_field($_POST['post_type']);
		$args = array(
                'numberposts'      => $limit_to,
                'offset'           => $from_limit,
                'category'         => $cat_id,
                'orderby'          => 'date',
                'order'            => 'DESC',
                'post_type'        => $post_type,
                'post_status'      => 'publish'
			);
		$results = get_posts($args);
		$html = '';
        foreach($results as $result){
		    $post_id = $result->ID;
            $permalink = get_the_permalink($post_id);
			$excerpt_content = get_option('wp_post_excerpt_content','120');
            $content = substr($result->post_content, 0, $excerpt_content)."...";
            $title = $result->post_title;
            $comment_count = $result->comment_count;
            $img_url = get_the_post_thumbnail_url($post_id);
			if(empty($img_url)){
			$fullcontent = $result->post_content;
			$regex = '/src="([^"]*)"/';
			preg_match_all( $regex, $fullcontent, $matches );
			$matches = array_reverse($matches);
			$img_url = $matches[0][0];
			}
            $post_date = $result->post_date;
            $date1=date_create($post_date);
            $date = date_format($date1,"F d, Y");
			$categoies=get_the_category($post_id);
			
			$cat_html='';
			foreach($categoies as $category){
			$term_id = $category->term_id;
			$cat_name = $category->name;
			$category_link = get_category_link($term_id);
			$cat_html .='<a href="'.$category_link.'">'.$cat_name.'</a>';
			$date2 = $post_date;
			$timestamp2 = strtotime($date2);
			    }
			global $wpdb;
			$post_author_id = (int) $wpdb->get_var( $wpdb->prepare( "SELECT post_author FROM {$wpdb->posts} WHERE ID = %d ", $post_id ) );
			$author =  new WP_User( $post_author_id );
			$display_name = $author->display_name;
			$avartar = get_avatar( $post_author_id, 25 );
    ?>
		
        <article class="post-item">
					<div class="item-wrapper">
						<figure class="thumbnail  position-relative">						
							<a href="<?php echo $permalink; ?>" title="<?php the_title_attribute(); ?>" rel="bookmark" class="d-block  img-style" style="background: url('<?php echo $img_url; ?>')">
							</a>
						</figure>
						<div class="item-content">
							<h3><a href="<?php echo $permalink; ?>"><?php echo $title; ?></a></h3>
							<div class="item-detailes">
								<div class="item-heart">
									<?php $like_count =get_post_meta( $post_id, "_post_like_count", true );  if( $like_count <= '0' && $like_count == '' ){echo'0';}else{echo get_post_meta( $post_id, "_post_like_count", true );}?><i class="icon-heart"></i>
								</div>	
								<div class="item-date">
									<span><i class="icon-tinder"></i><?php echo digix_wp_get_views($post_id); ?></span>					
									<span><i class="icon-calendar"></i><?php echo dx_jdate('Y/m/d', $timestamp2);?></span>
								</div>
								
							</div>
							<div class="item-info">
								<div><?php echo $avartar; ?><span><?php echo $display_name; ?></span></div>
								<div>
									<?php if ( function_exists('rmp_get_visual_rating') && rmp_get_visual_rating($post_id) ) { ?>
										<span class="post-rate">
											<div class="average-rate"><span class="average-rate"><?php echo str_replace('/',',',rmp_get_avg_rating($post_id)); ?></span>/5</div>
											<div class="average-stars"><?php echo rmp_get_visual_rating($post_id); ?></div>
										</span>
									<?php } ?>
								</div>
							</div>
						</div>
					</div>
				</article>
		<?php }
	echo $html;		
	wp_die();
} 
}
new Digix_loadmorepost();
endif;



