<?php
/**
 * Digix functions and definitions
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @package Digix
 */
class Digix_Product_Faqs_FRONT {

	/**
	 * Constructor of class.
	 */
	public function __construct() {
		add_filter( 'woocommerce_product_tabs', array( $this, 'add_faqs_tab' ) );
	}

	/**
	 * Add Faqs tab.
	 *
	 * @param array $tabs All registered woocommerce tabs.
	 * @return array
	 */
	public function add_faqs_tab( $tabs ) {

		global $post;
		$faqs = get_post_meta( $post->ID, '_Digix_Product_Faqs', true );

		if ( ! empty( $faqs ) ) {
			$tabs['Digix_Product_Faqs'] = array(
				'title'    => __('FAQs','digix'),
				'priority' => 50,
				'callback' => array( $this, 'faqs_tab_content' ),
			);
		}

		return $tabs;
	}

	/**
	 * Add faqs content.
	 */
	public function faqs_tab_content() {

		global $post;
		$faqs = get_post_meta( $post->ID, '_Digix_Product_Faqs', true );

		if ( ! empty( $faqs ) ) {

			wp_enqueue_style( 'woo-product-faqs' );
			wp_enqueue_script( 'woo-product-faqs' );
			?>
			<div class="wcpf-product-faqs">
				<?php
				foreach ( $faqs as $faq ) {
					if ( ! empty( $faq['question'] ) && ! empty( $faq['answer'] ) ) {
						?>
						<div class="accordion-item" itemscope itemprop="mainEntity" itemtype="https://schema.org/Question">
							<h3 class="accordion-heading" itemprop="name"><?php echo esc_html( $faq['question'] ); ?><i class="icon-question"></i></h3>
							<div class="accordion-content" itemscope itemprop="acceptedAnswer" itemtype="https://schema.org/Answer">
								<div itemprop="text">
									<p><?php echo esc_html( $faq['answer'] ); ?></p>
								</div>
							</div>
						</div>
						<?php
					}
				}
				?>
			</div>
			<?php
		}
	}
}
