<?php



if(!class_exists('Digix_Order_Tracking')) {

	final class Digix_Order_Tracking {
		
		function __construct(){
			
		}

		// progress bar active icon/img condition
		public static function digix_wcps($data, $status, $value){

			if($data == $status) {			
				echo esc_html($value);			
			}

		}
		// Progress bar text for invalid order
		public static function order_text($status){
			
			if('cancelled' === $status) {
				printf('The order has been %s, Please contact support', ucwords($status));
			}
			elseif('refunded' === $status) {
				printf('The order has been %s, Please contact support', ucwords($status));
			}
			elseif('failed' === $status) {
				printf('The order has been %s, Please contact support', ucwords($status));
			}

		}

		// Progress bar Background color for invalid order
		public static function order_class($status){
			
			if('cancelled' === $status || 'refunded' === $status || 'failed' === $status ) {
				echo esc_attr('digix_wc_order_cancelled');
			}else {
				return true;
			}

		}
		// Progress bar individual Background color for valid order
		public static function prograssbar($status) {
			if('pending' === $status) {
				printf('%s', apply_filters( 'digix_pending_prograss_percent', '25' ));
			}
			elseif('on-hold' === $status) {
				printf('%s', apply_filters( 'digix_on_hold_prograss_percent', '50' ));
			}
			elseif('processing' === $status || 'mk-ready' === $status || 'mk-packing' === $status || 'mk-warehouse' === $status || 'pws-in-stock' === $status || 'pws-packaged' === $status || 'aw-d-warehouse' === $status || 'aw-ready-to-send' === $status ) {
				printf('%s', apply_filters( 'digix_processing_prograss_percent', '75' ));
			}
			elseif('completed' === $status) {
				printf('%s', apply_filters( 'digix_completed_prograss_percent', '100' ));
			}
		}

		// find payment method name from selected gateway ID
		public static function selected_gateway_name($selected) {

			$payment_method = WC()->payment_gateways->payment_gateways();		

			if(array_key_exists($selected, $payment_method)) {
				$payment_method_title = $payment_method[$selected]->title;
				echo $payment_method_title;
			}else {

				echo 'No exists';
			}

		}

		// check if order number exists
		public static function order_number_exists($order_number)
			{   
				if(get_post_type($order_number) == "shop_order")
				{
					return true;
				}
				else
				{
				return false;
				}
			}


	}
}

// Ajax action function
function digix_wc_order_tracking_result() {

	if(wp_verify_nonce( $_POST['Ali_nonce'], 'digix_nonce_data' )) {

        require_once( IM_DIR . '/includes/classes/tracking/track.php'); 

	}else {
		echo 'Invalid User';
	}

	exit;
}

add_action('wp_ajax_digix_wc_order_tracking_result', 'digix_wc_order_tracking_result');
add_action('wp_ajax_nopriv_digix_wc_order_tracking_result', 'digix_wc_order_tracking_result');




if(!class_exists('Digix_Order_Tracking')) {
	return;
}

// Order and Phone number is required
// function digix_order_number_phone_number_required(){
// 	printf('%s Order Number & Phone field is required %s', '<h3 class="digix_notice">', '</h3>');
// }
// add_filter( 'digix_order_number_phone_number_required', 'digix_order_number_phone_number_required');

// set limit for showing title in tracking page
function digix_product_title_trim_words($value) {
	return 7;
}
add_filter('digix_product_title_trim_words', 'digix_product_title_trim_words');


// set progress bar percent
function digix_sended_prograss_percent() {
	return 80;
}
add_filter('digix_sended_prograss_percent', 'digix_sended_prograss_percent');


function digix_order_is_not_found($value, $order_number) {

	$order_not_found = sprintf('%s Oops! Sorry! %s order is not found! please check order or phone number %s', '<h5 class="digix_notice">', $order_number, '</h5>');

	return $order_not_found;
}
add_filter('digix_order_is_not_found', 'digix_order_is_not_found', 10, 2);


