<?php 
 // Don't call the file directly
if ( !defined( 'ABSPATH' ) ) exit;

if(!class_exists('Digix_Order_Tracking')) {
	return;
}

?>
<div class="digix-tracking-list">
	<table>
		<tr>
			<td>کدرهگیری سفارش</td>
			<td><?php echo esc_html($order->get_id()); ?></td>
		</tr>
		<tr>
			<td>تاریخ ثبت سفارش</td>			
			<td><?php $timestamp2 = $order_data['date_created']->date('U'); echo dx_jdate('در تاریخ: Y/m/d در ساعت:  h:i:s ', $timestamp2);?></td>						
		</tr>
		<tr>
			<td>وضعیت سفارش</td>
			<td><?php echo esc_html( wc_get_order_status_name( $order->get_status() ) ); ?></td>	
		</tr>
		<tr>
			<td>بروزرسانی سفارش</td>
			<td><?php $timestamp2 = $order_data['date_modified']->date('U'); echo dx_jdate('در تاریخ: Y/m/d در ساعت:  h:i:s ', $timestamp2); ?></td>
		</tr>

			<tr>
				<td>محصول</td>	
				<td>
					<ul>
						<?php 
							$i = 0;
							foreach ($order->get_items() as $item_key => $item ):
								$i++;
						?>
							<li><a href="<?php the_permalink($item->get_product_id());?>"> <?php echo $i. '. '; echo esc_html(wp_trim_words($item->get_name(), apply_filters('digix_product_title_trim_words', 8), NULL));?></a></li>
						<?php endforeach; ?>
					</ul>
				</td>	
			</tr>									

		<tr>
			<td>نام خریدار</td>
			<?php if(!empty($order_data['shipping']['first_name'])) : ?>
				<td><?php echo esc_html($order_data['shipping']['first_name']); ?> <?php echo esc_html($order_data['shipping']['last_name']); ?></td>
			<?php else : ?>
				<td><?php echo esc_html($order_data['billing']['first_name']); ?> <?php echo esc_html($order_data['billing']['last_name']); ?></td>
			<?php endif; ?>
		</tr>
		<tr>
			<td>شماره تماس</td>
			<?php if(!empty($order_data['shipping']['phone'])) : ?>
				<td><?php echo esc_html($order_data['shipping']['phone']); ?></td>
			<?php else : ?>
				<td><?php echo esc_html($order_data['billing']['phone']); ?></td>
			<?php endif; ?>
		</tr>
		<tr>
			<td>یادداشت مشتری</td>
			<td><?php echo esc_html($order->get_customer_note()); ?></td>
		</tr>
		<tr>
			<td>روش تحویل</td>
			<td><?php echo esc_html($order->get_shipping_method()); ?></td>
		</tr>
		<tr>
			<td>روش پرداخت</td>
			<td><?php echo esc_html(Digix_Order_Tracking::selected_gateway_name($order->get_payment_method())); ?></td>
		</tr>
		<tr>
			<td>مجموع مبلغ سفارش</td>
			<td><?php echo esc_html(wc_format_decimal($order->get_total(), 2)); ?></td>
		</tr>
	</table>
</div>