<?php
/**
 * DIGIX functions and definitions
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @package DIGIX
 */
Global $options;


/*
 * Let WordPress manage the document title.
 * By adding theme support, we declare that this theme does not use a
 * hard-coded <title> tag in the document head, and expect WordPress to
 * provide it for us.
 */

add_theme_support( 'title-tag' );



#
##
# Enqueue scripts and styles in FrontEnd

function digix_wp_frontend_enqueue()
{
	Global $wp_query;
	Global $options;
	wp_enqueue_style('swiper',IM_URI . '/static/css/swiper.min.css',array(),'all');
	wp_enqueue_style('bootstrap',IM_URI . '/static/css/bootstrap.min.css',array(),'all');
	wp_enqueue_style('DigixFont',IM_URI . '/static/fonts/' . $options['font'] .'/font.css',array(),'all');
	wp_enqueue_style('digix',IM_URI . '/static/css/digix.min.css',array(),'all');
	wp_enqueue_style('style', IM_URI . '/static/css/style.min.css',array(),'all');
	wp_enqueue_style('styles', IM_URI . '/style.css',array(),'all');

	wp_enqueue_script('swiper',IM_URI . '/static/js/swiper.min.js', array(),'',true);
	wp_enqueue_script('popper',IM_URI . '/static/js/popper.min.js', array(),'',true);
	wp_enqueue_script('bootstrap',IM_URI . '/static/js/bootstrap.min.js', array(),'',true);
	
	wp_register_script('digixproductlocation',IM_URI.'/static/js/location-picker.js',array(),'',true);
	
	$localization = 
			array(
				'ajax_url' 		=> admin_url( 'admin-ajax.php' ) ,
				'admin_url' 	=> admin_url(),		
				'all_city' 		=> __("all cities","digix"),		
				'all_in_city' 	=> __("all cities in","digix"),		
				'select_city' 	=> __("Select at least one city","digix"),		
			);
	wp_localize_script('digixproductlocation', 'digixpicker', $localization);		
	wp_enqueue_script('digixproductlocation');
	if( is_account_page() ):
		wp_enqueue_script('track-order',IM_URI . '/static/js/track.js', array(),'',true);
		wp_localize_script( 'track-order', 'bix', array( 'ajaxurl' 		=> 	admin_url( 'admin-ajax.php' )));
	endif;
	if( is_account_page() || is_product() ):
	wp_enqueue_script('chart',IM_URI . '/static/js/chart.js');
	endif;
	if ( $options['woocommerce-checkout-map'] == 'yes' && (isset($options['woocommerce-map-api']) && !empty($options['woocommerce-map-api']) ) ){
	if( is_checkout() ):
		wp_enqueue_style('mappcss','https://cdn.map.ir/web-sdk/1.4.2/css/mapp.min.css',array(),'all');
		wp_enqueue_style('mappstyle','https://cdn.map.ir/web-sdk/1.4.2/css/fa/style.css',array(),'all');
	endif;
	}
	wp_register_script('digix',IM_URI . '/static/js/digix.js', array(),'',true);
	
	// Localize the script
	$translation = 
	array(
	'pro_search_ajaxurl' 		=> admin_url( 'admin-ajax.php' ) ,
	'admin_url' 				=> admin_url(),
	'dl_nonce'					=> wp_create_nonce( 'cld-ajax-nonce' ),
	'loadmore' 					=> __('load more','digix'),
	'hidebtn' 					=> __('load less','digix'),	
	'resultmore_one' 			=> __('You have searched for ','digix'),
	'resultmore_two' 			=> __(' product ( view more )','digix'),
	'single_ajax'				=> $options['woocommerce-single-ajax'],
	'loadless' 					=>'1',	
	'delay'         			=> (int) '300' ,	
		);
	wp_localize_script('digix', 'DIGIX', $translation);		
	wp_enqueue_script('digix');
}
add_action("wp_enqueue_scripts","digix_wp_frontend_enqueue");




#
##
# Enqueue scripts and styles in BackEnd

function digix_wp_backend_enqueue() 
{
	// wp_enqueue_media();
	// wp_enqueue_style( 'wp-color-picker' );
	wp_register_style('digix-admin',  IM_URI . '/static/css/admin.css',null,'');
	wp_enqueue_style( 'digix-admin' );
	// scripts
	wp_register_script('digix-admin', IM_URI . '/static/js/admin.js',array( 'jquery'),'',true);
	wp_enqueue_script( 'digix-admin' );
}
add_action( 'admin_enqueue_scripts', 'digix_wp_backend_enqueue' );


/**
 * Allow SVG through Media Uploader
 */
add_filter( 'upload_mimes', 'digix_mime_types' );
function digix_mime_types( $mimes ) {
	$mimes['svg'] = 'image/svg+xml';
	$mimes['webm'] = 'video/webm';
	$mimes['mp4']  = 'video/mp4';
	$mimes['ogg']  = 'video/ogg';

	return $mimes;
}

#
##
# Page Number 
function digix_number() {
	 global $wp_query;
	 $big = 999999999; // need an unlikely integer
	 $pageNum = $wp_query->max_num_pages ;
	 if($pageNum>1){ 
		echo '<div class="pagenav">';
			echo paginate_links( array(
			 'current' => max( 1, get_query_var('paged') ),
			 'prev_next' => false,
			 'total' => $wp_query->max_num_pages
			));
		echo '</div>';
    }
}
#
##
# analytics code
function analytics_code() 
{
	global $options;
	if ( $options['cutomize-analytics'] ) {
		echo '<script type="text/javascript">'. $options['cutomize-analytics'] .'</script>';
	}
}
add_action( 'wp_head', 'analytics_code', 100 );

#
##
# Hook Custom JS code to the footer

function custom_js() 
{
	global $options;

	if ( $options['cutomize-js'] ) {
		echo '<script type="text/javascript">'. $options['cutomize-js'] .'</script>';
	}
}
add_action( 'wp_footer', 'custom_js', 100 );

#
##
# Nav Menu Support

function digix_wp_register_menus() 
{
	register_nav_menus( array( 'mobile' => __('mobile menus','digix') ) );
	register_nav_menus( array( 'primary' => __('Megamenu','digix') ) );
	register_nav_menus( array( 'header' => __('Header Menu','digix') ) );
	register_nav_menus( array( 'footer' => __('Footer Menu','digix') ) );
	register_nav_menus( array( 'blog' => __('Blog Menu','digix') ) );
}
add_action( 'init', 'digix_wp_register_menus' );
add_theme_support( 'menus' );

#
##
# set view

function digix_wp_set_views( $postID ) 
{
	$count_key = 'post_views_count';
	$count = get_post_meta($postID, $count_key, true);
	if($count=='')
	{
		$count = 0;delete_post_meta( $postID, $count_key );
		add_post_meta( $postID, $count_key, '0' );
	}
	else 
	{
		$count++;update_post_meta( $postID, $count_key, $count );
	}
}

#
##
# get view

function digix_wp_get_views( $postID )
{
	$count_key = 'post_views_count';
	$count = get_post_meta( $postID, $count_key, true );
	$zero_view = '0' . __(' view ','digix');
	if($count=='') 
	{
		delete_post_meta( $postID, $count_key );
		add_post_meta( $postID, $count_key, '0' );
		return $zero_view;
	}
	return $count .' '. __('view','digix');
}

#
##
# Limit excerpt to a number of characters without cutting last word

function limit_words($string, $word_limit)
{
	$words = explode(' ', $string);
	return implode(' ', array_slice($words, 0, $word_limit));
}


#
##
# get is page built with elementor or not

function is_elementor()
{
    global $post;

    if (in_array('elementor/elementor.php', apply_filters('active_plugins', get_option('active_plugins')))) {
        return true;
    } else {
        return false;
    }
}

function is_elementor_active()
{
    if (in_array('elementor-pro/elementor-pro.php', apply_filters('active_plugins', get_option('active_plugins')))) {
        return true;
    } else {
        return false;
    }
}
add_action('wp_head', 'digix_notification_bar');

function digix_notification_bar(){
	Global $wp, $options; 
	if ( $options['digix_notifbar_activation'] == '1' ){
		if ( $options['digix_notifbar_home'] == '1' ) { 
		$current_url = home_url(add_query_arg(array($_GET), $wp->request));
			if ( $current_url != get_site_url() ) { 
				return;
			}
		}
		$sticky         = ( $options['digix_notifbar_sticky'] == '1') ? "sticky": "";
		if( $options['digix_notifbar_type'] == 'gif') {
			$url   		= $options['digix_notifbar_type_gif_url'];
			$img   		= $options['digix_notifbar_type_gif'];
			$html  		= "<section class='NotificationBar $class $sticky'>";
			$html 	   .= "<a href='$url' class='gifbar-url d-flex'>";
			$html      .= "<img class='gifbar-img' src='$img' alt='notification'>";
			$html      .= "</a>";
			$html      .= "</section>";
		} else if( $options['digix_notifbar_type'] == 'text') {
			$class		= "DDesktop";
			$bg	   		= !empty($options['digix_notifbar_type_text_img']) ? $options['digix_notifbar_type_text_img'] : "";
			$bgcolor	= $options['digix_notifbar_type_text_background'];
			$text		= $options['digix_notifbar_type_text'];
			$textcolor	= $options['digix_notifbar_type_text_color'];
			$center     = ($options['digix_notifbar_type_text_position'] == '1') ? "j-center":"";
			$buttontext	= $options['digix_notifbar_type_text_button_text'];
			$buttonurl	= $options['digix_notifbar_type_text_button_url'];
			$btncolor	= $options['digix_notifbar_type_text_button_color'];
			$btnbgcolor	= $options['digix_notifbar_type_text_button_background'];
			$close      = ($options['digix_notifbar_type_text_close'] == '1')? "<a class='textbar-close'><svg width='24' height='24' xmlns='http://www.w3.org/2000/svg' viewBox='0 0 24 24'><path d='M12 10.6L6.6 5.2 5.2 6.6l5.4 5.4-5.4 5.4 1.4 1.4 5.4-5.4 5.4 5.4 1.4-1.4-5.4-5.4 5.4-5.4-1.4-1.4-5.4 5.4z'></path></svg></a>" : "";
			$button		= ($options['digix_notifbar_type_text_button'] == '1')? "<div class='textbar-url $center'><a style='color:$btncolor;background:$btnbgcolor' href='$buttonurl' target='_blank' class='url'>$buttontext</a></div>":"";
			$html  		= "<section class='NotificationBar $class $sticky' style='background: url($bg);background-color:$bgcolor'>";
			$html      .= "<div class='container'>";
			$html      .= "<div class='textbar $center'>";
			$html      .= $close;
			$html      .= "<div class='textbar-text'>";
			$html      .= "<p style='color:$textcolor'>$text</p>";
			$html	   .= "</div>";
			$html      .= $button;
			$html	   .= "</div>";
			$html	   .= "</div>";
			$html	   .= "</section>";
		}
		
		echo $html;	
	}
}
#
##
# get is page built with VC or not

function is_wpb()
{
    global $post;

    if (in_array('js_composer/js_composer.php', apply_filters('active_plugins', get_option('active_plugins')))) {
        return get_post_meta($post->ID, '_wpb_vc_js_status', true);
    } else {
        return false;
    }
}

function is_wpb_active()
{
    if (in_array('js_composer/js_composer.php', apply_filters('active_plugins', get_option('active_plugins')))) {
        return true;
    } else {
        return false;
    }
}



#
##
# Register Siebar

register_sidebar(array(
	'name' 				=> __('shop sidebar','digix'),
	'id' 				=> 'shop', 
	'before_title' 		=> '<header class="widget-header"><h3 class="widget-title">', 
	'after_title' 		=> '</h3></header><figure class="widget-content">',
	'before_widget' 	=> '<div class="%2$s widget">',
	'after_widget' 		=> '</figure></div>', 
 ));



#
##
# Digix Floating contact button


function digix_floating_contact_button()
{
	Global $options;
	if( $options['contact-floating'] != 'yes'){
		return;
	}
	$button =  '<section class="floating-contact">';
	$button .= '<div class="cards">';
	$button .= '<ul class="contact-list">';
	if(  isset($options["contact-telegram"]) && !empty($options["contact-telegram"])) : $button .= '<li class="contact-item"><a href="' . $options["contact-telegram"] . '">' . __('contact from telegram','digix') . '<i class="icon-telegram"></i></a></li>';endif;
	if(  isset($options["contact-phone"]) && !empty($options["contact-phone"])) : $button .= '<li class="contact-item"><a href="tel:' . $options["contact-phone"] . '">' . __('contact from phone','digix') . '<i class="icon-phone"></i></a></li>';endif;
	if(  isset($options["contact-mobile"]) && !empty($options["contact-mobile"])) : $button .= '<li class="contact-item"><a href="tel:' . $options["contact-mobile"] . '">' . __('contact from mobile','digix') . '<i class="icon-mobile"></i></a></li>';endif;
	if(  isset($options["contact-instagram"]) && !empty($options["contact-instagram"])) : $button .= '<li class="contact-item"><a href="' . $options["contact-instagram"] . '">' . __('contact from instagram','digix') . '<i class="icon-instagram"></i></a></li>';endif;
	if(  isset($options["contact-eitaa"]) && !empty($options["contact-eitaa"])) : $button .= '<li class="contact-item"><a href="' . $options["contact-eitaa"] . '">' . __('contact from eitaa','digix') . '<i class="icon-eitaa"></i></a></li>';endif;
	if(  isset($options["contact-bale"]) && !empty($options["contact-bale"])) : $button .= '<li class="contact-item"><a href="' . $options["contact-bale"] . '">' . __('contact from bale','digix') . '<i class="icon-bale"></i></a></li>';endif;
	if(  isset($options["contact-rubika"]) && !empty($options["contact-rubika"])) : $button .= '<li class="contact-item"><a href="' . $options["contact-rubika"] . '">' . __('contact from rubika','digix') . '<i class="icon-rubika"></i></a></li>';endif;
	if(  isset($options["contact-gap"]) && !empty($options["contact-gap"])) : $button .= '<li class="contact-item"><a href="' . $options["contact-gap"] . '">' . __('contact from gap','digix') . '<i class="icon-gap"></i></a></li>';endif;
	if(  isset($options["contact-sapp"]) && !empty($options["contact-sapp"])) : $button .= '<li class="contact-item"><a href="' . $options["contact-sapp"] . '">' . __('contact from sorush','digix') . '<i class="icon-sapp"></i></a></li>';endif;
	if(  isset($options["contact-whatsapp"]) && !empty($options["contact-whatsapp"])) : $button .= '<li class="contact-item"><a href="https://wa.me/' . $options["contact-whatsapp"] . '">' . __('contact from whatsapp','digix') . '<i class="icon-whatsapp"></i></a></li>';endif;
	if(  isset($options["contact-mail"]) && !empty($options["contact-mail"])) : $button .= '<li class="contact-item"><a href="mailto:' . $options["contact-mail"] . '">' . __('contact from mail','digix') . '<i class="icon-mail"></i></a></li>';endif;
	$button .= '</ul>';
	$button .= '</div>';
	$button .= '<div class="floating-button">';
	$button .= '<i class="icon-comment icon wa"></i>';
	$button .= '<i class="icon-letter-x icon close fbtn-close"></i>';
	$button .= '</div>';
	$button .= '</section>';
	echo $button;
}

add_action('wp_footer','digix_floating_contact_button',10);



#
##
# Custom styling from color scheme 

function head_contents() {
	global $options;
	$favicon = $options['general-icon'];
	?>

	<meta name="theme-color" content="<?= $options['mobile-browsercolor']; ?>">
	<meta name="msapplication-navbutton-color" content="<?= $options['mobile-browsercolor']; ?>">
	<meta name="apple-mobile-web-app-capable" content="yes">
	<meta name="apple-mobile-web-app-status-bar-style" content="black-translucent">

	<?php if ( $favicon ) { ?>  
	<link rel="apple-touch-icon" sizes="57x57" href="<?= $favicon; ?>">

	<link rel="icon" type="image/png" sizes="192x192" href="<?= $favicon; ?>">
	<?php } ?>

	<?php

}
add_action( 'wp_head', 'head_contents' );

function digix_term_links( $term_tax, $term_ids ) {
	if ( is_array( $term_ids ) ){
		$term_tax_link = ( $term_tax == 'category' ? 'cat' : $term_tax );
		$term_tax_link = ( $term_tax == 'post_tag' ? 'tag' : $term_tax );
		if( count( $term_ids ) == 1 ) {
			$term_link = get_term_link( (int)$term_ids[0], $term_tax );
		} else {
			$term_link = get_home_url() . '/?' .$term_tax_link.'=';
			foreach( $term_ids as $id ) {
				$term = get_term( $id, $term_tax );
				$slug = $term->slug;
				$term_link .= $slug . ',';
			}
		}
	} else {
		$term_link = get_term_link( (int)$term_ids, $term_tax );
	}
	return $term_link;
}

#
##
# Custom styling from color scheme 

function custom_css() 
{
	global $options;
	$bodycolor = $options['general-bodycolor'];
	if( isset($options['general-width']) && !empty($options['general-width']) ) {
		$generalwidth = $options['general-width'];
	}
	$general_logo_cpattern = $options['general-logo-cpattern'];
	$footer_cosmetic_social_color = $options['footer-cosmetic-social-color'];
	$woocommerce_archive_number = $options['woocommerce-archive-number'];
	$woocommerce_related_number = $options['woocommerce-related-number'];
	$related_color = $options['woocommerce-related-color'];
	$pitem_h2a = $options['woocommerce-pitem-h2a'];
	$pitem_h2a_size = $options['woocommerce-pitem-h2a-size'];
	$addcart = $options['woocommerce-addcart-color'];
	$single_addcart = $options['woocommerce-singleaddcart-color'];
	$del = $options['woocommerce-sale-color'];
	$price = $options['woocommerce-price-color'];
	$color = $options['general-color'];
	$subcolor = $options['general-subcolor'];
	$navigation_bgcolor = $options['woocommerce-tab']['navigation-bgcolor'];
	$item1_bgcolor = $options['woocommerce-tab']['item1-bgcolor'];
	$item2_bgcolor = $options['woocommerce-tab']['item2-bgcolor'];
	$item3_bgcolor = $options['woocommerce-tab']['item3-bgcolor'];
	$item4_bgcolor = $options['woocommerce-tab']['item4-bgcolor'];
	$myaccount_menubgcolor = $options['woocommerce-tab']['myaccount-menubgcolor'];
	$myaccount_menucolor = $options['woocommerce-tab']['myaccount-menucolor'];
	$contact_color = $options['contact-color'];

	?>
	<style>
		body{
			background-color:<?php echo $bodycolor;?>;
		}
		<?php if( isset($generalwidth) && !empty($generalwidth) ) { ?>
		.container {
			max-width: <?php echo $generalwidth; ?>px;
		}
		<?php } ?>
		header.header-cosmetic .up .logo a::before{
			background: url('<?php echo $general_logo_cpattern; ?>') no-repeat 0 0;
		}
		.cosmetic-footer .sectiondown .down .right .social ul li{
			border-color:<?php echo $footer_cosmetic_social_color; ?>;
		}
		.cosmetic-footer .sectiondown .down .right .social ul li a {
			color: <?php echo $footer_cosmetic_social_color; ?>;
		}
		.header-cosmetic .up{
			background:<?php echo $options['general-cosmetic-topline-bg'];?> !important;
		}
		.header-cosmetic .down {
			background-color: <?php echo $options['general-cosmetic-bg'];?> !important;
		}
		.header-cosmetic .down .top .align-center .support svg, .header-cosmetic .down .top .align-center .support svg *, header.header-cosmetic .down .top .align-center .address svg, header.header-cosmetic .down .top .align-center .address svg * {
			stroke: <?php echo $options['general-cosmetic-colorcomp'];?>;
		}
		header.header-cosmetic .down .top .align-center .address svg, header.header-cosmetic .down .top .align-center .address svg * {
			fill: <?php echo $options['general-cosmetic-colorcomp'];?>;
		}
		header.header-cosmetic .down .top .align-center .social ul li a i, header.header-cosmetic .down .btm .align-center .navigation .megamenu .megamenu-title, header.header-cosmetic .down .btm .align-center .navigation .megamenu .icon-bars, header.header-cosmetic .down .btm .align-center .user .user-cart .cart i, header.header-cosmetic .down .btm .align-center .user .myaccount i, header.header-cosmetic .down .btm .align-center .user .myaccount a, header.header-cosmetic .down .btm .align-center .user .myaccount button{
			color:<?php echo $options['general-cosmetic-colorcomp'];?>;
		}
		header.header-cosmetic .down .btm .align-center .navigation .megamenu::after{
			border-color:<?php echo $options['general-cosmetic-colorcomp'];?>;
		}
		header.header-cosmetic .down .btm .align-center .search form input{
			background-color:<?php echo $options['general-cosmetic-colorsearch'];?>;
		}
		<?php if($woocommerce_archive_number == 5 ){?>
		.woocommerce .wc-archive .wc-content .woocommerce-archive{
			grid-gap: 10px;
			-ms-grid-columns: minmax(0, 1fr) [5];
			grid-template-columns: repeat(5, minmax(0, 1fr));
			margin-bottom: 10px;
		}
		.woocommerce .wc-archive .wc-content .woocommerce-archive .product-item .product-thumbnails a {
			position: relative;
			width: 150px !important;
			height: 150px !important;
		}
		.woocommerce .wc-archive .wc-content .woocommerce-archive .product-item .product-thumbnails a img {
			max-width: 150px !important;
		}
		.woocommerce .wc-archive .wc-content .woocommerce-archive .product-item .product-detailes h2 {
			height: 50px;
			margin-bottom: 10px;
		}
		.woocommerce .wc-archive .wc-content .woocommerce-archive .product-item .product-detailes h2 a {
			line-height: 2;
			height: 50px;
			overflow: hidden;
			text-overflow: clip;
			display: block;
			font-size: 12px;
			color: #424242;
		}
		<?php } ?>
		.im-product.products .product-item .product-detailes h2 a, .im-product.woocommerce-archive .product-item .product-detailes h2 a{
			font-size:<?php echo $pitem_h2a_size;?>px;
			color:<?php echo $pitem_h2a; ?>;
		}
		.woocommerce div.product form.cart .button {
			background-color:<?php echo $single_addcart;?>;
		}
		.im-product .product-item .product-detailes .product-add button {
			background-color:<?php echo $addcart;?>;
		}
		.im-product.products .swiper-container h3{
			color:<?php echo $related_color;?>;
		}
		.im-product.products .swiper-container h3.right strong{
			color:<?php echo $related_color;?>;
		}
		.im-product.products .swiper-container h3.right strong:after{
			background:<?php echo $related_color;?>;
		}
		/*** price ***/
		.woocommerce div.product span.price del {
			color: <?php echo $del;?>;
			font-size: 17px;
		}
		.im-product .product-item .product-detailes .product-add .product-price del{
			color:<?php echo $del;?>;
		}
		.woocommerce div.product span.price {
			color:<?php echo $price;?>;
		}
		.im-product .product-item .product-detailes .product-add .product-price>span, .im-product .product-item .product-detailes .product-add .product-price ins {
			color:<?php echo $price;?>;
		}
		
		/*** General Color ***/
		.woocommerce div.product .woocommerce-tabs .panel.woocommerce-Tabs-panel--reviews .digix-wc-review header.review-header .product-review-detailes .submit-review .add-review-uri a {
			background-color:<?php echo $color;?>;
		}
		.woocommerce div.product .woocommerce-tabs ul.tabs li.active {
			border-bottom-color:<?php echo $color;?>;
		}
		.woocommerce div.product .woocommerce-tabs .panel.woocommerce-Tabs-panel--reviews .digix-wc-review .review-entry .review-box .review-wrapper .comment-respond form .form-submit input[type=submit] {
			background-color: <?php echo $color;?> !important;
		}
		.woocommerce .wc-archive .sidebar .widget .widget-content .price_slider_wrapper .price_slider_amount .button {
			background-color: <?php echo $color;?>;
		}
		.woocommerce .woocommerce-Button {
			background-color: <?php echo $color;?> !important;
		}
		.woocommerce .woocommerce-Button:hover {
			background-color: <?php echo $color;?> !important;
		}
		.woocommerce button.button {
			background-color: <?php echo $color;?>;
		}
		.woocommerce button.button:hover {
			background-color: <?php echo $color;?>;
		}
		.woocommerce-account .myaccount-notification header h3 {
			background: <?php echo $color;?>;
		}
		.woocommerce-account .woocommerce-MyAccount-content .order-tracking-container .digix-tracking-from form input[type=submit] {
			background-color: <?php echo $color;?>;
		}
		header#im-header .header-down .header-woo .im-cart .mini-cart .cart-empty .empty-btn a {
			color: <?php echo $color;?>;
		}
		header#im-header .header-down .header-woo .im-cart .mini-cart .mini-cart-footer .woocommerce-mini-cart__buttons a {
			background-color: <?php echo $color;?>;
		}
		.woocommerce .woo-cart-form .cart-detailes .cart_totals .wc-proceed-to-checkout a {
			background-color: <?php echo $color;?>;
		}
		.woocommerce .woo-cart-form .cart-detailes .cart_totals .wc-proceed-to-checkout a:hover {
			background-color: <?php echo $color;?>;
		}
		.woocommerce .woo-cart-form .cart-customize .cart-coupon>button {
			background-color: <?php echo $color;?>;
		}
		.woocommerce .woo-cart-form .cart-customize .cart-coupon>button:hover {
			background-color: <?php echo $color;?>;
		}
		.woocommerce form.checkout.woocommerce-checkout .woocommerce-checkout-review-order #payment div.form-row #place_order {
			background-color: <?php echo $color;?>;
		}
		.woocommerce .order-successful {
			color: <?php echo $color;?>;
		}
		header.headers .up .list .user a.heart span, header.headers .up .list .user a.cart span{
			background-color: <?php echo $color;?>;
		}
		header.headers .up .list .user .user-cart .mini-cart .cart-empty .empty-btn a{
			color: <?php echo $color;?>;
		}
		path.emptypath{
			fill: <?php echo $color;?> !important;
		}
		.digix-post .wp_btn_more button{
			background: <?php echo $color;?> !important;
		}
		.cart-is-empty-text a{
			background-color: <?php echo $color;?> !important;
			border-color: <?php echo $color;?> !important;
		}
		/*** complement ***/
		
		header#im-header .header-down .header-woo .im-user.access .mini-user .user-detailes {
			background: <?php echo $subcolor;?>;
		}
		.woocommerce-account .myaccount-notification header a {
			background-color: <?php echo $subcolor;?>;
		}
		.checkout-process ul li.true-bar p {
			color: <?php echo $subcolor;?>;
		}
		.checkout-process ul li.true-bar span {
			background-color: <?php echo $subcolor;?> !important;
		}
		.woocommerce form.checkout.woocommerce-checkout .woocommerce-checkout-review-order .order-time .list .item input:checked+label {
			border-color: <?php echo $subcolor;?>;
			color: <?php echo $subcolor;?>;
		}
		.woocommerce-account .woocommerce-MyAccount-navigation .panel-user header{
			background : <?php echo $navigation_bgcolor;?>;
		}
		.woocommerce-account .myaccount-detailes .detailes-panel .detailes-item:nth-child(1) {
			background-color: <?php echo $item1_bgcolor;?>;
		}
		.woocommerce-account .myaccount-detailes .detailes-panel .detailes-item:nth-child(2) {
			background-color: <?php echo $item2_bgcolor;?>;
		}
		.woocommerce-account .myaccount-detailes .detailes-panel .detailes-item:nth-child(3) {
			background-color: <?php echo $item3_bgcolor;?>;
		}
		.woocommerce-account .myaccount-detailes .detailes-panel .detailes-item:nth-child(4) {
			background-color: <?php echo $item4_bgcolor;?>;
		}
		.woocommerce-account .woocommerce-MyAccount-navigation .Myaccount-navigation li.is-active a{
		    border-color: <?php echo $myaccount_menucolor;?> !important;
		    color: <?php echo $myaccount_menucolor;?> !important;
		    background-color: <?php echo $myaccount_menubgcolor;?> !important;
		}
		.floating-contact .floating-button{
		    background-color: <?php echo $contact_color;?> !important;
		}
		<?php
			if ( $options['cutomize-css'] ) {
				echo $options['cutomize-css'];
			}
		?>
	</style>

	<?php
}
add_action( 'wp_head', 'custom_css', 100 );

// For good measure, you can also add the follow code, which will hide errors from being displayed on-screen
@ini_set('display_errors', 0);