<?php

global $post, $product;


	$attachment_ids = $product->get_gallery_image_ids();

// Add thumbnail to gallery
if( has_post_thumbnail() ) {
	$product_thumbnail_id = get_post_thumbnail_id();
	if( $product_thumbnail_id ) {
		$attachment_ids = array_merge( array( $product_thumbnail_id ), $attachment_ids );
	}
}

?>

<div class="digix-lightbox">
	<div class="digix-lightbox-container close">
		<div class="digix-lightbox-overlay"></div>
		<div class="digix-lightbox-wrapper">
			<div class="digix-lightbox-close"></div>
			<div class="digix-header">
					<?php the_title('<span class="digix-product-title">', '</span>'); ?>
					<a class="digix-button digix-back-button"><span><?php esc_html_e( 'Back', 'avashop' ); ?></span></a>
			</div>
			<div class="digix-lightbox-thumbnails">
				<div class="swiper-container">
					<div class="swiper-wrapper">
						<?php
						if( $attachment_ids ) {
							$loop = 1;
							foreach( $attachment_ids as $attachment_id ) {
								$video_url = null;
								
								echo '<div data-digix-type="' . ( $video_url ? 'video' : 'image' ) . '" data-digix-index="' . $loop . '" class="swiper-slide">';

								$props = wc_get_product_attachment_props( $attachment_id, $post );

								if( ! $props['url'] ) {
									continue;
								}

								echo apply_filters(
									'woocommerce_single_product_image_thumbnail_html',
									sprintf(
										'<a href="%s" class="%s" title="%s">%s</a>',
										esc_url( $props['url'] ),
										( empty( $video_url ) ? 'digix-image-thumbnail' : 'digix-video-thumbnail' ),
										esc_attr( $props['caption'] ),
										wp_get_attachment_image( $attachment_id, apply_filters( 'single_product_small_thumbnail_size', 'shop_catalog' ) )
									),
									$attachment_id,
									$post->ID,
									esc_attr( '' )
								);

								echo '</div>';

								$loop++;
							}
						}
						?>
					</div>
				</div>
			</div>
			<ul class="digix-lightbox-content">
				<?php
				if( $attachment_ids ) {
					$loop = 1;
					foreach( $attachment_ids as $attachment_id ) {
						$video_url = null;

						echo '<li data-digix-index="' . esc_attr( $loop ) . '">';

						$props = wc_get_product_attachment_props( $attachment_id, $post );

						if( ! $props['url'] ) {
							continue;
						}

						if( $video_url ) {
							echo '<iframe width="100%" height="100%" src="" frameborder="0" allowfullscreen="true" webkitallowfullscreen="true" mozallowfullscreen="true" data-digix-src="'.esc_url( $video_url ).'" id="digix-lightbox-video-' . esc_attr( $loop ) . '"></iframe>';
							echo '<div class="digix-loading-wrapper" id="digix-loading-wrapper-' . esc_attr( $loop ) .'" ><div class="digix-loader digix-loading-bar"></div></div>';
						} else {
							echo '<div class="digix-middle-table-cell">';
							
							$image_attributes = wp_get_attachment_image_src( $attachment_id, 'woocommerce_single', false );
							?>
							<img alt="<?php echo $props['title']; ?>" src="" data-digix-src="<?php echo $props['full_src']; ?>" width="<?php echo $image_attributes[1]; ?>" height="<?php echo $image_attributes[2]; ?>" id="digix-lightbox-image-<?php echo esc_attr( $loop ); ?>" class="digix-lightbox-image">
							<div class="digix-loading-wrapper" id="digix-loading-wrapper-<?php echo esc_attr( $loop ); ?>" ><div class="digix-loader digix-loading-bar"></div></div>
							<?php
							echo '</div>';
						}

						echo '</li>';

						$loop++;
					}
				}
				?>
			</ul>
		</div>
	</div>
</div>