<?php


// Notification Taxonomy Functions


add_filter('the_content', 'digix_notifications_guestes');
function Notifications() {
	$labels = array(
		'name'                  => __( 'Notifications', 'digix' ),
		'singular_name'         => __( 'Notifications', 'digix' ),
		'menu_name'             => __( 'Notifications', 'digix' ),
		'name_admin_bar'        => __( 'Notifications', 'digix' ),
		'archives'              => __( 'Notifications Archive', 'digix' ),
		'attributes'            => __( 'Notification attributes', 'digix' ),
		'parent_item_colon'     => __( 'Parent', 'digix' ),
		'all_items'             => __( 'All Notifications', 'digix' ),
		'add_new_item'          => __( 'Add Notification', 'digix' ),
		'add_new'               => __( 'Add', 'digix' ),
		'new_item'              => __( 'New Notification', 'digix' ),
		'edit_item'             => __( 'Edit', 'digix' ),
		'update_item'           => __( 'Update', 'digix' ),
		'view_item'             => __( 'Show', 'digix' ),
		'view_items'            => __( 'Show Notifications', 'digix' ),
		'search_items'          => __( 'Search in Notifications', 'digix' ),
		'not_found'             => __( 'Not Found', 'digix' ),
		'not_found_in_trash'    => __( 'Not Found In Trash', 'digix' ),
	);
	$args = array(
		'label'                 => __( 'Notification', 'digix' ),
		'description'           => __( 'Description', 'digix' ),
		'labels'                => $labels,
		'supports'              => array( 'title', 'editor', 'custom-fields' ),
		'hierarchical'          => false,
		'public'                => true,
		'publicly_queryable' 	=> false,
		'show_ui'               => true,
		'show_in_menu'          => true,
		'menu_position'         => 5,
		'show_in_admin_bar'     => true,
		'show_in_nav_menus'     => true,
		'can_export'            => true,
		'has_archive'           => true,
		'exclude_from_search'   => false,
		'query_var'				=> true,
		'rewrite' 				=> array('slug' => 'notifications'),
		'menu_icon' 			=> 'dashicons-megaphone',
		'capability_type'       => 'post',
	);
	register_post_type( 'Notifications', $args );
}
add_action( 'init', 'Notifications', 0 );
function digix_notifications_guestes($content)
    {
        global $post;
        if ($post->post_type == 'notifications') {
            if (!is_user_logged_in()) {
                $content = __( 'You will not be able to view this Notification.', 'digix' );
            }
        }
        return $content;
    }
	




// Notification EndPoints  { Woocommerce Myaccount }

	
	
	function digix_is_endpoint( $endpoint = false ) {
		global $wp_query;
		if( !$wp_query )
			return false;
		return isset( $wp_query->query[ $endpoint ] );
	}
	function digix_account_menu_items( $items ) {
		$items = array_slice( $items, 0, 6, true )
			+ array( 'notification' => __( 'Notifications', 'digix' ) )
			+ array_slice( $items, 6, null, true );
		return $items;
	}
	add_filter( 'woocommerce_account_menu_items', 'digix_account_menu_items', 25 );
	function digix_add_my_account_endpoint() {
		add_rewrite_endpoint( 'notification', EP_PAGES );
	}
	add_action( 'init', 'digix_add_my_account_endpoint' );





// Notification content


function digix_notification_endpoint_content() {
	$paged = isset($_GET['pagenum']) ? intval($_GET['pagenum']) : 1;
	$number = 10;
	if (isset($_GET['view'])) {
		$postid = $_GET['view'];
		$post = get_post($postid);
		if ($post) {
			update_user_meta(get_current_user_id(), 'read_post_' . $postid, true) ?>
			<div class="notification-content">
				<h1 class="notification-title"><?php echo $post->post_title; ?></h1>
				<article class="notification-body">
						<?php echo $post->post_content; ?>
				</article>
			</div>
			<?php
			}
	} else {?>
			<section class="myaccount-notification">
                <header class="notifications-header">
                    <h3><?php echo __( 'Latest Notification', 'digix' ); ?></h3>
                </header>
			<?php
			$args = array(
				'numberposts' => -1,
				'post_type' => 'notifications',
				'posts_per_page' =>  $number,
				'post_status' => array('publish'),
				'paged'          =>  $paged,
				);
			$sep = '';
			$query = new WP_Query($args);
			if ($query->have_posts()) :
				$num = null;?>
				<div class="notification">
					<ul class="notification-list" >
						<?php while ( $query->have_posts()) : $query->the_post(); ?>
							<li class="<?php get_notification_unread(get_the_ID());?>">
								<a href="<?php echo get_permalink( get_option('woocommerce_myaccount_page_id') ); ?>notification/?view=<?php the_ID(); ?>">
									<span class="notification-icon"></span>
									<h6><?php the_title(); ?></h6>
									<span class="notification-time"><?php echo human_time_diff(get_the_time('U'), current_time('timestamp')) . ' پیش';?></span>
								</a>
							</li>
						<?php endwhile; ?>
					</ul>
				</div>
		<?php else : ?>
				<div class="alert alert-info">
				<?php echo __( 'There Is No Notification', 'digix' ); ?>
				</div>
		<?php endif; ?>
		<?php wp_reset_query(); ?>
	</section>
<?php }
}
add_action( 'woocommerce_account_notification_endpoint', 'digix_notification_endpoint_content' );


/**
 * avashop Notifications
 *
 */
 
 function digix_woocommerce_notification(){?>
        <section class="myaccount-notification">
                <header class="notifications-header">
                    <h3><?php echo __( 'Latest Notification', 'digix' ); ?></h3>
                    <a href="<?php echo esc_url( trailingslashit( wc_get_account_endpoint_url( 'notification' ) ) ); ?>">
                        <span><?php echo __('view all','digix');?></span>
                        <i class="icon-arrow-left"></i>
                    </a>
                </header>
                <?php query_posts("&showposts=2&post_type=notifications"); ?>
                <?php if( have_posts() ):?>
                    <div class="notification">
                        <ul class="notification-list" >
                            <?php while (have_posts()) : the_post(); ?>
                                <li class="<?php get_notification_unread(get_the_ID());?>">
                                    <a href="<?php echo get_permalink( get_option('woocommerce_myaccount_page_id') ); ?>notification/?view=<?php the_ID(); ?>">
                                        <span class="notification-icon"></span>
                                        <h6><?php the_title(); ?></h6>
                                        <span class="notification-time"><?php echo human_time_diff(get_the_time('U'), current_time('timestamp')) . ' پیش';?></span>
                                    </a>
                                </li>
                            <?php endwhile; ?>
                        </ul>
                    </div>
                <?php endif;?>
                <?php wp_reset_query(); ?>
        </section>
    <?php
    }
    
    function digix_call_myaccount_dashboard_notification(){
        
        $current_url = (isset($_SERVER['HTTPS']) ? "https" : "http") . "://$_SERVER[HTTP_HOST]$_SERVER[REQUEST_URI]";
        $myaccount_url = esc_url(get_permalink( get_option('woocommerce_myaccount_page_id')));
        
        if(is_user_logged_in() && $myaccount_url == $current_url){
            add_action('woocommerce_after_account_navigation','digix_woocommerce_notification', 10);
        }
    }
    add_action('init','digix_call_myaccount_dashboard_notification');
    
    
    
    
    /**
     * seen notification / Get Notification Unread
     *
     */
     
     function get_notification_unread($post_id){
        global $current_user;
        if(get_user_meta(get_current_user_id(), 'read_post_' . $post_id, true) == ""){
            if(fsdate('Y-m-d',get_the_date('Y-m-d',$post_id)) >= fsdate('Y-m-d', $current_user->user_registered)){
                echo 'unread';
            }
        }
    }
    function fsdate($format, $time, $tr_num = '')
{
    if (function_exists('wpp_jdate')) {
        return wpp_jdate($format, $time, $tr_num);
    } else {
       // return date($format, $time);
    }
}
    