<?php

if( class_exists( 'CSF' ) ) {

    //
    // Set a unique slug-like ID
    $prefix = 'digix_option';
  
    //
    // Create options
    CSF::createOptions( $prefix, array(
      'menu_title' => __('تنظیمات پوسته','digix'),
      'menu_slug'  => 'theme-options',
    ) );
  
    
  
    //
	//
    // Woocommerce section
    CSF::createSection( $prefix, array(
	  'id' 	   => 'general',
	  'icon'   => 'fas fa-home',
      'title'  => __('تنظیمات عمومی','digix'),
      'fields' => array(
	)));
	CSF::createSection( $prefix, array(
	  'parent' 	   => 'general',
      'title'  => __('پیکربندی فونت','digix'),
      'fields' => array(
		array(
			'id'          => 'font',
			'type'        => 'select',
			'title'       => __('فونت پوسته','digix'),
			'placeholder' => __('فونت پوسته را انتخاب نمایید','digix'),
			'default'		=> 'kalameh',
			'options'     => array(
				'kalameh'       	=> __('کلمه','digix'),
				'iranyekan'       	=> __('ایران یکان','digix'),
			),
        ),	
		// array(
			// 'id'    		=> 'admin_font',
			// 'type'  		=> 'switcher',
			// 'default' 		=> false,
			// 'title' 		=> __('تغییر فونت پیشخوان','digix'),
		// ),
		// array(
			// 'id'          => 'font',
			// 'type'        => 'select',
			// 'dependency'  => array( 'admin_font', '==', true ),
			// 'title'       => __('فونت پوسته','digix'),
			// 'placeholder' => __('فونت پوسته را انتخاب نمایید','digix'),
			// 'default'	  => 'kalameh',
			// 'options'     => array(
				// 'kalameh'       	=> __('کلمه','digix'),
				// 'iranyekan'       	=> __('ایران یکان','digix'),
			// ),
        // ),
	  )
    ) );
    // General section
    CSF::createSection( $prefix, array(
	  'parent' 	   => 'general',
      'title'  => __('همگانی','digix'),
      'fields' => array(
  
        // field
        array(
          'id'    => 'general-title',
          'type'  => 'text',
          'title' => __('عنوان سایت','digix'),
        ),
        array(
          'id'    => 'general-description',
          'type'  => 'textarea',
          'title' => __('توضیخات سایت','digix'),
        ),
		array(
          'id'      => 'general-width',
          'type'    => 'text',
          'title'   => __('عرض کانتینر سایت( بهترین سایز 1440 پیکسل میباشد)','digix'),
          'default' => '1440',
          'placeholder' => '1440',
        ),
		array(
          'id'          => 'general-header',
          'type'        => 'select',
          'title'       => __('سربرگ فروشگاه','digix'),
          'placeholder' => __('سربرگ فروشگاه را انتخاب کنید','digix'),
		  'default'		=> 'header-modern',
          'options'     => array(
            'header-default'       => __('سربرگ پیشفرض','digix'),
            'header-modern'        => __('سربرگ مدرن','digix'),
            'header-cosmetic'        => __('سربرگ مناسب فروشگاه لوازم آرایشی','digix'),
          ),
        ),
		array(
          'id'      => 'general-logo-m',
          'type'    => 'upload',
		  'dependency' 	=> array( 'general-header', '==', 'header-modern' ),
          'title'   => __('لوگو سربرگ','digix'),
          'subtitle'   => __('سایز لوگو باید 180پیکسل در 45پیکسل باشد','digix'),
          'library' => 'image',
        ),
        array(
          'id'      => 'general-logo-d',
          'type'    => 'upload',
		  'dependency' 	=> array( 'general-header', '==', 'header-default' ),
          'title'   => __('لوگو سربرگ','digix'),
          'subtitle'   => __('سایز لوگو باید 220پیکسل در 40پیکسل باشد','digix'),
          'library' => 'image',
        ),
		array(
          'id'      => 'general-logo-c',
          'type'    => 'upload',
		  'dependency' 	=> array( 'general-header', '==', 'header-cosmetic' ),
          'title'   => __('لوگو سربرگ','digix'),
          'subtitle'   => __('سایز لوگو باید 125پیکسل در 45پیکسل باشد','digix'),
          'library' => 'image',
        ),
		array(
          'id'      => 'general-logo-cpattern',
          'type'    => 'upload',
		  'dependency' 	=> array( 'general-header', '==', 'header-cosmetic' ),
		  'default' => DIGIX_IMG . 'pattern-cosmetic.png',
          'title'   => __('پترن سربرگ','digix'),
          'subtitle'   => __('سایز پترن باید 240پیکسل در 60پیکسل باشد','digix'),
          'library' => 'image',
        ),
		array(
		  'id'    => 'general-header-tracking',
		  'type'  => 'switcher',
		  'dependency' 	=> array( 'general-header', '==', 'header-modern' ),
		  'default' => true,
		  'title' => __('دکمه پیگیری سفارشات','digix'),
		  'subtitle' => __('دکمه ارجاع به صفحه پیگیری سفارشات فعال باشد؟','digix'),
		),
		array(
		  'id'    => 'general-header-sale',
		  'type'  => 'switcher',
		  'dependency' 	=> array( 'general-header', '==', 'header-modern' ),
		  'default' => true,
		  'title' => __('دکمه فروش ویژه','digix'),
		  'subtitle' => __('دکمه ارجاع به صفحه فروش ویژه فعال باشد؟','digix'),
		),
		array(
          'id'      => 'general-cosmetic-topline-bg',
		  'dependency' 	=> array( 'general-header', '==', 'header-cosmetic' ),
          'type'    => 'color',
          'title'   => __('رنگ نوار بالایی سربرگ','digix'),
          'default' => '#ff4d6d',
        ),
		array(
          'id'      => 'general-cosmetic-bg',
		  'dependency' 	=> array( 'general-header', '==', 'header-cosmetic' ),
          'type'    => 'color',
          'title'   => __('رنگ پس زمینه سربرگ','digix'),
          'default' => '#ffe9ed',
        ),
		array(
          'id'      => 'general-cosmetic-colorcomp',
		  'dependency' 	=> array( 'general-header', '==', 'header-cosmetic' ),
          'type'    => 'color',
          'title'   => __('رنگ مکمل سربرگ','digix'),
          'default' => '#ff4d6d',
        ),
		array(
          'id'      => 'general-cosmetic-colorsearch',
		  'dependency' 	=> array( 'general-header', '==', 'header-cosmetic' ),
          'type'    => 'color',
          'title'   => __('رنگ پسزمینه نوار جستجو','digix'),
          'default' => '#ff4d6d',
        ),
		
		
        array(
          'id'      => 'general-icon',
          'type'    => 'upload',
          'title'   => __('آیکون','digix'),
          'placeholder'   => __('بهترین سایز 512پیکسل در 512پیکسل','digix'),
          'library' => 'image',
        ),
		array(
          'id'      => 'general-bodycolor',
          'type'    => 'color',
          'title'   => __('رنگ پس زمینه سایت','digix'),
          'default' => '#f3f6f7',
        ),
        array(
          'id'      => 'general-color',
          'type'    => 'color',
          'title'   => __('رنگ اصلی','digix'),
          'default' => '#2fdf84',
        ),
        array(
          'id'      => 'general-subcolor',
          'type'    => 'color',
          'title'   => __('رنگ مکمل','digix'),
          'default' => '#094aef',
        ),
  
      )
    ) );
	CSF::createSection( $prefix, array(
	  'parent' 	   => 'general',
      'title'  => __('وبلاگ','digix'),
      'fields' => array(
		array(
		  'id'    => 'general-blog-masonry',
		  'type'  => 'switcher',
		  'default' => true,
		  'title' => __('مطالب شبکه ای','digix'),
		  'subtitle' => __('مظالب شبکه ای در وبلاگ فعال باشد؟ ','digix'),
		),
    ) ));

    //
	CSF::createSection( $prefix, array(
	'id'    => 'digix_notifbar',
	'title' =>  __('نوار اعلان','digix'),
	'icon'  => 'fas fa-bell',
	'fields' => array(
		array(
			'id'    	=> 'digix_notifbar_activation',
			'type'  	=> 'switcher',
			'default' 	=> false,
			'title' 	=> __('نوار اعلان','digix'),
			'subtitle' 	=> __('فعال یا غیرفعال','digix'),
		),
		array(
            'id' 		=> 'digix_notifbar_position',
            'type' 		=> 'select',
            'title' 	=> __('جایگاه فراخوانی کد های نوار اعلان', 'digix'),
            'subtitle' 	=> __('اگر صفحه ای اختصاصی برای صفحه اصلی یا سایر صفحات و یا سربرگ سفارشی ایجاد کرده اید بر روی گزینه پیش از تگ شروع بدنه سایت قرار دهید', 'digix'),
            'default' 	=> 'head',
            'options' 	=> array(
                'head' 	=> __('پیش از تگ شروع بدنه سایت', 'digix'),
                'body' 	=> __('پس از تگ شروع بدنه سایت', 'digix'),
            ),
            'dependency'=> array(
                array('digix_notifbar_activation', '==', 'true'),
            ),
        ),
		array(
            'id' 		=> 'digix_notifbar_type',
            'type' 		=> 'select',
            'title' 	=> __('انتخاب نوع نوار اعلان', 'digix'),
            'default' 	=> 'text',
            'options' 	=> array(
                'text' 	=> __('متنی', 'digix'),
                'gif' 	=> __('گیف یا تصویر', 'digix'),
            ),
            'dependency'=> array(
                array('digix_notifbar_activation', '==', 'true'),
            ),
        ),
		array(
			'id'    	=> 'digix_notifbar_type_gif',
			'type'  	=> 'upload',
			'library' 	=> 'image',
			'title' 	=> __('تصویر ، گیف', 'digix'),
			'desc' 		=> __('آدرس تصویر یا گیف ( سایز پیشنهادی ۱۵۲۰x۵۵px )', 'digix'),
			'dependency'=> array(
				array('digix_notifbar_type', '==', 'gif'),
				array('digix_notifbar_activation', '==', 'true'),
			),
		),
		array(
			'id'    	=> 'digix_notifbar_type_gif_mob',
			'type'  	=> 'upload',
			'library' 	=> 'image',
			'title' 	=> __('تصویر ، گیف در حالت تبلت/موبایل', 'digix'),
			'desc' 		=> __(' آدرس تصویر یا گیف ( سایز پیشنهادی 720x96px ) ', 'digix'),
			'dependency'=> array(
				array('digix_notifbar_type', '==', 'gif'),
				array('digix_notifbar_activation', '==', 'true'),
			),
		),
		array(
            'id' 		=> 'digix_notifbar_type_gif_url',
            'type' 		=> 'text',
            'title' 	=> __('لینک', 'digix'),
            'default' 	=> '#',
            'dependency'=> array(
                array('digix_notifbar_type', '==', 'gif'),
                array('digix_notifbar_activation', '==', 'true'),
            ),
        ),
		array(
            'id' 		=> 'digix_notifbar_type_text',
            'type'	 	=> 'text',
            'title' 	=> __('متن نوار اعلان', 'digix'),
            'desc' 		=> __('متن اصلی نوار اعلان', 'digix'),
            'default' 	=> 'این یک متن تستی در نوار اعلان صفحه میباشد‌!',
            'dependency'=> array(
                array('digix_notifbar_type', '==', 'text'),
                array('digix_notifbar_activation', '==', 'true'),
            ),
            'select2' 	=> array('allowClear' => false)
        ),
        array(
            'id' 		=> 'digix_notifbar_type_text_color',
            'type' 		=> 'color',
            'title' 	=> __('رنگ متن اصلی', 'digix'),
            'desc' 		=> __('انتخاب رنگ متن اصلی نوار اعلان', 'digix'),
            'validate' 	=> 'color',
            'transparent'=> false,
            'default' 	=> '#fdfdfd',
            'dependency'=> array(
                array('digix_notifbar_type', '==', 'text'),
                array('digix_notifbar_activation', '==', 'true'),
            ),
            'select2' 	=> array('allowClear' => false)
        ),
        array(
            'id' 		=> 'digix_notifbar_type_text_position',
            'type' 		=> 'switcher',
            'title' 	=> __('وسط چین', 'digix'),
            'desc' 		=> __('وسط چین کردن متن عنوان نوار اعلان', 'digix'),
            'dependency'=> array(
                array('digix_notifbar_type', '==', 'text'),
                array('digix_notifbar_activation', '==', 'true'),
            ),
            'default' => false
        ),

        array(
            'id' 		=> 'digix_notifbar_type_text_background',
            'type' 		=> 'color',
            'title' 	=> __('رنگ پس زمینه', 'digix'),
            'desc' 		=> __('انتخاب رنگ پس زمینه نوار اعلان', 'digix'),
            'validate' 	=> 'color',
            'transparent'=> false,
            'default' 	=> '#EF394E',
            'dependency'=> array(
                array('digix_notifbar_type', '==', 'text'),
                array('digix_notifbar_activation', '==', 'true'),
            ),
            'select2' 	=> array('allowClear' => false)
        ),
        array(
            'id' 		=> 'digix_notifbar_type_text_img',
            'type'  	=> 'upload',
			'library' 	=> 'image',
            'title' 	=> __('تصویر پس زمینه', 'digix'),
            'desc' 		=> __('اپلود تصویر پس زمینه در صورت عدم انتخاب رنگ پس زمینه', 'digix'),
            'operator' 	=> 'and',
            'dependency'=> array(
                array('digix_notifbar_type', '==', 'text'),
                array('digix_notifbar_activation', '==', 'true'),
            ),
            'select2' 	=> array('allowClear' => false)
        ),
        array(
            'id' 		=> 'digix_notifbar_type_text_close',
            'type' 		=> 'switcher',
            'title' 	=> __('نمایش دکمه بستن اعلان', 'digix'),
            'default' 	=> true,
            'dependency'=> array(
                array('digix_notifbar_type', '==', 'text'),
                array('digix_notifbar_activation', '==', 'true'),
            ),
            'select2' 	=> array('allowClear' => false)
        ),
        array(
            'id' 		=> 'digix_notifbar_type_text_button',
            'type' 		=> 'switcher',
            'title' 	=> __('نمایش دکمه نوار اعلان', 'digix'),
            'default' 	=> false,
            'dependency'=> array(
                array('digix_notifbar_type', '==', 'text'),
                array('digix_notifbar_activation', '==', 'true'),
            ),
            'select2' 	=> array('allowClear' => false)
        ),
        array(
            'id' 		=> 'digix_notifbar_type_text_button_text',
            'type' 		=> 'text',
            'title' 	=> __('متن دکمه', 'digix'),
            'desc' 		=> __('متن دکمه نوار اعلان', 'digix'),
            'default' 	=> 'خرید فقط از ژاکت',
            'dependency'=> array(
                array('digix_notifbar_type_text_button', '==', 'true'),
                array('digix_notifbar_type', '==', 'text'),
                array('digix_notifbar_activation', '==', 'true'),
            ),
            'select2' 	=> array('allowClear' => false)
        ),
        array(
            'id' 		=> 'digix_notifbar_type_text_button_url',
            'type' 		=> 'text',
            'title' 	=> __('لینک دکمه', 'digix'),
            'desc' 		=> __('لینک دکمه نوار اعلان', 'digix'),
            'default' 	=> '#',
            'dependency'=> array(
				array('digix_notifbar_type_text_button', '==', 'true'),
                array('digix_notifbar_type', '==', 'text'),
                array('digix_notifbar_activation', '==', 'true'),
            ),
        ),
        array(
            'id' 		=> 'digix_notifbar_type_text_button_color',
            'type' 		=> 'color',
            'title' 	=> __('رنگ دکمه', 'digix'),
            'desc' 		=> __('انتخاب رنگ دکمه نوار اعلان', 'digix'),
            'validate' 	=> 'color',
            'transparent'=> false,
            'default' 	=> '#EF394E',
            'dependency'=> array(
				array('digix_notifbar_type_text_button', '==', 'true'),
                array('digix_notifbar_type', '==', 'text'),
                array('digix_notifbar_activation', '==', 'true'),
            ),
        ),
        array(
            'id' 		=> 'digix_notifbar_type_text_button_background',
            'type' 		=> 'color',
            'title' 	=> __('رنگ پس زمینه دکمه', 'digix'),
            'desc' 		=> __('انتخاب رنگ پس زمینه دکمه نوار اعلان', 'digix'),
            'validate' 	=> 'color',
            'transparent'=> false,
            'default' 	=> '#fff',
            'dependency'=> array(
				array('digix_notifbar_type_text_button', '==', 'true'),
                array('digix_notifbar_type', '==', 'text'),
                array('digix_notifbar_activation', '==', 'true'),
            ),
        ),
        array(
            'id' 		=> 'digix_notifbar_sticky',
            'type' 		=> 'switcher',
            'title' 	=> __('چسبان', 'digix'),
            'desc' 		=> __('نمایش چسبان نوار اعلان', 'digix'),
            'dependency'=> array(
                array('digix_notifbar_activation', '==', 'true'),
            ),
            'default' => false
        ),
        array(
            'id' 		=> 'digix_notifbar_home',
            'type' 		=> 'switcher',
            'title' 	=> __('نمایش فقط در صفحه اصلی', 'digix'),
            'default' 	=> false,
            'dependency'=> array(
                array('digix_notifbar_activation', '==', 'true'),
            ),
        ),
        array(
            'id' 		=> 'digix_notifbar_pc',
            'type' 		=> 'switcher',
            'title' 	=> __('نمایش فقط در دسکتاپ', 'digix'),
            'default' 	=> false,
            'dependency'=> array(
                array('digix_notifbar_activation', '==', 'true'),
                array('digix_notifbar_activation', '==', 'true'),
            ),
        ),
	)
));
    // Woocommerce section
    CSF::createSection( $prefix, array(
	  'id' 	   => 'woocommerce',
	  'icon'   => 'fas fa-shopping-bag',
      'title'  => __('فروشگاه','digix'),
      'fields' => array(
	)));
	
	CSF::createSection( $prefix, array(
	  'parent'      => 'woocommerce',
      'title'  => __('همگانی','digix'),
      'fields' => array(
        // field
		array(
		  'id'    => 'woocommerce-notiny',
		  'type'  => 'switcher',
		  'default' => true,
		  'title' => __('اطلاعیه افزوده شدن به سبد خرید','digix'),
		  'subtitle' => __('اطلاعیه افزوده شدن به سبد خرید فعال باشد؟','digix'),
		),
		array(
		  'id'    => 'woocommerce-location',
		  'type'  => 'switcher',
		  'default' => false,
		  'title' => __('انتخاب مکان برای محصولات','digix'),
		  'subtitle' => __('انتخاب مکان برای محصولات فعال باشد؟','digix'),
		),
		array(
		  'id'    => 'woocommerce-location-mobile',
		  'type'  => 'switcher',
		  'default' => false,
		  'title' => __('انتخاب مکان برای محصولات در نسخه موبایل','digix'),
		  'subtitle' => __('انتخاب مکان برای محصولات در نسخه موبایل فعال باشد؟','digix'),
		),
		array(
		  'id'      => 'woocommerce-related-number',
		  'type'    => 'number',
		  'default'    => '5',
		  'min'    => '4',
		  'max'    => '7',
		  'title'   => __('تعداد اسلاید های محصولات مشابه','digix'),
		),
		array(
          'id'          => 'woocommerce-related-align',
          'type'        => 'select',
          'default'        => 'center',
          'title'       => __('جهت عنوان اسلایدر محصولات مشابه','digix'),
          'placeholder' => __('جهت عنوان اسلایدر محصولات مشابه را انتخاب کنید','digix'),
          'options'     => array(
            'center'       => __('وسط','digix'),
            'right'        => __('راست','digix'),
          ),
        ),	  
		array(
          'id'      => 'woocommerce-pitem-h2a-size',
          'type'    => 'number',
		  'placeholder'    => '15',
		  'default'    => '15',
		  'min'    => '12',
		  'max'    => '20',
          'title'   => __('سایز متن عناوین آیتم محصولات آرشیو','digix'),
        ),
		array(
          'id'      => 'woocommerce-onesale-page',
          'type'    => 'color',
          'title'   => __('رنگ پس زمینه صفحه فروش ویژه','digix'),
          'default' => '#2833ff',
        ),
		array(
          'id'      => 'woocommerce-related-color',
          'type'    => 'color',
          'title'   => __('رنگ عنوان اسلایدر محصولات مشابه','digix'),
          'default' => '#000',
        ),
		array(
          'id'      => 'woocommerce-pitem-h2a',
          'type'    => 'color',
          'title'   => __('رنگ متن عناوین آیتم محصولات آرشیو','digix'),
          'default' => '#000',
        ),
		array(
          'id'          => 'woocommerce-pitem-boxshadow',
          'type'        => 'select',
          'default'        => 'yes',
          'title'       => __('سایه آیتم محصولات','digix'),
          'placeholder' => __('سایه آیتم محصولات فعال باشد؟','digix'),
          'options'     => array(
            'yes'       => __('بلی','digix'),
            'no'        => __('خیر','digix'),
          ),
        ),
		array(
          'id'      => 'woocommerce-sale-color',
          'type'    => 'color',
          'title'   => __('رنگ قیمت تخفیف','digix'),
          'default' => '#ff000',
        ),
        array(
          'id'      => 'woocommerce-price-color',
          'type'    => 'color',
          'title'   => __('رنگ قیمت ها','digix'),
          'default' => '#3ab54a',
        ),
		array(
          'id'      => 'woocommerce-discount-color',
          'type'    => 'color',
          'title'   => __('رنگ متن تیکت تخفیف','digix'),
          'default' => '#fff',
        ),
		array(
          'id'      => 'woocommerce-discount-bgcolor',
          'type'    => 'color',
          'title'   => __('رنگ پس زمینه تیکت تخفیف','digix'),
          'default' => '#ff000',
        ),
        array(
          'id'      => 'woocommerce-addcart-color',
          'type'    => 'color',
          'title'   => __('رنگ پسزمینه دکمه افزودن به سبد خرید','digix'),
          'default' => '#3ab54a',
        ),
		array(
          'id'      => 'woocommerce-singleaddcart-color',
          'type'    => 'color',
          'title'   => __('رنگ پسزمینه دکمه افزودن به سبد خرید صفحه محصول','digix'),
          'default' => '#2196f3',
        ),
        
		  array(
      'id'    => 'woocommerce-tab',
      'type'  => 'tabbed',
      'title' => 'تنظیمات',
      'tabs'  => array(

        array(
          'title'  => 'حساب کاربری',
          'fields' => array(
			array(
			  'id'      => 'navigation-bgcolor',
			  'type'    => 'color',
			  'title'   => __('رنگ پس زمینه نوار آواتار جساب کاربری','digix'),
			  'default' => '#11a917',
			),
			array(
			  'id'      => 'item1-bgcolor',
			  'type'    => 'color',
			  'title'   => __('رنگ پس زمینه آیتم شماره یک اطلاعات کاربری در حساب کاربری','digix'),
			  'default' => '#ffae00',
			),
			array(
			  'id'      => 'item2-bgcolor',
			  'type'    => 'color',
			  'title'   => __('رنگ پس زمینه آیتم شماره دو اطلاعات کاربری در حساب کاربری','digix'),
			  'default' => '#64bc36',
			),
			array(
			  'id'      => 'item3-bgcolor',
			  'type'    => 'color',
			  'title'   => __('رنگ پس زمینه آیتم شماره سه اطلاعات کاربری در حساب کاربری','digix'),
			  'default' => '#f3103c',
			),
			array(
			  'id'      => 'item4-bgcolor',
			  'type'    => 'color',
			  'title'   => __('رنگ پس زمینه آیتم شماره چهار اطلاعات کاربری در حساب کاربری','digix'),
			  'default' => '#a837bb',
			),
			array(
			  'id'      => 'myaccount-menubgcolor',
			  'type'    => 'color',
			  'title'   => __('رنگ پس زمینه منو های حساب کاربری در حالت انتخاب','digix'),
			  'default' => '#00ff0808',
			),
			array(
			  'id'      => 'myaccount-menucolor',
			  'type'    => 'color',
			  'title'   => __('رنگ منو های حساب کاربری در حالت انتخاب','digix'),
			  'default' => '#27b12b',
			),
          ),
        ),
      ),
    ),
	
      )
    ) );
	CSF::createSection( $prefix, array(
	  'parent'      => 'woocommerce',
      'title'  => __('آرشیو','digix'),
      'fields' => array(
			array(
          'id'          => 'woocommerce-childcat',
          'type'        => 'select',
		  'default'        => 'yes',
          'title'       => __('دسته بندی فرزند','digix'),
          'subtitle' => __('انتخاب کنید که دسته بندی فرزند در آرشیو محصولات نمایش داده شود','digix'),
          'options'     => array(
            'yes'       => __('بلی','digix'),
            'no'        => __('خیر','digix'),
          ),
        ),
		array(
          'id'          => 'woocommerce-archive-attributes',
          'type'        => 'select',
          'default'        => 'yes',
          'title'       => __('نمایش ویژگی ها در آرشیو محصولات','digix'),
          'subtitle' => __('نمایش یا عدم نمایش ویژگیها در آرشیو محصولات را انتخاب کنید','digix'),
          'options'     => array(
            'yes'       => __('بلی','digix'),
            'no'        => __('خیر','digix'),
          ),
        ),
		array(
          'id'          => 'woocommerce-addcart',
          'type'        => 'select',
          'default'        => 'yes',
          'title'       => __('نمایش دکمه افزودن به سبد خرید در آرشیو محصولات','digix'),
          'subtitle' => __('نمایش یا عذم نمایش دکمه افزودن بهسبد خرید در آرشیو را انتخاب کنید','digix'),
          'options'     => array(
            'yes'       => __('بلی','digix'),
            'no'        => __('خیر','digix'),
          ),
        ),
		array(
		  'id'      => 'woocommerce-archive-number',
		  'type'    => 'number',
		  'default'    => '4',
		  'min'    => '4',
		  'max'    => '5',
		  'title'   => __('تعداد محصولات آرشیو در هر ردیف','digix'),
		),
		array(
		  'id'    => 'woocommerce-outstock',
		  'type'  => 'switcher',
		  'default' => true,
		  'title' => __('نمایش محصولات موجود در انتهای لیست','mobix'),
		),
		
	  )));
	  CSF::createSection( $prefix, array(
	  'parent'      => 'woocommerce',
      'title'  => __('صفحه معرفی محصول','digix'),
      'fields' => array(
			array(
			  'id'      => 'woocommerce-delivery-home',
			  'type'    => 'text',
			  'title'   => __('زمان ارسال برای شهر مبدا','digix'),
			  'placeholder' => '۲ روز ارسال به تهران',
			),
			array(
			  'id'      => 'woocommerce-delivery-other',
			  'type'    => 'text',
			  'title'   => __('زمان ارسال برای سایر شهرها','digix'),
			  'placeholder' => '۴ روز ارسال به سایر شهرها',
			),
			array(
			  'id'    => 'woocommerce-single-ajax',
			  'type'  => 'switcher',
			  'default' => true,
			  'title' => __('آجاکس افزودن به سبد خرید','digix'),
			  'subtitle' => __('حالت آجاکس برای دکمه افزودن به سبد خرید فعال باشد؟','digix'),
			),
	  )));
	  
	  CSF::createSection( $prefix, array(
	  'parent'      => 'woocommerce',
      'title'  => __('سبد خرید و تسویه حساب','digix'),
      'fields' => array(
			array(
			  'id'          => 'woocommerce-checkout-map',
			  'type'        => 'select',
			  'title'       => __('نمایش نقشه صورتحساب','digix'),
			  'placeholder' => __('انتخاب کنید','digix'),
			  'default'     => 'yes',
			  'options'     => array(
				'yes'       => __('بلی','digix'),
				'no'        => __('خیر','digix'),
			  ),
			),
			array(
			  'id'    => 'woocommerce-map-api',
			  'type'  => 'text',
			  'title' => __('کلید دسترسی map.ir','digix'),
			),
			array(
			  'id'    => 'woocommerce-checkout-login',
			  'type'  => 'switcher',
			  'default' => true,
			  'title' => __('پیام لاگین و ثبت نام','digix'),
			  'subtitle' => __('نمایش پیام لاگین و ثبت نام برای تکمیل خرید','digix'),
			),
			array(
			  'id'    => 'woocommerce-shipping-packing',
			  'type'  => 'switcher',
			  'default' => true,
			  'title' => __('وضعیت بسته بندی','digix'),
			  'subtitle' => __('وضعیت بسته بندی به بخش پیگیری و سفارشات اضافه شود؟','digix'),
			),
			array(
			  'id'    => 'woocommerce-shipping-warehouse',
			  'type'  => 'switcher',
			  'default' => true,
			  'title' => __('وضعیت تحویل به انبار','digix'),
			  'subtitle' => __('وضعیت تحویل به انبار به بخش پیگیری و سفارشات اضافه شود؟','digix'),
			),
			array(
			  'id'    => 'woocommerce-shipping-ready',
			  'type'  => 'switcher',
			  'default' => true,
			  'title' => __('وضعیت آماده ارسال','digix'),
			  'subtitle' => __('وضعیت آماده ارسال به بخش پیگیری و سفارشات اضافه شود؟','digix'),
			),
	  )));
	  CSF::createSection( $prefix, array(
	  'parent'      => 'woocommerce',
      'title'  => __('زمان تحویل کالا','digix'),
      'fields' => array(
			array(
				'id'          => 'woocommerce-shipping-time',
				'type'        => 'select',
				'title'       => __('نمایش زمان ارسال محصول در صورتحساب','digix'),
				'placeholder' => __('انتخاب کنید','digix'),
				'default'     => 'yes',
				'options'     => array(
					'yes'       => __('بلی','digix'),
					'no'        => __('خیر','digix'),
				),
			),
			array(
				'id'    => 'woocommerce_show_days',
				'type'  => 'number',
				'default'  => '5',
				'title' => __('تعداد روز نمایش','digix'),
				'subtitle' => __('تعداد روزهایی که در جدول زمان ارسال پیک میخواهید نمایش دهید را وارد کنید.','digix'),
				'dependency'=> array(
					array('woocommerce-shipping-time', '==', 'yes'),
				),
			),
			array(
				'id'         => 'woocommerce_week_days_without_deliver',
				'type'       => 'select',
				'title'      => __('روزهای هفته بدون پیک','digix'),
				'subtitle'   => __('روزهای هفته ای که پیک ندارید را وارد کنید','digix'),
				'chosen'      => true,
				'multiple'    => true,
				'sortable'    => true,
				'options'    => array(
					'شنبه'     => __('شنبه','digix'),
					'یکشنبه'       => __('یکشنبه','digix'),
					'دوشنبه'       => __('دوشنبه','digix'),
					'سه شنبه'      => __('سه شنبه','digix'),
					'چهارشنبه'    => __('چهار شنبه','digix'),
					'پنجشنبه'     => __('پنج شنبه','digix'),
					'جمعه'       => __('جمعه','digix'),
				),
				'default'    => 'جمعه',
				'dependency'=> array(
					array('woocommerce-shipping-time', '==', 'yes'),
				),
			),
			array(
				'id'    => 'woocommerce_start_days',
				'type'  => 'number',
				'default'  => '2',
				'title' => __('شروع از','digix'),
				'subtitle' => __('برای مثال، در صورتی که عدد ۲ را وارد کنید و امروز شنبه باشد، روز اولی که در جدول نمایش داده میشود دوشنبه خواهد بود!','digix'),
				'dependency'=> array(
					array('woocommerce-shipping-time', '==', 'yes'),
				),
			),
			array(
				'id'        => 'woocommerce_time_order',
				'type'      => 'group',
				'title'     => __('ساعت تحویل','digix'),
				'dependency' => array(
					array('woocommerce-shipping-time', '==', 'yes'),
				),
				'fields'    => array(
					array(
						'id'    => 'time_send_order',
						'type'  => 'text',
						'title' => __('ساعت تحویل','digix'),
						'desc'  => __('ساعت ارسال سفارش را تعیین کنید مثلا: ساعت ۱۰ تا ۲۲','digix'),
					),
				),
				'default' => array(
					array(
						'time_send_order' => 'ساعت 10 تا 13',
					),
					array(
						'time_send_order' => 'ساعت 15 تا 18',
					),
					array(
						'time_send_order' => 'ساعت 19 تا 21',
					),
				),
			),
			array(
				'id'        => 'woocommerce_without_day_order',
				'type'      => 'group',
				'title'     => __('تاریخ های بدون پیک','digix'),
				'dependency' => array(
					array('woocommerce-shipping-time', '==', 'yes'),
				),
				'fields'    => array(
					array(
						'id'    => 'without_day_order',
						'type'  => 'pdate',
						'title' => __('تاریخ','digix'),
						'desc'  => __('تاریخ را به شمسی به فرمت YYYY/MM/DD وارد نمایید , مثال : 1402/04/26','digix'),
						'settings' => array(
							'format'  => 'YYYY/MM/DD',
						),
						'default' => '1402/05/15',
					),
				),
				'default' => array(
					array(
						'without_day_order' => '1402/04/26',
					),
					array(
						'without_day_order' => '1402/04/27',
					),
					array(
						'without_day_order' => '1402/04/28',
					),
				),
			),
		
	  )));
	  CSF::createSection( $prefix, array(
	  'parent'      => 'woocommerce',
      'title'  => __('برندها','digix'),
      'fields' => array(
			array(
			  'id'      => 'woocommerce-brand-slug',
			  'type'    => 'text',
			  'title'   => __('نامک برند محصول','digix'),
			  'default' => 'brand',
			  'placeholder' => 'brand',
			  'subtitle' => 'بعد از ذخیره تنظیمات، به تنظیمات پیوند یکتا وردپرس بروید و بر روی ذخیره کلیک کنید.',
			),
			array(
			  'id'      => 'woocommerce-brand-taxonomy',
			  'type'    => 'text',
			  'title'   => __('Taxonomy برندمحصول','digix'),
			  'default' => 'product_brand',
			  'placeholder' => 'product_brand',
			  'subtitle' => 'بعد از ذخیره تنظیمات، به تنظیمات پیوند یکتا وردپرس بروید و بر روی ذخیره کلیک کنید. توسط این بخش می توانید taxonomy برند که در دیتابیس ذخیره می شود را تغییر دهید، توجه کنید که با تغییر این بخش برندهایی که قبلا ساخته اید نمایش داده نمی شوند، کاربرد این قسمت برای سازگاری با برندهای قالب ها و افزونه های دیگر می باشد.',
			),
			array(
			  'id'    => 'woocommerce-brand-single',
			  'type'  => 'switcher',
			  'default' => true,
			  'title' => __('نمایش برند محصول','digix'),
			  'subtitle' => __('نمایش بخش برند محصول در صفحه محصول','digix'),
			),
			array(
			  'id'    => 'woocommerce-brand-schema',
			  'type'  => 'switcher',
			  'default' => true,
			  'title' => __('اضافه کردن کد اسکیما برند','digix'),
			  'subtitle' => __('اضافه کردن کد اسکیما برند به اسکیما محصول','digix'),
			),
	  ))); 
	  
	  CSF::createSection( $prefix, array(
	  'parent'      => 'woocommerce',
      'title'  => __('افزونه پیامکی دیجیتس','digix'),
      'fields' => array(
			array(
			  'id'    => 'woocommerce-digits',
			  'type'  => 'switcher',
			  'default' => false,
			  'title' => __('افزونه ثبت نام و ورود دیجیتس','digix'),
			  'subtitle' => __('فعالسازی استفاده از افزونه دیجیتس برای ورود و ثبت نام ','digix'),
			),
			array(
			  'id'          => 'woocommerce-digits-type',
			  'dependency' 	=> array( 'woocommerce-digits', '==', true ),
			  'type'        => 'select',
			  'default'        => 'popup',
			  'title'       => __('نوع دکمه ثبت نام ورود','digix'),
			  'subtitle' => __('نوع دکمه ثبت نام ورود ار انتخاب نمایید','digix'),
			  'options'     => array(
				'popup'       => __('پاپ آپ','digix'),
				'redirect'    => __('ریدایرکت یه صفحه','digix'),
			  ),
			),
			array(
			  'id'    => 'woocommerce-redirect-login',
			  'dependency' 	=> array( 'woocommerce-digits-type', '==', 'redirect' ),
			  'type'  => 'text',
			  'title' => __('لینک صفحه ورود','digix'),
			  'placeholder' => esc_url( home_url() ) . '/?login=true',
			  'default' => esc_url( home_url() ) . '/?login=true',
			),
			array(
			  'id'    => 'woocommerce-redirect-register',
			  'dependency' 	=> array( 'woocommerce-digits-type', '==', 'redirect' ),
			  'type'  => 'text',
			  'title' => __('لینک صفحه ثبت نام','digix'),
			  'placeholder' => esc_url( home_url() ) . '/?login=true&type=register',
			  'default' => esc_url( home_url() ) . '/?login=true&type=register',
			),
		  
	  )));


    //
    // Social section
    CSF::createSection( $prefix, array(
      'title'  => __('جستجو','digix'),
	  'icon'   => 'fas fa-search',
      'fields' => array(
  
        // field
        array(
          'id'    => 'search-title',
          'type'  => 'text',
          'title' => __('عنوان نوار جستجو','digix'),
          'placeholder' => __('جستجو در محصولات...','digix'),
        ),
        array(
          'id'     => 'search-keyboards',
          'type'   => 'repeater',
          'title'  => __('کلمات کلیدی محبوب','digix'),
          'fields' => array(
            array(
              'id'    => 'key-title',
              'type'  => 'text',
              'title' => __('عنوان','digix'),
            ),
          ),
        ),
        array(
          'id'           => 'search-image',
          'type'         => 'upload',
          'title'        => __('تصویر','digix'),
          'library'      => 'image',
          'button_title' => __('آپلود','digix'),
        ),
        array(
          'id'    => 'search-url',
          'type'  => 'text',
          'title' => __('لینک تصویر','digix'),
        ),
  
      )
    ) );
    //
    // Application section
    CSF::createSection( $prefix, array(
      'title'  => __('ارتباط با ما','digix'),
	  'icon'   => 'fas fa-phone',
      'fields' => array(
  
        // field
        array(
          'id'          => 'contact-floating',
          'type'        => 'select',
          'title'       => __('دکمه تماس باما شناور','digix'),
          'placeholder' => __('انتخاب کنید','digix'),
          'options'     => array(
            'yes'       => __('بلی','digix'),
            'no'        => __('خیر','digix'),
          ),
        ),
		array(
          'id'          => 'contact-floating-mobile',
          'type'        => 'select',
          'default'        => 'no',
          'title'       => __('دکمه تماس باما شناور در نسخه موبایل','digix'),
          'placeholder' => __('انتخاب کنید','digix'),
          'options'     => array(
            'yes'       => __('بلی','digix'),
            'no'        => __('خیر','digix'),
          ),
        ),
		array(
          'id'      => 'contact-color',
          'type'    => 'color',
          'title'   => __('رنگ دکمه تماس با ما شناور','digix'),
          'default' => '#25d366',
        ),
        array(
          'id'    => 'contact-phone',
          'type'  => 'text',
          'title' => __('شماره ثابت پشتیبانی','digix'),
        ),
        array(
          'id'    => 'contact-tell',
          'type'  => 'text',
          'title' => __('شماره تماس پشتیبانی','digix'),
        ),
        array(
          'id'    => 'contact-mail',
          'type'  => 'text',
          'title' => __('ایمیل پشتیبانی','digix'),
        ),
        array(
          'id'    => 'contact-whatsapp',
          'type'  => 'text',
          'title' => __('شماره تماس واتس اپ','digix'),
          'subtitle' => __('شماره همراه خود را در فرمت بین المللی بنویسید  ( مثال : 989101234567','digix'),
        ),
		array(
          'id'    => 'contact-twitter',
          'type'  => 'text',
          'title' => __('آدرس حساب توییتر','digix'),
        ),
		array(
          'id'    => 'contact-facebook',
          'type'  => 'text',
          'title' => __('آدرس حساب فیسبوک','digix'),
        ),
        array(
          'id'    => 'contact-telegram',
          'type'  => 'text',
          'title' => __('آدرس حساب تلگرام','digix'),
        ),
        array(
          'id'    => 'contact-instagram',
          'type'  => 'text',
          'title' => __('آدرس حساب اینستاگرام','digix'),
        ),
		array(
          'id'    => 'contact-eitaa',
          'type'  => 'text',
          'title' => __('ادرس حساب ایتا','digix'),
        ),
		array(
          'id'    => 'contact-bale',
          'type'  => 'text',
          'title' => __('آدرس حساب بله','digix'),
        ),
		array(
          'id'    => 'contact-rubika',
          'type'  => 'text',
          'title' => __('آدرس حساب روبیکا','digix'),
        ),
		array(
          'id'    => 'contact-gap',
          'type'  => 'text',
          'title' => __('آدرس حساب گپ','digix'),
        ),
		array(
          'id'    => 'contact-sapp',
          'type'  => 'text',
          'title' => __('آدرس حساب سروش','digix'),
        ),
        array(
          'id'    => 'contact-detailes',
          'type'  => 'text',
          'title' => __('اطلاعات پشتیبانی (مانند زمان پاسخگویی به تماس ها)','digix'),
        ),
  
      )
    ) );
    //
    // Application section
    CSF::createSection( $prefix, array(
      'title'  => __('اپلیکیشن','digix'),
	  'icon'   => 'fas fa-kaaba',
      'fields' => array(
  
        // field
		array(
		  'id'    => 'application-switch',
		  'type'  => 'switcher',
		  'default' => true,
		  'title' => __('بخش اپلیکیشن ها','digix'),
		  'subtitle' => __('فعالسازی نمایش بخش اپلیکیشن ها','digix'),
		),
		array(
          'id'      => 'application-color',
          'type'    => 'color',
          'title'   => __('رنگ پس زمینه باکس دانلود اپلیکیشن','digix'),
          'default' => '#3c4b6d',
        ),
		array(
          'id'      => 'application-icon',
          'type'    => 'upload',
          'title'   => __('آیکون','digix'),
          'placeholder'   => __('بهترین سایز 512پیکسل در 512پیکسل','digix'),
          'library' => 'image',
        ),
        array(
          'id'    => 'application-play',
          'type'  => 'text',
          'title' => __('لینک دانلود از گوگل پلی','digix'),
        ),
        array(
          'id'    => 'application-bazar',
          'type'  => 'text',
          'title' => __('لینک دانلود ار کافه بازار','digix'),
        ),
        array(
          'id'    => 'application-myket',
          'type'  => 'text',
          'title' => __('لینک دانلود از مایکت','digix'),
        ),
        array(
          'id'    => 'application-sibapp',
          'type'  => 'text',
          'title' => __('لینک دانلود از سیب اپ','digix'),
        ),
      )
    ) );
    //
    // Footer section
    CSF::createSection( $prefix, array(
      'title'  => __('پابرگ','digix'),
	  'icon'   => 'fas fa-band-aid',
      'fields' => array(
  
        //
        // field
		array(
          'id'          => 'footer-footer',
          'type'        => 'select',
          'title'       => __('پابرگ فروشگاه','digix'),
          'placeholder' => __('پابرگ فروشگاه را انتخاب کنید','digix'),
		  'default'		=> 'footer-default',
          'options'     => array(
            'footer-default'       => __('پابرگ پیشفرض','digix'),
            'footer-cosmetic'        => __('پابرگ ساده','digix'),
          ),
        ),
		array(
          'id'      => 'footer-logo-cosmetic',
          'type'    => 'upload',
		  'dependency' 	=> array( 'footer-footer', '==', 'footer-cosmetic' ),
          'title'   => __('لوگو پابرگ','digix'),
          'placeholder'   => __('سایز لوگو باید 100پیکسل در 35پیکسل باشد','digix'),
          'library' => 'image',
        ),
		array(
          'id'      => 'footer-cosmetic-social-color',
		  'dependency' 	=> array( 'footer-footer', '==', 'footer-cosmetic' ),
          'type'    => 'color',
          'title'   => __('رنگ آیتم های شبکه اجتماعی','digix'),
          'default' => '#ff4d6d',
        ),
        array(
          'id'      => 'footer-newsletter-color',
          'type'    => 'color',
          'title'   => __('رنگ پس زمینه باکس خبرنامه','digix'),
          'default' => '#3c4b6d',
        ),
        array(
          'id'    => 'footer-newsletterdesc',
          'type'  => 'textarea',
          'title' => __('توضیخات خبرنامه','digix'),
        ),
        array(
          'id'    => 'footer-newsletter',
          'type'  => 'text',
          'title' => __('شورتکد خبرنامه','digix'),
        ),
        array(
          'id'    => 'footer-about',
          'type'  => 'textarea',
          'title' => __('درباره ما','digix'),
        ),
		array(
          'id'    => 'footer-address',
          'type'  => 'textarea',
          'title' => __('آدرس فروشگاه','digix'),
        ),
        array(
          'id'    => 'footer-trusttext',
          'type'  => 'text',
          'title' => __('توضیخات','digix'),
        ),
        array(
          'id'            => 'footer-trust',
          'type'          => 'wp_editor',
          'title'         => __('اینماد','digix'),
          'subtitle'      => __('کد را وارد نمایید','digix'),
          'height'        => '100px',
          'media_buttons' => true,
        ),
		array(
          'id'    => 'footer-trust-shortcode',
          'type'  => 'text',
          'title' => __('شورتکد مرتبط با نماد ها','digix'),
          'subtitle' => __('از افزونه های واسط برای نمایش نماد استفاده میکنید؟ شورتکد افزونه را در اینجا وارد نمایید','digix'),
        ),
        array(
          'id'    => 'footer-saramadtext',
          'type'  => 'text',
          'title' => __('توضیخات','digix'),
        ),
        array(
          'id'            => 'footer-saramad',
          'type'          => 'wp_editor',
          'title'         => __('سرآمد','digix'),
          'subtitle'      => __('کد را وارد نمایید','digix'),
          'height'        => '100px',
          'media_buttons' => true,
        ),
		array(
          'id'    => 'footer-saramad-shortcode',
          'type'  => 'text',
          'title' => __('شورتکد مرتبط با نماد ها','digix'),
          'subtitle' => __('از افزونه های واسط برای نمایش نماد استفاده میکنید؟ شورتکد افزونه را در اینجا وارد نمایید','digix'),
        ),
        array(
          'id'    => 'footer-copyright',
          'type'  => 'wp_editor',
          'title' => __('کپی رایت','digix'),
          'height'        => '50px',
          'media_buttons' => false,
        ),
      )
    ) );
	//
	CSF::createSection( $prefix, array(
	  'id'    => 'digix_mobile',
	  'title' => 'نسخه آداپتیو موبایل',
	  'icon'  => 'fas fa-mobile',
	) );
    // Mobile section
    CSF::createSection( $prefix, array(
	  'parent'      => 'digix_mobile',
      'title'  => __('همگانی','digix'),
      'fields' => array(
  
        
		
		array(
          'id'    => 'mobile-blog',
          'type'  => 'text',
          'title' => __('لینک صفحه وبلاگ','digix'),
        ),
		array(
          'id'      => 'mobile-color',
          'type'    => 'color',
          'title'   => __('رنگ همگانی(اصلی)','digix'),
          'default' => '#094aef',
        ),
		array(
          'id'      => 'mobile-subcolor',
          'type'    => 'color',
          'title'   => __('رنگ مکمل','digix'),
          'default' => '#2fdf84',
        ),
		array(
          'id'      => 'mobile-browsercolor',
          'type'    => 'color',
          'title'   => __('رنگ پسزمینه مرورگر','digix'),
          'default' => '#094aef',
        ),
		array(
          'id'      => 'mobile-cartcolor',
          'type'    => 'color',
          'title'   => __('رنگ پس زمینه دکمه افزودن به سبد خرید','digix'),
          'default' => '#094aef',
        ),
		array(
          'id'      => 'mobile-pricecolor',
          'type'    => 'color',
          'title'   => __('رنگ قیمت ها','digix'),
          'default' => '#3ab54a',
        ),
  
      ) ) ); 
	CSF::createSection( $prefix, array(
	  'parent'      => 'digix_mobile',
      'title'  => __('سربرگ','digix'),
      'fields' => array(
			// field
		array(
          'id'          => 'mobile-header',
          'type'        => 'select',
          'title'       => __('نوع سربرگ','digix'),
          'placeholder' => __('انتخاب کنید','digix'),
          'options'     => array(
            'default'       => __('پیشفرض','digix'),
            'modern'        => __('مدرن','digix'),
          ),
        ),
		array(
          'id'      => 'mobile-logo',
          'type'    => 'upload',
          'title'   => __('لوگو سربرگ','digix'),
          'placeholder'   => __('سایز لوگو باید 100 پیکسل در 38 پیکسل باشد','digix'),
          'library' => 'image',
        ),
		array(
          'id'      => 'mobile-footlogo',
          'type'    => 'upload',
          'title'   => __('لوگو پابرگ','digix'),
          'placeholder'   => __('سایز لوگو باید 140پیکسل در 40پیکسل باشد','digix'),
          'library' => 'image',
        ),
        array(
          'id'    => 'mobile-faqs',
          'type'  => 'text',
          'title' => __('لینک آیتم سربرگ موبایل ','digix'),
        ),
		array(
          'id'    => 'mobile-faqs-icon',
          'type'  => 'text',
          'placeholder'  => 'icon-question',
          'title' => __('آیکون لینک آیتم سربرگ موبایل','digix'),
          'title' => __('<a href="https://iraniwp.ir/digix/icon.html">آیکون را از اینجا انتخاب کنید</a>','digix'),
        ),
	) ) );
	CSF::createSection( $prefix, array(
	  'parent'      => 'digix_mobile',
      'title'  => __('نوار میانبر','digix'),
      'fields' => array(
	  
	  
		array(
          'id'          => 'toolbar_category',
          'type'        => 'select',
          'title'       => __('نحوه نمایش دسته بندی ها','digix'),
          'default' 	=> 'default',
          'options'     => array(
            'default'       => __('پیشفرض','digix'),
            'custom'        => __('سفارشی','digix'),
          ),
        ),
		array(
				'id'        => 'toolbar_category_custom',
				'type'      => 'group',
				'title'     => __('دسته بندی های دلخواه','digix'),
				'dependency' => array(
					array('toolbar_category', '==', 'custom'),
				),
				'fields'    => array(
					array(
					  'id'    => 'title',
					  'type'  => 'text',
					  'title' => __('عنوان','digix'),
					),
					array(
					  'id'      => 'img',
					  'type'    => 'upload',
					  'title'   => __('تصویر دسته بندی','digix'),
					  'library' => 'image',
					),
					array(
					  'id'    => 'url',
					  'type'  => 'text',
					  'title' => __('لینک','digix'),
					),
				),
			),
		
		
		
		
		
		
		
		
	) ) );
	CSF::createSection( $prefix, array(
	  'parent'      => 'digix_mobile',
      'title'  => __('سفارشی سازی','digix'),
      'fields' => array(
		array(
		  'id'       => 'cutomize-mobjs',
		  'type'     => 'code_editor',
		  'title'    => __('جاوا اسکریپت','digix'),
		  'subtitle' => 'محل درج کد های جاوا اسکریپت و جیکوئری برای موبایل',
		  'settings' => array(
			'theme'  => 'dracula',
			'mode'   => 'javascript',
			),
		),
		array(
		  'id'       => 'cutomize-mobcss',
		  'type'     => 'code_editor',
		  'title'    => __('استایل','digix'),
		  'subtitle' => 'محل درج کد های سی اس اس و استایل برای موبایل',
		  'settings' => array(
			'theme'  => 'mbo',
			'mode'   => 'css',
			),
		),
	) ) );
	//
    // cutomize section
    CSF::createSection( $prefix, array(
	  'parent'      => 'digix_mobile',
      'title'  => __('ارتباط با ما','digix'),
      'fields' => array(
        array(
          'id'    => 'mobile-contactus',
          'type'  => 'text',
          'title' => __('لینک صفحه تماس با ما','digix'),
        ),
		array(
		  'id'    => 'whatsapp-activate',
		  'type'  => 'switcher',
		  'default' => true,
		  'title' => __('نمایش واتس اپ','mobix'),
		),
		array(
		  'id'    => 'twitter-activate',
		  'type'  => 'switcher',
		  'default' => true,
		  'title' => __('نمایش توییتر','mobix'),
		),
		array(
		  'id'    => 'facebook-activate',
		  'type'  => 'switcher',
		  'default' => true,
		  'title' => __('نمایش فیسبوگ','mobix'),
		),
		array(
		  'id'    => 'telegram-activate',
		  'type'  => 'switcher',
		  'default' => true,
		  'title' => __('نمایش تلگرام','mobix'),
		),
		array(
		  'id'    => 'instagram-activate',
		  'type'  => 'switcher',
		  'default' => true,
		  'title' => __('نمایش اینستاگرام','mobix'),
		),
		array(
		  'id'    => 'eitaa-activate',
		  'type'  => 'switcher',
		  'default' => true,
		  'title' => __('نمایش ایتا','mobix'),
		),
		array(
		  'id'    => 'bale-activate',
		  'type'  => 'switcher',
		  'default' => true,
		  'title' => __('نمایش بله','mobix'),
		),
		array(
		  'id'    => 'rubika-activate',
		  'type'  => 'switcher',
		  'default' => true,
		  'title' => __('نمایش روبیکا','mobix'),
		),
		array(
		  'id'    => 'gap-activate',
		  'type'  => 'switcher',
		  'default' => true,
		  'title' => __('نمایش گپ','mobix'),
		),
		array(
		  'id'    => 'sapp-activate',
		  'type'  => 'switcher',
		  'default' => true,
		  'title' => __('نمایش سروش','mobix'),
		),
	)
    ) );
	//
    // cutomize section
    CSF::createSection( $prefix, array(
      'title'  => __('سفارشی سازی','digix'),
	  'icon'   => 'fas fa-broom',
      'fields' => array(
  
		array(
		  'id'       => 'cutomize-analytics',
		  'type'     => 'code_editor',
		  'title'    => __('درج کد های گوگل آنالیتیکس','digix'),
		  'settings' => array(
			'theme'  => 'dracula',
			'mode'   => 'javascript',
			),
		),
		array(
		  'id'       => 'cutomize-js',
		  'type'     => 'code_editor',
		  'title'    => __('جاوا اسکریپت','digix'),
		  'settings' => array(
			'theme'  => 'dracula',
			'mode'   => 'javascript',
			),
		),
		array(
		  'id'       => 'cutomize-css',
		  'type'     => 'code_editor',
		  'title'    => __('استایل','digix'),
		  'settings' => array(
			'theme'  => 'mbo',
			'mode'   => 'css',
			),
		),
  
      )
    ) );
  
	 // Field: backup
	//
	CSF::createSection( $prefix, array(
	  'title'       => 'پشتیبان گیری',
	  'icon'        => 'fas fa-shield-alt',
	  'fields'      => array(

		array(
		  'type' => 'backup',
		),

	  )
	) );   
  }
  $options = get_option( 'digix_option' );