<?php
class Order {
	public function __construct() {
		add_shortcode( 'ac', 'available_coupon_codes' );
	}

	public static function get_total_order_count( $userID ) {
		$orders = wc_get_orders( [
			'status'   => 'wc-completed',
			'customer' => $userID
		] );

		return count( $orders );
	}

	public static function getTotal( $userID, $html = false ) {
		$customer_orders = get_posts( [
			'numberposts' => - 1,
			'meta_key'    => '_customer_user',
			'meta_value'  => $userID,
			'post_type'   => [ 'shop_order' ],
			'post_status' => [ 'wc-completed' ]
		] );
		$total           = 0;
		foreach ( $customer_orders as $customer_order ) {
			$order = wc_get_order( $customer_order );
			$total += $order->get_total();
		}

		return $html ? number_format( $total ) . ' ' . get_woocommerce_currency_symbol() : $total;
	}

	public static function chart( $day, $format = 'm/d' ) {
		$results = [];
		$dates   = Utility::getDatesList( strtotime( "-$day days" ) );
		foreach ( $dates as $date ) {
			$results['date'][]  = dx_jdate( $format, strtotime( $date ) );
			$results['price'][] = self::getDateTotal( $date );
		}

		return $results;
	}

	public static function getDateTotal( $date ) {
		$total  = 0;
		$orders = Order::getOrdersByDate( $date );
		foreach ( $orders as $order ) {
			$total += $order->get_total();
		}

		return $total;
	}

	public static function getOrdersByDate( $date ) {
		$args             = [];
		$args['status']   = 'wc-completed';
		$args['customer'] = get_current_user_id();
		if ( $date ) {
			$date                 = date( "Y-m-d", strtotime( $date ) );
			$args['date_created'] = $date;
		}

		return wc_get_orders( $args );
	}

	public static function getOrders( $userID, $count = 3 ) {
		return get_posts( [
			'numberposts' => $count,
			'meta_key'    => '_customer_user',
			'meta_value'  => $userID,
			'orderby'     => 'date',
			'order'       => 'desc',
			'post_type'   => [ 'shop_order' ],
			'post_status' => [ 'wc-completed' ]
		] );
	}

	public static function getOrdersProduct( $userID, $count = 3 ) {
		$orders   = wc_get_orders( [
			'customer_id' => $userID,
			'orderby'     => 'date',
			'order'       => 'DESC',
			'status'      => array( 'wc-completed' ),
		] );
		$products = [];
		foreach ( $orders as $order ) {
			$data = $order->get_data();
			$date = $data['date_created']->date( 'Y-m-d H:i:s' );
			foreach ( $order->get_items() as $item_id => $item ) {
				if ( $count > count( $products ) ) {
					$products[] = [
						'name'  => $item->get_name(),
						'price' => number_format( $item->get_total() ) . ' ' . get_woocommerce_currency_symbol(),
						'date'  => Utility::human_time( strtotime( $date ) )
					];
				} else {
					break;
				}
			}
		}

		return $products;
	}

	public static function orderStatus( $status ) {
		$status_bar = [
			'completed'  => 'success',
			'cancelled'  => 'danger',
			'processing' => 'warning',
			'pending'    => 'warning',
			'failed'     => 'danger',
			'on-hold'    => 'danger',
			'refunded'   => 'danger',
		];

		return $status_bar[ $status ];
	}

	public static function general_coupon_codes() {
		global $wpdb;
		$coupon_posts = get_posts( array(
			'posts_per_page' => 1,
			'order'          => 'asc',
			'meta_key'       => 'individual_use',
			'meta_value'     => 'no',
			'post_type'      => 'shop_coupon',
			'post_status'    => 'publish',
		) );
		$coupon_codes = [];
		foreach ( $coupon_posts as $coupon_post ) {
			$product_ids        = metadata_exists( 'post', $coupon_post->ID, 'product_ids' );
			$product_categories = metadata_exists( 'post', $coupon_post->ID, 'product_categories' );
			$date_expires       = (int) get_post_meta( $coupon_post->ID, 'date_expires', true );
			$now                = current_time( 'timestamps', 1 );
			if ( ! $product_ids && ! $product_categories && ( ! $date_expires || $date_expires >= $now ) ) {
				$coupon_codes[] = $coupon_post;
			}
		}

		return $coupon_codes;
	}
}
