<?php

defined( 'ABSPATH' ) || exit;

if ( ! function_exists( 'digix_search_init' ) ) {
	add_action( 'wp_loaded', 'digix_search_init', 11 );

	function digix_search_init() {
		// load text-domain

		if ( ! class_exists( 'digix_search' ) && class_exists( 'WC_Product' ) ) {
			class digix_search {
				protected static $instance = null;
				protected static $settings = array();

				public static function instance() {
					if ( is_null( self::$instance ) ) {
						self::$instance = new self();
					}

					return self::$instance;
				}

				function __construct() {
                    Global $options;
					
					add_action( 'wp_ajax_wpls_load_search_results', array( $this, 'load_search_results' ) );
					add_action( 'wp_ajax_nopriv_wpls_load_search_results', array( $this, 'load_search_results' ) );
					add_action( 'wp_enqueue_scripts', array( $this, 'enqueue_scripts' ) );

				}

				function enqueue_scripts() {
                    Global $options;
					if( is_page_template('templates/blog.php') || is_singular( 'post' ) || is_single() || is_archive() || is_category() || is_search() || is_tag() ) {
						wp_register_script( 'digix_postsearch', IM_URI . '/static/js/postsearch.js', array( 'jquery' ), '1', true );
				
						wp_localize_script(
							'digix_postsearch',
							'wpls',
							array(
								'ajax_url' => admin_url( 'admin-ajax.php' ),
							)
						);
						wp_enqueue_style( 'digix_postsearch' );
						wp_enqueue_script( 'digix_postsearch' );
					}
				}

				/**
				 * To load search results.
				 */
				public function load_search_results() {

					//phpcs:ignore
					$query               = isset( $_GET['query'] ) ? sanitize_text_field( wp_unslash( $_GET['query'] ) ) : '';

					$args = array(
						'post_type'   => 'post',
						'post_status' => 'publish',
						's'           => $query,
					);

					$search = new WP_Query( $args );

					ob_start();
					$size = "25-25";
					?>
					<ul id="wpls-search-result">
					<?php if ( $search->have_posts() ) : ?>

						<?php
						while ( $search->have_posts() ) :
							$search->the_post();
							?>
								<li>
									<a href="<?php the_permalink(); ?>"><img width="25" height="25" src="<?php the_post_thumbnail_url( array(100, 100) ); ?>" alt="<?php  the_title_attribute(); ?>" class="img-fluid thumbnail-img"><span><?php the_title(); ?></span></a>
								</li>
							<?php
						endwhile;
						?>
					<?php else : ?>
						<li class="nothing-here"><?php echo __( 'Sorry, no search results were found.', 'digix' ); ?></li>
					<?php endif; ?>
					</ul> 
					<?php

					wp_reset_postdata();

					$content = ob_get_clean();

					echo $content; //phpcs:ignore
					die();
				}
			}

			return digix_search::instance();
		}
	}
}
