<?php

  // Exit if accessed directly
  if (!defined('ABSPATH') ) {
    exit;
}


class iwp_mega_menu_walker extends Walker_Nav_Menu {

	private $tie_megamenu_type 			= '';
	private $tie_megamenu_icon 			= '';
	private $tie_megamenu_cicon 		= '';
	private $tie_megamenu_image 		= '';
	private $tie_megamenu_position 		= '';
	private $tie_megamenu_position_y 	= '';
	private $tie_megamenu_repeat 		= '';
	private $tie_has_children 			= '';

	/**
	 * Starts the list before the elements are added.
	 */
	public function start_lvl( &$output, $depth = 0, $args = array() ) {
		$indent = str_repeat("\t", $depth);

		if( $depth === 0 ){
		}
		elseif( $depth === 1 ){
			$output .= "\n$indent<ul class=\"digix-submenu\">\n";
		}
		else{
			$output .= "\n$indent<ul class=\"digix-submenu iran-sub digix-sub full-item mega-sub\">\n";
		}
	}


	/**
	 * Ends the list of after the elements are added.
	 */
	public function end_lvl( &$output, $depth = 0, $args = array() ) {
		$indent = str_repeat("\t", $depth);
		$output .= "$indent</ul>\n";

	}


	public function start_el( &$output, $item, $depth = 0, $args = array(), $id = 0 ) {
		$indent = ( $depth ) ? str_repeat( "\t", $depth ) : '';

		$classes = empty( $item->classes ) ? array() : (array) $item->classes;
		$classes[] = 'menu-item-' . $item->ID;
		$class_names = join( " " , apply_filters( 'nav_menu_css_class', array_filter( $classes ), $item, $args ) );


		$a_class = $item_output = '';

		if( $depth === 0 ){

			$this->tie_has_children = 0;
			if( !empty( $args->has_children ) )
				$this->tie_has_children           = $args->has_children;

			$this->tie_megamenu_columns       = get_post_meta( $item->ID, 'tie_megamenu_columns', 		true );
			$this->tie_megamenu_image         = get_post_meta( $item->ID, 'tie_megamenu_image', 		true );
			$this->tie_megamenu_position      = get_post_meta( $item->ID, 'tie_megamenu_position', 		true );
			$this->tie_megamenu_position_y    = get_post_meta( $item->ID, 'tie_megamenu_position_y', 	true );
			$this->tie_megamenu_repeat 	      = get_post_meta( $item->ID, 'tie_megamenu_repeat',		true );
		}
		$this->tie_megamenu_icon = get_post_meta( $item->ID, 'tie_megamenu_icon', true);
		$this->tie_megamenu_cicon = get_post_meta( $item->ID, 'tie_megamenu_cicon', true);

		//Menu Classes
		if( $depth === 0 ){
			$class_names .= ' mega-menu';
			$columns = ( !empty( $this->tie_megamenu_columns ) ? $this->tie_megamenu_columns :  4 );
			$class_names .= ' first-li mega-menu-col-'.$columns.' ';
		}
		if( $depth === 1 ){
			$class_names .=' mega-menu-column ';
			$a_class = ' class="mega-menu-head" ';
		}
	// =====================

		$class_names = $class_names ? ' class="' . esc_attr( $class_names ) . '"' : '';

		/**
		 * Filter the ID applied to a menu item's <li>.
		 */
		$id = apply_filters( 'nav_menu_item_id', 'menu-item-'. $item->ID, $item, $args );
		$id = $id ? ' id="' . esc_attr( $id ) . '"' : '';

		$output .= $indent . '<li' . $id . $class_names .'>';

		$atts = array();
		$atts['title']  = ! empty( $item->attr_title ) ? $item->attr_title : '';
		$atts['target'] = ! empty( $item->target )     ? $item->target     : '';
		$atts['rel']    = ! empty( $item->xfn )        ? $item->xfn        : '';
		$atts['href']   = ! empty( $item->url )        ? $item->url        : '';

		/**
		 * Filter the HTML attributes applied to a menu item's <a>.
		 *
		 */
		$atts = apply_filters( 'nav_menu_link_attributes', $atts, $item, $args );

		$attributes = '';
		foreach ( $atts as $attr => $value ) {
			if ( ! empty( $value ) ) {
				$value = ( 'href' === $attr ) ? esc_url( $value ) : esc_attr( $value );
				$attributes .= ' ' . $attr . '="' . $value . '"';
			}
		}
		if( !empty( $args->before ) ) $item_output = $args->before;
		$item_output .= '<a'.$a_class . $attributes .'>';
		if (!empty( $this->tie_megamenu_cicon ) ){
			$item_output .= '<img src="'.$this->tie_megamenu_cicon.'" class="cicon"/>';
		}else if( !empty( $this->tie_megamenu_cicon && !empty( $this->tie_megamenu_icon ) ) ){
			$item_output .= '<img src="'.$this->tie_megamenu_cicon.'" class="cicon"/>';
		}else if( !empty( $this->tie_megamenu_icon ) &&  empty( $this->tie_megamenu_cicon  )){
			 $item_output .= '<i class="'.$this->tie_megamenu_icon.'"></i>';
		}
		/** This filter is documented in wp-includes/post-template.php */
		$item_output .= $args->link_before . apply_filters( 'the_title', $item->title, $item->ID ) . $args->link_after;
		$item_output .= '</a>';
		$item_output .= $args->after;


	//By TieLabs ===========
	if($args->walker->has_children)
        {
		if( $depth === 0 ){

			if ( !empty( $this->tie_megamenu_image )) {
				$img = "style='background-image: url($this->tie_megamenu_image);'";
			}else{
				$img= "";
			}

			$item_output .="\n<ul class=\"digix-submenu iran-sub digix-sub full-item mega-sub\">\n<span class=\"digix-megamenu-background\"$img></span>\n";
		}
		}
		$output .= apply_filters( 'walker_nav_menu_start_el', $item_output, $item, $depth, $args );
	
	}
	public function end_el( &$output, $item, $depth = 0, $args = array() ) {
			global $post;

		$output .= "</li>\n";
	}


	function display_element( $element, &$children_elements, $max_depth, $depth=0, $args = array() , &$output ) {
		$id_field = $this->db_fields['id'];
		if ( is_object( $args[0] ) ) {
			$args[0]->has_children = ! empty( $children_elements[$element->$id_field] );
		}
		return parent::display_element( $element, $children_elements, $max_depth, $depth, $args, $output );
	}
} 
// add_filter( 'wp_edit_nav_menu_walker', 'tie_custom_nav_edit_walker',10,2 );
// function tie_custom_nav_edit_walker($walker,$menu_id) {
    // return 'tie_mega_menu_edit_walker';
// }

add_action( 'wp_nav_menu_item_custom_fields', 'tie_add_megamenu_fields', 10, 4 );
function tie_add_megamenu_fields( $item_id, $item, $depth, $args ) { ?>

	<div class="clear"></div>
	<div class="tie-mega-menu-type">


		<p class="field-megamenu-columns description description-wide">
			<label for="edit-menu-item-megamenu-columns-<?php echo $item_id; ?>">
				تعداد ستون
				<select id="edit-menu-item-megamenu-columns-<?php echo $item_id; ?>" class="widefat code edit-menu-item-megamenu-columns" name="menu-item-tie-megamenu-columns[<?php echo $item_id; ?>]">
					<option value="4" <?php selected( $item->tie_megamenu_columns, '4' ); ?>>4</option>
					<option value="5" <?php selected( $item->tie_megamenu_columns, '5' ); ?>>5</option>
				</select>
			</label>
		</p>
		<p class="field-megamenu-image description description-wide">
			<label for="edit-menu-item-tie-megamenu-icon-<?php echo $item_id; ?>">
				آیکون
			</label>
			<input type="text" id="edit-menu-item-tie-megamenu-icon-<?php echo $item_id; ?>" class="widefat code edit-menu-item-tie-megamenu-icon" name="menu-item-tie-megamenu-icon[<?php echo $item_id; ?>]" value="<?php echo $item->tie_megamenu_icon; ?>" />
			<span class="description">میتوانید از <a href="https://iraniwp.ir/digix/icon.html" target="_blank">اینجا</a>  آیکون را انتخاب کنید</span>
		</p>
		<p class="field-megamenu-image description description-wide">
			<label for="edit-menu-item-tie-megamenu-cicon-<?php echo $item_id; ?>">
				آیکون دلخواه ( اندازه طول و عرض تصویر 22 پیکسل در 22 پیکسل باشد)
			</label>
			<input type="text" id="edit-menu-item-tie-megamenu-cicon-<?php echo $item_id; ?>" class="widefat code edit-menu-item-tie-megamenu-cicon" name="menu-item-tie-megamenu-cicon[<?php echo $item_id; ?>]" value="<?php echo $item->tie_megamenu_cicon; ?>" />
			<span class="description">توجه کنید در صورتی که هر دو مقدار ورودی آیکون را وارد نمایید , آیکون دلخواه اولویت نمایش را داراست</span>
		</p>
		<p class="field-megamenu-image description description-wide">
			<label for="edit-menu-item-megamenu-image-<?php echo $item_id; ?>">
				پس زمینه مگامنو
			</label>
			<input type="text" id="edit-menu-item-megamenu-image-<?php echo $item_id; ?>" class="widefat code edit-menu-item-megamenu-image" name="menu-item-tie-megamenu-image[<?php echo $item_id; ?>]" value="<?php echo $item->tie_megamenu_image; ?>" />
		</p>


	</div>
<?php }


// Save The custom Fields
add_action('wp_update_nav_menu_item', 'tie_custom_nav_update', 10, 3);
function tie_custom_nav_update($menu_id, $menu_item_db_id, $args ) {

	$custom_meta_fields = array(
		'menu-item-tie-megamenu-type',
		'menu-item-tie-megamenu-columns',
		'menu-item-tie-megamenu-icon',
		'menu-item-tie-megamenu-cicon',
		'menu-item-tie-megamenu-image',
		'menu-item-tie-megamenu-position',
		'menu-item-tie-megamenu-position-y',
		'menu-item-tie-megamenu-min-height',
		'menu-item-tie-megamenu-repeat',
		'menu-item-tie-megamenu-padding-left',
		'menu-item-tie-megamenu-padding-right'
	);

	foreach( $custom_meta_fields as $custom_meta_field ){
		$save_option_name		= str_replace( 'menu-item-', '', $custom_meta_field);
		$save_option_name		= str_replace( '-', '_', $save_option_name);

		if ( !empty($_REQUEST[ $custom_meta_field ][ $menu_item_db_id ] ) ) {
			$custom_value = $_REQUEST[ $custom_meta_field ][ $menu_item_db_id ];
			update_post_meta( $menu_item_db_id, $save_option_name, $custom_value );
		}else{
			delete_post_meta( $menu_item_db_id, $save_option_name );
		}
	}
}

/*
 * Adds value of new field to $item object that will be passed to     Walker_Nav_Menu_Edit_Custom
 */
add_filter( 'wp_setup_nav_menu_item','tie_custom_nav_item' );
function tie_custom_nav_item($menu_item) {
    $menu_item->tie_megamenu_icon			= get_post_meta( $menu_item->ID, 'tie_megamenu_icon',			true );
	$menu_item->tie_megamenu_cicon			= get_post_meta( $menu_item->ID, 'tie_megamenu_cicon',			true );
    $menu_item->tie_megamenu_image			= get_post_meta( $menu_item->ID, 'tie_megamenu_image',			true );
    $menu_item->tie_megamenu_position 		= get_post_meta( $menu_item->ID, 'tie_megamenu_position',		true );
    $menu_item->tie_megamenu_position_y		= get_post_meta( $menu_item->ID, 'tie_megamenu_position_y',		true );
    $menu_item->tie_megamenu_repeat			= get_post_meta( $menu_item->ID, 'tie_megamenu_repeat',			true );
    return $menu_item;
}
