<?php
/**
 * The main template file
 *
 * This is the most generic template file in a WordPress theme
 * and one of the two required files for a theme (the other being style.css).
 * It is used to display a page when nothing more specific matches a query.
 * E.g., it puts together the home page when no home.php file exists.
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package Digix
 */

get_header();
Global $post;
$post_id = get_the_id();
?>
<main class="main" role="main" itemscope itemprop="mainContentOfPage">
	<div class="container">
		<?php
			/**
			 * woocommerce_before_main_content hook.
			 *
			 * @hooked woocommerce_output_content_wrapper - 10 (outputs opening divs for the content)
			 * @hooked woocommerce_breadcrumb - 20
			 */
			do_action( 'woocommerce_before_main_content' );
		?>
            <div class="main-page">
                <?php if ( have_posts() ): ?>
				    <?php 
					while ( have_posts() ):the_post();?>
						<article id="post-<?php the_ID(); ?>" <?php post_class( 'site-page page-content-single' ); ?>>
							<div class="page-wrapper">
								<header class="entry-header">
									<?php the_title( '<h1 class="entry-title">', '</h1>' ); ?>
								</header><!-- .entry-header -->

								<div class="entry-content clearfix">
									<?php the_content(); ?>
								</div><!-- .entry-content -->
							</div>
						</article><!-- #post-<?php the_ID(); ?> -->
					<?php
                    endwhile; ?>
			    <?php endif; ?>
            </div>
        </div>
    </main>

<?php get_footer(); ?>