<?php

class digix_elementor_brand extends \Elementor\Widget_Base 
{

	public function get_name() 
    {
		return 'brand-element';
	}

	public function get_title() 
    {
		return __('brand element','digix');
	}

	public function get_icon() 
    {
		return 'eicon-product-stock';
	}

	public function get_categories() 
    {
		return [ 'digix' ];
	}

	protected function _register_controls() 
    {

		$this->start_controls_section(
			'content_section',
			[
				'label' => __('brand element','digix'),
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'title',
			[
				'label'       => __('title','digix'),
				'type'        => \Elementor\Controls_Manager::TEXT,
				'input_type'  => 'text',
				'placeholder' => '',
			]
		);
        $this->add_control(
			'number',
			[
				'label'      => __('number of brands','digix'),
				'type'       => \Elementor\Controls_Manager::NUMBER,
				'input_type' => 'number',
			]
		);
		$this->add_control(
			'exclude',
			[
				'label'       => __('Exclude brand','digix'),
				'type'        => \Elementor\Controls_Manager::TEXT,
				'input_type'  => 'text',
				'description' => __('Separate Brand IDs with English commas.','digix'),
			]
		);
		$this->add_control(
			'hide_empty',
			[
				'label'        => __('Hide Empty','digix'),
				'type'         => \Elementor\Controls_Manager::SWITCHER,
				'label_on'     => __('active','digix'),
				'label_off'    => __('inactive','digix'),
				'return_value' => '1',
			]
		);
		$this->add_control(
			'text_align',
			[
				'label' => __( 'title text align', 'digix' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'default' => 'center',
				'options' => [
					'center' => __( 'center', 'digix' ),
					'right'  => __( 'right', 'digix' ),
				],
				'selectors' => [
					'{{WRAPPER}} .digix-brand .swiper-container h3' => 'text-align: {{VALUE}};',
				],
			]
		);
		$this->add_control(
			'title_color',
			[
				'label' => __( 'title color', 'digix' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'default' => '#000',
				'selectors' => [
					'{{WRAPPER}} .digix-brand .swiper-container h3' => 'color: {{VALUE}} !important',
					'{{WRAPPER}} .digix-brand  h3' => 'color: {{VALUE}} !important',
					'{{WRAPPER}} .digix-brand .swiper-container h3 strong' => 'color: {{VALUE}} !important',
					'{{WRAPPER}} .digix-brand  h3 strong' => 'color: {{VALUE}} !important',
					'{{WRAPPER}} .digix-brand .swiper-container h3.right strong::after' => 'background: {{VALUE}} !important',
				],
			]
		);
		$this->end_controls_section();
	}

	protected function render()
    {
		global $options;
		$settings = $this->get_settings_for_display();

		$title          = $settings['title'];
		$text_align     = $settings['text_align'];
        $number         = ! empty( $settings['number'] ) ? $settings['number'] : 10;
		$exclude        = ! empty( $settings['exclude'] ) ? trim( $settings['exclude'] ) : '';
		$hide_empty     = ! empty( $settings['hide_empty'] ) ? 1 : 0;

        $exclude = array_map( 'intval', explode( ',', $settings['exclude'] ) );
		$taxonomy = $options['woocommerce-brand-taxonomy'];
		$brands = get_terms( $taxonomy, array( 'hide_empty' => $settings['hide_empty'], 'orderby' => 'name', 'exclude' => $exclude, 'number' => $settings['number'], 'order' => 'asc' ) );

		if ( ! $brands ) {
			return;
		} ?>
			<section class="digix-brand">
				<div dir="rtl" class="swiper-container swiper-brand <?php echo $text_align . '-item';?>">

					<div class="swiper-button-next"></div>
					<?php
                    if ( $title ) 
                    {
                        echo '<h3 class="' . $text_align . '"><strong>' . $title . '</strong></h3>';
                    }
					?>						
					<div class="swiper-button-prev"></div>
					<div class="swiper-wrapper">
						<?php foreach ( array_values( $brands ) as $index => $brand ) : ?>
							<div class="swiper-slide">
                                <a class="brand-item" href="<?php echo esc_url( get_term_link( $brand->slug, 'product_brand' ) ); ?>" title="<?php echo esc_attr( $brand->name ); ?>">
                                    <?php echo get_brand_thumbnail_image( $brand ); ?>
                                </a>
							</div>
						<?php endforeach;  ?>
						<?php wp_reset_postdata(); ?>
					</div>	
				</div>
			</section>
		<?php 
	}
}