<?php

class digix_elementor_category extends \Elementor\Widget_Base {

	public function get_name() {
		return 'product-category';
	}

	public function get_title() {
		return __( 'product category', 'digix' );
	}

  public function get_icon() {
    return 'eicon-gallery-grid';
  }

  public function get_categories() {
    return [ 'digix' ];
  }

  protected function _register_controls() {

    $this->start_controls_section(
        'content_section',
        [
            'label' => __('product category','digix'),
            'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
        ]
    );

		$repeater = new \Elementor\Repeater();

		$repeater->add_control(
			'title', [
				'label'     => __( 'title', 'digix' ),
				'type'      => \Elementor\Controls_Manager::TEXT,
				'default'   => __( 'digital' , 'digix' ),
			]
		);

    $img_carousel = wc_placeholder_img_src( $size = array('100' , '100'));
    $repeater->add_control(
			'list_img',
			[
				'label' => __( 'image', 'digix' ),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'default' => [
						'url' => $img_carousel,
					],
			]
		);

		$repeater->add_control(
			'list_url', [
				'label' => __( 'url', 'digix' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __( '#' , 'digix' ),
			]
		);

		$repeater->add_control(
			'item_background',
			[
				'label' => __('background color', 'digix' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} {{CURRENT_ITEM}}' => 'background: {{VALUE}}'
				],
			]
		);
		$repeater->add_control(
			'item_color',
			[
				'label' => __('title color', 'digix' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} {{CURRENT_ITEM}}' => 'color: {{VALUE}}'
				],
			]
		);
		$this->add_control(
			'widget_title',
			[
				'label' => __( 'widget title', 'digix' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __( 'product category', 'digix' ),
			]
		);
		$this->add_control(
			'loop',
			[
				'label' => __( 'item list', 'digix' ),
				'type' => \Elementor\Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
				'default' => [
					[
						'title' => __( 'digital', 'digix' ),
					],
				],
				'title_field' => '{{{ title }}}',
			]
		);

		$this->end_controls_section();

    $this->start_controls_section(
		 'widget_config',
		 [
			 'label' => __( 'item configuration', 'digix' ),
			 'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
		 ]
		);


      	$this->add_control(
      		'widget_radius',
				[
					'label' => __( 'widget border radius', 'digix' ),
					'type' => \Elementor\Controls_Manager::TEXT,
					'default' => '11px',
						'selectors' => [
						'{{WRAPPER}} .digix-procat .procat-list article' => 'border-radius: {{VALUE}}',
						],
				]
      	);

		$this->add_control(
			'widget_background',
			[
				'label' => __( 'background color', 'digix' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .digix-procat .procat-list article' => 'background-color: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'widget_color',
			[
				'label' => __( 'widget color', 'digix' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .digix-procat .procat-list article' => 'color: {{VALUE}}',
				],
			]
		);

		$this->end_controls_section();
	}


	protected function render() {
	$settings = $this->get_settings_for_display();
    $loop = $settings['loop'];
    $widget_title = $settings['widget_title'];
    //$title = $settings['title'];

?>
  <?php if ($loop): ?>

  <section class="digix-procat">
	<?php if($widget_title):?>
		<header class="procat-header">
	 		<h3>
		 		<?php echo $widget_title;?>
			</h3>
	 	</header>
	<?php endif; ?>
		<div dir="rtl" class="swiper-container swiper-html" data-swiper='{"spaceBetween": 10, "slidesPerView":8, "loop": false, "navigation": {"nextEl": ".swiper-button-next", "prevEl": ".swiper-button-prev"}, "breakpoints": {"320": {"slidesPerView":2},"991": {"slidesPerView":5},"1100": {"slidesPerView":8}}}'>
			<div class="swiper-wrapper procat-list">
				<?php foreach ($loop as $item): ?>
					<div class="swiper-slide">	
						<article class="procat-item elementor-repeater-item-<?php echo esc_attr( $item['_id'] );?>">
							<a href="<?php echo $item['list_url'];?>" class="procat-url">
								<img class="procat-img img-fluid" src="<?php echo $item['list_img']['url'];?>" alt="promotion-categories">
								<h4 class="procat-title"><?php echo $item['title'];?></h4>
							</a>
						</article>
					</div>
				<?php endforeach; ?>
			</div>
  </section>
  <?php 
    endif; 
	}
}
