<?php
class digix_elementor_gamingproduct_two extends \Elementor\Widget_Base {


	public function get_name() {
		return 'product-gaming2';
	}

	public function get_title() {
		return __('Gaming Product Element - two','digix');
	}

	public function get_icon() {
		return 'eicon-product-stock';
	}

	public function get_categories() {
		return [ 'digix' ];
	}

	protected function _register_controls() {
		$this->start_controls_section(
			'configuration',
			[
				'label' => __('Configuration','digix'),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,

			]
		);
		$this->add_control(
			'title',
			[
				'label' 		=> __('title','digix'),
				'type' 			=> \Elementor\Controls_Manager::TEXT,
				'input_type' 	=> 'text',
				'default' 		=> 'محصولات جدید',
			]
		);
		$this->add_control(
			'url',
			[
				'label' => __('url','digix'),
				'type' => \Elementor\Controls_Manager::TEXT,
				'label_block' => 'true',
				'default' => '#',

			]
		);
		$options = array();
		$args = array(
		'hide_empty' => false,
		);
		$categories =  $categories = get_categories(array('taxonomy'=> 'product_cat'));
		foreach ( $categories as $key => $category ) {$options[$category->term_id] = $category->name;}
		$procat = array();
		$categories = get_terms("product_cat");
		if ( !empty( $categories ) && !is_wp_error( $categories ) ){
			foreach ( $categories as $category ) {
				$procat[ $category->term_id ] = $category->name;
			}
		}
		$protag = array();
		$tags = get_terms("product_tag");
		if ( !empty( $tags ) && !is_wp_error( $tags ) ){
			foreach ( $tags as $tag ) {
				$protag[ $tag->term_id ] = $tag->name;
			}
		}
		$prodbrand = array();
		global $options;
		$taxonomy = $options['woocommerce-brand-taxonomy'];
		$brands = get_terms($taxonomy);
		if ( !empty( $brands ) && !is_wp_error( $brands ) ){
			foreach ( $brands as $brand ) {
				$probrand[ $brand->term_id ] = $brand->name;
			}
		}
		$this->add_control(
			'sort',
			[
				'label' => __( 'Sort products', 'digix' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'default' => 'latest',
				'options' => [
					'latest'  			=> __( 'latest products', 'digix' ),
					'random' 			=> __( 'random products', 'digix' ),
					'viewed' 			=> __( 'most visited products', 'digix' ),
					'saled' 			=> __('best selling products', 'digix'),
					'price-desc'  		=> __( 'price from descending', 'digix' ),
					'price-asc'  		=> __( 'price from ascending', 'digix' ),
					'discounted' 		=> __( 'discounted products', 'digix' ),
					'rand_discounted' 	=> __( 'Random Discounted Products', 'digix' ),
					'menu_order' 		=> __( 'according to title', 'digix' ),
				],
			]
		);
		$this->add_control(
			'instock',
			[
				'label' 		=> __('instock products','digix'),
				'type' 			=> \Elementor\Controls_Manager::SWITCHER,
				'label_on'     	=> __('active','digix'),
				'label_off'    	=> __('inactive','digix'),
				'return_value' 	=> 'yes',
				'default' 		=> 'no',
			]
		);
		$this->add_control(
			'product_filter',
			[
				'label' => __( 'Product filter', 'digix' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'default' => 'category',
				'options' => [
					'category' 	 	=> __( 'Products category', 'digix' ),
					'tag' 			=> __( 'Products tag', 'digix' ),
					'brand' 		=> __( 'Products brand', 'digix' ),
					'proid' 		=> __( 'Manual selection of products', 'digix' ),
				],
			]
		);
		$this->add_control(
			'product_cat',
			[
				'label' 		=> __( 'product category', 'digix' ),
				'description' 	=> __( 'Empty labels (no products) are not displayed', 'digix' ),
				'type' 			=> \Elementor\Controls_Manager::SELECT2,
				'multiple' 		=> true,
				'options' 		=> $procat,
				'condition' 	=> 
					[
						'product_filter' => 'category',
					],
			]
		);
		$this->add_control(
			'product_tag',
			[
				'label' 		=> __( 'product tag', 'digix' ),
				'description' 	=> __( 'Empty labels (no products) are not displayed', 'digix' ),
				'label_block' 	=> true,
				'type' 			=> \Elementor\Controls_Manager::TEXT,
				'placeholder' 	=> __( 'Tag(s) ID', 'digix' ),
				'condition' 	=> 
					[
						'product_filter' => 'tag',
					],
			]
		);
		$this->add_control(
			'product_brand',
			[
				'label' 		=> __( 'product brand', 'digix' ),
				'description' 	=> __('Filter and product display by brand', 'digix'),
				'type' 			=> \Elementor\Controls_Manager::SELECT2,
				'multiple' 		=> true,
				'options' 		=> $probrand,
				'condition' 	=> 
					[
					'product_filter' => 'brand',
					],
			]
		);
		$this->add_control(
			'product_id',
			[
				'label' 		=> __( 'product id', 'digix' ),
				'description' 	=> __('Separate product IDs with English commas.','digix'),
				'label_block' 	=> true,
				'type' 			=> \Elementor\Controls_Manager::TEXT,
				'condition' 	=> 
					[
					'product_filter' => 'proid',
					],
			]
		);
		$this->add_control(
			'posts_per_page',
			[
				'label' 		=> __('number of products','digix'),
				'type' 			=> \Elementor\Controls_Manager::NUMBER,
				'min' 			=> 1,
				'max' 			=> 200,
				'step' 			=> 1,
				'default' 		=> 8,
			]
		);
		$this->add_control(
			'slide_per_view',
			[
				'label'      => __('number of slide per view','digix'),
				'type'       => \Elementor\Controls_Manager::NUMBER,
				'input_type' => 'number',
				'default'	 => 4,
				'min'		 => 3,
				'max'		 => 7,
			]
		);


		$this->end_controls_section();

		$this->start_controls_section(
		 'style',
		 [
			 'label' 			=> __( 'Style', 'digix' ),
			 'tab' 				=> \Elementor\Controls_Manager::TAB_CONTENT,
		 ]
		);
		$this->add_control(
			'title_color',
			[
				'label' 		=> __( 'Section title color', 'digix' ),
				'type' 			=> \Elementor\Controls_Manager::COLOR,
				'default' 		=> '#000',
				'selectors'		=> 
					[
						'{{WRAPPER}} .GamingProductTwo header h3' => 'color: {{VALUE}} !important',
					],
			]
        );
		$this->add_control(
			'url_color',
			[
				'label' 		=> __( 'Section url button color', 'digix' ),
				'type' 			=> \Elementor\Controls_Manager::COLOR,
				'default' 		=> '#000',
				'selectors'		=> 
					[
						'{{WRAPPER}} .GamingProductTwo header a' => 'color: {{VALUE}} !important',
					],
			]
        );
        $this->add_control(
			'border_radius',
			[
				'label' 		=> __( 'Product item border radius', 'digix' ),
				'type' 			=> \Elementor\Controls_Manager::TEXT,
				'default' 		=> '15px',
				'selectors' 	=> 
					[
						'{{WRAPPER}} .GamingProductTwo .product-item' => 'border-radius: {{VALUE}} !important',
						'{{WRAPPER}} .GamingProductTwo .product-item .product-thumbnails a img' => 'border-radius: {{VALUE}} {{VALUE}} 0 0 !important',
						'{{WRAPPER}} .GamingProductTwo .product-item .product-detailes .product-add' => 'border-radius: 0 0 {{VALUE}} {{VALUE}} !important',
					],
			]
        );
		$this->add_control(
			'product_title_color',
			[
				'label' 		=> __( 'product item title color', 'digix' ),
				'type' 			=> \Elementor\Controls_Manager::COLOR,
				'default' 		=> '#000',
				'selectors'		=> 
					[
						'{{WRAPPER}} .GamingProductTwo .product-item .product-detailes h2 a' => 'color: {{VALUE}} !important',
					],
			]
        );
		$this->add_control(
			'product_title_size',
			[
				'label' 		=> __( 'product item title size', 'digix' ),
				'type' 			=> \Elementor\Controls_Manager::TEXT,
				'default' 		=> '15px',
				'selectors'		=> 
					[
						'{{WRAPPER}} .GamingProductTwo .product-item .product-detailes h2 a' => 'font-size: {{VALUE}} !important',
					],
			]
        );
		$this->add_control(
			'product_subtitle_color',
			[
				'label' 		=> __( 'product item subtitle color', 'digix' ),
				'type' 			=> \Elementor\Controls_Manager::COLOR,
				'default' 		=> '#000',
				'selectors'		=> 
					[
						'{{WRAPPER}} .GamingProductTwo .product-item .product-detailes .subtitle' => 'color: {{VALUE}} !important',
					],
			]
        );
		$this->add_control(
			'product_subtitle_size',
			[
				'label' 		=> __( 'product item subtitle size', 'digix' ),
				'type' 			=> \Elementor\Controls_Manager::TEXT,
				'default' 		=> '14px',
				'selectors'		=> 
					[
						'{{WRAPPER}} .GamingProductTwo .product-item .product-detailes .subtitle' => 'font-size: {{VALUE}} !important',
					],
			]
        );
		$this->add_control(
			'product_url_color',
			[
				'label' 		=> __( 'Product More button color', 'digix' ),
				'type' 			=> \Elementor\Controls_Manager::COLOR,
				'default' 		=> '#000',
				'selectors'		=> 
					[
						'{{WRAPPER}} .GamingProductTwo .product-item .product-detailes .product-add a' => 'color: {{VALUE}} !important',
					],
			]
        );
		$this->add_control(
			'product_url_svg_color',
			[
				'label' 		=> __( 'Product More button icon color', 'digix' ),
				'type' 			=> \Elementor\Controls_Manager::COLOR,
				'default' 		=> '#ed3237',
				'selectors'		=> 
					[
						'{{WRAPPER}} .GamingProductTwo .product-item .product-detailes .product-add a svg' => 'fill: {{VALUE}} !important',
					],
			]
        );
		$this->add_control(
			'product_url_bgcolor',
			[
				'label' 		=> __( 'Product More button background color', 'digix' ),
				'type' 			=> \Elementor\Controls_Manager::COLOR,
				'default' 		=> '#f0f0f0',
				'selectors'		=> 
					[
						'{{WRAPPER}} .GamingProductTwo .product-item .product-detailes .product-add' => 'background-color: {{VALUE}} !important',
					],
			]
        );
		$this->end_controls_section();

	}

	protected function render() {
		$settings 			= $this->get_settings_for_display();
		$title 				= $settings['title'];
		$url 				= $settings['url'];
		$sort 				= $settings['sort'];
		$product_filter 	= $settings['product_filter'];
		$product_cat 		= $settings['product_cat'];
		$product_tag 		= $settings['product_tag'];
		$product_brand 		= $settings['product_brand'];
		$slide_per_view 	= $settings['slide_per_view'];
		Global $options;


	 $view_all_link = '';
		switch ($sort) {
			case 'latest':
				$arms = array(
				'posts_per_page' => $settings['posts_per_page'],
				'post_type' => 'product',
				'post_status' => 'publish',
				'order' => 'DESC'  );
				break;
			case 'menu_order':
				$arms = array(
				'posts_per_page' => $settings['posts_per_page'],
				'post_type' => 'product',
				'post_status' => 'publish',
				'orderby' => 'menu_order title',
				'order' => 'ASC'  );
				break;
			case 'saled':
				$arms = array(
				'posts_per_page' => $settings['posts_per_page'],
				'post_type' => 'product',
				'post_status' => 'publish',
				'meta_key' => 'total_sales',
				 'orderby' => 'meta_value_num',
				 'order' => 'DESC'  );
				break;
			case 'discounted':
				$arms = array(
					'posts_per_page'    => $settings['posts_per_page'],
					'post_status'       => 'publish',
					'order' => 'DESC',
					'post_type'         => 'product',
					'post__in'          => array_merge( array( 0 ), wc_get_product_ids_on_sale() )
				);
				break;
			case 'rand_discounted':
				$arms = array(
					'posts_per_page'    => $settings['posts_per_page'],
					'post_status'       => 'publish',
					'orderby'        	=> 'rand',
					'post_type'         => 'product',
					'post__in'          => array_merge( array( 0 ), wc_get_product_ids_on_sale() )
				);
				break;
			case 'viewed':
				$arms = array(
				'posts_per_page' => $settings['posts_per_page'],
				'post_type' => 'product',
				'post_status' => 'publish',
				'order'            => 'DESC',
			'suppress_filters' => false,  //required param
			'orderby'          => 'post_views',  //required param
				);
				break;
			case 'price-desc':
				$arms = array(
				'posts_per_page' => $settings['posts_per_page'],
				'post_type' => 'product',
				'post_status' => 'publish',
				'orderby'        => 'meta_value_num',
				'meta_key'       => '_price',
				'order'          => 'DESC');
				break;
			case 'price-asc':
				$arms = array(
				'posts_per_page' => $settings['posts_per_page'],
				'post_type' => 'product',
				'post_status' => 'publish',
				'orderby'        => 'meta_value_num',
				'meta_key'       => '_price',
				'order'          => 'ASC');
				break;
			case 'random':
				$arms = array(
				'posts_per_page' => $settings['posts_per_page'],
				'post_type' => 'product',
				'post_status' => 'publish',
				'orderby'        => 'rand'  );
				break;
			default:
			$arms = array(
				'posts_per_page' => $settings['posts_per_page'],
				'post_type' => 'product',
				'post_status' => 'publish',
				'meta_key' => 'onsales_round',
				'meta_value' => 'yes',
			 );
			}
			if ( $product_filter ) {
				if ( $product_filter == 'category' && !empty($product_cat) ) {
					$arms['tax_query'] = array(
						array(
						'taxonomy' => 'product_cat',
						'field' => 'term_id',
						'terms' => $product_cat
						)
					);
					$view_all_link = digix_term_links( 'product_cat', $product_cat );
				} elseif ( $product_filter == 'tag' && !empty($product_tag) ) {
					$arms['tax_query'] = array(
						array(
						'taxonomy' => 'product_tag',
						'field' => 'term_id',
						'terms' => $product_tag
						)
					);
					$view_all_link = digix_term_links( 'product_tag', $product_tag );
				} elseif ( $product_filter == 'brand' && !empty($product_brand) ) {
					$arms['tax_query'] = array(
						array(
						'taxonomy' => $options['woocommerce-brand-taxonomy'],
						'field' => 'term_id',
						'terms' => $product_brand
						)
					);
					$view_all_link = digix_term_links( $options['woocommerce-brand-taxonomy'] , $product_brand );
				}elseif ( $product_filter == 'proid' && !empty($product_id) ) {
					$arms['tax_query'] = array(
						array(
						'post__in' => array( $product_id),
						)
					);
				}
			}

		if('yes' === $settings['instock'] ){
			$arms['meta_query'] = array(
					'relation' => 'AND',
					array(
						'key' => '_stock_status',
						'value' => 'instock'
					),
				);
		}

		$arms[] = array(
			'fields'                    => 'ids',
			'no_found_rows'             => true,
			'update_post_term_cache'    => false
		);

		if(isset($_COOKIE['digixproductlocation']) && !empty(($_COOKIE['digixproductlocation']))){
			$product_city=explode(',', $_COOKIE['digixproductlocation']);
			if (!empty($product_city) && $product_city !== 0) {
				if (is_array($arms["tax_query"])) {
					$arms["tax_query"][] = ["taxonomy" => "product_city", "field" => "id", "terms" => $product_city];
				} else {
					$arms["tax_query"] = ["relation" => "AND", ["taxonomy" => "product_city", "field" => "id", "terms" => $product_city]];
				}
			}
		}
    $products = new WP_Query( $arms );
	global $product;
	$meta = get_post_meta( get_the_ID(), 'digix_metabox', true );
	global $options;?>
<?php if ( $products ->have_posts() ) :?>
<section class=" GamingProductTwo im-product">
	
		<header class="gm2-header">
			<h3>
				<?php echo $title;?>
			</h3>	
			<?php if( !empty( $url ) ){ ?>
				<a href="<?php echo $url; ?>">
					<?php echo __("See More","digix");?>
				</a>
			<?php } ?>	
		</header>	
		<div class="gm2full">
			<div dir="rtl" class="swiper-container swiper-GamingProductTwo swiper-html" data-swiper='{"spaceBetween": 30, "slidesPerView":<?php echo $slide_per_view; ?>, "loop": false, "navigation": {"nextEl": ".swiper-button-next", "prevEl": ".swiper-button-prev"}, "breakpoints": {"320": {"slidesPerView":2},"991": {"slidesPerView":4},"1100": {"slidesPerView":<?php echo $slide_per_view; ?>}}}'>
				<div class="swiper-wrapper">
					<?php while ( $products->have_posts() ) : $products->the_post(); ?>
						<?php $product = wc_get_product( get_the_id() );$meta = get_post_meta( get_the_ID(), 'digix_metabox', true ); ?>
						<div class="swiper-slide">
							<div class="product-item">
								<figure class="product-thumbnails">
									<a href="<?php echo $product->get_permalink(); ?>">
										<?php echo( has_post_thumbnail() ? get_the_post_thumbnail( get_the_id(),'', array( 'class' => 'img-fluid' ) ) : wc_placeholder_img( 'woocommerce_thumbnail' ) ); ?>
									</a>
								</figure>
								<div class="product-detailes">
									<h2>
										<a href="<?php echo $product->get_permalink(); ?>"><?php echo $product->get_title(); ?></a>
									</h2>
									<?php if( !empty($meta['subtitle']) ): ?>
										<span class="subtitle">
											<?php echo $meta['subtitle']; ?>
										</span>
									<?php endif; ?>
									<div class="product-add">
										<a href="<?php echo $product->get_permalink(); ?>">
											<svg width="24" height="24" x="0" y="0" viewBox="-20 50 680 680" xmlns="http://www.w3.org/2000/svg"><path d="M430 226q-10 0-17.5 6.5T405 251q0 44-30.5 74T300 355q-43 0-73.5-30T196 251q0-12-6-18.5t-16-6.5q-9 0-16.5 6.5T150 251q0 31 11 58 13 28 33.5 48.5T242 390q27 11 58 11 32 0 59-11 27-12 47.5-32.5T439 309q12-27 12-58 3-12-4.5-18.5T430 226zm163 18q-4-32-18-60t-36.5-49Q516 114 488 101q-29-12-61-13-31-2-63-4-31-1-62-1t-62 1q-32 2-63 4-32 1-61 13-28 13-50.5 33.5T29 183q-14 27-18 58-4 35-7 70-2 34-2 69t2 71q3 35 7 71 6 34 19 60 14 27 34.5 46.5T113 659q28 12 64 16 31 2 62.5 4t64.5 2q30 0 61-2l62-4q32-1 61-13 29-13 52-34t37-49q16-28 19-60 3-34 5-68 2-35 1.5-69.5T600 312q-3-34-7-68zm-47 271q-1 25-12 45-11 21-27.5 36.5T468 621q-22 8-48 8-30 3-59 4-30 1-60.5 1t-60.5-1q-29-1-59-4-56-7-86.5-34T54 512q-5-33-7-67-2-33-2-66.5t2-66.5q2-34 7-68 2-24 13-45 11-20 27-35.5t37-23.5q22-9 46-9 31-3 60.5-4.5T297 125q30 0 60.5 1.5T420 131q25 0 46 9 22 8 38.5 23.5T531 201q10 21 12 47 6 33 9 67 3 33 3.5 66.5T553 448q-2 34-7 67z"></path></svg>
											<?php echo __("See and Buy","digix"); ?>
										</a>
									</div>
								</div>
							</div>
						</div>
					<?php endwhile; ?>
					<?php wp_reset_postdata(); ?>
				</div>	
				<div class="swiper-button">
					<div class="swiper-button-next swip-btn"></div>
					<div class="swiper-button-prev swip-btn"></div>
				</div>
			</div>
		</div>
</section>
<?php endif;?>
<?php

	}

	protected function _content_template() {}

}
