<?php

class digix_elementor_special2 extends \Elementor\Widget_Base {

	public function get_name() 
    {
		return 'special2-slider';
	}

	public function get_title() 
    {
		return __('special element','digix');
	}

	public function get_icon() 
    {
		return 'eicon-slider-device';
	}

	public function get_categories() 
    {
		return [ 'digix' ];
	}

	protected function _register_controls() {

		$this->start_controls_section(
			'content_section',
			[
				'label' => __('special element','digix'),
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'ms_important_note',
			[
				'label'           => '',
				'type'            => \Elementor\Controls_Manager::RAW_HTML,
				'raw'             => __('special element','digix'),
				'content_classes' => '',
			]
		);
        
		$this->add_control(
			'title',
			[
				'label'       => __('title','digix'),
				'type'        => \Elementor\Controls_Manager::TEXT,
				'input_type'  => 'text',
				'placeholder' => __('special products today','digix'),
			]
		);

		$this->add_control(
			'posts_per_page',
			[
				'label'      => __('number of products','digix'),
				'type'       => \Elementor\Controls_Manager::NUMBER,
				'input_type' => 'number',
                'default'     => '10',
			]
		);
        $this->add_control(
			'attributes',
			[
				'label'        => __('show attributes','digix'),
				'type'         => \Elementor\Controls_Manager::SWITCHER,
				'label_on'     => __('active','digix'),
				'label_off'    => __('inactive','digix'),
				'return_value' => '1',
			]
		);
		$this->end_controls_section();

		$this->start_controls_section(
			'style',
			[
				'label' => __( 'style', 'digix' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'background_color',
			[
				'label' => __( 'Pattern background color', 'digix' ),
				'type' => \Elementor\Controls_Manager::COLOR,
				'default' => '#094aef',
				'selectors' => [
					'{{WRAPPER}} .digix-offer .offer-list:before' => 'background-color: {{VALUE}} !important',
				],
			]
		);
	   $this->add_control(
		   'item_color',
		   [
			   'label' => __( 'amazing item color', 'digix' ),
			   'type' => \Elementor\Controls_Manager::COLOR,
			   'default' => '#094aef',
			   'selectors' => [
				   '{{WRAPPER}} .digix-offer .offer-list .swiper-offer-item .swiper-wrapper .swiper-slide.swiper-slide-thumb-active .offer-item-title' => 'color: {{VALUE}} !important',
			   ],
		   ]
	   );
	   $this->add_control(
		'discount_color',
		[
			'label' => __( 'discount text color', 'digix' ),
			'type' => \Elementor\Controls_Manager::COLOR,
			'default' => '#fff',
			'selectors' => [
				'{{WRAPPER}} .digix-offer .offer-list .swiper-offer .offer-url .offer-detailes .offer-information .offer-price .discount' => 'color: {{VALUE}}; border-color: {{VALUE}};',
				'{{WRAPPER}} .digix-product .product-item .discount' => 'color: {{VALUE}}; border-color: {{VALUE}};',
			],
		]
		);
	   $this->add_control(
		'discount_bgcolor',
		[
			'label' => __( 'discount background color', 'digix' ),
			'type' => \Elementor\Controls_Manager::COLOR,
			'default' => '#ff0000',
			'selectors' => [
				'{{WRAPPER}} .digix-offer .offer-list .swiper-offer .offer-url .offer-detailes .offer-information .offer-price .discount' => 'background-color: {{VALUE}}',
				'{{WRAPPER}} .digix-product .product-item .discount' => 'background-color: {{VALUE}};',
			],
		]
		);
		$this->add_control(
            'price_color',
            [
                'label' => __( 'price color', 'digix' ),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#3ab54a',
                'selectors' => [
                    '{{WRAPPER}} .digix-offer .offer-list .swiper-offer .offer-url .offer-detailes .offer-information .offer-price>span' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .digix-offer .offer-list .swiper-offer .offer-url .offer-detailes .offer-information .offer-price ins' => 'color: {{VALUE}}',
                ],
            ]
        );
	  $this->end_controls_section();
	}

	protected function render() 
    { 
        $settings = $this->get_settings_for_display();

		$title          = $settings['title'];
		$attributes   	= ! empty( $settings['attributes'] ) ? 1 : 0;
		$posts_per_page = ! empty( $settings['posts_per_page'] ) ? $settings['posts_per_page'] : 10;
	    $args = array(
		'post_type'      => 'product',
		'posts_per_page' => $posts_per_page,
		'meta_query'     => array(
			'relation' => 'AND',
			array(
				'key'     => 'digix_special_slider_active',
				'value'   => 'yes',
				'compare' => '=',
			),
			array(
				'key'     => 'digix_special_slider_date_start',
				'value'   => '',
				'compare' => '!=',
			),
			array(
				'key'     => 'digix_special_slider_date_start',
				'value'   => time(),
				'compare' => '<',
			),
			array(
				'key'     => 'digix_special_slider_date_end',
				'value'   => '',
				'compare' => '!=',
			),
		),
		);
		if(isset($_COOKIE['digixproductlocation']) && !empty(($_COOKIE['digixproductlocation']))){
			$product_city=explode(',', $_COOKIE['digixproductlocation']);
			if (!empty($product_city) && $product_city !== 0) {
				if (is_array($args["tax_query"])) {
					$args["tax_query"][] = ["taxonomy" => "product_city", "field" => "id", "terms" => $product_city];
				} else {
					$args["tax_query"] = ["relation" => "AND", ["taxonomy" => "product_city", "field" => "id", "terms" => $product_city]];
				}
			}
		}
	

	$special = new WP_Query( $args );
	if ( $special->have_posts() ) { ?>
<section class="digix-offer">
	<div class="offer-list">
		<div class="swiper swiper-offer">
				<div class="swiper-wrapper">
                <?php
				
					while ( $special->have_posts() ) {
						$special->the_post();
						$product    = wc_get_product( $special->post->ID );
						$date_start = get_post_meta( $special->post->ID, 'digix_special_slider_date_start', true );
						$date_end   = get_post_meta( $special->post->ID, 'digix_special_slider_date_end', true );

						//$active     = $i == 0 ? 'active' : '';
						$deprecated = $date_end < time() ? true : false;
						?>
						<a id="tab-<?php echo rand(); ?>" href="<?php the_permalink(); ?>" title="<?php the_title(); ?>" class="swiper-slide offer-url<?php if (!$product->is_in_stock()) {echo' out_of_stock';} ?>">
							<div class="offer-pic">
								
									<?php $offer_img=get_post_meta(get_the_ID(),'up-offer',true); if(isset($offer_img) && !empty($offer_img)): ?>                 
									 <img src="<?php echo get_post_meta( get_the_ID(), 'up-offer', true ); ?>">
									 <?php else :
									 echo has_post_thumbnail() ? the_post_thumbnail( array(200,200) ) : wc_placeholder_img( 'shop_thumbnail' );?>
									 <?php endif; ?>
							</div>
							<div class="offer-detailes">
								<div class="offer-information">
									<h3 class="offer-title"><strong><?php the_title(); ?></strong></h3>
									<div class="offer-price"><?php woocommerce_template_loop_price() ?><?php if($product->is_on_sale()) { echo '<span class="discount">٪' . digix_wooocmmerce_discount(get_the_ID()) . '</span>';} ?></div>
									<div class="offer-attributes">
										<?php echo digix_woocommerce_attributes($product); ?>
									</div>
								</div>
								<div class="offer-timer">
									<?php if ( ! $deprecated ){ ?>
										<div class="timer">
											<div class="countdown timer-countdown-<?php $gshoprand=rand(); echo($gshoprand);?>" data-date="<?php echo date( 'Y-m-d', esc_attr( $date_end ) ); ?>"></div>
										</div>
										<script>
										
										jQuery(function($) {
											var dayz = new Date('<?php echo date( 'Y/m/d', esc_attr( $date_end ) ); ?> 23:59:59');
											jQuery('.timer-countdown-<?php echo($gshoprand);?>').countdown({ 
												until: dayz, 
												layout: '<span class="day"><b>{dn}</b><div><?php echo __('day','digix'); ?></div></span><span class="hour"><b>{hn}</b><div><?php echo __('hour','digix'); ?></div></span><span class="min"><b>{mn}</b><div><?php echo __('minutes','digix'); ?></div></span><span class="sec"><b>{sn}</b><div><?php echo __('seconds','digix'); ?></div></span> '
											});
										});
										
										</script>
									<?php }else{?>
										<div class="offer-end">
											<button class="btn end"><?php echo __('This offer has expired','digix'); ?></button>
										</div>
									<?php } ?>
								</div>
							</div>
						</a>
                        <?php
				}
				wp_reset_postdata();
			?>
			</div>
		</div>
		<div class="swiper swiper-offer-item">
			<div class="swiper-wrapper">
                    <?php
			$counter = '1';
			$j = 0;
			while ( $special->have_posts() ) {
				$special->the_post();
				
				$date_start = get_post_meta( $special->post->ID, 'amazing_offer_date_start', true );
				$date_end   = get_post_meta( $special->post->ID, 'amazing_offer_date_end', true );

				$active = $j == 0 ? 'active' : '';
				echo '<div class="swiper-slide h-auto"><span class="offer-item-title">'; echo get_the_title( $special->post->ID ); echo'</span></div>';
				$j ++;
			}
			wp_reset_postdata();
?>
			</div>
		</div>
	</div>
</section>
    <?php
	}
}

}