(function ($) {
	"use strict";

	// on ready
	$(function() {
		resize();
		
		var swiper = new Swiper(".digix-image-gallery .swiper-container", {
			slidesPerView: 1,
			centeredSlides: true,
			pagination: {
				el: ".digix-image-gallery .swiper-pagination",
				dynamicBullets: true,
			},
		});

		Array.from(document.querySelectorAll(".digix-lightbox-content img")).forEach(function (el) {
			new PinchZoom.default(el, {});
		});
	});
	
	// on resize
	$(window).on("resize", resize);

	// scripts
	$(document).on("keydown", function (event) {
		if(event.keyCode == 27) {
			lightbox_close();
		}
	});

	$(document).on("click", ".digix-image-gallery a", function (e) {
		e.preventDefault();
		scroll_enable();

		var $index = $(this).data("digix-index");
		var $type = $(this).data("digix-type");

		lightbox_open();
		lightbox_open_item($index, $type);
	});

	$(document).on("click", ".digix-lightbox-thumbnails .swiper-slide", function (e) {
		e.preventDefault();
		var $index = $(this).attr("data-digix-index");
		var $type = $(this).attr("data-digix-type");

		lightbox_open_item($index, $type);
	});

	$(document).on("click", ".digix-lightbox", function (e) {
		if (!$(event.target).closest(".digix-lightbox-wrapper").length) {
			lightbox_close();
		}
	});

	$(document).on("click", ".digix-lightbox-close, .digix-back-button", function (e) {
		lightbox_close();
	});

	function lightbox_open() {
		$(".digix-lightbox-container").show();
		$(".digix-lightbox-container").removeClass("close");
		$(".digix-lightbox-container").addClass("open");

		var swiper = new Swiper(".digix-lightbox-thumbnails .swiper-container", {
			slidesPerView: 4,
			spaceBetween: 30,
			centeredSlides: true,
		});
	}

	function lightbox_close() {
		$(".digix-lightbox-container").removeClass("open");
		$(".digix-lightbox-container").addClass("close");

		lightbox_videos_stop();

		$(".digix-lightbox-container").hide(500);

		scroll_disable();
	}

	function scroll_enable() {
		$("html").css({
			overflow: "hidden",
			height: "100%"
		});
	}

	function scroll_disable() {
		$("html").css({
			overflow: "auto",
			height: "auto"
		});
	}

	function lightbox_videos_stop() {
		$(".digix-lightbox-container iframe").each(function () {
			var VideoURL = $(this).attr("src");
			$(this).attr("src", "");
			$(this).attr("src", VideoURL);
		});
	}

	function lightbox_open_item($index, $type) {
		lightbox_videos_stop();

		$(".digix-lightbox-thumbnails .swiper-slide").removeClass("swiper-slide-active");
		$(".digix-lightbox-thumbnails").find("[data-digix-index=" + $index + "]").addClass("swiper-slide-active");
		$(".digix-lightbox-content li").removeClass("active");
		$(".digix-lightbox-content").find("[data-digix-index=" + $index + "]").addClass("active");

		if ($type == "image") {
			$("#digix-lightbox-image-" + $index).fadeOut(100, function () {
				$("#digix-lightbox-image-" + $index).attr("src", $(this).attr("data-digix-src")).one("load", function () {
					$("#digix-loading-wrapper-" + $index).fadeOut(100);
					$("#digix-lightbox-image-" + $index).fadeIn(100);
				});
			});
		} else {
			$("#digix-lightbox-video-" + $index).fadeOut(100, function () {
				$("#digix-lightbox-video-" + $index).attr("src", $(this).attr("data-digix-src")).one("load", function () {
					$("#digix-loading-wrapper-" + $index).fadeOut(100);
					$("#digix-lightbox-video-" + $index).fadeIn(100);
				});
			});
		}
	}

	function resize() {
		var width_offset, height_offset, top, left;
		switch (2) {
			case 1:
				width_offset = 0;
				height_offset = 0;
				top = 0;
				left = 0;
				break;
			case 2:
				width_offset = 10;
				height_offset = 10;
				top = 5;
				left = 5;
				break;
			default:
				width_offset = 10;
				height_offset = 10;
				top = 5;
				left = 5;
		}

		$(".digix-lightbox-wrapper").css({
			width: $(window).width() - width_offset,
			height: $(window).height() - height_offset,
			top: top,
			left: left,
		});
	}
}(jQuery));