(function(factory){
	if(typeof define==="function" && define.amd){
		define(["jquery"],factory);
	}else if(typeof module!=="undefined" && module.exports){
		module.exports=factory;
	}else{
		factory(jQuery,window,document);
	}
}(function($){
(function(init){
	var _rjs=typeof define==="function" && define.amd, /* RequireJS */
		_njs=typeof module !== "undefined" && module.exports, /* NodeJS */
		_dlp=("https:"==document.location.protocol) ? "https:" : "http:", /* location protocol */
		_url="cdnjs.cloudflare.com/ajax/libs/jquery-mousewheel/3.1.13/jquery.mousewheel.min.js";
	if(!_rjs){
		if(_njs){
			require("jquery-mousewheel")($);
		}else{
			/* load jquery-mousewheel plugin (via CDN) if it's not present or not loaded via RequireJS 
			(works when mCustomScrollbar fn is called on window load) */
			$.event.special.mousewheel || $("head").append(decodeURI("%3Cscript src="+_dlp+"//"+_url+"%3E%3C/script%3E"));
		}
	}
	init();
})}));
(function ($) {
	"use strict";

	// on ready
	$(function() {
		resize();

		product_image_zoom_init();


	});

	// on resize
	$(window).on("resize", resize);
	$(window).on("resize", lightbox_img_resize);

	// scripts
	$(document).on("keydown", function (event) {
		if(event.keyCode == 27) {
			if($(".panWrapper").length) {
				if($(".panWrapper").is(":hidden")) {
					lightbox_close();
				}
			} else {
				lightbox_close();
			}
		}
	});

	$(document).on("click", ".digix-image-gallery ul li a", function (e) {
		e.preventDefault();
		scroll_enable();

		var $index = $(this).data("digix-index");
		var $type = $(this).data("digix-type");

		lightbox_open();

		lightbox_open_item($index, $type);
	});

	$(document).on("click", ".digix-lightbox-thumbnails li", function (e) {
		e.preventDefault();
		var $index = $(this).attr("data-digix-index");
		var $type = $(this).attr("data-digix-type");

		lightbox_open_item($index, $type);
	});

	$(document).on("click", ".digix-lightbox", function (e) {
		if (!$(event.target).closest(".digix-lightbox-wrapper").length && !$(event.target).closest(".zoomContainer").length) {
			lightbox_close();
		}
	});

	$(document).on("click", ".digix-lightbox-wrapper .icon-close", function (e) {
		lightbox_close();
	});

	function lightbox_open() {
		$(".digix-lightbox-container").show();
		$(".digix-lightbox-container").removeClass("close");
		$(".digix-lightbox-container").addClass("open");

		resize();
		lightbox_img_resize();
	}

	function lightbox_close() {
		$(".digix-lightbox-container").removeClass("open");
		$(".digix-lightbox-container").addClass("close");

		product_image_zoom_init();
		lightbox_videos_stop();

		$(".digix-lightbox-container").hide(500);
		scroll_disable();
	}

	function scroll_enable() {
		$("html").css({
			overflow: "hidden",
			height: "100%"
		});
	}

	function scroll_disable() {
		$("html").css({
			overflow: "auto",
			height: "auto"
		});
	}

	function lightbox_videos_stop() {
		$(".digix-lightbox-container iframe").each(function () {
			var VideoURL = $(this).attr("src");
			$(this).attr("src", "");
			$(this).attr("src", VideoURL);
		});
	}

	function lightbox_open_item($index, $type) {
		lightbox_videos_stop();
		$(".digix-lightbox-thumbnails li").removeClass("active");
		$(".digix-lightbox-thumbnails").find("[data-digix-index=" + $index + "]").addClass("active");
		$(".digix-lightbox-content li").removeClass("active");
		$(".digix-lightbox-content").find("[data-digix-index=" + $index + "]").addClass("active");
		if ($type == "image") {
			$("#digix-lightbox-image-" + $index).fadeOut(100, function () {
				$("#digix-lightbox-image-" + $index).attr("src", $(this).attr("data-digix-src")).one("load", function () {
					var lensShape;
					switch (parseInt(digix_script_vars.lightbox_zoom_lens_shape)) {
						case 1:
							lensShape = "square";
							break;
						case 2:
							lensShape = "round";
							break;
						default:
							lensShape = "square";
					}

					$("#digix-loading-wrapper-" + $index).fadeOut(100);
					$("#digix-lightbox-image-" + $index).fadeIn(100);
					if (parseInt(digix_script_vars.lightbox_zoom_mode) == 1) {
						$("#digix-lightbox-image-" + $index).elevateZoom({
							zoomType: "lens",
							lensShape: lensShape,
							lensSize: digix_script_vars.lightbox_zoom_lens_size,
							borderSize: digix_script_vars.lightbox_zoom_lens_border_size,
							borderColour: digix_script_vars.lightbox_zoom_lens_border_color,
							custom_class: 'zoomContainerLightbox'
						});
					}
				});
			});
		} else if ($type == "video") {
			$("#digix-lightbox-video-" + $index).fadeOut(100, function () {
				$("#digix-lightbox-video-" + $index).attr("src", $(this).attr("data-digix-src")).one("load", function () {
					$("#digix-loading-wrapper-" + $index).fadeOut(100);
					$("#digix-lightbox-video-" + $index).fadeIn(100);
				});
			});
		}
	}

	function product_image_zoom_init() {
		if (parseInt(digix_script_vars.image_zoom) == 1) {
			$(".digix-product-image img.digix-thumbnail-image").elevateZoom({
				zoomWindowWidth: digix_script_vars.zoom_window_width,
				zoomWindowHeight: digix_script_vars.zoom_window_height,
				zoomWindowFadeIn: 200,
				zoomWindowFadeOut: 200,
				lensFadeIn: 200,
				lensFadeOut: 200,
				zoomWindowPosition: parseInt(digix_script_vars.zoom_window_position),
				borderSize: digix_script_vars.zoom_window_border_size,
				borderColour: digix_script_vars.zoom_window_border_color,
			});
		}
	}

	function resize() {
		var width_offset, height_offset, top, left;
		switch (parseInt(digix_script_vars.lightbox_size)) {
			case 1:
				width_offset = 0;
				height_offset = 0;
				top = 0;
				left = 0;
				break;
			case 2:
				width_offset = 20;
				height_offset = 20;
				top = 10;
				left = 10;
				break;
			case 3:
				width_offset = 200;
				height_offset = 30;
				top = 15;
				left = 100;
				break;
			case 4:
				width_offset = 400;
				height_offset = 100;
				top = 50;
				left = 200;
				break;
			default:
				width_offset = 200;
				height_offset = 30;
				top = 15;
				left = 100;
		}

		$(".digix-lightbox-wrapper").css({
			width: $(window).width() - width_offset,
			height: $(window).height() - height_offset,
			top: top,
			left: left,
		});
	};

	function lightbox_img_resize() {
		var $lightbox_content_width = $(".digix-lightbox-content").width();

		$(".digix-lightbox-container .digix-centered-flex").each(function (i, obj) {
			$(this).width($lightbox_content_width);
		});
	};

	/* function lightbox_scrollbar_set() {
		$(".digix-lightbox-thumbnails").mCustomScrollbar({
			theme: "dark",
			scrollButtons: {
				enable: (parseInt(digix_script_vars.lightbox_scrollbar_buttons) ? true : false)
			},
		});
	}; */
}(jQuery));
