<?php
/**
 * Mini-cart
 *
 * Contains the markup for the mini-cart, used by the cart widget.
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/cart/mini-cart.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce/Templates
 * @version 5.2.0
 */

defined( 'ABSPATH' ) || exit;


do_action( 'woocommerce_before_mini_cart' ); ?>

<?php if ( ! WC()->cart->is_empty() ) : ?>
    <ul class="woocommerce-mini-cart <?php echo esc_attr( $args['list_class'] ); ?>">
		<?php
		do_action( 'woocommerce_before_mini_cart_contents' );

		foreach ( WC()->cart->get_cart() as $cart_item_key => $cart_item ) {
			$_product = apply_filters( 'woocommerce_cart_item_product', $cart_item['data'], $cart_item, $cart_item_key );
			$product_id = apply_filters( 'woocommerce_cart_item_product_id', $cart_item['product_id'], $cart_item, $cart_item_key );

			if ( $_product && $_product->exists() && $cart_item['quantity'] > 0 && apply_filters( 'woocommerce_widget_cart_item_visible', true, $cart_item, $cart_item_key ) ) {
				$product_name = apply_filters( 'woocommerce_cart_item_name', $_product->get_name(), $cart_item, $cart_item_key );
				$thumbnail = apply_filters( 'woocommerce_cart_item_thumbnail', $_product->get_image(), $cart_item, $cart_item_key );
				$product_price = apply_filters( 'woocommerce_cart_item_price', WC()->cart->get_product_price( $_product ), $cart_item, $cart_item_key );
				$product_permalink = apply_filters( 'woocommerce_cart_item_permalink', $_product->is_visible() ? $_product->get_permalink( $cart_item ) : '', $cart_item, $cart_item_key );
				?>
                <li class="woocommerce-mini-cart-item <?php echo esc_attr( apply_filters( 'woocommerce_mini_cart_item_class', 'mini_cart_item', $cart_item, $cart_item_key ) ); ?>">
					<?php if ( empty( $product_permalink ) ) : ?>
						<?php echo $thumbnail . '<span class="product-name">' . $product_name . '</span>'; // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?>
					<?php else : ?>
                        <a href="<?php echo esc_url( $product_permalink ); ?>">
							<?php echo $thumbnail . '<span class="product-name">' . $product_name . '</span>'; // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?>
                        </a>
					<?php endif; ?>
                    <div class="cart-detailes">
						<?php echo apply_filters( 'woocommerce_widget_cart_item_quantity', '<span class="fees">' . __("quantity and price:","digix") .' </span><span class="quantity">' . sprintf( '%s &times; %s', $cart_item['quantity'], $product_price ) . '</span>', $cart_item, $cart_item_key ); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?>
						<?php
						echo apply_filters( // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
							'woocommerce_cart_item_remove_link',
							sprintf(
								'<a href="%s" data-toggle="tooltip" data-placement="top" title="%s" class="remove remove-item" aria-label="%s" data-product_id="%s" data-cart_item_key="%s" data-product_sku="%s"><i class="icon-trash"></i></a>',
								esc_url( wc_get_cart_remove_url( $cart_item_key ) ),
								esc_attr__( 'Remove this item', 'woocommerce' ),
								esc_attr__( 'Remove this item', 'woocommerce' ),
								esc_attr( $product_id ),
								esc_attr( $cart_item_key ),
								esc_attr( $_product->get_sku() )
							),
							$cart_item_key
						);
						?>
                    </div>
                </li>
				<?php
			}
		}

		do_action( 'woocommerce_mini_cart_contents' );
		?>
    </ul>

    <div class="mini-cart-footer text-center">
        <p class="woocommerce-mini-cart__total total">
			<?php
			/**
			 * Hook: woocommerce_widget_shopping_cart_total.
			 *
			 * @hooked woocommerce_widget_shopping_cart_subtotal - 10
			 */
			do_action( 'woocommerce_widget_shopping_cart_total' );
			?>
        </p>

		<?php do_action( 'woocommerce_widget_shopping_cart_before_buttons' ); ?>

        <p class="woocommerce-mini-cart__buttons buttons"><?php do_action( 'woocommerce_widget_shopping_cart_buttons' ); ?></p>

		<?php do_action( 'woocommerce_widget_shopping_cart_after_buttons' ); ?>
    </div>
<?php else : ?>

    <section class="cart-empty">
		<div class="empty-icon">
			<svg  viewBox="0 0 36 36" xmlns="http://www.w3.org/2000/svg"><path d="m31.833 8.377c0 6.917 3.583 11.667 3.583 15s-1.916 10.333-17.249 10.333-17.584-9.417-17.584-13.083c0-17.167 31.25-24.5 31.25-12.25z" fill="#efefef"/><g fill="#a4afc1"><path d="m28.467 1.967h1v2h-1z" transform="matrix(.707 -.707 .707 .707 6.386 21.352)"/><path d="m32.533 6.033h1v2h-1z" transform="matrix(.707 -.707 .707 .707 4.702 25.418)"/><path d="m31.856 2.467h2v1h-2z" transform="matrix(.707 -.707 .707 .707 7.525 24.102)"/></g><path d="m20.75 9.75h4.5c.48 0 .89.34.98.8l3 14.5c.01.07.02.13.02.2 0 .55-.45 1-1 1h-4.5z" class="emptypath" fill="#2fdf84"/><path d="m25.25 25.25c0 .55-.45 1-1 1h-16.5c-.55 0-1-.45-1-1 0-.07.01-.13.02-.2l3-14.5c.09-.46.5-.8.98-.8h10.5c.48 0 .89.34.98.8l3 14.5c.01.07.02.13.02.2z" fill="#f3f3f1"/><path d="m9 25.25c0-.07.01-.13.02-.2l3-14.5c.09-.46.5-.8.98-.8h-2.25c-.48 0-.89.34-.98.8l-3 14.5c-.01.07-.02.13-.02.2 0 .55.45 1 1 1h2.25c-.55 0-1-.45-1-1z" fill="#d5dbe1"/><path class="emptypath" d="m22.25 9.75 3 16.5h2l-3-16.5z" fill="#00b871"/><path d="m24.25 27h-16.5c-.965 0-1.75-.785-1.75-1.75 0-.102.011-.191.025-.292l3.01-14.56c.158-.807.88-1.398 1.715-1.398h10.5c.835 0 1.557.591 1.716 1.406l2.998 14.492c.025.161.036.25.036.352 0 .965-.785 1.75-1.75 1.75zm-13.5-16.5c-.118 0-.222.083-.244.193l-3.002 14.509c-.004.184.11.298.246.298h16.5c.136 0 .25-.114.25-.25h.75-.75c0-.026-.006-.048-.009-.074l-2.995-14.475c-.023-.119-.128-.202-.246-.202h-10.5z"/><path d="m28.25 27h-4.5v-1.5h4.5c.136 0 .25-.114.25-.25l-3.004-14.548c-.023-.119-.128-.202-.246-.202h-4.5v-1.5h4.5c.835 0 1.557.591 1.716 1.406l2.998 14.492c.025.161.036.25.036.352 0 .965-.785 1.75-1.75 1.75z"/><path d="m16 18c-2.206 0-4-1.794-4-4v-2.25h1.5v2.25c0 1.378 1.122 2.5 2.5 2.5s2.5-1.122 2.5-2.5v-2.25h1.5v2.25c0 2.206-1.794 4-4 4z"/></svg>
		</div>
		<div class="empty-title"><?php echo __('Your shopping cart is empty!','digix'); ?></div>
		<div class="empty-description"><?php echo __('You can go to the following pages to view more products:','digix'); ?></div>
		<div class="empty-btn">
			<a href="<?php echo get_permalink( wc_get_page_id( 'shop' ) ); ?>" class="empty-btn"><?php echo __('Shop','digix'); ?></a>
			
			|
			
			<a href="<?php echo esc_url( home_url() ); ?>" class="empty-btn"><?php echo __('Home','digix'); ?></a>	
		</div>
	</section>

<?php endif; ?>

<?php do_action( 'woocommerce_after_mini_cart' ); ?>
