<?php
/**
 * My Account navigation
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/myaccount/navigation.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce/Templates
 * @version 2.6.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

do_action( 'woocommerce_before_account_navigation' );
global $current_user;
_wp_get_current_user();
?>

<nav class="woocommerce-MyAccount-navigation">
	<div class="panel-user">
        <header>
            <b><?php echo $current_user->display_name;?></b>
            <small><?php echo __('WellCome','digix'); ?></small>
            <a href="javascript:;" class="user-dropdown" ><i class="icon-menu1"></i></a>
            <div class="user-dropdown-menu list-unstyled">
                <li><a href="<?php echo wc_get_account_endpoint_url( 'edit-account' ); ?>"><?php echo __('edit profile','digix'); ?></a></li>
                <li><a href="<?php echo wc_get_account_endpoint_url( 'customer-logout' ); ?>"><?php echo __('Exit','digix'); ?></a></li>
            </div>
        </header>
        <div class="avatar-box"><?php echo get_avatar($current_user->ID, '100' , '','', array('class' => 'panel-user-img'));?></div>
        <div class="row">
            <div class="col-6">
                <small><b><?php echo __('Your Membership','digix');?></b></small>
                <small class="user-date"><?php $user = wp_get_current_user();$udata = get_userdata( $user->ID );$registered = $udata->user_registered;date_default_timezone_set("Asia/Tehran");
						$now = time()-3600;
						$in = strtotime($registered)+12600;echo '<span>' . human_time_diff($in, $now). ' ' . __('ago','digix') . '</span>'; ?></small>
            </div>
            <div class="col-6">
                <small><b><?php echo __('today','digix'); ?></b></small>
                <small class="user-date"><?php echo dx_jdate( 'Y/m/d', current_time( 'timestamp', 1 ) );?></small>
            </div>
        </div>
        <a href="<?php echo wc_get_account_endpoint_url( 'customer-logout' ); ?>" class="exit"><i class="icon-offline"></i><small><?php echo __('Exit','digix'); ?></small> </a>
    </div>
	<ul class="Myaccount-navigation">
		<?php foreach ( wc_get_account_menu_items() as $endpoint => $label ) : ?>
			<li class="<?php echo wc_get_account_menu_item_classes( $endpoint ); ?>">
				<a href="<?php echo esc_url( wc_get_account_endpoint_url( $endpoint ) ); ?>"><?php echo esc_html( $label ); ?></a>
			</li>
		<?php endforeach; ?>
	</ul>
</nav>

<?php do_action( 'woocommerce_after_account_navigation' ); ?>
