<?php

/**
 * Display single product reviews (comments)
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/single-product-reviews.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 4.3.0
 */

defined('ABSPATH') || exit;

global $product;

if (!comments_open()) {
	return;
}

$meta = get_post_meta( get_the_ID(), 'digix_metabox', true );
if (is_array($meta)):
$label_1 = $meta['range1']['name'];
$label_2 = $meta['range2']['name'];
$label_3 = $meta['range3']['name'];
$label_4 = $meta['range4']['name'];
$label_5 = $meta['range5']['name'];
endif;
	
?>

<section class="digix-wc-review">
	<header class="review-header">
		<div class="user-rate">
			<span class="rate-title">
				<?php echo __('rate users to ','digix') . esc_html( get_the_title() ) . ': ';?>
			</span>
			<span class="average-rate">
				<span><?php echo (!empty($product->get_average_rating())) ? $product->get_average_rating() : '0'; ?></span><?php echo __('of the total ','digix'); ?><span><?php echo (!empty($product->get_rating_counts())) ? $product->get_rating_counts()[5] : '0'; ?></span><?php echo __('comment','digix'); ?>
			</span>
		</div>
		<div class="product-review-detailes">
			<div class="rate-list">
				<?php if(!empty($meta['range1']['name'])): ?>
				<div class="rate-item">
					<b><?php echo $label_1; ?></b>
					<div class="rate-content">
						<div class="rate-result" style="width:<?php echo $meta['range1']['slider']; ?>%"></div>
					</div>
				</div>
				<?php endif; ?>
				<?php if(!empty($meta['range2']['name'])): ?>
				<div class="rate-item">
					<b><?php echo $label_2; ?></b>
					<div class="rate-content">
						<div class="rate-result" style="width:<?php echo $meta['range2']['slider']; ?>%"></div>
					</div>
				</div>
				<?php endif; ?>
				<?php if(!empty($meta['range3']['name'])): ?>
				<div class="rate-item">
					<b><?php echo $label_3; ?></b>
					<div class="rate-content">
						<div class="rate-result" style="width:<?php echo $meta['range3']['slider']; ?>%"></div>
					</div>
				</div>
				<?php endif; ?>
				<?php if(!empty($meta['range4']['name'])): ?>
				<div class="rate-item">
					<b><?php echo $label_4; ?></b>
					<div class="rate-content">
						<div class="rate-result" style="width:<?php echo $meta['range4']['slider']; ?>%"></div>
					</div>
				</div>
				<?php endif; ?>
				<?php if(!empty($meta['range5']['name'])): ?>
				<div class="rate-item">
					<b><?php echo $label_5; ?></b>
					<div class="rate-content">
						<div class="rate-result" style="width:<?php echo $meta['range5']['slider']; ?>%"></div>
					</div>
				</div>
				<?php endif; ?>
			</div>
			<div class="submit-review">
				<b><?php echo __('Give your comment about this product','digix'); ?></b>
				<div class="submit-desc">
					<?php echo __('To post a comment, you must first log in to your account. If you have already bought this product from this store, your opinion will be registered as the owner of the product.','digix'); ?>
						<!-- برای ثبت نظر، لازم است ابتدا وارد حساب کاربری خود شوید. اگر این محصول را قبلا از این فروشگاه خریده باشید، نظر شما به عنوان مالک محصول ثبت خواهد شد. -->
				</div>
				<?php
				if (!is_user_logged_in()) {
				?>
					<!-- <div class="submit-login">
						<?php printf(__('To post a comment, you must first <a href="%s">log in to your account</a>','digix'), wc_get_page_permalink('myaccount'));?>
					</div> -->
				<?php
				} else {
				?>
					<div class="add-review-uri">
						<a data-target="#review-box" href="#review-box"><?php echo __('add new comment','digix');?></a>
					</div>
				<?php
				}
				?>
			</div>
		</div>
	</header>
	<div class="review-result">
		<?php
		if (have_comments()) {
		?>
			<ul class="review-list">
				<?php
					wp_list_comments(apply_filters('woocommerce_product_review_list_args', array('callback' => 'woocommerce_comments')));
				?>
			</ul>
		<?php
		} else {
		?>
			<div class="review-first">
				<p><?php echo __('No comments found!','digix');?></p>
				<?php printf(__("<p>Be the first to comment on the<b> %s</b></p>","digix"), get_the_title());?>
			</div>
		<?php
		}
		?>

	</div>
	<?php
	if (is_user_logged_in()) {
	?>
		<div class="review-entry" id="review-box">
			<div class="review-box">

				<?php
				$commenter    = wp_get_current_commenter();
				$comment_form = array(
					'title_reply'         => '',
					'title_reply_to'      => '',
					'title_reply_before'  => '',
					'title_reply_after'   => '',
					'comment_notes_after' => '',
					'label_submit'        => esc_html__('Submit', 'woocommerce'),
					'logged_in_as'        => '',
					'comment_field'       => '<section class="comment-form-comment"><label for="comment">' . esc_html__( 'Your review', 'woocommerce' ) . '&nbsp;</label><textarea id="comment" name="comment" cols="30" rows="10"></textarea></section>',
					'comment_notes_before' => '',
				);
				
				$name_email_required = (bool) get_option('require_name_email', 1);
				$fields              = array();

				$comment_form['fields'] = array();

				foreach ($fields as $key => $field) {
					$field_html  = '<div class="col-6"><div class="vitrin-product-comments-area-field">';
					$field_html .= '<label for="' . esc_attr($key) . '">' . esc_html($field['label']);

					if ($field['required']) {
						$field_html .= '&nbsp;<span class="required">*</span>';
					}

					$field_html .= '</label><input id="' . esc_attr($key) . '" name="' . esc_attr($key) . '" type="' . esc_attr($field['type']) . '" value="' . esc_attr($field['value']) . '" ' . ($field['required'] ? 'required' : '') . ' /></div></div>';

					$comment_form['fields'][$key] = $field_html;
				}

				$comment_form['fields']['cookies'] = '';
				?>

					<div class="review-wrapper">
						<?php
						comment_form(apply_filters('woocommerce_product_review_comment_form_args', $comment_form));
						?>
					</div>
			</div>
		</div>
	<?php
	} else {
	?>
		<section class="review-first-login">
			<?php printf(__("<p>To post a comment, you must first log in to your account</p><a href='%s'>Login to account</a>","digix"),wc_get_page_permalink('myaccount') );?>
		</section>
	<?php
	}
	?>

</section>