<?php

/**
 * Review Comments Template
 *
 * Closing li is left out on purpose!.
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/single-product/review.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 2.6.0
 */

if (!defined('ABSPATH')) {
	exit; // Exit if accessed directly
}
global $comment;
$verified = wc_review_is_from_verified_owner( $comment->comment_ID );
$timestamp2 = get_comment_date('U');
?>
<li <?php comment_class(); ?> id="li-comment-<?php comment_ID(); ?>">

	<?php
	$comment_idd = get_comment_ID();
	$content = get_comment_text($comment_idd);
	$title = get_comment_meta($comment_idd, 'title', true);
	$recommendstatus = get_comment_meta($comment_idd, 'recommendstatus', true);
	$alist = get_comment_meta($comment_idd, 'alist', true);
	$dlist = get_comment_meta($comment_idd, 'dlist', true);
	$range1 = get_comment_meta($comment_idd, 'range1', true);
	$range2 = get_comment_meta($comment_idd, 'range2', true);
	$range3 = get_comment_meta($comment_idd, 'range3', true);
	$range4 = get_comment_meta($comment_idd, 'range4', true);
	$range5 = get_comment_meta($comment_idd, 'range5', true);
	?>
	<header class="comment-header">
		<div class="comment-author">
			<div class="author">
				<?php
				/**
				 * The woocommerce_review_before hook
				 *
				 * @hooked woocommerce_review_display_gravatar - 10
				 */
				do_action( 'woocommerce_review_before', $comment );
				?>
				<strong><?php echo get_comment_author(get_comment_ID()); ?></strong>
				<?php
					if ( 'yes' === get_option( 'woocommerce_review_rating_verification_label' ) && $verified ) {
						echo '<em class="woocommerce-review__verified verified">(' . esc_attr__( 'verified owner', 'woocommerce' ) . ')</em> ';
					}

				?>
			</div>
			<div class="comment-recommendation">
				<?php if ($recommendstatus == '1') :?>
					<div class="true"><i class="icon-check-mark"></i><?php echo __('I recommend buying this product','digix'); ?></div>
				<?php elseif($recommendstatus == '0'):?>
					<div class="false"><i class="icon-letter-x"></i><?php echo __('I do not recommend buying this product','digix'); ?></div>
				<?php elseif($recommendstatus == '2'):?>
					<div class="none"><i class="icon-warning-sign"></i><?php echo __('I have no idea about buying this product','digix'); ?></div>
				<?php endif;?>
			</div>
		</div>
		<div class="comment-rating">
			<?php
			global $comment;
			$rating = intval( get_comment_meta( $comment->comment_ID, 'rating', true ) );
			
			if ( $rating && wc_review_ratings_enabled() ) {
				echo wc_get_rating_html( $rating ); // WPCS: XSS ok.
			}
			?>
		</div>
	</header>
	<div class="comment-content" id="comment-comntent">
		<div class="content">
			<?php 
				if($title):
					echo '<b>' . $title . '</b>';
				endif;
				do_action( 'woocommerce_review_before_comment_text', $comment );

				/**
				 * The woocommerce_review_comment_text hook
				 *
				 * @hooked woocommerce_review_display_comment_text - 10
				 */
				do_action( 'woocommerce_review_comment_text', $comment );

				do_action( 'woocommerce_review_after_comment_text', $comment );
			?>
		</div>
		<div class="points">
			<?php
				$g_array = explode(",", $alist);
				$b_array = explode(",", $dlist);
				if ($g_array[0] != '' || $b_array[0] != '') {
				?>
					<?php
					if ($g_array[0] != '') {

						echo '<section class="gpoints"><div class="gpoints-header"><i class="icon-check-mark"></i>' . __('Good Points','digix'). '</div>';
						foreach ($g_array as $g_item) {
					?>
							<li><?php echo $g_item; ?></li>
						<?php
						}
						echo'</section>';
					}
					if ($b_array[0] != '') {
						echo '<section class="bpoints"><div class="bpoints-header"><i class="icon-letter-x"></i>' . __('Bad Points','digix'). '</div>';
						foreach ($b_array as $b_item) {
						?>
							<li><?php echo $b_item; ?></li>
					<?php
						}
						echo'</section>';
					}
					?>
				<?php
				}
			?>
		</div>
		<div class="slider">
			<?php
			$meta = get_post_meta( get_the_ID(), 'digix_metabox', true );
			if (is_array($meta)):
				$label_1 = $meta['range1']['name'];
				$label_2 = $meta['range2']['name'];
				$label_3 = $meta['range3']['name'];
				$label_4 = $meta['range4']['name'];
				$label_5 = $meta['range5']['name'];
			endif;
			?>
			<div class="rate-list">
				<?php if(!empty($meta['range1']['name'])): ?>
				<div class="rate-item select-slide">
					<span><?php echo $label_1; ?></span>
					<div class="rate-content">
						<div class="rate-result" style="width:<?php echo $range1; ?>%"></div>
					</div>
				</div>
				<?php endif; ?>
				<?php if(!empty($meta['range2']['name'])): ?>
				<div class="rate-item select-slide">
					<span><?php echo $label_2; ?></span>
					<div class="rate-content">
						<div class="rate-result" style="width:<?php echo $range2; ?>%"></div>
					</div>
				</div>
				<?php endif; ?>
				<?php if(!empty($meta['range3']['name'])): ?>
				<div class="rate-item select-slide">
					<span><?php echo $label_3; ?></span>
					<div class="rate-content">
						<div class="rate-result" style="width:<?php echo $range3; ?>%"></div>
					</div>
				</div>
				<?php endif; ?>
				<?php if(!empty($meta['range4']['name'])): ?>
				<div class="rate-item select-slide">
					<span><?php echo $label_4; ?></span>
					<div class="rate-content">
						<div class="rate-result" style="width:<?php echo $range4; ?>%"></div>
					</div>
				</div>
				<?php endif; ?>
				<?php if(!empty($meta['range5']['name'])): ?>
				<div class="rate-item select-slide">
					<span><?php echo $label_5; ?></span>
					<div class="rate-content">
						<div class="rate-result" style="width:<?php echo $range5; ?>%"></div>
					</div>
				</div>
				<?php endif; ?>
			</div>
		</div>
	</div>
	<div class="comment-meta">
		<div class="comment-date">
			<?php printf(__('<i class="icon-calendar"></i>Posted On: %s','digix'), dx_jdate('Y/m/d', $timestamp2)); ?>
		</div>
		<div class="comment-likedislike">
			<p><?php echo __('Was this comment useful to you?','digix');?></p>
			<?php comments_like_dislike($comment_idd); ?>
		</div>
	</div>
	