<?php
/**
 * Single Product title
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/single-product/title.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 4.4.0
 */
Global $product;
Global $post;
Global $options;
$meta = get_post_meta( get_the_ID(), 'digix_metabox', true );
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}
if ( !empty( $options['woocommerce-brand-single'] ) ) {
	if ( $options['woocommerce-brand-single'] == true ) {
	$terms       = get_the_terms( $post->ID, 'product_brand' );
	$brand_count = is_array( $terms ) ? sizeof( $terms ) : 0;

	$taxonomy    = get_taxonomy( 'product_brand' );
	$labels      = $taxonomy->labels;
	}
}
if ( class_exists( 'WeDevs_Dokan' ) ){
    $author     = get_user_by( 'id', $post->post_author );
    $store_info = dokan_get_store_info( $author->ID );
}
?>
<figure class="im-single-product-title">
    <h1 class="product_title entry-title">
        <strong>
            <?php echo esc_html( get_the_title() ); ?>
        </strong>
    </h1>
    <?php if( !empty($meta['subtitle']) ): ?>
        <span>
            <?php echo $meta['subtitle']; ?>
        </span>
    <?php endif; ?>
</figure>
<figure class="im-product-stock">
	<?php
		if ( !empty( $options['woocommerce-brand-single'] ) ) {
			if ( $options['woocommerce-brand-single'] == true ) { 
				if( !empty( get_the_terms( get_the_ID(), $options['woocommerce-brand-taxonomy'] ) ) ) {?>
				<div class="product-brand">
					<?php echo get_brands( $post->ID, ', ', ' <span class="posted_in">' . sprintf( _n( '%1$s: ', '%2$s: ', $brand_count ), $labels->singular_name, $labels->name ), '</span>' ); ?>
				</div>
	<?php
				}
			}
		}
	?>
    <div class="im-product-status">
        <span><?php echo __( "Status: ", "digix" ); ?></span>
        <?php if ( ! $product->is_in_stock() ) {echo '<span class="out-stock">' . __( "Out Of Stock", "digix" ) . '</span>';}else{echo '<span class="in-stock">' . __( "in Stock", "digix" ) . '</span>';} ?>
    </div>
    <?php if ( class_exists( 'WeDevs_Dokan' ) ){ ?>
        <div class="seller-select">
            <span><?php echo __( ' Seller: ', 'digix' ); ?></span> 
            <?php printf( '<a href="%s">%s</a>', esc_url( dokan_get_store_url( $author->ID ) ), esc_html( $store_info['store_name'] ) ); ?>
        </div>
    <?php } ?>
</figure>
