<section class="digix-seller">
    <div class="seller-list">
        <?php if ( $sellers['users'] ) : ?>
                <?php
                foreach ( $sellers['users'] as $seller ) {
                    $vendor                   = dokan()->vendor->get( $seller->ID );
                    $store_banner_id          = $vendor->get_banner_id();
                    $store_name               = $vendor->get_shop_name();
                    $store_url                = $vendor->get_shop_url();
                    $store_rating             = $vendor->get_rating();
                    $is_store_featured        = $vendor->is_featured();
                    $store_phone              = $vendor->get_phone();
                    $store_info               = dokan_get_store_info( $seller->ID );
                    $store_address            = dokan_get_seller_short_address( $seller->ID );
                    $store_banner_url         = $store_banner_id ? wp_get_attachment_image_src( $store_banner_id, $image_size ) : DOKAN_PLUGIN_ASSEST . '/images/default-store-banner.png';
                    $show_store_open_close    = dokan_get_option( 'store_open_close', 'dokan_appearance', 'on' );
                    $dokan_store_time_enabled = isset( $store_info['dokan_store_time_enabled'] ) ? $store_info['dokan_store_time_enabled'] : '';
                    $store_open_is_on         = ( 'on' === $show_store_open_close && 'yes' === $dokan_store_time_enabled && ! $is_store_featured ) ? 'store_open_is_on' : '';
                    ?>

                    <article class="single-seller <?php echo ( ! $store_banner_id ) ? 'no-banner-img' : ''; ?>">
                        <div class="seller-avatar">
                            <a href="<?php echo esc_url( $store_url ); ?>">
                                <img src="<?php echo esc_url( $vendor->get_avatar() ); ?>"
                                    alt="<?php echo esc_attr( $vendor->get_shop_name() ); ?>"
                                    size="150">
                            </a>
                        </div>
                        <figure class="store-header">
                            <div class="store-banner">
                                <a href="<?php echo esc_url( $store_url ); ?>">
                                    <img src="<?php echo is_array( $store_banner_url ) ? esc_attr( $store_banner_url[0] ) : esc_attr( $store_banner_url ); ?>">
                                </a>
                            </div>
                        </figure>

                        <div class="seller-content">
                            <h2><a href="<?php echo esc_attr( $store_url ); ?>"><?php echo esc_html( $store_name ); ?></a> <?php apply_filters( 'dokan_store_list_loop_after_store_name', $vendor ); ?></h2>
                            <?php if ( ! empty( $store_rating['count'] ) ) : ?>
                                <div class="dokan-seller-rating"
                                    title="
                                    <?php
                                        echo sprintf(
                                            // translators: 1) seller rating
                                            esc_attr__( 'Rated %s out of 5', 'dokan-lite' ), number_format_i18n( $store_rating['rating'] )
                                        );
                                    ?>
                                    ">
                                    <?php echo wp_kses_post( dokan_generate_ratings( $store_rating['rating'], 5 ) ); ?>
                                    
                                </div>
                            <?php endif ?>
                        </div>
                    </article>

                <?php } ?>
                <div class="dokan-clearfix"></div>

            <?php
            $user_count   = $sellers['count'];
            $num_of_pages = ceil( $user_count / $limit );

            if ( $num_of_pages > 1 ) {
                echo '<div class="pagination-container clearfix">';

                $pagination_args = [
                    'current'   => $paged,
                    'total'     => $num_of_pages,
                    'base'      => $pagination_base,
                    'type'      => 'array',
                    'prev_text' => __( '&larr; Previous', 'dokan-lite' ),
                    'next_text' => __( 'Next &rarr;', 'dokan-lite' ),
                ];

                if ( ! empty( $search_query ) ) {
                    $pagination_args['add_args'] = [
                        'dokan_seller_search' => $search_query,
                    ];
                }

                $page_links = paginate_links( $pagination_args );

                if ( $page_links ) {
                    $pagination_links = '<div class="pagination-wrap">';
                    $pagination_links .= '<ul class="pagination"><li>';
                    $pagination_links .= join( "</li>\n\t<li>", $page_links );
                    $pagination_links .= "</li>\n</ul>\n";
                    $pagination_links .= '</div>';

                    echo wp_kses_post( $pagination_links );
                }

                echo '</div>';
            }
            ?>

        <?php else : ?>
            <p class="dokan-error"><?php esc_html_e( 'No vendor found!', 'dokan-lite' ); ?></p>
        <?php endif; ?>
    </div>
</section>
