<?php
class digix_elementor_gamingproduct extends \Elementor\Widget_Base {


	public function get_name() {
		return 'product-gaming';
	}

	public function get_title() {
		return __('Gaming Product Element - one','digix');
	}

	public function get_icon() {
		return 'eicon-product-stock';
	}

	public function get_categories() {
		return [ 'digix' ];
	}

	protected function _register_controls() {
		$this->start_controls_section(
			'configuration',
			[
				'label' => __('Configuration','digix'),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,

			]
		);
		$this->add_control(
			'data_active',
			[
				'label' 		=> __('showing detailes box','digix'),
				'type' 			=> \Elementor\Controls_Manager::SWITCHER,
				'label_on'     	=> __('active','digix'),
				'label_off'    	=> __('inactive','digix'),
				'return_value' 	=> 'yes',
				'default' 		=> 'no',
			]
		);
		$img = DIGIX_URI . '/static/img/Gamebg.jpg';
		$this->add_control(
			'data_backgroundimage',
			[
				'label' => __( 'detailes box background image', 'digix' ),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'default' => 
					[
						'url' => $img,
					],
				'condition' 	=> 
					[
					'data_active' => 'yes',
					],
			]
        );
		$options = array();
		$args = array(
		'hide_empty' => false,
		);
		$categories =  $categories = get_categories(array('taxonomy'=> 'product_cat'));
		foreach ( $categories as $key => $category ) {$options[$category->term_id] = $category->name;}
		$procat = array();
		$categories = get_terms("product_cat");
		if ( !empty( $categories ) && !is_wp_error( $categories ) ){
			foreach ( $categories as $category ) {
				$procat[ $category->term_id ] = $category->name;
			}
		}
		$protag = array();
		$tags = get_terms("product_tag");
		if ( !empty( $tags ) && !is_wp_error( $tags ) ){
			foreach ( $tags as $tag ) {
				$protag[ $tag->term_id ] = $tag->name;
			}
		}
		$prodbrand = array();
		global $options;
		$taxonomy = $options['woocommerce-brand-taxonomy'];
		$brands = get_terms($taxonomy);
		if ( !empty( $brands ) && !is_wp_error( $brands ) ){
			foreach ( $brands as $brand ) {
				$probrand[ $brand->term_id ] = $brand->name;
			}
		}
		$this->add_control(
			'sort',
			[
				'label' => __( 'Sort products', 'digix' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'default' => 'latest',
				'options' => [
					'latest'  			=> __( 'latest products', 'digix' ),
					'random' 			=> __( 'random products', 'digix' ),
					'viewed' 			=> __( 'most visited products', 'digix' ),
					'saled' 			=> __('best selling products', 'digix'),
					'price-desc'  		=> __( 'price from descending', 'digix' ),
					'price-asc'  		=> __( 'price from ascending', 'digix' ),
					'discounted' 		=> __( 'discounted products', 'digix' ),
					'rand_discounted' 	=> __( 'Random Discounted Products', 'digix' ),
					'menu_order' 		=> __( 'according to title', 'digix' ),
				],
			]
		);
		$this->add_control(
			'instock',
			[
				'label' 		=> __('instock products','digix'),
				'type' 			=> \Elementor\Controls_Manager::SWITCHER,
				'label_on'     	=> __('active','digix'),
				'label_off'    	=> __('inactive','digix'),
				'return_value' 	=> 'yes',
				'default' 		=> 'no',
			]
		);
		$this->add_control(
			'product_filter',
			[
				'label' => __( 'Product filter', 'digix' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'default' => 'category',
				'options' => [
					'category' 	 	=> __( 'Products category', 'digix' ),
					'tag' 			=> __( 'Products tag', 'digix' ),
					'brand' 		=> __( 'Products brand', 'digix' ),
					'proid' 		=> __( 'Manual selection of products', 'digix' ),
				],
			]
		);
		$this->add_control(
			'product_cat',
			[
				'label' 		=> __( 'product category', 'digix' ),
				'description' 	=> __( 'Empty labels (no products) are not displayed', 'digix' ),
				'type' 			=> \Elementor\Controls_Manager::SELECT2,
				'multiple' 		=> true,
				'options' 		=> $procat,
				'condition' 	=> 
					[
						'product_filter' => 'category',
					],
			]
		);
		$this->add_control(
			'product_tag',
			[
				'label' 		=> __( 'product tag', 'digix' ),
				'description' 	=> __( 'Empty labels (no products) are not displayed', 'digix' ),
				'label_block' 	=> true,
				'type' 			=> \Elementor\Controls_Manager::TEXT,
				'placeholder' 	=> __( 'Tag(s) ID', 'digix' ),
				'condition' 	=> 
					[
						'product_filter' => 'tag',
					],
			]
		);
		$this->add_control(
			'product_brand',
			[
				'label' 		=> __( 'product brand', 'digix' ),
				'description' 	=> __('Filter and product display by brand', 'digix'),
				'type' 			=> \Elementor\Controls_Manager::SELECT2,
				'multiple' 		=> true,
				'options' 		=> $probrand,
				'condition' 	=> 
					[
					'product_filter' => 'brand',
					],
			]
		);
		$this->add_control(
			'product_id',
			[
				'label' 		=> __( 'product id', 'digix' ),
				'description' 	=> __('Separate product IDs with English commas.','digix'),
				'label_block' 	=> true,
				'type' 			=> \Elementor\Controls_Manager::TEXT,
				'condition' 	=> 
					[
					'product_filter' => 'proid',
					],
			]
		);
		$this->add_control(
			'posts_per_page',
			[
				'label' 		=> __('number of products','digix'),
				'type' 			=> \Elementor\Controls_Manager::NUMBER,
				'min' 			=> 1,
				'max' 			=> 200,
				'step' 			=> 1,
				'default' 		=> 8,
			]
		);



		$this->end_controls_section();

		$this->start_controls_section(
		 'style',
		 [
			 'label' 			=> __( 'Style', 'digix' ),
			 'tab' 				=> \Elementor\Controls_Manager::TAB_CONTENT,
		 ]
		);
        $this->add_control(
			'border_radius',
			[
				'label' 		=> __( 'Product item border radius', 'digix' ),
				'type' 			=> \Elementor\Controls_Manager::TEXT,
				'default' 		=> '15px',
				'selectors' 	=> 
					[
						'{{WRAPPER}} .gaming-product .product-item' => 'border-radius: {{VALUE}} !important',
						'{{WRAPPER}} .gaming-product .product-item .product-thumbnails a img' => 'border-radius: {{VALUE}} !important',
					],
			]
        );
		$this->add_control(
			'product_title_color',
			[
				'label' 		=> __( 'product item title color', 'digix' ),
				'type' 			=> \Elementor\Controls_Manager::COLOR,
				'default' 		=> '#000',
				'selectors'		=> 
					[
						'{{WRAPPER}} .gaming-product .product-item .product-detailes h2 a' => 'color: {{VALUE}} !important',
					],
			]
        );
		$this->add_control(
			'product_title_size',
			[
				'label' 		=> __( 'product item title size', 'digix' ),
				'type' 			=> \Elementor\Controls_Manager::TEXT,
				'default' 		=> '13px',
				'selectors'		=> 
					[
						'{{WRAPPER}} .gaming-product .product-item .product-detailes h2 a' => 'font-size: {{VALUE}} !important',
					],
			]
        );
		$this->add_control(
			'price_color',
			[
				'label' 		=> __( 'Price color', 'digix' ),
				'type' 			=> \Elementor\Controls_Manager::COLOR,
				'default' 		=> '#000',
				'selectors'		=> 
					[
						'{{WRAPPER}} .gaming-product .product-item .product-detailes .product-add .product-price>span' => 'color: {{VALUE}} !important',
						'{{WRAPPER}} .gaming-product .product-item .product-detailes .product-add .product-price ins' => 'color: {{VALUE}} !important',
					],
			]
        );
		$this->add_control(
			'discount_color',
			[
				'label' 		=> __( 'Product Discount color', 'digix' ),
				'type' 			=> \Elementor\Controls_Manager::COLOR,
				'default' 		=> '#fff',
				'selectors'		=> 
					[
						'{{WRAPPER}} .gaming-product .product-item .product-detailes .discount' => 'color: {{VALUE}} !important',
					],
			]
        );
		$this->add_control(
			'discount_bgcolor',
			[
				'label' 		=> __( 'Product Discount background color', 'digix' ),
				'type' 			=> \Elementor\Controls_Manager::COLOR,
				'default' 		=> '#f00',
				'selectors'		=> 
					[
						'{{WRAPPER}} .gaming-product .product-item .product-detailes .discount' => 'background-color: {{VALUE}} !important',
						'{{WRAPPER}} .gaming-product .product-item .product-detailes .discount' => 'border-color: {{VALUE}} !important',
					],
			]
        );
		$this->add_control(
			'more_bgcolor',
			[
				'label' 		=> __( 'more button background color', 'digix' ),
				'type' 			=> \Elementor\Controls_Manager::COLOR,
				'default' 		=> '#fff212',
				'selectors'		=> 
					[
						'{{WRAPPER}} .gaming-product .product-item .product-detailes .product-add a.product-url' => 'background-color: {{VALUE}}',
					],
			]
        );
		$this->add_control(
			'more_color',
			[
				'label' 		=> __( 'more button color', 'digix' ),
				'type' 			=> \Elementor\Controls_Manager::COLOR,
				'default' 		=> '#000',
				'selectors'		=> 
					[
						'{{WRAPPER}} .gaming-product .product-item .product-detailes .product-add a.product-url' => 'color: {{VALUE}} !important',
						'{{WRAPPER}} .gaming-product .product-item .product-detailes .product-add a.product-url svg' => 'fill: {{VALUE}} !important',
					],
			]
        );
		$this->end_controls_section();

	}

	protected function render() {
		$settings 			= $this->get_settings_for_display();
		$sort 				= $settings['sort'];
		$product_filter 	= $settings['product_filter'];
		$product_cat 		= $settings['product_cat'];
		$product_tag 		= $settings['product_tag'];
		$product_brand 		= $settings['product_brand'];
		$data_background	= $settings['data_backgroundimage'];
		$data_active 		= $settings['data_active'];
		Global $options;



	 $view_all_link = '';
		switch ($sort) {
			case 'latest':
				$arms = array(
				'posts_per_page' => $settings['posts_per_page'],
				'post_type' => 'product',
				'post_status' => 'publish',
				'order' => 'DESC'  );
				break;
			case 'menu_order':
				$arms = array(
				'posts_per_page' => $settings['posts_per_page'],
				'post_type' => 'product',
				'post_status' => 'publish',
				'orderby' => 'menu_order title',
				'order' => 'ASC'  );
				break;
			case 'saled':
				$arms = array(
				'posts_per_page' => $settings['posts_per_page'],
				'post_type' => 'product',
				'post_status' => 'publish',
				'meta_key' => 'total_sales',
				 'orderby' => 'meta_value_num',
				 'order' => 'DESC'  );
				break;
			case 'discounted':
				$arms = array(
					'posts_per_page'    => $settings['posts_per_page'],
					'post_status'       => 'publish',
					'order' => 'DESC',
					'post_type'         => 'product',
					'post__in'          => array_merge( array( 0 ), wc_get_product_ids_on_sale() )
				);
				break;
			case 'rand_discounted':
				$arms = array(
					'posts_per_page'    => $settings['posts_per_page'],
					'post_status'       => 'publish',
					'orderby'        	=> 'rand',
					'post_type'         => 'product',
					'post__in'          => array_merge( array( 0 ), wc_get_product_ids_on_sale() )
				);
				break;
			case 'viewed':
				$arms = array(
				'posts_per_page' => $settings['posts_per_page'],
				'post_type' => 'product',
				'post_status' => 'publish',
				'order'            => 'DESC',
			'suppress_filters' => false,  //required param
			'orderby'          => 'post_views',  //required param
				);
				break;
			case 'price-desc':
				$arms = array(
				'posts_per_page' => $settings['posts_per_page'],
				'post_type' => 'product',
				'post_status' => 'publish',
				'orderby'        => 'meta_value_num',
				'meta_key'       => '_price',
				'order'          => 'DESC');
				break;
			case 'price-asc':
				$arms = array(
				'posts_per_page' => $settings['posts_per_page'],
				'post_type' => 'product',
				'post_status' => 'publish',
				'orderby'        => 'meta_value_num',
				'meta_key'       => '_price',
				'order'          => 'ASC');
				break;
			case 'random':
				$arms = array(
				'posts_per_page' => $settings['posts_per_page'],
				'post_type' => 'product',
				'post_status' => 'publish',
				'orderby'        => 'rand'  );
				break;
			default:
			$arms = array(
				'posts_per_page' => $settings['posts_per_page'],
				'post_type' => 'product',
				'post_status' => 'publish',
				'meta_key' => 'onsales_round',
				'meta_value' => 'yes',
			 );
			}
			if ( $product_filter ) {
				if ( $product_filter == 'category' && !empty($product_cat) ) {
					$arms['tax_query'] = array(
						array(
						'taxonomy' => 'product_cat',
						'field' => 'term_id',
						'terms' => $product_cat
						)
					);
					$view_all_link = digix_term_links( 'product_cat', $product_cat );
				} elseif ( $product_filter == 'tag' && !empty($product_tag) ) {
					$arms['tax_query'] = array(
						array(
						'taxonomy' => 'product_tag',
						'field' => 'term_id',
						'terms' => $product_tag
						)
					);
					$view_all_link = digix_term_links( 'product_tag', $product_tag );
				} elseif ( $product_filter == 'brand' && !empty($product_brand) ) {
					$arms['tax_query'] = array(
						array(
						'taxonomy' => $options['woocommerce-brand-taxonomy'],
						'field' => 'term_id',
						'terms' => $product_brand
						)
					);
					$view_all_link = digix_term_links( $options['woocommerce-brand-taxonomy'] , $product_brand );
				}elseif ( $product_filter == 'proid' && !empty($product_id) ) {
					$arms['tax_query'] = array(
						array(
						'post__in' => array( $product_id),
						)
					);
				}
			}

		if('yes' === $settings['instock'] ){
			$arms['meta_query'] = array(
					'relation' => 'AND',
					array(
						'key' => '_stock_status',
						'value' => 'instock'
					),
				);
		}

		$arms[] = array(
			'fields'                    => 'ids',
			'no_found_rows'             => true,
			'update_post_term_cache'    => false
		);

		if(isset($_COOKIE['digixproductlocation']) && !empty(($_COOKIE['digixproductlocation']))){
			$product_city=explode(',', $_COOKIE['digixproductlocation']);
			if (!empty($product_city) && $product_city !== 0) {
				if (is_array($arms["tax_query"])) {
					$arms["tax_query"][] = ["taxonomy" => "product_city", "field" => "id", "terms" => $product_city];
				} else {
					$arms["tax_query"] = ["relation" => "AND", ["taxonomy" => "product_city", "field" => "id", "terms" => $product_city]];
				}
			}
		}
    $products = new WP_Query( $arms );
	global $product;
	global $options;?>
<?php if ( $products ->have_posts() ) :?>
<section class="gaming-product digix-product">
<div class="mobile-product">
				<?php if ( $data_active == 'yes' ): ?>
						<div class="DataBox">
							<div class="content">
								<h5><?php echo $title;?></h5>
								<div class="image">
									<p>
										<strong>
											<span style="color: rgb(255, 190, 0);">
												<img src="<?php echo $data_background['url']; ?>" alt="" width="150" height="150">
											</span>
										</strong>
									</p>
								</div>
							</div>
							<?php if( !empty( $url ) ){ ?>
								<a class="url" target="_blank" href="<?php echo $url; ?>" style="cursor: pointer; text-decoration: none;">
									<button class="button btn" tabindex="0" type="button">
										<span class="text">نمایش همه</span>
										<svg width="20" height="20" id="chevronLeft" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24"><path d="M11.414 12l4.293 4.293-1.414 1.414-5-5a1 1 0 010-1.414l5-5 1.414 1.414L11.414 12z"></path></svg>
										<span class="guard"></span>
									</button>
								</a>
							<?php } ?>
						</div>
				<?php endif; ?>
							
			<?php while ( $products ->have_posts() ) : $products ->the_post();
				global $woocommerce , $product;
				$price = get_post_meta( get_the_ID(), '_regular_price', true);
				$sale = get_post_meta( get_the_ID(), '_sale_price', true);
				$meta = get_post_meta( get_the_ID(), 'digix_metabox', true );
			?>

				<div class="product-item">
					<figure class="product-thumbnails">
						<a href="<?php echo $product->get_permalink(); ?>">
							<?php echo( has_post_thumbnail() ? get_the_post_thumbnail( get_the_id(), '', array( 'class' => 'img-fluid' ) ) : wc_placeholder_img( 'woocommerce_thumbnail' ) ); ?>
						</a>
					</figure>
					<div class="product-detailes">
						<h2>
							<a href="<?php echo $product->get_permalink(); ?>"><?php echo $product->get_title(); ?></a>
						</h2>
						<?php if($product->is_on_sale()){ ?>
							<div class="discount">
								<?php echo digix_wooocmmerce_discount(get_the_ID()) ?>٪ <span>تخفیف</span> 
							</div>
						<?php } ?>
						<div class="product-add">
							<div class="product-price <?php if($product->is_on_sale()){ ?> sale <?php }else{ ?>notsale<?php } ?>">
								<?php 
									if ( ! $product->is_in_stock() ) :
										echo'<span class="OutOfStock">' . __( "ناموجود", "digix" ) . '</span>';
									else: 
										echo $product->get_price_html(); 
									endif;
								?>
							</div>
							<?php if ( $product->is_in_stock() ) : ?>
								<a class="product-url" data-toggle="tooltip" data-original-title="<?php echo esc_html( $product->add_to_cart_text() );?>" href="<?php echo $product->get_permalink(); ?>">
									<svg width="24" height="24" x="0" y="0" viewBox="-20 50 680 680"  xmlns="http://www.w3.org/2000/svg"><path d="M430 226q-10 0-17.5 6.5T405 251q0 44-30.5 74T300 355q-43 0-73.5-30T196 251q0-12-6-18.5t-16-6.5q-9 0-16.5 6.5T150 251q0 31 11 58 13 28 33.5 48.5T242 390q27 11 58 11 32 0 59-11 27-12 47.5-32.5T439 309q12-27 12-58 3-12-4.5-18.5T430 226zm163 18q-4-32-18-60t-36.5-49Q516 114 488 101q-29-12-61-13-31-2-63-4-31-1-62-1t-62 1q-32 2-63 4-32 1-61 13-28 13-50.5 33.5T29 183q-14 27-18 58-4 35-7 70-2 34-2 69t2 71q3 35 7 71 6 34 19 60 14 27 34.5 46.5T113 659q28 12 64 16 31 2 62.5 4t64.5 2q30 0 61-2l62-4q32-1 61-13 29-13 52-34t37-49q16-28 19-60 3-34 5-68 2-35 1.5-69.5T600 312q-3-34-7-68zm-47 271q-1 25-12 45-11 21-27.5 36.5T468 621q-22 8-48 8-30 3-59 4-30 1-60.5 1t-60.5-1q-29-1-59-4-56-7-86.5-34T54 512q-5-33-7-67-2-33-2-66.5t2-66.5q2-34 7-68 2-24 13-45 11-20 27-35.5t37-23.5q22-9 46-9 31-3 60.5-4.5T297 125q30 0 60.5 1.5T420 131q25 0 46 9 22 8 38.5 23.5T531 201q10 21 12 47 6 33 9 67 3 33 3.5 66.5T553 448q-2 34-7 67z"/></svg>
									<span>
										خرید
									</span>
	
								</a>
							<?php endif; ?>
						</div>
					</div>
				</div>
			
			<?php endwhile; ?>
			<?php wp_reset_postdata(); ?>
	</div>
</section>
<?php endif;?>
<?php

	}

	protected function _content_template() {}

}
