<?php

class digix_elementor_product_search extends \Elementor\Widget_Base {

	public function get_name() {
		return 'search-element';
	}

	public function get_title() {
		return __( 'Ajax search box', 'digix' );
	}

  public function get_icon() {
    return 'eicon-search';
  }

  public function get_categories() {
    return [ 'digix' ];
  }

  protected function _register_controls() {

		$this->start_controls_section(
			'configuration',
			[
				'label' => __( 'Configuration', 'digix' ),
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$repeater = new \Elementor\Repeater();
		$repeater->add_control(
			'key', [
				'label'     => __( 'Keywords', 'digix' ),
				'type'      => \Elementor\Controls_Manager::TEXT,
			]
		);
		$this->add_control(
			'title', [
				'label'     => __( 'Searc box title', 'digix' ),
				'type'      => \Elementor\Controls_Manager::TEXT,
				'default'   => 'نام محصول مورد علاقه خود را جستجو کنید...' ,
			]
		);
		
		
		$this->add_control(
			'Keywords',
			[
				'label' => __( 'Keywords', 'digix' ),
				'type' => \Elementor\Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
				'default' => [
					[
						'key' => 'گوشی',
					],
				],
				'title_field' => '{{{ key }}}',
			]
		);
		$this->add_control(
			'image',
			[
				'label' => __( 'image', 'digix' ),
				'type' => \Elementor\Controls_Manager::MEDIA,
			]
		);

		$this->add_control(
			'url', [
				'label' => __( 'url', 'digix' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __( '#' , 'digix' ),
			]
		);
		$this->end_controls_section();

		$this->start_controls_section(
		 'style',
			[
				'label' 			=> __( 'Style', 'digix' ),
				'tab' 				=> \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'position',
			[
				'type' => \Elementor\Controls_Manager::CHOOSE,
				'label' => __( 'Search button Position', 'digix' ),
				'default' => 'right',
				'options' => [
					'right' => [
						'title' => __( 'right', 'digix' ),
						'icon'  => 'eicon-caret-right',
					],
					'left' => [
						'title' => __( 'left', 'digix' ),
						'icon'  => ' eicon-caret-left',
					],
				],
				'toggle' => false,
			]
		);
		$this->add_control(
			'button_color',
			[
				'label' 		=> __( 'Search button color', 'digix' ),
				'type' 			=> \Elementor\Controls_Manager::COLOR,
				'default' 		=> '#5f5f5f',
				'selectors'		=> 
					[
						'{{WRAPPER}} .search-element .search-form button svg' => 'fill: {{VALUE}} !important',
					],
			]
        );
		$this->add_control(
			'button_bgcolor',
			[
				'label' 		=> __( 'Search button background color', 'digix' ),
				'type' 			=> \Elementor\Controls_Manager::COLOR,
				'default' 		=> '#cfcfcf',
				'selectors'		=> 
					[
						'{{WRAPPER}} .search-element .search-form button' => 'background-color: {{VALUE}} !important',
					],
			]
        );
		$this->add_control(
			'field_bgcolor',
			[
				'label' 		=> __( 'Search field background color', 'digix' ),
				'type' 			=> \Elementor\Controls_Manager::COLOR,
				'default' 		=> '#f5f5f5',
				'selectors'		=> 
					[
						'{{WRAPPER}} .search-element .search-form input' => 'background-color: {{VALUE}} !important',
					],
			]
        );
		$this->add_control(
			'field_color',
			[
				'label' 		=> __( 'Search field color', 'digix' ),
				'type' 			=> \Elementor\Controls_Manager::COLOR,
				'default' 		=> '#5f5f5f',
				'selectors'		=> 
					[
						'{{WRAPPER}} .search-element .search-form input' => 'color: {{VALUE}} !important',
					],
			]
        );
		$this->add_control(
			'border_radius',
			[
				'label' 		=> __( 'Search field border radius', 'digix' ),
				'type' 			=> \Elementor\Controls_Manager::TEXT,
				'default' 		=> '8px',
				'selectors' 	=> 
					[
						'{{WRAPPER}} .search-element .search-form input' => 'border-radius: {{VALUE}} !important',
					],
			]
        );
		$this->add_control(
			'border_width',
			[
				'label' 		=> __( 'Search field border width', 'digix' ),
				'type' 			=> \Elementor\Controls_Manager::TEXT,
				'default' 		=> '1px',
				'selectors' 	=> 
					[
						'{{WRAPPER}} .search-element .search-form input' => 'border-width: {{VALUE}} !important',
					],
			]
        );
		$this->add_control(
			'border_color',
			[
				'label' 		=> __( 'Search field border color', 'digix' ),
				'type' 			=> \Elementor\Controls_Manager::COLOR,
				'default' 		=> '#f5f5f5',
				'selectors'		=> 
					[
						'{{WRAPPER}} .search-element .search-form input' => 'border-color: {{VALUE}} !important',
					],
			]
        );
		$this->add_control(
			'padding_top',
			[
				'label' 		=> __( 'Search field border padding top', 'digix' ),
				'type' 			=> \Elementor\Controls_Manager::COLOR,
				'default' 		=> '0px',
				'selectors'		=> 
					[
						'{{WRAPPER}} .search-element .search-form input' => 'padding-top: {{VALUE}} !important',
					],
			]
        );
		$this->add_control(
			'padding_bottom',
			[
				'label' 		=> __( 'Search field border padding bottom', 'digix' ),
				'type' 			=> \Elementor\Controls_Manager::COLOR,
				'default' 		=> '0px',
				'selectors'		=> 
					[
						'{{WRAPPER}} .search-element .search-form input' => 'padding-bottom: {{VALUE}} !important',
					],
			]
        );
		$this->add_control(
			'accordion_space',
			[
				'label' 		=> __( 'Search result box space', 'digix' ),
				'type' 			=> \Elementor\Controls_Manager::TEXT,
				'default' 		=> '100%',
				'selectors'		=> 
					[
						'{{WRAPPER}} .search-element.active .search-inbox' => 'top: {{VALUE}} !important',
					],
			]
        );
		$this->end_controls_section();
	}


	protected function render() {
		Global $options;
		$settings 	= $this->get_settings_for_display();
		$title 		= $settings['title'];
		$position 	= $settings['position'];
		$Keywords 	= $settings['Keywords'];
		$image 		= $settings['image'];
		$url 		= $settings['url'];

?>
<section class="search-element search digix-search">
	<form class="search-form" role="search" autocomplete="off" action="<?php echo esc_url( get_permalink( wc_get_page_id( 'shop' ) ) );?>" method="get">
		<button class="btn" type="submit" <?php if($position =='left'){echo'style="right:auto;left:5px;"';}?>>
			<svg width="24" height="24" id="searchSearch" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24"><path fill-rule="evenodd" d="M10.5 18a7.5 7.5 0 115.973-2.963l4.369 4.246-1.394 1.434-4.387-4.263A7.467 7.467 0 0110.5 18zm5.5-7.5a5.5 5.5 0 11-11 0 5.5 5.5 0 0111 0z" clip-rule="evenodd"></path></svg>
		</button>
		<input type="search" id="digix-ajaxsearch" name="s" <?php if($position =='left'){echo'style="padding-right:6px;padding-left:45px;"';}?> class="search-input" value="" placeholder="<?php echo $title; ?>" data-charaters="3" data-functiontype="both">
		<input type="hidden" name="post_type" value="product">
	</form>
</section>
  <?php 
	}
}
