<?php

class digix_elementor_seen extends \Elementor\Widget_Base 
{

	public function get_name() 
    {
		return 'seen-element';
	}

	public function get_title() 
    {
		return __('seen element','digix');
	}

	public function get_icon() 
    {
		return 'eicon-product-stock';
	}

	public function get_categories() 
    {
		return [ 'digix' ];
	}

	protected function _register_controls() 
    {

		$this->start_controls_section(
			'content_section',
			[
				'label' => __('product element','digix'),
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'title',
			[
				'label'       => __('title','digix'),
				'type'        => \Elementor\Controls_Manager::TEXT,
				'input_type'  => 'text',
				'placeholder' => '',
			]
		);

		$this->end_controls_section();
	}

	protected function render()
    {

		$settings = $this->get_settings_for_display();

		$title          = $settings['title'];
		
      $viewed_products = ! empty( $_COOKIE['woocommerce_recently_viewed'] ) ? (array) explode( '|', wp_unslash( $_COOKIE['woocommerce_recently_viewed'] ) ) : array(); // @codingStandardsIgnoreLine
      $viewed_products = array_reverse( array_filter( array_map( 'absint', $viewed_products ) ) );
      $query_args = array(
       'posts_per_page' => 4,
       'no_found_rows'  => 1,
       'post_status'    => 'publish',
       'post_type'      => 'product',
       'post__in'       => $viewed_products,
       'orderby'        => 'post__in',
      );

       $query_args['tax_query'] = array(
         array(
           'taxonomy' => 'product_visibility',
           'field'    => 'name',
           'terms'    => 'outofstock',
           'operator' => 'NOT IN',
         ),
       ); // WPCS: slow query ok.

      $loop = new WP_Query( $query_args );
      if ( $loop->have_posts() ) : ?>
			<section class="digix-recently-seen">
                <?php if( $title ) : ?>
                    <header class="recently-header">
                        <h3>
                            <?php echo $title; ?>
                        </h3>
                    </header>
                <?php endif; ?>
                <ul class="recently-list">
                <?php
                    while ( $loop->have_posts() ) : $loop->the_post() ?>
                        <li>
                            <a href="<?php echo get_the_permalink(); ?>">
                                <figure><?php echo get_the_post_thumbnail(get_the_ID(), 'thumbnail', array( 'class' => 'center img-fluid' ) ); ?></figure>
                                <p><?php echo the_title(); ?></p>
                            </a>
                        </li>
                    <?php endwhile; ?><?php wp_reset_postdata(); ?>
                </ul>
            </section>

     <?php
        endif;	
	}
}