<?php

class digix_elementor_story extends \Elementor\Widget_Base {

	public function get_name() {
		return 'timeline-story';
	}

	public function get_title() {
		return __( 'timeline story', 'digix' );
	}

  public function get_icon() {
    return 'eicon-gallery-grid';
  }

  public function get_categories() {
    return [ 'digix' ];
  }

  protected function _register_controls() {

		$this->start_controls_section(
			'content_section',
			[
				'label' => __('استوری','digix'),
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		$repeater = new \Elementor\Repeater();

		$repeater->add_control(
			'story_title', [
				'label'     => __( 'عنوان استوری', 'digix' ),
				'type'      => \Elementor\Controls_Manager::TEXT,
				'default'   => __( 'لوازم تحریر' , 'digix' ),
			]
		);

		$repeater->add_control(
			'story_img',
			[
				'label' => __( 'تصویر کوچک پیشنمایش استوری', 'digix' ),
				'type' => \Elementor\Controls_Manager::MEDIA,
			]
		);
		
		$repeater->add_control(
			'story_time',
			[
				'label' => __( 'مدت زمان هر استوری', 'digix' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'second' ],
				'range' => [
					'second' => [
						'min' => 0,
						'max' => 60,
						'step'=> 1,
					],					
				],
				'default' => [
					'unit' => 'second',
					'size' => 5,
				],
				'selectors' => [
					'{{WRAPPER}}' => 'transform: rotate({{SIZE}}{{UNIT}});',
				],
			]
		);
		$repeater->add_control(
			'type',
			[
				'type' => \Elementor\Controls_Manager::CHOOSE,
				'label' => esc_html__( 'Type', 'digix' ),
				'default' => 'image',
				'options' => [
					'image' => [
						'title' => esc_html__( 'Image', 'digix' ),
						'icon' => 'eicon-image-bold',
					],
					'video' => [
						'title' => esc_html__( 'Video', 'digix' ),
						'icon' => 'eicon-video-camera',
					],
				],
				'toggle' => false,
			]
		);
		$repeater->add_control(
			'story_gallery',
			[
				'label' => esc_html__( 'تصویر استوری', 'digix' ),
				'type' => \Elementor\Controls_Manager::GALLERY,
				'show_label' => false,
				'dynamic' => [
					'active' => true,
				],
				'condition' => [
					'type' => 'image',
				],
			]
		);
		$repeater->add_control(
			'videoimage',
			[
				'label' => esc_html__( 'video preview image', 'digix' ),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'dynamic' => [
					'active' => true,
				],
				'condition' => [
					'type' => 'video',
				],
				
			]
		);
		$repeater->add_control(
			'video',
			[
				'label' => esc_html__( 'Video Link', 'digix' ),
				'type' =>  \Elementor\Controls_Manager::URL,
				'dynamic' => [
					'active' => true,
				],
				'placeholder' => esc_html__( 'Enter your video link', 'digix' ),
				'options' => false,
				'condition' => [
					'type' => 'video',
				],
			]
		);
		$repeater->add_control(
			'story_url', [
				'label' => __( 'لینک مقصد استوری', 'digix' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => '',
			]
		);
		
		$repeater->add_control(
			'story_text', [
				'label' => __( 'متن دکمه برای لینک های استوری', 'digix' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __( 'مشاهده' , 'digix' ),
			]
		);
		
		$this->add_control(
			'loop',
			[
				'label' => __( 'استوری ها', 'digix' ),
				'type' => \Elementor\Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
				'default' => [
					[
						'story_title' => __( 'digital', 'digix' ),
					],
				],
				'title_field' => '{{{ story_title }}}',
			]
		);

		$this->end_controls_section();
	}


	protected function render() {
	$settings = $this->get_settings_for_display();
	$loop = $settings['loop'];
	$type = $settings['type'];
	$video = $settings['video'];
	$videoimage = $settings['videoimage'];
    //$title = $settings['title'];

?>

  	<section class="digix-Story">
		<div id="stories" class="storiesWrapper"></div>
		<script src="<?php echo DIGIX_URI . '/static/js/zuck.js';?>"></script>
		<script>
	var timestamp = function() {
  var timeIndex = 0;
  var shifts = [35, 60, 60 * 3, 60 * 60 * 2, 60 * 60 * 25, 60 * 60 * 24 * 4, 60 * 60 * 24 * 10];

  var now = new Date();
  var shift = shifts[timeIndex++] || 0;
  var date = new Date(now - shift * 1000);

  return date.getTime() / 1000;
};

var changeSkin = function(skin) {
  location.href = location.href.split('#')[0].split('?')[0] + '?skin=' + skin;
};

var getCurrentSkin = function() {
  var header = document.getElementById('header');
  var skin = location.href.split('skin=')[1];

  if (!skin) {
    skin = 'Snapgram';
  }

  if (skin.indexOf('#') !== -1) {
    skin = skin.split('#')[0];
  }

  var skins = {
    Snapgram: {
      avatars: true,
      list: false,
      autoFullScreen: false,
      cubeEffect: true,
      paginationArrows: false
    },

    VemDeZAP: {
      avatars: false,
      list: true,
      autoFullScreen: false,
      cubeEffect: false,
      paginationArrows: true
    },

    FaceSnap: {
      avatars: true,
      list: false,
      autoFullScreen: true,
      cubeEffect: false,
      paginationArrows: true
    },

    Snapssenger: {
      avatars: false,
      list: false,
      autoFullScreen: false,
      cubeEffect: false,
      paginationArrows: false
    }
  };

  var el = document.querySelectorAll('#skin option');
  var total = el.length;
  for (var i = 0; i < total; i++) {
    var what = skin == el[i].value ? true : false;

    if (what) {
      el[i].setAttribute('selected', 'selected');

      header.innerHTML = skin;
      header.className = skin;
    } else {
      el[i].removeAttribute('selected');
    }
  }

  return {
    name: skin, 
    params: skins[skin] 
  };
};
      var currentSkin = getCurrentSkin();
      var stories = window.Zuck(document.querySelector('#stories'), {
        backNative: true,
        previousTap: true,
		rtl: true,
        skin: currentSkin['name'],
        autoFullScreen: currentSkin['params']['autoFullScreen'],
        avatars: currentSkin['params']['avatars'],
        paginationArrows: currentSkin['params']['paginationArrows'],
        list: currentSkin['params']['list'],
        cubeEffect: currentSkin['params']['cubeEffect'],
        localStorage: true,
		stories: [
			<?php foreach ($loop as $item): ?>
				Zuck.buildTimelineItem(
					'<?php echo $item['_id'];?>',
					'<?php echo $item['story_img']['url'];?>',
					'<?php echo $item['story_title'];?>',
					'#',
					timestamp(),
					[
						<?php if ( $item['type'] == 'image' ){ ?>
							<?php foreach ($item['story_gallery'] as $gallery): ?>
								[
									'<?php echo $item['_id'] . "-" . $gallery['id'];?>',
									'photo',
									<?php echo $item['story_time']['size'];?>,
									'<?php echo $gallery['url'];?>',
									'<?php echo $gallery['url'];?>',
									'<?php echo $item['story_url'];?>',
									'<?php echo $item['story_text'];?>',
									false,
									timestamp()
								],
							<?php endforeach; ?>
						<?php }elseif ( $item['type'] == 'video' ){ ?>
							[
								'<?php echo $item['_id'] . "-" . rand();?>',
								'video',
								0,
								'<?php echo $item['video']['url'];?>',
								'<?php echo $item['videoimage']; ?>',
								'<?php echo $item['story_url'];?>',
								'<?php echo $item['story_text'];?>',
								false,
								timestamp()
							],
						<?php } ?>
					  
					]
				),
			<?php endforeach; ?>
        ]
      });
    </script>
  	</section>
  <?php 
	}
}
