<?php

// Digix class_alias
if ( ! class_exists( 'Digix_mobile' ) ) {
	class Digix_mobile{
		public function __construct() {
			 Global $options;
			 add_action( 'wp_enqueue_scripts', array( $this, 'digix_frontend_enqueue' ),999 );
			 if ( $options['woocommerce-checkout-map'] == 'yes' ){
				add_action( 'wp_footer', array( $this, 'digix_checkout_enqueue' ),99);	
			 }
			 remove_action( 'woocommerce_cart_collaterals', 'woocommerce_cross_sell_display' );
			 add_filter('woocommerce_show_variation_price', function() { return TRUE;});
			 remove_Action('woocommerce_single_variation','woocommerce_single_variation',10);
			 add_action( 'digix_short_description', 'woocommerce_template_single_excerpt');		 
			 add_action( 'digix_woocommerce_single_variation', 'woocommerce_single_variation');		 
			 add_action( 'wp_footer', array( $this, 'digix_toolbar' ),1);		 
			 add_action( 'wp_enqueue_scripts', array( $this, 'script_cleaner' ), 100 );
			 add_filter( 'comment_post_redirect', array( $this, 'redirect_after_comment'), 10, 2 );
			 add_action( 'wp_ajax_woocommerce_ajax_add_to_cart', array( $this, 'woocommerce_ajax_add_to_cart'));
			 add_action( 'wp_ajax_nopriv_woocommerce_ajax_add_to_cart', array( $this, 'woocommerce_ajax_add_to_cart'));
			 add_filter( 'woocommerce_product_tabs', array( $this, 'digix_remove_tab'), 11 );
			 add_action( 'woocommerce_product_options_general_product_data', array( $this, 'custom_field' ) );
			 add_action( 'woocommerce_process_product_meta', array( $this, 'save_custom_field' ) );
			 add_action( 'woocommerce_product_after_variable_attributes', array( $this, 'variation_custom_field' ), 10, 3 );
			 add_action( 'woocommerce_save_product_variation', array( $this, 'save_variation_custom_field' ), 10, 2 );
			 add_action( 'digix_wc_single_action',array( $this, 'digix_wc_single_action_pricechart'), 10 );
			 add_action( 'digix_wc_single_action',array( $this, 'digix_wc_single_action_share'), 30 );
			 add_action( 'wp_footer',array( $this, 'digix_wc_single_share_modal'), 30 );
			 add_action( 'digix_wc_single_action',array( $this, 'digix_wc_single_action_video'), 40 );
			 add_action( 'wp_footer',array( $this, 'digix_wc_single_video_modal'), 40 );
			 add_filter( 'comment_form_defaults', array( $this, 'render_digix_anonymous_users'), 10, 1);
			 add_action( 'comment_form_top', array( $this, 'render_digix_authorized_users'));
			 add_action( 'comment_post', array( $this, 'save_digix_comment_custom_fields'), 10, 3);
			 add_action( 'add_meta_boxes_comment', array( $this, 'digix_comment_add_meta_box'), 10, 1);
			 add_filter( 'woocommerce_breadcrumb_defaults',  array( $this, 'digix_woocommerce_breadcrumbs'));
			 add_action( 'woocommerce_before_main_content',array( $this, 'digix_woocommerce_child_category'),50);
			 add_filter( 'woocommerce_sale_flash', array( $this, 'digix_percentage_sale'), 10, 3 );
			 add_filter( 'woocommerce_variable_sale_price_html', array( $this, 'digix_woocommerce_variable_price'), 10, 2 );
			 add_filter( 'woocommerce_variable_price_html', array( $this, 'digix_woocommerce_variable_price'), 10, 2 );
			 add_action( 'wp_footer', array( $this, 'digix_wc_archive_ordering' ),2);
			 add_action( 'wp_footer', array( $this, 'digix_wc_archive_filtering' ),3);
			 add_action( 'init',array( $this, 'digix_woocommerce_myaccount'));
			 add_action( 'woocommerce_edit_account_form', array( $this, 'add_billing_phone_to_edit_account_form') ); // After existing fields
			 add_action( 'woocommerce_save_account_details_errors',array( $this, 'billing_phone_field_validation'), 20, 1 );
			 add_action( 'woocommerce_save_account_details', array( $this, 'my_account_saving_billing_phone'), 20, 1 );
			 add_filter( 'woocommerce_account_menu_items', array( $this, 'comment_account_menu'), 5, 1);
			 add_action( 'init', array( $this, 'add_comment_endpoint'));
			 add_action( 'woocommerce_account_comment_endpoint', array( $this, 'comment_endpoint_content'));
			 add_filter( 'woocommerce_account_menu_items', array( $this, 'tracking_account_menu'), 1, 2);
			 add_action( 'init', array( $this, 'add_tracking_endpoint'));
			 add_action( 'woocommerce_account_tracking_endpoint', array( $this, 'tracking_endpoint_content'));
			 add_filter( 'woocommerce_account_menu_items', array( $this, 'iranwp_account_menu_favorites'), 10, 1 );
			 add_action( 'init', array( $this, 'iranwp_add_favorites_endpoint') );
			 add_action( 'woocommerce_account_favorites_endpoint', array( $this, 'iranwp_favorites_endpoint_content') );
			 add_action( 'wp_footer',array( $this, 'digix_myaccount_order_chart'));
			 if ( $options['woocommerce-checkout-map'] == 'yes' ){
			 add_action( 'woocommerce_after_checkout_billing_form', array( $this, 'digix_location_selector_field'),10 );
			 add_action( 'woocommerce_checkout_process', array( $this, 'digix_location_selector_field_validate') );
			 add_action( 'woocommerce_checkout_update_order_meta', array( $this, 'digix_location_selector_field_save') );
			 add_action( 'woocommerce_thankyou', array( $this, 'digix_location_selector_field_thankyou' ));
			 add_action( 'woocommerce_admin_order_data_after_billing_address', array( $this, 'digix_location_selector_field_order') );
			 add_action( 'woocommerce_email_after_order_table', array( $this, 'digix_location_selector_field_emails'), 20, 4 );
			 }
			 add_action( 'after_setup_theme', array( $this, 'digix_mobile_walker') );
			 add_action( 'wp_footer', array( $this, 'digix_categories_modal' ),4);
			 add_filter( 'woocommerce_add_to_cart_fragments', array( $this, 'digix_count_fragments'), 10, 1 );
			 add_filter( 'woocommerce_get_catalog_ordering_args', array( $this, 'wcs_get_catalog_ordering_args') );
			 add_filter( 'woocommerce_default_catalog_orderby_options', array( $this, 'wcs_catalog_orderby') );
			 add_filter( 'woocommerce_catalog_orderby', array( $this, 'wcs_catalog_orderby' ));
			 if ( $options['woocommerce-outstock'] === '1' ) {
				add_filter( 'posts_clauses', array($this,'digix_wc_orderby_status'), 2000 );
			 }
			 if( !empty($_GET['orderby']) ){
				 if( $_GET['orderby'] == 'on_sale' ){
					add_filter( 'body_class', function( $classes ) {return array_merge( $classes, array( 'on-sale' ) );} );
				 }
			 }
			 if( $options['mobile-header'] == 'modern' ){
				add_filter( 'body_class', function( $classes ) {return array_merge( $classes, array( 'body-modern' ) );} );
			 }else{
				add_filter( 'body_class', function( $classes ) {return array_merge( $classes, array( 'body-default' ) );} );
			 }
			 $my_theme = wp_get_theme( 'Digix' );
			 if ( $my_theme->exists() ){
				add_action('admin_notices', array( $this, 'Digix_check'));
			 }
			 add_action('wp_head', array($this,'digix_notification_bar'));
		}
		public function Digix_check(){
				echo '<div class="notice notice-info is-dismissible">
					  <p>لطفا برای نمایش صحیح و صحت کارکرد سایت قالب دیجیکس را فعال نمایید</p>
					 </div>';
		}
		public function digix_frontend_enqueue() {
			Global $options;
			wp_enqueue_style('bootstrapstyle', DIGIX_URI . '/static/css/bootstrap.min.css',array(),'all');
			wp_enqueue_style('DigixFont',DIGIX_URI . '/static/fonts/' . $options['font'] .'/font.css',array(),'all');
			wp_enqueue_style('digix-icon', DIGIX_URI . '/static/css/digix.min.css',array(),'all');
			wp_enqueue_style('main-style', DIGIX_URI . '/static/css/style.min.css',array(),'all');
			wp_enqueue_style('styles', DIGIX_URI . '/style.css',array(),'all');
			
			wp_enqueue_script('popper',DIGIX_URI . '/static/js/popper.min.js', array(),'',true);
			wp_enqueue_script('bootstrap',DIGIX_URI . '/static/js/bootstrap.min.js', array(),'',true);
			if( is_account_page() ):
				wp_enqueue_script('track-order',DIGIX_URI . '/static/js/track.js', array(),'',true);
				wp_localize_script( 'track-order', 'bix', array( 'ajaxurl' 		=> 	admin_url( 'admin-ajax.php' )));
			endif;
			wp_register_script('digixproductlocation',DIGIX_URI.'/static/js/location-picker.js',array(),'',true);
			$localization = 
					array(
						'ajax_url' 		=> admin_url( 'admin-ajax.php' ) ,
						'admin_url' 	=> admin_url(),		
						'all_city' 		=> __("all cities","digix"),		
						'all_in_city' 	=> __("all cities in","digix"),		
						'select_city' 	=> __("Select at least one city","digix"),		
					);
			wp_localize_script('digixproductlocation', 'digixpicker', $localization);		
			wp_enqueue_script('digixproductlocation');
			if( is_account_page() || is_product() ):
				wp_enqueue_script('chart',DIGIX_URI . '/static/js/chart.js');
			endif;
			wp_enqueue_script('zeynep',DIGIX_URI . '/static/js/zeynep.js', array(),'',true);
			wp_register_script('digix' , DIGIX_URI . '/static/js/digix.js', array(),'',true);
			// Localize the script
			$translation = 
			array(
			'pro_search_ajaxurl' 		=> admin_url( 'admin-ajax.php' ) ,
			'admin_url' 				=> admin_url(),
			'dl_nonce'					=> wp_create_nonce( 'cld-ajax-nonce' ),
			'loadmore' 					=> __('load more','digix'),
			'hidebtn' 					=> __('load less','digix'),	
			'resultmore_one' 			=> __('You have searched for ','digix'),
			'resultmore_two' 			=> __(' product ( view more )','digix'),
			'single_ajax'				=> $options['woocommerce-single-ajax'],
			'loadless' 					=>'1',	
			'delay'         			=> (int) '300' ,	
				);
			wp_localize_script('digix', 'DIGIX', $translation);		
			wp_enqueue_script('digix');
        }
		public function digix_checkout_enqueue() {
			global $options;
			if ( $options['woocommerce-checkout-map'] == 'yes' ){
			if( is_checkout() ){?>
				<link rel="stylesheet" href="https://cdn.map.ir/web-sdk/1.4.2/css/mapp.min.css">
				<link rel="stylesheet" href="https://cdn.map.ir/web-sdk/1.4.2/css/fa/style.css">
				<script type="text/javascript" src="https://cdn.map.ir/web-sdk/1.4.2/js/jquery-3.2.1.min.js"></script>
				<script type="text/javascript" src="https://cdn.map.ir/web-sdk/1.4.2/js/mapp.env.js"></script>
				<script type="text/javascript" src="https://cdn.map.ir/web-sdk/1.4.2/js/mapp.min.js"></script>
				<script type="text/javascript" src="<?php echo DIGIX_URI . '/static/js/hack.js';?>"></script>
				<script>
			    jQuery(document).ready(function ($) {
					var apiKey = "<?php echo $options['woocommerce-map-api']; ?>";
					var app = new Mapp({
					element: "#app",
					presets: {
						latlng: {
						lat: 32,
						lng: 52
						},
						zoom: 6
					},
					locale: "fa",
					apiKey
					});

					app.addVectorLayers();

					var start = {};
					var index = 1;
					var curse = 0;
					var history = [];
					var memeTimeout;

					kickOff();
					$(".clear-btn").on("click", function() {

					if (start.marker) app.map.removeLayer(start.marker);

					$(".app-start").remove();

					index = 1;
					curse = 0;
					history = [];

					$("#digix_location").val("");

					kickOff();
					});

					$("#app-submit").on("click", function() {
					if ($("#digix_location").val()) {
						leg("آدرس نهایی بعد از ویرایش: «" + $("#digix_location").val() + "»");
					} else {
						leg("کدوم آدرس آخه؟! شما به من آدرس را نشان بده...");
					}
					});

					app.map.on("click", function() {
					leg("روی نقشه کلیک شد.");
					});

					function kickOff() {
					leg(
						"در این دمو موقعیت کاربر گرفته میشه، و پس از ثبت محل مورد نظر کاربر آدرس محل مشخص شده پیدا، ویرایش، و ثبت میشه."
					);

					start = {
						latlng: undefined,
						marker: undefined,
						icon: {
						iconUrl: "./app/assets/images/marker-default-blue.svg",
						iconSize: [40, 40],
						iconAnchor: [20, 40],
						popupAnchor: [0, -40]
						}
					};

					app.map.fitBounds([[35.532, 51.051], [35.835, 51.632]]);

					leg("در حال تلاش برای پیدا کردن موقعیت فعلی کاربر...");

					userLocationFound = false;
					app.getUserLocation({
						before: function() {
						freeze();
						},
						after: function() {
						unfreeze();
						},
						success: function() {
						userLocationFound = true;
						leg("موقعیت کاربر پیدا شد.");

						app.map.panTo({
							lat: app.states.user.latlng.lat,
							lng: app.states.user.latlng.lng
						});

						leg("نقشه به موقعیت کاربر حرکت داده شد.");

						$("#mapp-app").append('<div class="app-start"></div>');

						leg(
							"می‎توانید نقشه را حرکت داده و برای ثبت محل کاربر روی مارکر کلیک کنید."
						);
						leg("منتظر تصمیم شما...");

						$(".app-start").on("click", function() {
							start.latlng = app.map.getCenter();

							start.marker = app.addMarker({
							name: "start",
							latlng: start.latlng,
							icon: start.icon,
							popup: false,
							pan: false,
							draggable: true,
							history: false
							});

							leg("محل کاربر ثبت شد.");

							$(".app-start").remove();

							leg("برای تغییر محل کاربر می‎توانید مارکر را روی نقشه حرکت دهید.");

							doReverse();

							start.marker.on("dragend", function() {
							leg("محل کاربر تغییر کرد.");

							start.latlng = start.marker.getLatLng();

							doReverse();
							});
						});
						},
						error: function() {
						var centerMarker = $('#center-marker').show();
						centerMarker.on('click', function(){
							start.latlng = app.map.getCenter()
							app.map.panTo(start.latlng);
							doReverse();
						});
						},
						pan: false,
						marker: false
					});
					}

					function leg(text) {
					var printed = text;

					if (text === history[history.length - 1]) {
						printed = "برای بار دوم، " + text;

						if (text === history[history.length - 2]) {
						printed =
							curse < 2
						"دوباره " + text;

						if (curse === 2) meme("parviz");

						if (curse < 2 && text === history[history.length - 3]) {
							printed = "دوباره " + text;

							if (text === history[history.length - 4]) {
							printed = "دوباره " + text;

							if (text === history[history.length - 5]) {
								printed = "دوباره " + text;

								if (text === history[history.length - 6]) {
								curse = 1;
								printed = "دوباره " + text;

								if (text === history[history.length - 7]) {
									printed = "دوباره " + text;

									if (text === history[history.length - 8]) {
									printed = "دوباره " + text;

									if (text === history[history.length - 9]) {
										printed = "دوباره " + text;

										if (text === history[history.length - 10]) {
										printed = "دوباره " + text;

										return;
										}
									}
									}
								}
								}
							}
							}
						}
						}
					}

					if (
						curse === 1 &&
						history[history.length - 1] !== undefined &&
						text !== history[history.length - 1]
					) {
						history = [];
						curse = 2;
						index = 1;
						printed = "برگردیم سر نقشه. " + text;
					}

					history.push(text);

					var i = index;

					setTimeout(function() {
						$("#li-" + i).removeClass("highlighted");
					}, 2000);

					index += 1;
					}

					function doReverse() {
					if (start.latlng) {
						leg("در حال پیدا کردن آدرس...");

						var result = app.findReverseGeocode({
						before: function() {
							freeze();
						},
						after: function(data) {
							unfreeze();

							leg("آدرس پیدا شد.");

							$("#digix_location").val(data.address_compact);

							leg("می‎توانید آدرس را ویرایش کنید یا محل کاربر را تغییر دهید.");
						},
						state: {
							latlng: start.latlng
						}
						});
					}
					}


					function meme(image) {
					if (memeTimeout) clearTimeout(memeTimeout);

					$(".app-meme").addClass("app-visible");
					$(".app-meme").css({
						backgroundImage: "var(--meme-" + image + ")"
					});

					memeTimeout = setTimeout(function() {
						$(".app-meme").removeClass("app-visible");
					}, 1000);
					}

					function unfreeze() {
					$(".app-overlay").removeClass("app-visible");
					$("#digix_location").prop("disabled", false);
					$("button").prop("disabled", false);
					$("input").prop("disabled", false);
					}

					function freeze() {
					$(".app-overlay").addClass("app-visible");
					$("#digix_location").prop("disabled", true);
					$("button").prop("disabled", true);
					$("input").prop("disabled", true);
					}
				});

		</script>
		<?php
			}
			}
		}
		public function digix_toolbar(){ 
			Global $options;
			if( ! is_product() && ! is_single() && ! is_cart() && ! is_checkout() ): ?>
			<?php if( $options['mobile-header'] == 'modern' ):?>
			<section class="main-toolbar">
				<div class="modern-toolbar">
					<ul class="list">
						<li class="toolbar-item">
							<a href="<?php echo esc_url( home_url() ); ?>">
								<i class="icon-house"></i>
								<div><?php echo __('Home','digix'); ?></div>
							</a>
						</li>
						<li class="toolbar-item">
							<a href="<?= home_url( "?s=&post_type=product" ); ?>" class="tab-link">
								<i class="icon-search"></i>
								<div><?php echo __('Search','digix'); ?></div>
							</a>
						</li>
						<li class="toolbar-item">
							<button type="submit" class="procat-modal-btn" id="slide-down-btn">
								<i class="icon-menu1"></i>
								<div><?php echo __('Category','digix'); ?></div>
							</button>
						</li>
						<li class="toolbar-item">
							<a href="<?php if(class_exists( 'WC_Product' )){echo get_permalink( wc_get_page_id( 'cart' ) );}else{echo'#';} ?>">
								<i class="icon-cart"></i>
								<div><?php echo __('Cart','digix'); ?></div>
							</a>
						</li>
						<li class="toolbar-item">
							<?php if ( is_user_logged_in() ) : ?>
								<a href="<?php if(class_exists( 'WC_Product' )){ echo get_permalink( get_option('woocommerce_myaccount_page_id') );}else{echo'#';} ?>">
									<i class="icon-user"></i>
									<div><?php echo __('Myaccount','digix'); ?></div>
								</a>
							<?php else: ?>
								<?php if( $options['woocommerce-digits'] == '1' ) { ?>
									<?php if ( $options['woocommerce-digits-type'] == 'popup' ) { ?>
										<button style="background:0;border:0;outline:0;font-size:14px;font-weight:400;box-shadow: none;" href="?login=true" onclick="jQuery('this').digits_login_modal(jQuery(this));return false;" attr-disclick="1" class="digix-digit-btn btn digits-login-modal" type="1">
											<i class="icon-user"></i>
											<div><?php echo __('Myaccount','digix'); ?></div>
										</button>
									<?php }else{ ?>
										<a href="<?php echo $options['woocommerce-redirect-login']; ?>">
											<i class="icon-user"></i>
											<div><?php echo __('Myaccount','digix'); ?></div>
										</a>
									<?php } ?>
								<?php }else{ ?>
									<a href="<?php if(class_exists( 'WC_Product' )){ echo get_permalink( get_option('woocommerce_myaccount_page_id') );}else{echo'#';} ?>">
										<i class="icon-user"></i>
										<div><?php echo __('Myaccount','digix'); ?></div>
									</a>
								<?php } ?>
							<?php endif;?>
						</li>
					</ul>
				</div>
				<div class="zeynep-toolbar">
					<ul class="list">
						<li class="toolbar-item special">
							<a href="<?php echo get_permalink( wc_get_page_id( 'shop' ) ) . '?orderby=on_sale'; ?>" class="tab-link">
								<span><?php echo __('On Sale','digix'); ?></span>
								<i class="icon-cupon"></i>
							</a>
						</li>
						<li class="toolbar-item">
							<a href="<?php if(class_exists( 'WC_Product' )){echo get_permalink( wc_get_page_id( 'shop' ) );}else{echo'#';} ?>">
								<i class="icon-app-store"></i>
								<div><?php echo __('Shop','digix'); ?></div>
							</a>
						</li>
						<li class="toolbar-item">
							<a href="<?php echo $options['mobile-blog']; ?>">
								<i class="icon-audit"></i>
								<div><?php echo __('Blog','digix'); ?></div>
							</a>
						</li>
						<li class="toolbar-item">
							<a href="<?php echo $options['mobile-contactus']; ?>">
								<i class="icon-phone"></i>
								<div><?php echo __('Contact','digix'); ?></div>
							</a>
						</li>
					</ul>
				</div>
			</section>
			<?php else: ?>
			<div class="digix-toolbar">
				<div class="toolbox">
					<ul class="toolbar-list">
						<li class="toolbar-item">
							<a href="<?php echo esc_url( home_url() ); ?>">
								<i class="icon-house"></i>
								<div><?php echo __('Home','digix'); ?></div>
							</a>
						</li>
						<li class="toolbar-item">
							<a href="<?php if(class_exists( 'WC_Product' )){echo get_permalink( wc_get_page_id( 'shop' ) );}else{echo'#';} ?>" class="tab-link">
								<i class="icon-app-store"></i>
								<div><?php echo __('Shop','digix'); ?></div>
							</a>
						</li>
						<li class="toolbar-item">
							<a class="feature" href="<?php if(class_exists( 'WC_Product' )){echo get_permalink( wc_get_page_id( 'cart' ) );}else{echo'#';} ?>">
								<i class="icon-cart"></i><span class="cart-count" id="toolbox_cart"><?php if(class_exists( 'WC_Product' )){ if ( is_null(WC()->cart) ) {} else {echo WC()->cart->cart_contents_count;}}else{echo'0';} ?></span>
							</a>
						</li>
						<li class="toolbar-item">
							<button type="submit" class="procat-modal-btn" id="slide-down-btn">
								<i class="icon-menu1"></i>
								<div><?php echo __('Category','digix'); ?></div>
							</button>
						</li>
						<li class="toolbar-item">
						<?php if ( is_user_logged_in() ) : ?>
							<a href="<?php if(class_exists( 'WC_Product' )){ echo get_permalink( get_option('woocommerce_myaccount_page_id') );}else{echo'#';} ?>">
								<i class="icon-user"></i>
								<div><?php echo __('Myaccount','digix'); ?></div>
							</a>
						<?php else: ?>
							<?php if( $options['woocommerce-digits'] == '1' ) { ?>
								<?php if ( $options['woocommerce-digits-type'] == 'popup' ) { ?>
									<button style="background:0;border:0;outline:0;font-size:14px;font-weight:400;box-shadow: none;" href="?login=true" onclick="jQuery('this').digits_login_modal(jQuery(this));return false;" attr-disclick="1" class="digix-digit-btn btn digits-login-modal" type="1">
										<i class="icon-user"></i>
										<div><?php echo __('Myaccount','digix'); ?></div>
									</button>
								<?php }else{ ?>
									<a href="<?php echo $options['woocommerce-redirect-login']; ?>">
										<i class="icon-user"></i>
										<div><?php echo __('Myaccount','digix'); ?></div>
									</a>
								<?php } ?>
							<?php }else{ ?>
								<a href="<?php if(class_exists( 'WC_Product' )){ echo get_permalink( get_option('woocommerce_myaccount_page_id') );}else{echo'#';} ?>">
									<i class="icon-user"></i>
									<div><?php echo __('Myaccount','digix'); ?></div>
								</a>
							<?php } ?>
						<?php endif; ?>
						</li>
					</ul>
					<svg xmlns="http://www.w3.org/2000/svg" width="768" height="50" viewBox="0 0 768 50">
					  <path d="M-15,0H345c12.855,0,16.965,20,39,20,22.238,0,25.921-20,39-20H828V95H-15V0Z"></path>
					</svg>
				</div>
			</div>
			<?php
			endif;
			endif;
		}
		#
		##
		# Remove all unnecessary JS and CSS files
		public function script_cleaner() {

            // Styles
            wp_dequeue_style( 'select2' );
            wp_deregister_style( 'select2' );

            wp_dequeue_style( 'woocommerce-twenty-seventeen' );
            wp_deregister_style( 'woocommerce-twenty-seventeen' );


            wp_dequeue_style( 'woocommerce-smallscreen' );
            wp_deregister_style( 'woocommerce-smallscreen' );

            wp_dequeue_style( 'woocommerce-layout' );
            wp_deregister_style( 'woocommerce-layout' );
        }
        #
		## 
		# Redirect the user to the product instead of the comment ID
        public function redirect_after_comment( $location, $comment ){
            $post_id = $comment->comment_post_ID;

            if( 'product' == get_post_type( $post_id ) ){
                $location = wp_get_referer();
            }
            return $location;
        }
		#
		##
		#  add to cart ajax single
		public function woocommerce_ajax_add_to_cart() {

			$product_id = apply_filters('woocommerce_add_to_cart_product_id', absint($_POST['product_id']));
			$quantity = empty($_POST['quantity']) ? 1 : wc_stock_amount($_POST['quantity']);
			$variation_id = absint($_POST['variation_id']);
			$passed_validation = apply_filters('woocommerce_add_to_cart_validation', true, $product_id, $quantity);
			$product_status = get_post_status($product_id);

			if ($passed_validation && WC()->cart->add_to_cart($product_id, $quantity, $variation_id) && 'publish' === $product_status) {

				do_action('woocommerce_ajax_added_to_cart', $product_id);

				if ('yes' === get_option('woocommerce_cart_redirect_after_add')) {
					wc_add_to_cart_message(array($product_id => $quantity), true);
				}

				WC_AJAX :: get_refreshed_fragments();
			} else {

				$data = array(
					'error' => true,
					'product_url' => apply_filters('woocommerce_cart_redirect_after_error', get_permalink($product_id), $product_id));

				echo wp_send_json($data);
			}

			wp_die();
		}

		#
		##
		# remove product tab
		public function digix_remove_tab( $tabs ) {
		  unset( $tabs['shipping'] );
		  unset( $tabs['seller'] );
		  unset( $tabs['more_seller_product']);
		  return $tabs;
		}
		
		#
		##
		# price chart
		public function custom_field() {
			global $post;

			$product = wc_get_product( $post->ID );
			if ( $product->get_type() == 'variable' ) {
				return;
			}

			$price_changes = get_post_meta( $post->ID, '_mk_history_price' . $post->ID, true );

			$count = $price_changes ? count( $price_changes ) : 0;

			echo '<div class="options_group">';
			echo '<p class="header"><strong class="">تاریخچه قیمت محصول</strong></p>';
			if ( $price_changes && is_array( $price_changes ) ) {
				$i = 0;
				foreach ( $price_changes as $item ) {
					woocommerce_wp_text_input(
						array(
							'id'                => '_mk_history_price' .  ( $i + 1 ),
							'name'              => '_mk_history_price' . $post->ID . '[]',
							'label'             => 'قیمت ' . ( $i + 1 ),
							'desc_tip'          => 'true',
							'description'       => 'به این فرمت و وارد نمایید: تاریخ شمسی:قیمت',
							'placeholder'       => '1399-08-13:1500',
							'value'             => $item,
							'custom_attributes' => array(
								'dir' => 'ltr'
							),
						)
					);
					$i ++;
				}
			}
			echo '<a href="#" class="new-price button" data-id="' . $post->ID . '" data-count="' . $count . '">قیمت جدید</a>';
			echo '</div>';

			wp_nonce_field( 'security', 'history_price_nonce' );
		}
		public function save_custom_field( $post_id ) {
			if ( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) {
				return;
			}

			if ( ! isset( $_POST['history_price_nonce'] ) || ! wp_verify_nonce( $_POST['history_price_nonce'], 'security' ) ) {
				return;
			}

			if ( ! current_user_can( 'edit_post' ) ) {
				//return;
			}

			$product = wc_get_product( $post_id );
			if ( $product->get_type() == 'variable' ) {
				return;
			}

			if ( isset( $_POST[ '_mk_history_price' . $post_id ] ) ) {
				$price_changes = array_map( 'sanitize_text_field', $_POST[ '_mk_history_price' . $post_id ] );
				$price_changes = array_filter( $price_changes, function ( $value ) {
					return $value !== '';
				} );
				update_post_meta( $post_id, '_mk_history_price' . $post_id, $price_changes );
			}
		}
		public function variation_custom_field( $loop, $variation_data, $variation ) {
			$price_changes = get_post_meta( $variation->ID, '_mk_history_price' . $variation->ID, true );

			$count = $price_changes ? count( $price_changes ) : 0;

			echo '<p class="price-changes-title"><strong class="">تغییرات قیمت</strong></p>';
			if ( $price_changes && is_array( $price_changes ) ) {
				$i = 0;
				foreach ( $price_changes as $item ) {
					woocommerce_wp_text_input(
						array(
							'id'                => '_mk_history_price' . $variation->ID . ( $i + 1 ),
							'name'              => '_mk_history_price' . $variation->ID . '[]',
							'label'             => 'قیمت ' . ( $i + 1 ),
							'desc_tip'          => 'true',
							'description'       => 'به این فرمت وارد نمایید: تاریخ شمسی:قیمت',
							'placeholder'       => '1397-06-19:10000',
							'value'             => $item,
							'custom_attributes' => array(
								'dir' => 'ltr'
							),
						)
					);
					$i ++;
				}
			}
			echo '<a href="#" class="new-price button" data-id="' . $variation->ID . '" data-count="' . $count . '">قیمت جدید</a>';

			wp_nonce_field( 'security', 'history_price_nonce2' );
		}
		public function save_variation_custom_field( $post_id ) {
			if ( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) {
				return;
			}

			if ( ! isset( $_POST['history_price_nonce2'] ) || ! wp_verify_nonce( $_POST['history_price_nonce2'], 'security' ) ) {
				return;
			}

			if ( ! current_user_can( 'edit_post' ) ) {
				//return;
			}

			if ( isset( $_POST[ '_mk_history_price' . $post_id ] ) ) {
				$price_changes = array_map( 'sanitize_text_field', $_POST[ '_mk_history_price' . $post_id ] );
				$price_changes = array_filter( $price_changes, function ( $value ) {
					return $value !== '';
				} );
				update_post_meta( $post_id, '_mk_history_price' . $post_id, $price_changes );
			}
		}
		#
		##
		# Digix WC single product action

		public function digix_wc_single_action_pricechart()
		{
		  $post_id = get_the_id();
		  Global $post;
		  global $options;
			if ( mk_product_has_price_change( $post_id ) ):
			  $action  = '<div class="action-item">';
					$action .= '<button class="history-price" data-id="' . $post_id . '" data-toggle="modal" data-target="#price-changes-modal">';
			  $action .= '<i class="icon-line-chart"></i>';
			  if( $options['mobile-header'] == 'modern' ):
			  $action .= '<span>نمودار قیمت </span>';
			  endif;
					$action .= '</button>';
			  $action .= '</div>';
			  echo $action;
		  endif;
		  
		}
		public function digix_wc_single_action_share()
		{
		  $post_id = get_the_id();
		  global $options;
		  Global $post;?>
		<div class="action-item">
			<button class="product-share" data-toggle="modal" data-target="#share">
				<i class="icon-hare"></i>
				<?php if( $options['mobile-header'] == 'modern' ): ?>
					<span>به اشتراک گذاری کالا</span>
				<?php endif; ?>
			</button>
		</div>
			<?php
		}
		public function digix_wc_single_share_modal()
		{ ?>
			<div class="modal single-modal fade" id="share" role="dialog" aria-hidden="true">
				<div class="modal-dialog modal-md modal-dialog-centered" role="document">
				  <div class="modal-content br-0">	  
				  <!-- Modal Header -->
				  <div class="modal-header">
					<h4 class="modal-title"><?php esc_html_e( 'product share', 'digix' ); ?> <?php the_title(); ?></h4>
					<div type="button" class="close play_close" data-dismiss="modal"><?php echo __('back','digix');?><i class="icon-arrow-left"></i></div>
				  </div>	
				  <!-- Modal body -->
				  <div class="modal-body">
					<div class="flex w-100">
					  <div class="col-lg-12 p-0">
						<div class="shortlink">
						  <span><i class="icon-link"></i><?php esc_html_e( 'product short link:', 'digix' ); ?></span>
						  <textarea onclick="javascript:this.select();" readonly="readonly"><?php echo home_url()."/?p=".get_the_ID(); ?></textarea>
						</div>
						<div class="social-sharing">
						  <p><?php esc_html_e( 'If this article was useful for you, share it', 'digix' ); ?></p>
						  <div class="lets-share">
							<div class="social-btn text-center">
							  <div class="share-btn facebook">
								<a class="facebook" href="https://www.facebook.com/sharer.php?u=<?php the_permalink();?>&t=<?php the_title(); ?>" target="_blank">
								  <i class="icon-facebook"></i>
								</a>
							  </div>
							  <div class="share-btn twitter">
								<a class="twitter" href="https://twitter.com/home?status=Reading: <?php the_permalink(); ?>" title="<?php echo __('share in twitter','digix'); ?>" target="_blank">
								  <i class="icon-twitter"></i>
								</a>
							  </div>
							  <div class="share-btn pinterest">
								<a class="pinterest" href="https://pinterest.com/pin/create/button/?url=<?php the_permalink(); ?>&media=<?php global $post; $url = wp_get_attachment_url( get_post_thumbnail_id($post->ID) ); echo $url; ?>" title="Pinterest" rel="nofollow" target="_blank">
								  <i class="icon-pinterest"></i>
								</a>
							  </div>
							  <div class="share-btn telegram">
								<a class="telegram" href="https://t.me/share/url?url=<?php the_permalink(); ?>&amp;title=<?php the_title(); ?>" title="share on Telegram" rel="nofollow" target="_blank">
								  <i class="icon-telegram"></i>
								</a>
							  </div>
							  <div class="share-btn whatsapp">
								<a class="whatsapp" href="whatsapp://send?text=<?php the_permalink(); ?>" data-action="share/whatsapp/share">
								  <i class="icon-whatsapp"></i>
								</a>
							  </div>
							</div>
						  </div>
						</div>
					  </div>
					</div>
				  </div>
				  </div>
				</div>
				</div>
		<?php
		}
		public function digix_wc_single_action_video()
		{
		  global $options;
		  $post_id = get_the_id();
		  $meta = get_post_meta( get_the_ID(), 'digix_metabox', true );
		  if( isset( $meta['video'] ) && !empty( $meta['video'] )):
			  $action  = '<div class="action-item">';
			  $action .= '<button class="product-video" data-toggle="modal" data-target="#video">';
			  $action .= '<i class="icon-tiktok"></i>';
			  if( $options['mobile-header'] == 'modern' ):
				$action .= '<span>ویدئو معرفی محصول</span>';
			  endif;
			  $action .= '</button>';
			  $action .= '</div>';
		  echo $action;
		  endif;
		}
		public function digix_wc_single_video_modal()
		{
			$post_id = get_the_id();
			$meta = get_post_meta( get_the_ID(), 'digix_metabox', true );
			if( isset( $meta['video'] ) && !empty( $meta['video'] )):
			  $action = '<div class="modal single-modal fade" id="video" role="dialog" aria-hidden="true">';
			  $action .= '<div class="modal-dialog modal-lg modal-dialog-centered">';
			  $action .= '<div class="modal-content">';
			  $action .= '<div class="modal-header">';
			  $action .= '<h4 class="modal-title">' . __('Introduction video ','digix') . get_the_title() . '</h4>';
			  $action .= '<div type="button" class="close play_close" data-dismiss="modal">' . __('back','digix') . '<i class="icon-arrow-left"></i></div>';
			  $action .= '</div>';
			  $action .= '<div class="modal-body">';
			  $action .= '<video controls class="play-video">';
			  $action .= '<source src="' . $meta['video'] . '" type="video/mp4">';
			  $action .= '</video>';
			  $action .= '</div>';
			  $action .= '</div>';
			  $action .= '</div>';
			  $action .= '</div>';
			  echo $action;
			endif;
		}
		#
		##
		# wc review
		public function digix_wc_comment_fields_html() {
			ob_start();
			$meta = get_post_meta( get_the_ID(), 'digix_metabox', true );
			if (is_array($meta)):
				$label_1 = $meta['range1']['name'];
				$label_2 = $meta['range2']['name'];
				$label_3 = $meta['range3']['name'];
				$label_4 = $meta['range4']['name'];
				$label_5 = $meta['range5']['name'];
			endif;
		?>
			<section class="review-top">
				<div class="start">
					<section class="rating">
						<div class="form-field comment-form-title">
							<label for="title"><?php echo __('title','digix'); ?></label>
							<input type="text" name="title" placeholder="<?php echo __('Enter the title of your comment','digix'); ?>">
						</div>
						<?php
						echo'
						<div class="comment-form-rating"><label for="rating">
							' . esc_html__( 'Your rating', 'woocommerce' ) . ( wc_review_ratings_required() ? '&nbsp;<span class="required">*</span>' : '' ) . '</label><select name="rating" id="rating" required>
									<option value="">' . esc_html__( 'Rate&hellip;', 'woocommerce' ) . '</option>
									<option value="5">' . esc_html__( 'Perfect', 'woocommerce' ) . '</option>
									<option value="4">' . esc_html__( 'Good', 'woocommerce' ) . '</option>
									<option value="3">' . esc_html__( 'Average', 'woocommerce' ) . '</option>
									<option value="2">' . esc_html__( 'Not that bad', 'woocommerce' ) . '</option>
									<option value="1">' . esc_html__( 'Very poor', 'woocommerce' ) . '</option>
								</select>
						</div>';
								?>
					</section>
					<section class="points">
						<div class="form-field good-points">
							<label for="advantages"><?php echo __('good points','digix');?></label>
							<div class="field-input" id="good-points">
								<input type="text" name="advantages">
								<button type="button" onclick="addgpoints()" id="add-good">+</button>
							</div>
							<div id="good-points-list"></div>
						</div>	
						<div class="form-field bad-points">
							<label for="disadvantages"><?php echo __('bad points','digix');?></label>
							<div class="field-input" id="bad-points">
								<input type="text" name="disadvantages">
								<button type="button" onclick="addbpoints()" id="add-bad">+</button>
							</div>
							<div id="bad-points-list"></div>
						</div>
					</section>
				</div>
				<div class="end">
				<div class="rate-list">
						<?php if(!empty($meta['range1']['name'])): ?>
						<div class="rate-item select-slide">
							<b><?php echo $label_1; ?></b>
							<input type="range" id="range1" name="range1" min="0" max="100" value="50" step="25">
						</div>
						<?php endif; ?>
						<?php if(!empty($meta['range2']['name'])): ?>
						<div class="rate-item select-slide">
							<b><?php echo $label_2; ?></b>
							<input type="range" id="range2" name="range2" min="0" max="100" value="50" step="25">
						</div>
						<?php endif; ?>
						<?php if(!empty($meta['range3']['name'])): ?>
						<div class="rate-item select-slide">
							<b><?php echo $label_3; ?></b>
							<input type="range" id="range3" name="range3" min="0" max="100" value="50" step="25">
						</div>
						<?php endif; ?>
						<?php if(!empty($meta['range4']['name'])): ?>
						<div class="rate-item select-slide">
							<b><?php echo $label_4; ?></b>
							<input type="range" id="range4" name="range4" min="0" max="100" value="50" step="25">
						</div>
						<?php endif; ?>
						<?php if(!empty($meta['range5']['name'])): ?>
						<div class="rate-item select-slide">
							<b><?php echo $label_5; ?></b>
							<input type="range" id="range5" name="range5" min="0" max="100" value="50" step="25">
						</div>
						<?php endif; ?>
					</div>
					<div class="vitrin-product-comment-form-nounces">
						<input type="hidden" name="alist" id="alist" value="">
						<input type="hidden" name="dlist" id="dlist" value="">
					</div>
				</div>
			</section>
			<section class="review-radio-question">
				<header><?php echo __('Do you recommend buying the product to others?','digix'); ?></header>
				<div class="radio-list">
					<div class="radio-item">
						<input type="radio" name="recommendstatus" id="advicetrue" value="1" checked>
						<label for="advicetrue"><?php echo __('I suggest','digix'); ?></label>
					</div>
					<div class="radio-item">
						<input type="radio" name="recommendstatus" id="advicefalse" value="0">
						<label for="advicefalse"><?php echo __('I do not suggest','digix'); ?></label>
					</div>
					<div class="radio-item">
						<input type="radio" name="recommendstatus" id="advicenone" value="2">
						<label for="advicenone"><?php echo __('I have no opinion','digix'); ?></label>
					</div>
				</div>
			</section>
			
		<?php
			return ob_get_clean();
		}
		public function render_digix_authorized_users() {
			if (!is_product() || !is_user_logged_in()) {
				return;
			}

			echo $this -> digix_wc_comment_fields_html();
		}

		public function render_digix_anonymous_users() {
			if (!is_product() || is_user_logged_in()) {
				return;
			}

			echo $this -> digix_wc_comment_fields_html();
		}
		#
		##
		# save review data

		public function save_digix_comment_custom_fields($comment_id, $approved, $commentdata) {
			// The pros and cons fields are not required, so we have to check if they're not empty
			$title = isset($_POST['title']) ? $_POST['title'] : '';
			$recommendstatus = isset($_POST['recommendstatus']) ? $_POST['recommendstatus'] : '1';
			$range1 = isset($_POST['range1']) ? $_POST['range1'] : '0';
			$range2 = isset($_POST['range2']) ? $_POST['range2'] : '0';
			$range3 = isset($_POST['range3']) ? $_POST['range3'] : '0';
			$range4 = isset($_POST['range4']) ? $_POST['range4'] : '0';
			$range5 = isset($_POST['range5']) ? $_POST['range5'] : '0';
			$rate_average = array($range1, $range2, $range3, $range4, $range5);
			$alist = isset($_POST['alist']) ? $_POST['alist'] : '0';
			$dlist = isset($_POST['dlist']) ? $_POST['dlist'] : '0';

			// Spammers and hackers love to use comments to do XSS attacks.
			// Don't forget to escape the variables
			add_comment_meta($comment_id, 'title', $title);
			add_comment_meta($comment_id, 'recommendstatus', $recommendstatus);
			add_comment_meta($comment_id, 'range1', $range1);
			add_comment_meta($comment_id, 'range2', $range2);
			add_comment_meta($comment_id, 'range3', $range3);
			add_comment_meta($comment_id, 'range4', $range4);
			add_comment_meta($comment_id, 'range5', $range5);
			add_comment_meta($comment_id, 'alist', $alist);
			add_comment_meta($comment_id, 'dlist', $dlist);

			$rate_average_score = 0;
			for ($i = 0; count($rate_average) > $i; $i++) {
				switch ($rate_average[$i]) {
					case 0.00:
						$rate_average_score = $rate_average_score + 1;
						break;

					case 25.00:
						$rate_average_score = $rate_average_score + 2;
						break;

					case 50.00:
						$rate_average_score = $rate_average_score + 3;
						break;

					case 75.00:
						$rate_average_score = $rate_average_score + 4;
						break;

					case 100.00:
						$rate_average_score = $rate_average_score + 5;
						break;

					default:
						$rate_average_score = $rate_average_score + 0;
						break;
				}
			}
			$rate_average_score = round($rate_average_score / 5);
			add_comment_meta($comment_id, 'rating', $rate_average_score);
		}
		#
		##
		# product review metabx
		
		public function digix_comment_add_meta_box($comment) {
			$post_id = $comment->comment_post_ID;
			$product = wc_get_product($post_id);

			if ($product === null || $product === false) {
				return;
			}

			add_meta_box(
				'digix_product_review',
				__('comment detailes','digix'),
				array( $this, 'digix_review_fields_metabox'),
				'comment',
				'normal',
				'low'
			);
		}

		public function digix_review_fields_metabox($comment) {
			$title = get_comment_meta($comment->comment_ID, 'title', true);
			$recommendstatus = get_comment_meta($comment->comment_ID, 'recommendstatus', true);
			$range1 = get_comment_meta($comment->comment_ID, 'range1', true);
			$range2 = get_comment_meta($comment->comment_ID, 'range2', true);
			$range3 = get_comment_meta($comment->comment_ID, 'range3', true);
			$range4 = get_comment_meta($comment->comment_ID, 'range4', true);
			$range5 = get_comment_meta($comment->comment_ID, 'range5', true);
			$alist = get_comment_meta($comment->comment_ID, 'alist', true);
			$dlist = get_comment_meta($comment->comment_ID, 'dlist', true);
			wp_nonce_field(basename(__FILE__), 'digix_product_review_nonce');
		?>
			<p>
			<label><?php echo __('title','digix'); ?></label>
				<br />
				<input class="widefat" type="text" value="<?php echo $title; ?>" disabled />
			</p>
			<p>
			<label><?php echo __('recomended status','digix'); ?></label>
				<br />
				<input class="widefat" type="text" value="<?php echo $recommendstatus; ?>" disabled />
			</p>
			<p>
			<label><?php echo __('score 1','digix'); ?></label>
				<br />
				<input class="widefat" type="text" value="<?php echo $range1; ?>" disabled />
			</p>
			<p>
			<label><?php echo __('score 2','digix'); ?></label>
				<br />
				<input class="widefat" type="text" value="<?php echo $range2; ?>" disabled />
			</p>
			<p>
			<label><?php echo __('score 3','digix'); ?></label>
				<br />
				<input class="widefat" type="text" value="<?php echo $range3; ?>" disabled />
			</p>
			<p>
			<label><?php echo __('score 4','digix'); ?></label>
				<br />
				<input class="widefat" type="text" value="<?php echo $range4; ?>" disabled />
			</p>
			<p>
				<label><?php echo __('score 5','digix'); ?></label>
				<br />
				<input class="widefat" type="text" value="<?php echo $range5; ?>" disabled />
			</p>
			<p>
				<label><?php echo __('Advantages','digix'); ?></label>
				<br />
				<input class="widefat" type="text" value="<?php echo $alist; ?>" disabled />
			</p>
			<p>
				<label><?php echo __('Disadvantages','digix'); ?></label>
				<br />
				<input class="widefat" type="text" value="<?php echo $dlist; ?>" disabled />
			</p>
		<?php
		}

		#
		##
		#  Change several of the breadcrumb defaults

		public function digix_woocommerce_breadcrumbs() {
			return array(
					'delimiter'   => ' <i class="icon-arrow-left"></i> ',
					'wrap_before' => '<nav class="box woocommerce-breadcrumb" itemprop="breadcrumb">',
					'wrap_after'  => '</nav>',
					'before'      => '',
					'after'       => '',
					'home'        => _x( 'Home', 'breadcrumb', 'woocommerce' ),
				);
		}
		
		#
		##
		# digix woocommerce child category show in parent category

		public function digix_woocommerce_child_category()
		{
		  Global $options;
		  if ( $options['woocommerce-childcat'] == 'yes' ):
			if (is_product_category()):
			  $term = get_queried_object();
			  $children = get_terms( $term->taxonomy, array(
				'parent'    => $term->term_id,
				'hide_empty' => false
			  ) );
			$terms = get_terms([
				  'taxonomy' => 'product_cat',
				  'hide_empty' => false,
				  'parent' => get_queried_object_id()
				]);
			
			if ( $children ):

			  $html =  '<section class="digix-child-procat">';
			  $html .= '<header class="title-catchild">';
			  $html .= '<h3>' . __('child category','digix') . '</h3>';
			  $html .= '</header>';
			  $html .= '<div class="childcat-list">';
				foreach( $terms as $term ){
				  $thumbnail_id = get_term_meta($term->term_id, 'thumbnail_id', true);
				  $html .= '<a href="' . esc_url(get_term_link($term, 'product_cat')) . '" class="childcat-item">';
				  $html .= '<em>' .$term->count. '</em>';
				  $html .= '<figure class="childcat-img">';
				  if ($thumbnail_id){
					  $html .= wp_get_attachment_image($thumbnail_id, array(80,80), false, ['class' => 'img-fluid']);
					}
					else{
					  $html .=  wc_placeholder_img();
					}
					$html .= '</figure>';

					$html .= '<div class="childcat-title">'.$term->name.'</div>';

					$html .= '</a>';

				}

				$html .= '</div></section>';
				echo $html;
			  endif;
			endif;
		  endif;
		}

		
		#
		##
		# Retrieve product sale percentage
		
		public function digix_percentage_sale( $text, $post, $product ) {
		 
			$text = '<div class="discount_sale">';
		 
			$regular = $product->get_regular_price();
			$sale = $product->get_sale_price();
			if ( isset( $sale ) ) {
				$discount = round( $this -> digix_sale_percentage( $product ) );
			}
			$text .= '<span class="sale_darsad">';
			$text .= $discount . ' % ';
			$text .= 'تخفیف </span>';
			$text .= '</div>';
			return $text;
		}



		#
		##
		# Retrieve product sale percentage

		public function digix_sale_percentage( $product ) {
		$max_percentage = 0;

			if ( $product->is_on_sale() ) {
				if ( ! $product->is_type( 'variable' ) ) {
					$max_percentage = ( ( $product->get_regular_price() - $product->get_sale_price() ) / $product->get_regular_price() ) * 100;
				} else {
					foreach ( $product->get_children() as $child_id ) {
						$variation = wc_get_product( $child_id );
						$price = $variation->get_regular_price();
						$sale = $variation->get_sale_price();

						$percentage = 0;
						if ( $price != 0 && ! empty( $sale ) ) {
							$percentage = ( $price - $sale ) / $price * 100;
						}
						if ( $percentage > $max_percentage ) {
							$max_percentage = $percentage;
						}
					}
				}
			}
			return round( $max_percentage );
		}
		public function digix_woocommerce_variable_price( $price, $product ) 
		{

				$prices = array( $product->get_variation_price( 'min', true ), $product->get_variation_price( 'max', true ) );
				$price = $prices[0] !== $prices[1] ? sprintf( __( '%1$s', 'woocommerce' ), wc_price( $prices[0] ) ) : wc_price( $prices[0] );

				$prices = array( $product->get_variation_regular_price( 'min', true ), $product->get_variation_regular_price( 'max', true ) );
				sort( $prices );
				$saleprice = $prices[0] !== $prices[1] ? sprintf( __( '%1$s', 'woocommerce' ), wc_price( $prices[0] ) ) : wc_price( $prices[0] );
				if ( $price !== $saleprice ) 
			{
				  $price = '<del>' . $saleprice . '</del> <ins>' . $price . '</ins>';
				}
				return $price;
		}
		public function digix_wc_archive_ordering()
		{
			if ( ! wc_get_loop_prop( 'is_paginated' ) || ! woocommerce_products_will_display() ) {
				return;
			}
			if( is_shop() || is_product_category() || is_product_tag() ){
				$show_default_orderby    = 'menu_order' === apply_filters( 'woocommerce_default_catalog_orderby', get_option( 'woocommerce_default_catalog_orderby', 'menu_order' ) );
				$catalog_orderby_options = apply_filters(
				  'woocommerce_catalog_orderby',
				  array(
					'menu_order' => __( 'Default sorting', 'woocommerce' ),
					'popularity' => __( 'Sort by popularity', 'woocommerce' ),
					'rating'     => __( 'Sort by average rating', 'woocommerce' ),
					'date'       => __( 'Sort by latest', 'woocommerce' ),
					'price'      => __( 'Sort by price: low to high', 'woocommerce' ),
					'price-desc' => __( 'Sort by price: high to low', 'woocommerce' ),
				  )
				);

				$default_orderby = wc_get_loop_prop( 'is_search' ) ? 'relevance' : apply_filters( 'woocommerce_default_catalog_orderby', get_option( 'woocommerce_default_catalog_orderby', '' ) );
				// phpcs:disable WordPress.Security.NonceVerification.Recommended
				$orderby = isset( $_GET['orderby'] ) ? wc_clean( wp_unslash( $_GET['orderby'] ) ) : $default_orderby;
				// phpcs:enable WordPress.Security.NonceVerification.Recommended

				if ( wc_get_loop_prop( 'is_search' ) ) {
				  $catalog_orderby_options = array_merge( array( 'relevance' => __( 'Relevance', 'woocommerce' ) ), $catalog_orderby_options );

				  unset( $catalog_orderby_options['menu_order'] );
				}

				if ( ! $show_default_orderby ) {
				  unset( $catalog_orderby_options['menu_order'] );
				}

				if ( ! wc_review_ratings_enabled() ) {
				  unset( $catalog_orderby_options['rating'] );
				}

				if ( ! array_key_exists( $orderby, $catalog_orderby_options ) ) {
				  $orderby = current( array_keys( $catalog_orderby_options ) );
				}?>
			<div class="modal fade toggle-tab" id="digix-catelog">
			  <div class="modal-dialog">
				<div class="modal-content">

				  <!-- Modal Header -->
				  <div class="modal-header">
					<h4 class="modal-title"><?php echo __('Sort by:','digix'); ?></h4>
					<button type="button" class="close" data-dismiss="modal"><?php echo __('Back','digix'); ?><i class="icon-arrow-left"></i></button>
				  </div>

				  <!-- Modal body -->
				  <div class="modal-body">
						<ul class="catelog-list">
							
							
							<?php foreach ( $catalog_orderby_options as $id => $name ) : ?>
						  <?php
						  $link = remove_query_arg( 'orderby' );
						  $link = add_query_arg( array( 'orderby' => $id ), $link );
						  $name = str_replace( 'Sort by ', '', esc_html( $name ) );
						  $name = str_replace( 'Sort', '', esc_html( $name ) );
						  $name = str_replace( '', '', esc_html( $name ) );
						  $link = add_query_arg( array( 'orderby' => $id ), $link );
						  $name = str_replace( 'سازی', '', esc_html( $name ) );
						  $name = str_replace( 'بر', '', esc_html( $name ) );
						  $name = str_replace( 'اساس', '', esc_html( $name ) );
						  $name = str_replace( 'مرتب', '', esc_html( $name ) );
						  $name = str_replace( '', '', esc_html( $name ) );
						  ?>
							<li class="catelog-item <?php echo $orderby == $id ? 'active' : ''; ?>">
								<a href="<?php echo $link; ?>" class="<?php echo $orderby == $id ? 'active' : ''; ?>" rel="nofollow"><?php echo $name; ?></a>
							</li>
						  <?php endforeach; ?>
					  </ul>
				  </div>

				  <!-- Modal footer -->
				  <div class="modal-footer">
					<button type="button" class="btn btn-danger w-100" data-dismiss="modal"><?php echo __('Close','digix');?></button>
				  </div>

				</div>
			  </div>
			</div>
			<?php
			}else{}
		}
		public function digix_wc_archive_filtering()
		{
			if (is_active_sidebar('shop')):?>
				<div class="modal fade toggle-tab" id="digix-filter">
					<div class="modal-dialog">
						<div class="modal-content">
							<!-- Modal Header -->
							<div class="modal-header">
								<h4 class="modal-title"><?php echo __('Product Filter','digix'); ?></h4>
								<button type="button" class="close" data-dismiss="modal"><?php echo __('Back','digix'); ?><i class="icon-arrow-left"></i></button>
							</div>
							<!-- Modal body -->
							<div class="modal-body">
								<aside class="sidebar shop-sidebar" id="sidebar">
									<?php dynamic_sidebar('shop');?>
								</aside>
							</div>
							<!-- Modal footer -->
							<div class="modal-footer">
								<button type="button" class="btn btn-danger w-100" data-dismiss="modal"><?php echo __('Close','digix');?></button>
							</div>

						</div>
					</div>
				</div>
	<?php   endif; 
		}
		
		#
		##
		# Woocommerce Myaccount Options

		public function digix_myaccount_dasboard_information()
		{?>
		<section class="myaccount-detailes">
			<div class="detailes-panel">
			
				<div class="detailes-item">
				
					<div class="detailes-icon">
					
						<i class="icon-clock"></i>
					
					</div>
					
					<div class="detailes-body">
					
						<h6><?php echo __('Your Membership','digix');?></h6>
						<div>
						
							<?php
								$user = wp_get_current_user();
								$udata = get_userdata( $user->ID );
								$registered = $udata->user_registered;
								date_default_timezone_set("Asia/Tehran");
								$now = time()-3600;
								$in = strtotime($registered)+12600;
								echo '<span>' . human_time_diff( $in, $now) . ' ' . __('ago','digix') . '</span>'; 
							?>
							
						</div>
					
					</div>
				
				</div>
				
				<div class="detailes-item">
				
					<div class="detailes-icon">
					
						<i class="icon-audit"></i>
					
					</div>
					
					<div class="detailes-body">
					
						<h6><?php echo __('Total orders','digix');?></h6>
						<div>
						
							<?php
								$user_id = get_current_user_id();
								$iranwp_total_paid = wc_get_customer_total_spent( $user_id ) - '0.00';
								echo '<span>' . $iranwp_total_paid . ' ' . __('Tooman','digix') . '</span>';
							?>
							
						</div>
					
					</div>
				
				</div>
				
				<div class="detailes-item">
				
					<div class="detailes-icon">
					
						<i class="icon-chat"></i>
					
					</div>
					
					<div class="detailes-body">
					
						<h6><?php echo __('Your Comments','digix');?></h6>
						<div>
						
							<?php
								global $wpdb, $post, $current_user;
								wp_get_current_user();
								$userId = $current_user->ID;
								$where = 'WHERE comment_approved = 1 AND user_id = ' . $userId ;
								$comment_count = $wpdb->get_var("SELECT COUNT( * ) AS total 
								FROM {$wpdb->comments}
								{$where}");
								echo '<span>' . $comment_count . ' ' . __('comment','digix') . '</span>';
							?>
							
						</div>
					
					</div>
				
				</div>
				
				<div class="detailes-item">
				
					<div class="detailes-icon">
					
						<i class="icon-app-store"></i>
					
					</div>
					
					<div class="detailes-body">
					
						<h6><?php echo __('Total purchase','digix');?></h6>
						<div>
							<?php
								$user_id = get_current_user_id();
								$order_count = wc_get_customer_order_count($user_id);
								echo $order_count;
							?>
						</div>
					
					</div>
				
				</div>
			
			
			</div>
			
		</section>
		<?php	
		}
		
		#
		##
		# User Information And Detailes ON My Account

		public function digix_myaccount_user_detaile()
		{ 
		$current_user = wp_get_current_user();
		?>
			
			<section class="user-info">
			<?php if ( empty($current_user->user_email) || empty($current_user->user_firstname) || empty($current_user->user_lastname) ) : ?>
			  <div class="user-Authentication">
				<p class="Authentication-desc">
					<i class="icon-alert"></i>
					<?php echo '<b>' . $current_user->display_name . '</b> ' . __('To increase the security of your account and prevent misuse, please confirm your identity','digix');?>

				</p>
				<div class="Authentication-more">
				  <a href="<?php echo esc_url( wc_get_account_endpoint_url( 'edit-account' ) ); ?>"><span><?php echo __('Account information','digix'); ?></span>
					<i class="icon-arrow-left"></i>
				  </a>
				</div>
			  </div>
			<?php endif; ?>
				<div class="user-detailes">
				
					<div class="user-detailes-item">
						
						<i class="icon-user"></i>
						
						<span><?php echo $current_user->user_firstname . "  " . $current_user->user_lastname; ?></span>
					
					</div>
					
					<div class="user-detailes-item">
						
						<i class="icon-growth"></i>
						
						<span><?php echo $current_user->user_login; ?></span>
					
					</div>
					
					<div class="user-detailes-item">
						
						<i class="icon-mobile"></i>
						
						<span><?php echo $current_user->billing_phone; ?></span>
					
					</div>
					
					<div class="user-detailes-item">
						
						<i class="icon-mail"></i>
						
						<span><?php echo $current_user->user_email; ?></span>
					
					</div>
				
				</div>
			
			</section>
		<?php	
		}
		
		#
		##
		# Woocommerce User Order

		public function digix_myaccount_user_order()
		{ 
		  $current_user_id    = get_current_user_id();
		  $on_hold_orders     = wc_get_orders( array( 'status' => array( 'wc-on-hold' ), 'customer_id' => $current_user_id ) );
		  $processing_orders  = wc_get_orders( array( 'status' => array( 'wc-processing' ), 'customer_id' => $current_user_id ) );
		  $completed_orders   = wc_get_orders( array( 'status' => array( 'wc-completed' ), 'customer_id' => $current_user_id ) );
		  $pending_orders     = wc_get_orders( array( 'status' => array( 'wc-pending' ), 'customer_id' => $current_user_id ) );
		  $canceled_orders    = wc_get_orders( array( 'status' => array( 'wc-cancelled' ), 'customer_id' => $current_user_id ) ); 
		  ?>
			<section class="myaccount-order">
				<div class="order-status">
					<header class="order-header">
						<h3><?php echo __('My orders','digix');?></h3>
						<a href="<?php echo esc_url( trailingslashit( wc_get_account_endpoint_url( 'orders' ) ) ); ?>">
							<?php echo __('view all','digix');?>
						</a>
					</header>
					<div class="order-content">
						<div class="order-item">
						  <img src="<?php echo DIGIX_IMG . 'pending-order.svg';?>" alt="order-pending" class="img-fluid">
						  <div class="order-information">
								<div class="total"><?php echo count($pending_orders) . ' ' . __('order','digix'); ?></div>
								<div class="name"><?php echo __('Pending','digix'); ?></div>
						  </div>
						</div>
						<div class="order-item">
						  <img src="<?php echo DIGIX_IMG . 'processing-order.svg';?>" alt="order-processing" class="img-fluid">
						  <div class="order-information">
								<div class="total"><?php echo count($processing_orders) . ' ' . __('order','digix'); ?></div>
								<div class="name"><?php echo __('Processing','digix'); ?></div>
						  </div>
						</div>
						<div class="order-item">
						  <img src="<?php echo DIGIX_IMG . 'delivered-order.svg';?>" alt="order-delivered" class="img-fluid">
						  <div class="order-information">
								<div class="total"><?php echo count($completed_orders) . ' ' . __('order','digix'); ?></div>
								<div class="name"><?php echo __('Delivered','digix'); ?></div>
						  </div>
						</div>
						<div class="order-item">
						  <img src="<?php echo DIGIX_IMG . 'cancelled-order.svg';?>" alt="order-canlcelled" class="img-fluid">
						  <div class="order-information">
								<div class="total"><?php echo count($canceled_orders) . ' ' . __('order','digix'); ?></div>
								<div class="name"><?php echo __('Cancelled','digix'); ?></div>
						  </div>
						</div>
					</div>
				</div>
				<div class="order-chart">
					<header class="order-header">
						<h3><?php echo __('Order report','digix');?></h3>
					</header>
					<div class="order-content">
					  <div class="chart">
						<canvas id="OrderChart"></canvas>
					  </div>
					</div>
				</div>
			</section>
		<?php
		}
		#
		##
		# User Information And Detailes ON My Account

		public function digix_woocommerce_myaccount()
		{
			
			$current_url = (isset($_SERVER['HTTPS']) ? "https" : "http") . "://$_SERVER[HTTP_HOST]$_SERVER[REQUEST_URI]";
			$myaccount_url = esc_url(get_permalink( get_option('woocommerce_myaccount_page_id')));
			
			if(is_user_logged_in() && $myaccount_url == $current_url)
			{
				add_action('woocommerce_after_account_navigation',array( $this ,'digix_myaccount_dasboard_information'), 5);
				add_action('woocommerce_after_account_navigation',array( $this ,'digix_myaccount_user_detaile'), 10);
				add_action('woocommerce_after_account_navigation',array( $this ,'digix_myaccount_user_order'), 15);
			}
		}
		
		#
		##
		# Display the mobile phone field

		public function add_billing_phone_to_edit_account_form() 
		{
			$user = wp_get_current_user();
		?>
			<p class="woocommerce-form-row woocommerce-form-row–wide form-row form-row-wide">
			
			<label for="billing_phone"><?php echo __('phone number','digix'); ?> <span class="required">*</span></label>
			
			<input type="text" class="woocommerce-Input woocommerce-Input–phone input-text" name="billing_phone" id="billing_phone" value="<?php echo esc_attr( $user->billing_phone ); ?>" />
			
			</p>
		<?php
		}
		#
		##
		# Check and validate the mobile phone

		public function billing_phone_field_validation( $args )
		{
			if ( isset($_POST['billing_phone']) && empty($_POST['billing_phone']) )
			$args->add( 'error', __( 'Please fill in your Mobile phone', 'woocommerce' ),”);
		}
		#
		##
		# Save the mobile phone value to user data

		public function my_account_saving_billing_phone( $user_id ) 
		{
			if( isset($_POST['billing_phone']) && ! empty($_POST['billing_phone']) )
			update_user_meta( $user_id, 'billing_phone', sanitize_text_field($_POST['billing_phone']) );
		}
		#
		##
		# User Comment On Myaccount Page
		public function comment_account_menu($items) {
			 $logout = null;
			 if (isset($items['customer-logout'])) {
				 $logout = $items['customer-logout'];
			 }
			 unset($items['customer-logout']);
			 $items['comment'] = __('Your Comment','digix');
			 if ($logout) {
				 $items['customer-logout'] = $logout;
			 }
	 
			 return $items;
		 }
 
		public function add_comment_endpoint() {
				 add_rewrite_endpoint('comment', EP_PAGES);
				 flush_rewrite_rules();
			 }
		 
		public function comment_endpoint_content() {
			 $args = array(
				 'user_id' => get_current_user_id(),
			 );
			 $comments = get_comments($args);
			 if (count($comments)) {
				 echo '<div class="comment-posted"><b>' . __('All Comments you have posted','digix') . '</b></div><div class="digix-wc-comment">';
				 foreach ($comments as $comment) {
					 $post = get_post($comment->comment_post_ID);
	 
					 if (get_post_status($post) != 'publish') {
						 continue;
					 }
					 $rating = get_comment_meta($comment->comment_ID, 'rating', true);
	 
					 ?>
					 <figure class="comment-item">
						<div class="comment-thumbnail">
							<?php
							echo get_the_post_thumbnail($post->ID, 'woocommerce_thumbnail', ['class' => 'img-fluid']);
							?>
						</div>
						<div class="comment-detailes">
							<header class="comment-title">
								<h3><a href="<?php echo get_the_permalink($post->ID); ?>"><?php echo limit_words(get_the_title($post->ID), '8').' ...'; ?></a></h3>
							</header>
							<div class="your-comment"><?php echo limit_words($comment->comment_content, '15').' ...'; ?></div>
							<?php
							  if ($rating) {
								  echo '<div class="comment-rate">' . __('Your Rate','digix') . '<div class="rating-star">'. wc_get_rating_html($rating, 1) . '</div></div>';
							  }
							?>
						</div>
					 </figure>
					 <?php
				 }
				 echo '</div>';
			 } else {
				 echo '<div class="woocommerce-Message woocommerce-Message--info woocommerce-info">' . esc_html__('No comments found','digix') . '</div>';
			 }
		}
		#
		##
		#Order Tracker For My account
		public function tracking_account_menu($items) {
				$logout = null;
				if (isset($items['customer-logout'])) {
					$logout = $items['customer-logout'];
				}
				unset($items['customer-logout']);
				$items['tracking'] = __('tracking','digix');
				if ($logout) {
					$items['customer-logout'] = $logout;
				}

				return $items;
			}

		public function add_tracking_endpoint() {
				add_rewrite_endpoint('tracking', EP_PAGES);
				flush_rewrite_rules();
			}

		public function tracking_endpoint_content() {?>
		  <section class="order-tracking-container">
					<div class="digix-tracking">
						<!-- Pre Loader-->
						<div class="digix_result_preload_area">
							<div class="digix_result_preload">
								<div></div><div></div><div></div>
							</div>
						</div><!--/ Pre Loader-->
						
						<!-- Show All Output-->
						<div class="digix-traking-form-result"></div><!--/ Show All Output-->
							<!--Tracking Form -->
				  <div class="digix-tracking-from">
							<form method="POST">
								<div class="digix-tracking-form-area">
									<div class="digix-tracking-form-field inp">
										<input type="text" id="order_number" name="order_number" placeholder="کد رهگیری سفارش">
									</div>
									<!--<div class="digix-tracking-form-field">
										<input type="text" id="phone" name="phone_number" placeholder="شماره تماس"> 
									</div>-->
									<div class="digix-tracking-form-field digix-traking-form-submit">
										<?php wp_nonce_field('digix_nonce_data'); ?>							
										<input type="submit" value="رهگیری سفارش">
									</div>	
								</div>					
							</form>
						</div><!--/ Tracking Form -->
					</div>
		  </section>
			<?php
		}
		#
		##
		# wishlist
		public function iranwp_account_menu_favorites( $items ) {
			$logout = $items['customer-logout'];
			unset( $items['customer-logout'] );
			$items['favorites']       = __('Favorites','digix');
			$items['customer-logout'] = $logout;

			return $items;
		}
			
		public function iranwp_add_favorites_endpoint() {
			add_rewrite_endpoint( 'favorites', EP_PAGES );
			flush_rewrite_rules();
		}
			
		public function iranwp_favorites_endpoint_content() {
			echo do_shortcode('[iranwp_wishlist]');
		}
		
		#
		##
		# Digix Order chart in myaccount

		public function digix_myaccount_order_chart()
		{
			if( is_account_page() ): ?>
				<script>
				const ctx = document.getElementById('OrderChart');

				new Chart(ctx, {
					type: 'line',
					data: {
					labels: [<?php $res = order_chart()['chartWeek']['date']; foreach($res as $bes){ echo"'$bes',";}?>],
					datasets: [{
						label: '# of Votes',
						data: [<?php $res = order_chart()['chartWeek']['price']; foreach($res as $bes){ echo"'$bes',";}?>],
						borderWidth: 1,
						borderColor: '#f00',
						backgroundColor: '#f00',
						pointStyle: 'rectRounded',
					}]
					},
					options: {
					scales: {
						y: {
						beginAtZero: true
						}
					}
					}
				});
				</script>
				<?php
			endif;
		}
		# Map on Checkout
		public function digix_location_selector_field( $checkout ) { 
		   $current_user = wp_get_current_user();
		   $saved_license_no = $current_user->digix_location;
		   woocommerce_form_field( 'digix_location', array(        
			  'type' => 'textarea',        
			  'class' => array( 'form-row-wide' ),        
			  'label' => __('Your address','digix'),        
			  'placeholder' => '...',        
			  'required' => true,        
			  'default' => $saved_license_no,        
		   ), $checkout->get_value( 'digix_location' ) ); 
		}
		public function digix_location_selector_field_validate() {    
		   if ( ! $_POST['digix_location'] ) {
			  wc_add_notice( __('Please enter your Address','digix'), 'error' );
		   }
		}
		public function digix_location_selector_field_save( $order_id ) { 
			if ( $_POST['digix_location'] ) update_post_meta( $order_id, '_digix_location', esc_attr( $_POST['digix_location'] ) );
		}
		public function digix_location_selector_field_thankyou( $order_id ) {    
		   if ( get_post_meta( $order_id, '_digix_location', true ) ) echo '<p><strong>' . __('map address','digix') . '</strong> ' . get_post_meta( $order_id, '_digix_location', true ) . '</p>';
		}
		public function digix_location_selector_field_order( $order ) {    
		   $order_id = $order->get_id();
		   if ( get_post_meta( $order_id, '_digix_location', true ) ) echo '<p><strong>' . __('map address','digix') . '</strong> ' . get_post_meta( $order_id, '_digix_location', true ) . '</p>';
		}
		public function digix_location_selector_field_emails( $order, $sent_to_admin, $plain_text, $email ) {
			if ( get_post_meta( $order->get_id(), '_digix_location', true ) ) echo '<p><strong>' . __('map address','digix') . '</strong> ' . get_post_meta( $order->get_id(), '_digix_location', true ) . '</p>';
		}
		# MObility Menu Walker
		function digix_mobile_walker(){
			require_once get_template_directory() . '/includes/navwalker.php';
		}
		# product categorie modal
		public function digix_categories_modal(){Global $options;?>
			<div id="slide-down-modal" class="procat-modal">
				<div class="procat-content">
					<div class="procat-modal-header">
						<h4 class="procat-modal-title"><?php echo __('Product Category','digix'); ?></h4>
						<button type="button" class="procat-modal-close"  id="slide-down-close"><?php echo __('Back','digix'); ?><i class="icon-arrow-left"></i></button>
					  </div>
					<div class="procat-body">
						
						<?php
							if( $options['toolbar_category'] =='default' ){ 
								$t_args = array(
									'taxonomy'   => 'product_cat',
									'hide_empty' => false,
									'number'     => 'all',
								);
								$categories_list = get_terms( $t_args ); ?>
								<?php if ( $categories_list ) { ?>
								<div class="procat-list">
								<?php foreach ($categories_list as $category) {
									$category_thumbnail_id = get_term_meta( $category->term_id, 'thumbnail_id', true );
									$category_image = wp_get_attachment_url( $category_thumbnail_id );
								?>

								<a class="procat-item" href="<?php echo get_term_link( $category->term_id ); ?>" style="background-image:url(<?= esc_url($category_image); ?>);">
									<div class="procat-context">
										<div class="procat-title"><?= $category->name; ?></div>
										<div class="procat-subtitle"><?= $category->count; ?> <?php __( 'Products', 'digix' ); ?></div>
									</div>
								</a>

								<?php } ?>
								</div>
							<?php } else { ?>
								<div class="empty-state">
									<div class="content-block text-center">

										<h2><?php echo __( 'No Categories Found', 'digix' ); ?></h2>
										<p><?php echo __( "The category list is empty", "digix" ); ?></p>

									</div>
								</div>
							<?php } }else{?>
								<div class="procat-list">
							<?php
								$result = $options['toolbar_category_custom'];
									foreach( $result as $value ){ ?>

										<a class="procat-item" href="<?php echo $value['url']; ?>" style="background-image:url(<?php echo $value['img']; ?>);">
											<div class="procat-context">
												<div class="procat-title"><?php echo $value['title']; ?></div>
											</div>
										</a>

										
									<?php } ?>
								</div>
							<?php } ?>
					</div>
					<!-- Modal footer -->
					  <div class="procat-modal-footer">
						<button type="button" class="btn btn-danger w-100" id="slide-down-close-btn"><?php echo __('Close','digix');?></button>
					  </div>
				</div>
			</div>
		<?php	
		}
		#cart count fragments
		public function digix_count_fragments( $fragments ) {
			$fragments['.cart-count'] = '<span class="cart-count">' . WC()->cart->get_cart_contents_count() . '</span>';
			ob_start();
			return $fragments;
		}
		#
		##
		# WooCommerce Sales Sorting Filter
		
		public function wcs_get_catalog_ordering_args( $args ) {
			
			$orderby_value = isset( $_GET['orderby'] ) ? woocommerce_clean( $_GET['orderby'] ) : apply_filters( 'woocommerce_default_catalog_orderby', get_option( 'woocommerce_default_catalog_orderby' ) );
			 
			if ( 'on_sale' == $orderby_value ) {
				$args['orderby'] = 'meta_value_num';
				$args['order'] = 'DESC';
				$args['meta_query']     = array(
				'relation' => 'OR',
				array( // Simple products type
					'key'           => '_sale_price',
					'value'         => 0,
					'compare'       => '>',
					'type'          => 'numeric'
				),
				array( // Variable products type
					'key'           => '_min_variation_sale_price',
					'value'         => 0,
					'compare'       => '>',
					'type'          => 'numeric'
				)
			); 
			}
			return $args;
			
		}
		#
		##
		# WooCommerce Sales Sorting Filter
		public function wcs_catalog_orderby( $sortby ) {
			$sortby['on_sale'] = __('on-sale','digix');
			
			return $sortby;

		}
		#
		##
		# show out of stock product on end of list
		
		public function digix_wc_orderby_status( $posts_clauses ){
			global $options;
				global $wpdb;
				if ( !is_page() && !is_single() && !is_admin() && is_woocommerce() && is_archive() ) {
					$posts_clauses['join'] .= " INNER JOIN $wpdb->postmeta istockstatus ON ( $wpdb->posts.ID = istockstatus.post_id ) ";
					$posts_clauses['orderby'] = " istockstatus.meta_value ASC, " . $posts_clauses['orderby'];
					$posts_clauses['where'] = " AND istockstatus.meta_key = '_stock_status' AND istockstatus.meta_value <> '' " . $posts_clauses['where'];
				}
				return $posts_clauses;
		}
		public function digix_notification_bar(){
			Global $wp, $options; 
			if ( $options['digix_notifbar_pc'] == '1' ){
				return; 
			}
			if ( $options['digix_notifbar_activation'] == '1' ){
				if ( $options['digix_notifbar_home'] == '1' ) { 
				$current_url = home_url(add_query_arg(array($_GET), $wp->request));
					if ( $current_url != get_site_url() ) { 
						return;
					}
				}
				if( $options['mobile-header'] != 'modern' ){
					$sticky         = ( $options['digix_notifbar_sticky'] == '1') ? "sticky": "";
				}else{
					$sticky			= '';
				}
				if( $options['digix_notifbar_type'] == 'gif') {
					$url   		= $options['digix_notifbar_type_gif_url'];
					$img   		= $options['RoyalTopbar_type_gif_mob'];
					$html  		= "<section class='NotificationBar $class $sticky'>";
					$html 	   .= "<a href='$url' class='gifbar-url d-flex'>";
					$html      .= "<img class='gifbar-img' src='$img' alt='notification'>";
					$html      .= "</a>";
					$html      .= "</section>";
				} else if( $options['digix_notifbar_type'] == 'text') {
					$class 		= "DMobile";
					$bg	   		= !empty($options['digix_notifbar_type_text_img']) ? $options['digix_notifbar_type_text_img'] : "";
					$bgcolor	= $options['digix_notifbar_type_text_background'];
					$text		= $options['digix_notifbar_type_text'];
					$textcolor	= $options['digix_notifbar_type_text_color'];
					$center     = ($options['digix_notifbar_type_text_position'] == '1') ? "j-center":"";
					$buttontext	= $options['digix_notifbar_type_text_button_text'];
					$buttonurl	= $options['digix_notifbar_type_text_button_url'];
					$btncolor	= $options['digix_notifbar_type_text_button_color'];
					$btnbgcolor	= $options['digix_notifbar_type_text_button_background'];
					$close      = ($options['digix_notifbar_type_text_close'] == '1')? "<a class='textbar-close'><svg width='24' height='24' xmlns='http://www.w3.org/2000/svg' viewBox='0 0 24 24'><path d='M12 10.6L6.6 5.2 5.2 6.6l5.4 5.4-5.4 5.4 1.4 1.4 5.4-5.4 5.4 5.4 1.4-1.4-5.4-5.4 5.4-5.4-1.4-1.4-5.4 5.4z'></path></svg></a>" : "";
					$button		= ($options['digix_notifbar_type_text_button'] == '1')? "<div class='textbar-url $center'><a style='color:$btncolor;background:$btnbgcolor' href='$buttonurl' target='_blank' class='url'>$buttontext</a></div>":"";
					$html  		= "<section class='NotificationBar $class $sticky' style='background: url($bg);background-color:$bgcolor'>";
					$html      .= "<div class='container'>";
					$html      .= "<div class='textbar $center'>";
					$html      .= $close;
					$html      .= "<div class='textbar-text'>";
					$html      .= "<p style='color:$textcolor'>$text</p>";
					$html	   .= "</div>";
					$html      .= $button;
					$html	   .= "</div>";
					$html	   .= "</div>";
					$html	   .= "</section>";
				}
				
				echo $html;	
			}
		}

	}return new Digix_mobile();
}



