<?php

global $post, $product;


	$attachment_ids = $product->get_gallery_image_ids();

// Add thumbnail to gallery
if( has_post_thumbnail() ) {
	$product_thumbnail_id = get_post_thumbnail_id();
	if( $product_thumbnail_id ) {
		$attachment_ids = array_merge( array( $product_thumbnail_id ), $attachment_ids );
	}
}

?>

<div class="digix-lightbox">
	<div class="digix-lightbox-container close">
		<div class="digix-lightbox-overlay"></div>
		<div class="digix-lightbox-wrapper">
			
			<div class="digix-header">
					<?php the_title('<span class="digix-product-title">', '</span>'); ?>
					<a class="digix-button digix-back-button"><span><?php echo __( 'Back', 'digix' ); ?></span><i class="icon-arrow-left"></i></a>
			</div>
			<ul class="digix-lightbox-content">
				<?php
				if( $attachment_ids ) {
					$loop = 1;
					foreach( $attachment_ids as $attachment_id ) {
						$video_url = null;

						echo '<li data-digix-index="' . esc_attr( $loop ) . '">';

						$props = wc_get_product_attachment_props( $attachment_id, $post );

						if( ! $props['url'] ) {
							continue;
						}
							echo '<div class="digix-middle-table-cell">';
							
							$image_attributes = wp_get_attachment_image_src( $attachment_id, 'woocommerce_single', false );
							?>
							<img alt="<?php echo $props['title']; ?>" src="" data-digix-src="<?php echo $props['full_src']; ?>" width="<?php echo $image_attributes[1]; ?>" height="<?php echo $image_attributes[2]; ?>" id="digix-lightbox-image-<?php echo esc_attr( $loop ); ?>" class="digix-lightbox-image">
							<?php
							echo '</div>';

						echo '</li>';

						$loop++;
					}
				}
				?>
			</ul>
		</div>
	</div>
</div>