<?php
/*
Plugin Name: WPC Added To Cart Notification for WooCommerce
Plugin URI: https://wpclever.net/
Description: WPC Added To Cart Notification will open a popup to notify the customer immediately after adding a product to cart.
Version: 2.2.1
Author: WPClever
Author URI: https://wpclever.net
Text Domain: woo-added-to-cart-notification
Domain Path: /languages/
Requires at least: 4.0
Tested up to: 6.1
WC requires at least: 3.0
WC tested up to: 7.1
*/

defined( 'ABSPATH' ) || exit;
Global $options;
if ( $options['woocommerce-notiny'] == '1'){
if ( ! function_exists( 'digix_notification_cart' ) ) {
	add_action( 'wp_loaded', 'digix_notification_cart', 12 );

	function digix_notification_cart() {

		if ( ! class_exists( 'digix_notification_cart' ) && class_exists( 'WC_Product' ) ) {
			class digix_notification_cart {
                protected static $instance = null;

				public static function instance() {
					if ( is_null( self::$instance ) ) {
						self::$instance = new self();
					}

					return self::$instance;
				}
				function __construct() {

					// add the time
					add_action( 'woocommerce_add_to_cart', [ $this, 'add_to_cart' ], 10 );

					// fragments
					add_filter( 'woocommerce_add_to_cart_fragments', [ $this, 'add_to_cart_fragments' ] );

					// footer
					add_action( 'wp_footer', [ $this, 'footer' ] );
				}


				function get_notiny() {
					$items       = WC()->cart->get_cart();
					$return_html = '<div class="wooac-wrapper wooac-notiny" style="display:none">';

					if ( is_array( $items ) && count( $items ) > 0 ) {
						foreach ( $items as $key => $item ) {
							if ( ! isset( $item['wooac_time'] ) ) {
								$items[ $key ]['wooac_time'] = time() - 10000;
							}
						}      

						array_multisort( array_column( $items, 'wooac_time' ), SORT_ASC, $items );
						$item    = end( $items );
						$product = apply_filters( 'wooac_product', $item['data'], $item );

						if ( $product && ( $product_id = $product->get_id() ) && ! apply_filters( 'wooac_exclude', false, $product, $item ) ) {
							if ( ! in_array( $product_id, apply_filters( 'wooac_exclude_ids', array( 0 ) ), true ) ) {
								$return_html .= apply_filters( 'wooac_text', '<div class="wooac-text"><span>' . __('product was added to the cart.', 'digix' ) . '</div>', $product );
							}
						}
					}

					$return_html .= '</div>';

					return apply_filters( 'wooac_notiny_html', $return_html );
				}


				function add_to_cart( $cart_item_key ) {
					if ( isset( WC()->cart->cart_contents[ $cart_item_key ]['woosb_parent_id'] ) || isset( WC()->cart->cart_contents[ $cart_item_key ]['wooco_parent_id'] ) || isset( WC()->cart->cart_contents[ $cart_item_key ]['woobt_parent_id'] ) || isset( WC()->cart->cart_contents[ $cart_item_key ]['woofs_parent_id'] ) ) {
						// prevent bundled products and composite products
						WC()->cart->cart_contents[ $cart_item_key ]['wooac_time'] = time() - 10000;
					} else {
						WC()->cart->cart_contents[ $cart_item_key ]['wooac_time'] = time();
					}
				}

				function add_to_cart_fragments( $fragments ) {
					$fragments['.wooac-notiny'] = self::get_notiny();

					return $fragments;
				}

				function footer() {
					if ( is_admin() ) {
						return;
					}


							echo '<div class="wooac-wrapper wooac-notiny"></div>';
	

					if ( isset( $_POST['add-to-cart'] ) || isset( $_GET['add-to-cart'] ) ) {
						?>
                        <script>
                          jQuery(document).ready(function() {
                            jQuery('body').on('wc_fragments_refreshed', function() {
                              wooac_show();
                            });
                          });
                        </script>
						<?php
					}
				}
			}

			return digix_notification_cart::instance();
		}
	}
}
}