<?php
function digix_wishlist(){
    if ( ! class_exists( 'digix_wishlist' ) ) {
        class digix_wishlist {
            protected static $woosw_added = array();

            function __construct() {
                // add query var
                add_filter( 'query_vars', array( $this, 'query_varsi' ), 1 );

                add_action( 'init', array( $this, 'initi' ) );

                // menu
                //add_action( 'admin_menu', array( $this, 'admin_menu_wish' ) );

                // frontend scripts
                add_action( 'wp_enqueue_scripts', array( $this, 'wp_enqueue_scriptsi' ) );


                // add
                add_action( 'wp_ajax_wishlist_add', array( $this, 'wishlist_addi' ) );
                add_action( 'wp_ajax_nopriv_wishlist_add', array( $this, 'wishlist_addi' ) );

                // remove
                add_action( 'wp_ajax_wishlist_remove', array( $this, 'wishlist_removei' ) );
                add_action( 'wp_ajax_nopriv_wishlist_remove', array( $this, 'wishlist_removei' ) );

                // load
                add_action( 'wp_ajax_wishlist_load', array( $this, 'wishlist_loadi' ) );
                add_action( 'wp_ajax_nopriv_wishlist_load', array( $this, 'wishlist_loadi' ) );


                // footer
                add_action( 'wp_footer', array( $this, 'wp_footer' ) );

            }

            function query_varsi( $vars ) {
                $vars[] = 'woosw_id';

                return $vars;
            }

            function initi() {
                // add page
				Global $options;
                $wishlist_page = get_page_by_path( 'wishlist', OBJECT );



                // shortcode
                add_shortcode( 'wish_btn_archive_product', array( $this, 'wish_btn_archive_product_func' ) );
                add_shortcode( 'wish_btn_widgets_product', array( $this, 'wish_btn_widgets_product_func' ) );
                add_shortcode( 'wish_btn_single_product', array( $this, 'wish_btn_single_product_func' ) );
                add_shortcode( 'iranwp_wishlist', array( $this, 'list_shortcodei' ) );

                
                //add_action( 'woocommerce_after_shop_loop_item', array( $this, 'add_button' ), 11 );
                add_action( 'woocommerce_after_shop_loop_item', array( $this, 'wish_btn_archive_product' ), 11 );

                // add button for single
				if( $options['mobile-header'] != 'modern' ):
                add_action( 'digix_wc_single_action', array($this,'wish_btn_single_product'), 20);
				endif;
                //add_action( 'iranwp_action_product', array( $this, 'add_button_widget' ), 10);;
                add_action( 'iranwp_action_product', array( $this, 'wish_btn_widgets_product' ), 10);;

                // added products
                $woosw_key = self::set_key();

                if ( get_option( 'iranwp_wishlist_' . $woosw_key ) ) {
                    self::$woosw_added = get_option( 'iranwp_wishlist_' . $woosw_key );
                }
            }

            function wishlist_addi() {
                $return = array( 'status' => 0 );

                if ( ( $product_id = absint( $_POST['product_id'] ) ) > 0 ) {
                    $woosw_key = self::get_key();

                    if ( $woosw_key === '#' ) {
                        $return['status'] = 0;
                        $return['notice'] = __( 'Please log in to use the wishlist!', 'digix' );
                        $return['image']  = DIGIX_URI . '/static/img/heart_error.svg';
                    } else {
                        $woosw_products = array();

                        if ( get_option( 'iranwp_wishlist_' . $woosw_key ) ) {
                            $woosw_products = get_option( 'iranwp_wishlist_' . $woosw_key );
                        }

                        if ( ! array_key_exists( $product_id, $woosw_products ) ) {
                            // insert if not exists
                            $woosw_products = array( $product_id => time() ) + $woosw_products;
                            update_option( 'iranwp_wishlist_' . $woosw_key, $woosw_products );
                            $this->update_meta( $product_id, 'add' );
                            $return['notice'] = __( 'Added to the wishlist!', 'digix' );
                            $return['image']  = DIGIX_URI . '/static/img/heart_add.svg';
                        } else {
                            $return['notice'] = __( 'Already in the wishlist!', 'digix' );
                            $return['image']  = DIGIX_URI . '/static/img/heart_duplicate.svg';
                        }

                        $return['status'] = 1;
                        $return['count']  = count( $woosw_products );
                    }
                } else {
                    $return['status'] = 0;
                    $return['notice'] = __( 'Have an error, please try again!', 'digix' );
                    $return['image']  = DIGIX_URI . '/static/img/heart_error.svg';
                }

                echo json_encode( $return );
                die();
            }

            function wishlist_removei() {
                $return = array( 'status' => 0 );

                if ( ( $product_id = absint( $_POST['product_id'] ) ) > 0 ) {
                    $woosw_key = self::get_key();

                    if ( $woosw_key === '#' ) {
                        $return['notice'] = __( 'Please log in to use the wishlist!', 'digix' );
                    } else {
                        $woosw_products = array();

                        if ( get_option( 'iranwp_wishlist_' . $woosw_key ) ) {
                            $woosw_products = get_option( 'iranwp_wishlist_' . $woosw_key );
                        }

                        if ( array_key_exists( $product_id, $woosw_products ) ) {
                            unset( $woosw_products[ $product_id ] );
                            update_option( 'iranwp_wishlist_' . $woosw_key, $woosw_products );
                            $this->update_meta( $product_id, 'remove' );
                            $return['count']  = count( $woosw_products );
                            $return['status'] = 1;

                            if ( count( $woosw_products ) > 0 ) {
                                $return['notice'] = __( 'Removed from wishlist!', 'digix' );
                            } else {
                                $return['notice'] = __( 'There are no products on the wishlist!', 'digix' );
                            }
                        } else {
                            $return['notice'] = __( 'The product does not exist on the wishlist!', 'digix' );
                        }
                    }
                } else {
                    $return['notice'] = __( 'Have an error, please try again!', 'digix' );
                }

                echo json_encode( $return );
                die();
            }

            function wishlist_loadi() {
                $return    = array( 'status' => 0 );
                $woosw_key = self::get_key();

                if ( $woosw_key === '#' ) {
                    $return['notice'] = __( 'Please log in to use wishlist!', 'digix' );
                } else {
                    $woosw_products = array();

                    if ( get_option( 'iranwp_wishlist_' . $woosw_key ) ) {
                        $woosw_products = get_option( 'iranwp_wishlist_' . $woosw_key );
                    }

                    $return['status'] = 1;
                    $return['count']  = count( $woosw_products );
                    $return['value']  = $this->get_items( $woosw_key );
                }

                echo json_encode( $return );
                die();
            }
            function wish_btn_archive_product() {
                echo do_shortcode( '[wish_btn_archive_product]' );
            }
            function wish_btn_single_product() {
                echo do_shortcode( '[wish_btn_single_product]' );
            }
            function wish_btn_widgets_product() {
                echo do_shortcode( '[wish_btn_widgets_product]' );
            }

            function wish_btn_archive_product_func( $atts ) {
                $output = '';

                $atts = shortcode_atts( array(
                    'id'   => null,
                    'type' => get_option( 'woosw_button_type', 'button' )
                ), $atts, 'woosw' );

                if ( ! $atts['id'] ) {
                    global $product;
                    $atts['id'] = $product->get_id();
                }

                if ( $atts['id'] ) {
                    // check cats
                    $selected_cats = array('0');

                    if ( ! empty( $selected_cats ) && ( $selected_cats[0] !== '0' ) ) {
                        $in_cats = false;
                        $terms   = wp_get_post_terms( $atts['id'], 'product_cat', array( 'fields' => 'ids' ) );

                        foreach ( $terms as $term ) {
                            if ( in_array( $term, $selected_cats, false ) ) {
                                $in_cats = true;
                            }
                        }

                        if ( ! $in_cats ) {
                            return '';
                        }
                    }

                    $woosw_class = 'woosw-btn woosw-btn-' . esc_attr( $atts['id'] );

                    if ( array_key_exists( $atts['id'], self::$woosw_added ) ) {
                    
                    } else {
                        $woosw_text = get_option( 'woosw_button_text' );

                        $woosw_text = apply_filters( 'woosw_button_text', $woosw_text );
                    }

                    if ( ! array_key_exists( $atts['id'], self::$woosw_added ) ) {
                        $output = '<button data-toggle="tooltip" data-placement="top" title="' . __( 'Add to wishlist', 'digix' ) . '" class="' . esc_attr( $woosw_class ) .  'wc_archive_action_btn " data-id="' . esc_attr( $atts['id'] ) . '"><i class="fal fa-heart"></i></button>';
                    }else{
                        $output = '<button data-toggle="tooltip" data-placement="top" title="' . __( 'Added to wishlist', 'digix' ) . '" class="' . esc_attr( $woosw_class ) . ' wc_archive_action_btn_added " data-id="' . esc_attr( $atts['id'] ) . '"><i class="fal fa-heart"></i></button>';
                    }
                }
                

                return apply_filters( 'woosw_button_html', $output, $atts['id'] );
            }
            function wish_btn_widgets_product_func( $atts ) {
                $output = '';

                $atts = shortcode_atts( array(
                    'id'   => null,
                    'type' => get_option( 'woosw_button_type', 'button' )
                ), $atts, 'woosw' );

                if ( ! $atts['id'] ) {
                    global $product;
                    $atts['id'] = $product->get_id();
                }

                if ( $atts['id'] ) {
                    // check cats
                    $selected_cats = array('0');

                    if ( ! empty( $selected_cats ) && ( $selected_cats[0] !== '0' ) ) {
                        $in_cats = false;
                        $terms   = wp_get_post_terms( $atts['id'], 'product_cat', array( 'fields' => 'ids' ) );

                        foreach ( $terms as $term ) {
                            if ( in_array( $term, $selected_cats, false ) ) {
                                $in_cats = true;
                            }
                        }

                        if ( ! $in_cats ) {
                            return '';
                        }
                    }

                    $woosw_class = 'woosw-btn woosw-btn-' . esc_attr( $atts['id'] );
                    if ( array_key_exists( $atts['id'], self::$woosw_added ) ) {$icon_wish = '';}else{$icon_wish = '<i class="fal fa-heart"></i>';}
                    if ( array_key_exists( $atts['id'], self::$woosw_added ) ) {
                        //$woosw_class .= ' iranwp-wish-added';
                    } else {
                        $woosw_text = get_option( 'woosw_button_text' );

                        $woosw_text = apply_filters( 'woosw_button_text', $woosw_text );
                    }

                    if ( ! array_key_exists( $atts['id'], self::$woosw_added ) ) {
                        $output = '<button data-toggle="tooltip" data-placement="top" title="' . __( 'Add to wishlist', 'digix' ) . '" class="' . esc_attr( $woosw_class ) . ' wc_widgets_action_btn wc_widgets_action_wish " data-id="' . esc_attr( $atts['id'] ) . '"><i class="fal fa-heart"></i></button>';
                    } else {
                        $output = '<button data-toggle="tooltip" data-placement="top" title="' . __( 'Added to wishlist', 'digix' ) . '" class="' . esc_attr( $woosw_class ) . ' wc_widgets_action_btn_added wc_widgets_action_wish " data-id="' . esc_attr( $atts['id'] ) . '"><i class="fal fa-heart"></i></button>';
                    }
                }

                return apply_filters( 'woosw_button_html', $output, $atts['id'] );
            }
            function wish_btn_single_product_func( $atts ) {
                $output = '';

                $atts = shortcode_atts( array(
                    'id'   => null,
                    'type' => get_option( 'woosw_button_type', 'button' )
                ), $atts, 'woosw' );

                if ( ! $atts['id'] ) {
                    global $product;
                    $atts['id'] = get_the_id();
                }

                if ( $atts['id'] ) {
                    // check cats
                    $selected_cats = array('0');

                    if ( ! empty( $selected_cats ) && ( $selected_cats[0] !== '0' ) ) {
                        $in_cats = false;
                        $terms   = wp_get_post_terms( $atts['id'], 'product_cat', array( 'fields' => 'ids' ) );

                        foreach ( $terms as $term ) {
                            if ( in_array( $term, $selected_cats, false ) ) {
                                $in_cats = true;
                            }
                        }

                        if ( ! $in_cats ) {
                            return '';
                        }
                    }

                    $woosw_class = 'woosw-btn woosw-btn-' . esc_attr( $atts['id'] );
                    
                    if ( array_key_exists( $atts['id'], self::$woosw_added ) ) {
                        //$woosw_class .= ' iranwp-wish-added';
                    } else {
                        $woosw_text = get_option( 'woosw_button_text' );

                        $woosw_text = apply_filters( 'woosw_button_text', $woosw_text );
                    }

                    
                    if ( ! array_key_exists( $atts['id'], self::$woosw_added ) ) {
                        $output = '<div class="action-item"><button class="woox ' . esc_attr( $woosw_class ) . ' wc_single_action_btn " data-id="' . esc_attr( $atts['id'] ) . '"><i class="icon-heart"></i></button></div>';
                    } else {
                        $output = '<div class="action-item"><button class="woox ' . esc_attr( $woosw_class ) . ' wc_single_action_btn_added woosw-added" data-id="' . esc_attr( $atts['id'] ) . '"><i class="icon-heart"></i></button></div>';
                    }
                }

                return apply_filters( 'woosw_button_html', $output, $atts['id'] );
            }
            function list_shortcodei() {
                if ( get_query_var( 'woosw_id' ) ) {
                    $key = get_query_var( 'woosw_id' );
                } else {
                    $key = self::get_key();
                }

                $return_html   = '<section class="digix-wishlist">';
                $return_html   .= $this->get_items( $key );
                $return_html .= '</section><!-- /woosw-list -->';

                return $return_html;
            }

        
            function wp_enqueue_scriptsi() {
                // main style
                $woosw_color         = "#5fbd74";
                $woosw_custom_css    = ".woosw-area .woosw-inner .woosw-content .woosw-content-bot .woosw-notice { background-color: {$woosw_color}; } ";
                $woosw_custom_css    .= ".woosw-area .woosw-inner .woosw-content .woosw-content-bot .woosw-content-bot-inner .woosw-page a:hover, .woosw-area .woosw-inner .woosw-content .woosw-content-bot .woosw-content-bot-inner .woosw-continue:hover { color: {$woosw_color}; } ";
                wp_add_inline_style( 'style', $woosw_custom_css );

                // main js
                wp_enqueue_script( 'wishlist', DIGIX_URI . '/static/js/wishlist.js', array( 'jquery' ), '', true );

                // text
                $woosw_text = get_option( 'woosw_button_text' );

                if ( empty( $woosw_text ) ) {
                    $woosw_text = __( 'Add to wishlist', 'digix' );
                }

                $woosw_text = apply_filters( 'woosw_button_text', $woosw_text );


                // localize
                wp_localize_script( 'wishlist', 'woosw_vars', array(
                        'ajax_url'            => admin_url( 'admin-ajax.php' ),
                        //'menu_action'         => get_option( 'woosw_menu_action', 'open_page' ),
                        'copied_text'         => __( 'Copied the wishlist link:', 'digix' ),
                        'button_text'         => esc_html( $woosw_text ),
                        'button_action_added' => 'popup'
                    )
                );
            }

            function get_items( $key ) {
                $items_html     = '';
                $woosw_products = get_option( 'iranwp_wishlist_' . $key );

                if ( is_array( $woosw_products ) && ( count( $woosw_products ) > 0 ) ) {
                    $items_html .= '<div class="wishlist-list">';

                    foreach ( $woosw_products as $product_id => $product_time ) {
                        $product = wc_get_product( $product_id );

                        if ( ! $product ) {
                            continue;
                        }

                        $items_html .= '<div class="wishlist-item wishlist-item-' . $product_id . '" data-id="' . $product_id . '">';

                        if ( self::can_edit( $key ) ) {
                            $items_html .= '<div class="wishlist-item--remove"><span class="icon-trash"></span></div>';
                        }

                        $items_html .= '<div class="wishlist-item--image">' . $product->get_image() . '</div>';
                        $items_html .= '<div class="wishlist-detailes">';
                        $items_html .= '<div class="wishlist-item--title"><a href="' . $product->get_permalink() . '">' . $product->get_name() . '</a></div>';
                        $items_html .= '<div class="wishlist-item--price">' . $product->get_price_html() . '</div>';
                        $items_html .= '</div>';
                        $items_html .= '<div class="wishlist-action">';
                        $items_html .= '<div class="wishlist-item--add">' . do_shortcode( '[add_to_cart id="' . $product_id . '"]' ) . '</div>';
                        $items_html .= '</div>';
                        $items_html .= '</div>';
                    }

                    $items_html .= '</div>';
                } else {
                    $items_html = '<div class="woosw-content-mid-notice">' . __( 'There are no products on the wishlist!', 'digix' ) . '</div>';
                }

                return $items_html;
            }

            function wp_footer() {
                ?>
                <div id="woosw-area" class="woosw-area">
                    <div class="woosw-inner">
                        <div class="woosw-content">
                            <div class="woosw-content-top">
                                <?php esc_html_e( 'Wishlist', 'digix' ); ?>
                                <span class="woosw-close"></span>
                            </div>
                            <div class="woosw-content-mid"></div>
                            <div class="woosw-content-bot">
                                <div class="woosw-content-bot-inner">
                                    <span class="woosw-continue"
                                            data-url="<?php //echo ot_get_option( 'woosw_continue_url' ); ?>">
                                <?php esc_html_e( 'Continue shopping', 'digix' ); ?>
                            </span>
                                </div>
                                <div class="woosw-notice"></div>
                            </div>
                        </div>
                    </div>
                </div>
                <?php
            }

            function update_meta( $product_id, $action = 'add' ) {
                $meta_count = 'woosw_count';
                $meta_time  = ( $action === 'add' ? 'woosw_add' : 'woosw_remove' );
                $count      = get_post_meta( $product_id, $meta_count, true );
                $new_count  = 0;

                if ( $action === 'add' ) {
                    if ( $count ) {
                        $new_count = absint( $count ) + 1;
                    } else {
                        $new_count = 1;
                    }
                } elseif ( $action === 'remove' ) {
                    if ( $count && ( absint( $count ) > 1 ) ) {
                        $new_count = absint( $count ) - 1;
                    } else {
                        $new_count = 0;
                    }
                }

                update_post_meta( $product_id, $meta_count, $new_count );
                update_post_meta( $product_id, $meta_time, time() );
            }

            public static function generate_key() {
                $key         = '';
                $key_str     = 'ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789';
                $key_str_len = strlen( $key_str );

                for ( $i = 0; $i < 6; $i ++ ) {
                    $key .= $key_str[ random_int( 0, $key_str_len - 1 ) ];
                }

                return $key;
            }

            public static function exists_key( $key ) {
                if ( get_option( 'iranwp_wishlist_' . $key ) ) {
                    return true;
                }

                return false;
            }

            public static function can_edit( $key ) {
                if ( is_user_logged_in() ) {
                    if ( get_user_meta( get_current_user_id(), 'woosw_key', true ) === $key ) {
                        return true;
                    }
                } else {
                    if ( isset( $_COOKIE['woosw_key'] ) && ( $_COOKIE['woosw_key'] === $key ) ) {
                        return true;
                    }
                }

                return false;
            }

            public static function set_key() {
                if ( ! is_user_logged_in() ) {
                    return '#';
                }

                if ( is_user_logged_in() && ( ( $user_id = get_current_user_id() ) > 0 ) ) {
                    // for user
                    if ( get_user_meta( $user_id, 'woosw_key', true ) === '' ) {
                        $new_key = self::generate_key();

                        while ( self::exists_key( $new_key ) ) {
                            $new_key = self::generate_key();
                        }

                        update_user_meta( $user_id, 'woosw_key', $new_key );

                        return $new_key;
                    }

                    return get_user_meta( $user_id, 'woosw_key', true );
                }

                // for guest
                if ( isset( $_COOKIE['woosw_key'] ) ) {
                    return esc_attr( $_COOKIE['woosw_key'] );
                }

                $new_key = self::generate_key();

                while ( self::exists_key( $new_key ) ) {
                    $new_key = self::generate_key();
                }

                setcookie( 'woosw_key', $new_key, time() + 604800, COOKIEPATH, COOKIE_DOMAIN );

                return $new_key;
            }

            public static function get_key() {
                if ( ! is_user_logged_in() ) {
                    return '#';
                }

                if ( is_user_logged_in() && ( ( $user_id = get_current_user_id() ) > 0 ) ) {
                    return get_user_meta( $user_id, 'woosw_key', true );
                }

                if ( isset( $_COOKIE['woosw_key'] ) ) {
                    return esc_attr( $_COOKIE['woosw_key'] );
                }

                return '#';
            }

            public static function get_count( $key = null ) {
                if ( ! $key ) {
                    $key = self::get_key();
                }

                $woosw_products = array();

                if ( get_option( 'iranwp_wishlist_' . $key ) ) {
                    $woosw_products = get_option( 'iranwp_wishlist_' . $key );
                }

                return apply_filters( 'woosw_wishlist_count', count( $woosw_products ) );
            }

        }
        new digix_wishlist();
    }
}
add_action( 'after_setup_theme', 'digix_wishlist', 11 );