<?php
/**
 * The template for displaying the footer.
 *
 * Contains the body & html closing tags.
 *
 * @package DIGIX
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}
Global $options;
?>
<footer class="mobile-footer">
	<div class="mobtainer">
		<section class="toplogo">
			<a class="logo" href="<?php echo esc_url( home_url() ); ?>"><img src="<?php echo $options['mobile-footlogo'];?>" class="img-fluid"></a>
			<a href="#" class="topbutton">
				<span><?php echo __('Go to top','digix');?></span>
				<i class="icon-arrow-up"></i>
			</a>
		</section>
		<?php if( isset($options['contact-detailes']) && !empty($options['contact-detailes']) || isset($options['contact-tell']) && !empty($options['contact-tell']) || isset($options['contact-mail']) && !empty($options['contact-mail']) ):?>
            <section class="contact">
                <ul>
                    <?php if( isset($options['contact-tell']) && !empty($options['contact-tell'])):?>
                        <li><i class="icon-phone"></i><span><?php echo __('tell number','digix') . ':</span> ' . $options['contact-tell'];?></li>
                    <?php endif;?>
                    <?php if( isset($options['contact-mail']) && !empty($options['contact-mail'])):?>
                        <li><i class="icon-mail"></i><span><?php echo  __('E-mail','digix') . ':</span> ' . $options['contact-mail'];?></li>
                    <?php endif;?>
					<?php if( isset($options['contact-detailes']) && !empty($options['contact-detailes'])):?>
                        <li><i class="icon-clock"></i><?php echo $options['contact-detailes'];?></li>
                    <?php endif;?>
                </ul>
            </section>
		<?php endif;?>
		<?php if ( $options['application-switch'] === '1' ) : ?>
			<?php if( isset($options['application-play']) && !empty($options['application-play']) || isset($options['application-bazar']) && !empty($options['application-bazar']) || isset($options['application-myket']) && !empty($options['application-myket']) || isset($options['application-sibapp']) && !empty($options['application-sibapp']) ):?>
				<section class="application" style="background-color:<?php echo $options['application-color'];?>;">
					<a href="<?php echo esc_url( home_url() ); ?>" class="app-logo">
						<img src="<?php echo $options['application-icon']; ?>" alt="<?php echo $options['general-title']; ?>" class="img-fluid">
						<p><?php echo __('Download Application','digix');?></p>
					</a>
					<div class="app-file">
						<?php if( isset($options['application-play']) && !empty($options['application-play'])):?>
							<a href="<?php echo $options['application-play'];?>" target="_blank"><img src="<?php echo DIGIX_IMG . 'play.svg';?>"></a>
						<?php endif;?>
						<?php if( isset($options['application-bazar']) && !empty($options['application-bazar'])):?>
							<a href="<?php echo $options['application-bazar'];?>" target="_blank"><img src="<?php echo DIGIX_IMG . 'bazar.svg';?>"></a>
						<?php endif;?>
						<?php if( isset($options['application-myket']) && !empty($options['application-myket'])):?>
							<a href="<?php echo $options['application-myket'];?>" target="_blank"><img src="<?php echo DIGIX_IMG . 'myket.svg';?>"></a>
						<?php endif;?>
						<?php if( isset($options['application-sibapp']) && !empty($options['application-sibapp'])):?>
							<a href="<?php echo $options['application-sibapp'];?>" target="_blank"><img src="<?php echo DIGIX_IMG . 'sibapp.svg';?>"></a>
						<?php endif;?>
					</div>
				</section>
			<?php endif; ?>
		<?php endif; ?>
		<?php if( isset($options['contact-instagram']) && !empty($options['contact-instagram']) || isset($options['contact-twitter']) && !empty($options['contact-twitter']) || isset($options['contact-telegram']) && !empty($options['contact-telegram']) || isset($options['contact-facebook']) && !empty($options['contact-facebook']) ):?>
			<section class="social">
				<p>
						<?php printf(
							__('Follow %s in social media','digix'),$options['general-title']
						);?>
					</p>
				<ul>
                    <?php if( isset($options['contact-instagram']) && !empty($options['contact-instagram'])):?>
                        <li class="instagram"><a href="<?php echo $options['contact-instagram'];?>"><i class="icon-instagram"></i></a></li>
                    <?php endif;?>
                    <?php if( isset($options['contact-twitter']) && !empty($options['contact-twitter'])):?>    
                        <li><a href="<?php echo $options['contact-twitter'];?>" data-toggle="tooltip" data-placement="top" title="<?php echo __('twitter','digix'); ?>"><i class="icon-twitter"></i></a></li>
                    <?php endif;?>
                    <?php if( isset($options['contact-telegram']) && !empty($options['contact-telegram'])):?>        
                        <li><a href="<?php echo $options['contact-telegram'];?>" data-toggle="tooltip" data-placement="top" title="<?php echo __('telegram','digix'); ?>"><i class="icon-telegram"></i></a></li>
                    <?php endif;?>
                    <?php if( isset($options['contact-facebook']) && !empty($options['contact-facebook'])):?>
                        <li><a href="<?php echo $options['contact-facebook'];?>" data-toggle="tooltip" data-placement="top" title="<?php echo __('facebook','digix'); ?>"><i class="icon-facebook"></i></a></li>
                    <?php endif;?>
                </ul>
			</section>
		<?php endif; ?>
		<?php if( isset($options['footer-newsletter']) && !empty($options['footer-newsletter'])):?>
        <section class="newsletter">
			<div class="newsletter-box">
				<p>
					<?php echo $options['footer-newsletterdesc'];?>
				</p>
				<?php echo do_shortcode($options['footer-newsletter']);?>
			</div> 
        </section>
        <?php endif;?>
		<section class="about">
			<?php 
				$server = (isset($_SERVER['HTTPS']) ? "https" : "http") . "://$_SERVER[HTTP_HOST]$_SERVER[REQUEST_URI]";
				$home   = esc_url( home_url() ).'/';
				if ( $server == $home ):?>
					<h1>
						<strong>
							<?php bloginfo('name'); ?>
						</strong>
					</h1>
			<?php
				else:?>
					<h2>
						<strong>
							<?php bloginfo('name'); ?>
						</strong>
					</h2>
			<?php 
				endif; ?>             
			<div class="description">
				<?php echo $options['footer-about'];?>
			</div>
		</section>
		<?php if( isset($options['footer-trust']) || isset($options['footer-saramad']) ):?>
			<section class="trust">
				<ul>
					<li>
						<?php echo $options['footer-trust'];?>
						<?php 
							if ( isset ( $options['footer-trust-shortcode'] ) && !empty ( $options['footer-trust-shortcode'] ) ){ 
								$namad_two = $options['footer-trust-shortcode']; echo do_shortcode($namad_two);
							} 
						?>
					</li>
					<li>
						<?php echo $options['footer-saramad'];?>
						<?php 
								if ( isset ( $options['footer-saramad-shortcode'] ) && !empty ( $options['footer-saramad-shortcode'] ) ){ 
									$namad_two = $options['footer-saramad-shortcode']; echo do_shortcode($namad_two);
								} 
							?>
					</li>
				</ul>
			</section>
		<?php endif;?>
		<?php //if (has_nav_menu('footer')) : ?>
			<section class="footer-navigation">
				<div class="mobtainer">
					<?php
						wp_nav_menu(array(
								'theme_location' => 'footer',
								'container' => false,
								'menu_id' => 'footer-menu',
								'menu_class' => 'menu',
								'depth' => 1,
							));
					?>
				</div>
			</section>
		<?php //endif;?>
		<?php if( isset($options['footer-copyright']) && !empty($options['footer-copyright'])):?>
			<section class="copyright" itemprop="copyrightHolder" itemscope itemtype="http://schema.org/Organization">
				<?php echo $options['footer-copyright'];?>
			</section>
    <?php endif;?>
	</div>
</footer>