<?php
/**
 * The Template for displaying product archives, including the main shop page which is a post type archive
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/archive-product.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 3.4.0
 */

defined( 'ABSPATH' ) || exit;
Global $options;
get_header();
$term = get_queried_object();
$children = get_terms( 
	$term->taxonomy, array(
	'parent'    => $term->term_id,
	'hide_empty' => false
) );
?>
<main class="main" role="main" itemscope itemprop="mainContentOfPage">
<?php if( !empty( $_GET['orderby'] ) ):?>
	<?php if( $_GET['orderby'] == 'on_sale' && ( ! is_product_category() && ! is_product_tag() ) ):?>
	<section class="on-sale-shape">
		<div class="container">
			<div class="onsale-text">
				<div class="title">فــــــــــروش ویـــــــــــژه</div>
				<div class="context">پیشنهادهای شگفت‌انگیز, تخفیف و حراج</div>
			</div>
		</div>
		<style>
			.on-sale-shape {
				padding-top: 15px;
				overflow: hidden;
				height: 150px;
				width: 100%;
				margin-top: 5px;
				border-radius: 30px;
				z-index: -10;
				background: #2833ff;
				background: -webkit-linear-gradient(to left, #2833ff, #1488CC);
				background: linear-gradient(to left, #2833ff, #1488CC);
			}
			.onsale-text .title {
				text-align: center;
				font-size: 30px;
				font-weight: bold;
				color: white;
				position: relative;
			}
			.onsale-text .context {
				font-size: 15px;
				color: white;
				text-align:center;
			}
			.on-sale .onsale-container {
				margin-top: -30px;
				position:relative;
			}
			.on-sale .onsale-container .woocommerce-breadcrumb {
				display:none;
			}
		</style>
	</section>
	<?php endif; ?>
<?php endif; ?>
	<div class="onsale-container mobtainer <?php if ( $options['woocommerce-childcat'] == 'yes' &&   is_product_category() && ( $children ) ){echo'bread-relative';}?>">
		<?php
    	// Only load product if search query isn't empty
    	if ( is_search() && ! get_search_query() ) { ?>
		<section class="search-query">
			<form class="search" role="search" method="get" data-custom-search="true" action="<?php echo esc_url( home_url( '/' ) ); ?>" >
				<input type="search" placeholder="<?php echo $options['search-title']; ?>" name="s">
				<input type="hidden" name="post_type" value="product">
				<button type="submit">
					<i class="icon-search"></i>
				</button>
			</form>
			<div class="empty-state">
			    <div class="content-block text-center">

			        <div class="empty-icon">
			        	<i class="icon-search-box"></i>
			        </div>
			        <h2><?php echo __( 'Search for products', 'digix' ); ?></h2>
			        <p><?php echo __( 'Click on the search bar above to start your search', 'digix' ); ?></p>

			    </div>
			</div>
		</section>
    	<?php
    		//return;
    	}else{
    	?>
		<?php
		/**
		 * Hook: woocommerce_before_main_content.
		 *
		 * @hooked woocommerce_output_content_wrapper - 10 (outputs opening divs for the content)
		 * @hooked woocommerce_breadcrumb - 20
		 * @hooked WC_Structured_Data::generate_website_data() - 30
		 * @hooked woocommerce_output_all_notices - 40
		 */
		do_action( 'woocommerce_before_main_content' );
		?>
		<section class="wc-archive">
			<div class="wc-content">
				<section class="digix-product woocommerce-archive">
					<section class="archive-filter">
						<button class="left" type="button" data-toggle="modal" data-target="#digix-filter"><i class="icon-sort"></i>فیلتر کردن</button>
						<button class="right" type="button" data-toggle="modal" data-target="#digix-catelog"><i class="icon-spreadsheet-app"></i>مرتب سازی</button>
					</section>
					
				<?php
				if ( woocommerce_product_loop() ) {

					/**
					 * Hook: woocommerce_before_shop_loop.
					 *
					 * @hooked woocommerce_result_count - 20
					 * @hooked woocommerce_catalog_ordering - 30
					 */
					do_action( 'woocommerce_before_shop_loop' );
					echo'<div class="element-product">';
					woocommerce_product_loop_start();

					if ( wc_get_loop_prop( 'total' ) ) {
						while ( have_posts() ) {
							the_post();

							/**
							 * Hook: woocommerce_shop_loop.
							 */
							do_action( 'woocommerce_shop_loop' );
							
							wc_get_template_part( 'content', 'product' );
						}
					}

					woocommerce_product_loop_end();
					echo'</div>';
					/**
					 * Hook: woocommerce_after_shop_loop.
					 *
					 * @hooked woocommerce_pagination - 10
					 */
					do_action( 'woocommerce_after_shop_loop' );
				} else {
					/**
					 * Hook: woocommerce_no_products_found.
					 *
					 * @hooked wc_no_products_found - 10
					 */
					do_action( 'woocommerce_no_products_found' );
				}?>
				</section>
				
				<?php

				/**
				 * Hook: woocommerce_after_main_content.
				 *
				 * @hooked woocommerce_output_content_wrapper_end - 10 (outputs closing divs for the content)
				 */
				do_action( 'woocommerce_after_main_content' );
				?>
			</div>
		</section>
		<?php
		$description = wc_format_content( term_description() );
        if ( !empty( $description ) ) { ?>
		<section class="wc-archive-description">
			<?php if ( apply_filters( 'woocommerce_show_page_title', true ) ) : ?>
				<header class="woocommerce-products-header">
					<h1 class="woocommerce-products-header__title page-title m-0"><?php woocommerce_page_title(); ?></h1>
				</header>
			<?php endif; ?>
			<?php
			/**
			 * Hook: woocommerce_archive_description.
			 *
			 * @hooked woocommerce_taxonomy_archive_description - 10
			 * @hooked woocommerce_product_archive_description - 10
			 */
			do_action( 'woocommerce_archive_description' );
			?>
		</section>

		<?php } }?>	
	</div>
</main>

<?php
get_footer();
