<?php
/**
 * Single Product tabs
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/single-product/tabs/tabs.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 3.8.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Filter tabs and allow third parties to add their own.
 *
 * Each tab is an array containing title, callback and priority.
 *
 * @see woocommerce_default_product_tabs()
 */
$product_tabs = apply_filters( 'woocommerce_product_tabs', array() );

global $post;
global $product;
global $woocommerce;
$attributes = $product->get_attributes();
$export = get_the_excerpt( $product->get_id());
$the_content = get_the_content();
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
$review_count = $product->get_review_count();
$meta = get_post_meta( get_the_ID(), 'digix_metabox', true );
if (is_array($meta)):
$label_1 = $meta['range1']['name'];
$label_2 = $meta['range2']['name'];
$label_3 = $meta['range3']['name'];
$label_4 = $meta['range4']['name'];
$label_5 = $meta['range5']['name'];
endif;

if ( ! empty( $product_tabs ) ) : ?>

		<section class="mobile-product-tab">
			<div class="product-tab-nav">
				<ul class="tab-list">
					<?php foreach ( $product_tabs as $key => $product_tab ) :?>
						<li class="tab-item <?php echo esc_attr( $key ); ?>_tab" id="tab-title-<?php echo esc_attr( $key ); ?>">
							<header class="tab-header">
								<h4><?php echo wp_kses_post( apply_filters( 'woocommerce_product_' . $key . '_tab_title', $product_tab['title'], $key ) ); ?></h4>
								
								<?php if( $key != 'reviews'):?>
									<button type="button" data-toggle="modal" data-target="#digix-<?php echo esc_attr( $key ); ?>" class="more-toggle"><span><?php echo __('Show More','digix'); ?></span> <i class="icon-offshare"></i></button>
								<?php else: ?>
									<button type="button" data-toggle="modal" data-target="#digix-write-review" class="more-toggle"><?php echo __('Add New Comment','digix'); ?> <i class="icon-pen"></i></button>
								<?php endif; ?>
							</header>
							<figure class="tab-content <?php if( $key == 'reviews'){ echo'review-tab-content';}?>">
							<?php if( $key != 'reviews'):?>
								<?php
								if ( isset( $product_tab['callback'] ) ) {
									call_user_func( $product_tab['callback'], $key, $product_tab );
								}
								?>
							<?php else: ?>
								<section class="digix-wc-review">
									<header class="review-header">
										<div class="user-rate">
											<span class="rate-title">
												
											</span>
											<span class="average-rate">
												<?php echo __('rate users to ','digix') . esc_html( get_the_title() ) . ': ';?><span><?php echo (!empty($product->get_average_rating())) ? $product->get_average_rating() : '0'; ?></span><?php echo __('of the total ','digix'); ?><span><?php echo (!empty($product->get_rating_counts())) ? $product->get_rating_counts()[5] : '0'; ?></span><?php echo __('comment','digix'); ?>
											</span>
										</div>
										<div class="product-review-detailes">
											<div class="rate-list">
												<?php if(!empty($meta['range1']['name'])): ?>
												<div class="rate-item">
													<b><?php echo $label_1; ?></b>
													<div class="rate-content">
														<div class="rate-result" style="width:<?php echo $meta['range1']['slider']; ?>%"></div>
													</div>
												</div>
												<?php endif; ?>
												<?php if(!empty($meta['range2']['name'])): ?>
												<div class="rate-item">
													<b><?php echo $label_2; ?></b>
													<div class="rate-content">
														<div class="rate-result" style="width:<?php echo $meta['range2']['slider']; ?>%"></div>
													</div>
												</div>
												<?php endif; ?>
												<?php if(!empty($meta['range3']['name'])): ?>
												<div class="rate-item">
													<b><?php echo $label_3; ?></b>
													<div class="rate-content">
														<div class="rate-result" style="width:<?php echo $meta['range3']['slider']; ?>%"></div>
													</div>
												</div>
												<?php endif; ?>
												<?php if(!empty($meta['range4']['name'])): ?>
												<div class="rate-item">
													<b><?php echo $label_4; ?></b>
													<div class="rate-content">
														<div class="rate-result" style="width:<?php echo $meta['range4']['slider']; ?>%"></div>
													</div>
												</div>
												<?php endif; ?>
												<?php if(!empty($meta['range5']['name'])): ?>
												<div class="rate-item">
													<b><?php echo $label_5; ?></b>
													<div class="rate-content">
														<div class="rate-result" style="width:<?php echo $meta['range5']['slider']; ?>%"></div>
													</div>
												</div>
												<?php endif; ?>
											</div>
										</div>
									</header>
								</section>
								<?php endif; ?>
							</figure>
							<?php if( $key == 'reviews'){echo'<button class="more-review" type="button" data-toggle="modal" data-target="#digix-' . esc_attr( $key ). '">مشاهده همه  ' . $review_count . ' نظرات کاربران<i class="icon-offshare"></i></button>';}?>
						</li>
					<?php endforeach; ?>
				</ul>
			</div>

			<?php foreach ( $product_tabs as $key => $product_tab ) : ?>
			<div class="modal fade toggle-tab" id="digix-<?php echo esc_attr( $key ); ?>">
			  <div class="modal-dialog">
				<div class="modal-content">

				  <!-- Modal Header -->
				  <div class="modal-header">
					<h4 class="modal-title"><?php echo wp_kses_post( apply_filters( 'woocommerce_product_' . $key . '_tab_title', $product_tab['title'], $key ) ); ?></h4>
					<button type="button" class="close" data-dismiss="modal"><?php echo __('Back','digix'); ?><i class="icon-arrow-left"></i></button>
				  </div>

				  <!-- Modal body -->
				  <div class="modal-body">
					<?php
								if ( isset( $product_tab['callback'] ) ) {
									call_user_func( $product_tab['callback'], $key, $product_tab );
								}
								?>
				  </div>

				  <!-- Modal footer -->
				  <div class="modal-footer">
					<button type="button" class="btn btn-danger w-100" data-dismiss="modal"><?php echo __('Close','digix');?></button>
				  </div>

				</div>
			  </div>
			</div>

			<?php endforeach; ?>
			<div class="modal fade toggle-tab" id="digix-write-review">
			  <div class="modal-dialog">
				<div class="modal-content">

				  <!-- Modal Header -->
				  <div class="modal-header">
					<h4 class="modal-title"><?php echo __('Add New Comment','digix'); ?></h4>
					<button type="button" class="close" data-dismiss="modal"><?php echo __('Back','digix'); ?><i class="icon-arrow-left"></i></button>
				  </div>

				  <!-- Modal body -->
				  <div class="modal-body">
				  <section class="digix-wc-review">
					<?php if ( get_option( 'woocommerce_review_rating_verification_required' ) === 'no' || wc_customer_bought_product( '', get_current_user_id(), $product->get_id() ) ) : ?>
					
						<?php
							if (is_user_logged_in()) {
							?>
								<div class="review-entry" id="review-box">
									<div class="review-box">

										<?php
										$commenter    = wp_get_current_commenter();
										$comment_form = array(
											'title_reply'         => '',
											'title_reply_to'      => '',
											'title_reply_before'  => '',
											'title_reply_after'   => '',
											'comment_notes_after' => '',
											'label_submit'        => esc_html__('Submit', 'woocommerce'),
											'logged_in_as'        => '',
											'comment_field'       => '<section class="comment-form-comment"><label for="comment">' . esc_html__( 'Your review', 'woocommerce' ) . '&nbsp;</label><textarea id="comment" name="comment" cols="30" rows="10"></textarea></section>',
											'comment_notes_before' => '',
										);
										
										$name_email_required = (bool) get_option('require_name_email', 1);
										$fields              = array();

										$comment_form['fields'] = array();

										foreach ($fields as $key => $field) {
											$field_html  = '<div class="col-6"><div class="vitrin-product-comments-area-field">';
											$field_html .= '<label for="' . esc_attr($key) . '">' . esc_html($field['label']);

											if ($field['required']) {
												$field_html .= '&nbsp;<span class="required">*</span>';
											}

											$field_html .= '</label><input id="' . esc_attr($key) . '" name="' . esc_attr($key) . '" type="' . esc_attr($field['type']) . '" value="' . esc_attr($field['value']) . '" ' . ($field['required'] ? 'required' : '') . ' /></div></div>';

											$comment_form['fields'][$key] = $field_html;
										}

										$comment_form['fields']['cookies'] = '';
										?>

											<div class="review-wrapper">
												<?php
												comment_form(apply_filters('woocommerce_product_review_comment_form_args', $comment_form));
												?>
											</div>
									</div>
								</div>
							<?php
							} else {
							?>
								<section class="review-first-login">
									<?php printf(__("<p>To post a comment, you must first log in to your account</p><a href='%s'>Login to account</a>","digix"),wc_get_page_permalink('myaccount') );?>
								</section>
							<?php
							}
							?>

					<?php else : ?>

						<p class="woocommerce-verification-required"><?php _e( 'Only logged in customers who have purchased this product may leave a review.', 'woocommerce' ); ?></p>

					<?php endif; ?>
					</section>
				  </div>

				  <!-- Modal footer -->
				  <div class="modal-footer">
					<button type="button" class="btn btn-danger w-100" data-dismiss="modal"><?php echo __('Close','digix');?></button>
				  </div>

				</div>
			  </div>
			</div>
		</section>

		<?php do_action( 'woocommerce_product_after_tabs' ); ?>


<?php endif; ?>
