<?php
/**
 * Single Product title
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/single-product/title.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 4.4.0
 */
Global $product;
Global $post;
$meta = get_post_meta( get_the_ID(), 'digix_metabox', true );
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}
$terms       = get_the_terms( $post->ID, 'product_brand' );
$brand_count = is_array( $terms ) ? sizeof( $terms ) : 0;

$taxonomy    = get_taxonomy( 'product_brand' );
$labels      = $taxonomy->labels;
if ( class_exists( 'WeDevs_Dokan' ) ){
    $author     = get_user_by( 'id', $post->post_author );
    $store_info = dokan_get_store_info( $author->ID );
}
?>
<figure class="digix-single-product-title">
    <h1 class="product_title entry-title">
        <strong>
            <?php echo esc_html( get_the_title() ); ?>
        </strong>
    </h1>
    <?php if( !empty($meta['subtitle']) ): ?>
        <span class="subtitle">
            <?php echo $meta['subtitle']; ?>
        </span>
    <?php endif; ?>
	<div class="pitem">
		
		<?php
		if ( ! wc_review_ratings_enabled() ) {
			return;
		}

		$rating_count = $product->get_rating_count();
		$review_count = $product->get_review_count();
		$average      = $product->get_average_rating();

		if ( $rating_count > 0 ) : ?>

			<div class="woocommerce-product-rating">
			<i class="icon-star"></i>
				<span>(<?php printf( _n( '%s review', '%s reviews', $review_count, 'digix' ), '<span class="count">' . esc_html( $review_count ) . '</span>' ); ?>)</span>
			</div>

		<?php endif; ?>
		</div>
</figure>
<section class="pro-detailes">
	<figure class="digix-product-stock">
		<div class="product-brand">
			<?php echo get_brands( $post->ID, ', ', ' <span class="posted_in">' . sprintf( _n( '%1$s: ', '%2$s: ', $brand_count ), $labels->singular_name, $labels->name ), '</span>' ); ?>
		</div>
		<div class="digix-product-status">
			<span><?php echo __( "Status: ", "digix" ); ?></span>
			<?php if ( ! $product->is_in_stock() ) {echo '<span class="out-stock">' . __( "Out Of Stock", "digix" ) . '</span>';}else{echo '<span class="in-stock">' . __( "in Stock", "digix" ) . '</span>';} ?>
		</div>
		<?php if ( class_exists( 'WeDevs_Dokan' ) ){ ?>
			<div class="seller-select">
				<span><?php echo __( ' Seller: ', 'digix' ); ?></span> 
				<?php printf( '<a href="%s">%s</a>', esc_url( dokan_get_store_url( $author->ID ) ), esc_html( $store_info['store_name'] ) ); ?>
			</div>
		<?php } ?>
	</figure>
	<div class="product_meta">

		<?php do_action( 'woocommerce_product_meta_start' ); ?>

		<?php echo wc_get_product_category_list( $product->get_id(), ' / ', '<span class="posted_in"><b>' . _n( 'Category:', 'Categories:', count( $product->get_category_ids() ), 'woocommerce' ) . '</b> ', '</span>' ); ?>

		<?php echo wc_get_product_tag_list( $product->get_id(), ', ', '<span class="tagged_as"><b>' . _n( 'Tag:', 'Tags:', count( $product->get_tag_ids() ), 'woocommerce' ) . ' </b>', '</span>' ); ?>

		<?php do_action( 'woocommerce_product_meta_end' ); ?>

	</div>

</section>
<?php
	$meta = get_post_meta( get_the_ID(), 'digix_metabox', true );
	Global $options;
	if( !empty($options['woocommerce-delivery-home']) || !empty($options['woocommerce-delivery-other'])){
		echo '<section class="delivery-time"><span>'. $options['woocommerce-delivery-home'] . '</span><span>'. $options['woocommerce-delivery-other'] . '</span></section>';
	}
	if(!empty($meta['customer-free-switcher'])){
		if($meta['customer-free-switcher'] == true){
			echo'<div class="ShippingCondition">';
				echo'<ul class="list">';
					foreach($meta['customer-free'] as $item){
						$img = ! empty( $item['pic'] ) ? '<img src="' . $item['pic'] . '" class="img-fluid" width="20" height="20">' : '';
						echo'<li class="item">' . $img . '<span class="label">' . $item['label'] . '</span> <span class="value">' . $item['value'] . '</span></li>';
					}
				echo'</ul>';
			echo'</div>';
		}
    }
  ?>
