<?php
/*
Plugin Name: موبیکس( نسخه موبایل دیجیکس)
Plugin URI: https://avawp.com
Description: Digix is a complete mobile solution, packed with powerful features that are designed to push your WooCommerce store to another level.
Version: 2.9.1
Author: Hosein ghasemi
Author URI: avawp.com
*/


if ( ! defined( 'WPINC' ) ) die;
if ( ! class_exists( 'DIGIX_Core' ) ) die;	

// Set the version
define( 'MOBIX_VERSION', '1' );



class DIGIX_Core {

	protected static $instance = null;
	protected $globals;

	protected static $plugin_name 			= 'Mobix';
	protected static $plugin_slug 			= 'Mobix';
	protected static $theme_folder_name		= 'Mobix';

	protected $plugin_dir;
	protected $plugin_path;
	protected $plugin_url;

	public function __construct() {
		add_action( 'setup_theme', array($this, 'load_digix_theme') );
	}


	/**
	 * Set the instance
	*/
	public static function instance() {
		static $globals;
		if ( self::$instance == null ) {
			self::$instance = new self;
			$globals = self::$instance->set_globals();
		}
		return $globals;
	}


	/**
	 * Set Globals
	*/
	public function set_globals() {
		$this->plugin_file = __FILE__;
		$this->plugin_dir = dirname( plugin_basename( $this->plugin_file ) );
		$this->plugin_path = plugin_dir_path( $this->plugin_file );
		$this->plugin_url =	plugin_dir_url( $this->plugin_file );

		$globals = array (
			'plugin_name' 			=> self::$plugin_name,
			'plugin_slug' 			=> self::$plugin_slug,
			'plugin_dir' 			=> $this->plugin_dir,
			'plugin_path' 			=> $this->plugin_path,
			'plugin_url'			=> $this->plugin_url,
			'theme_folder_name'		=> self::$theme_folder_name
		);
		
		$this->globals = $globals;
		return $globals;
	}

	/**
	 * Load necessary files
	*/
	public function load_digix_theme() {
		if ( ! is_admin() ) {

			// Check if WooCommerce is active
			if ( class_exists( 'WooCommerce' ) ) {

				include_once( $this->globals['plugin_path'] . 'includes/class-mobile-detect.php' );
				$detect_device = new Mobile_Detect;

				// Load for mobile
					if ( $detect_device->isMobile() ) {
						$call_1 = function( $t ){
							return $this->globals['theme_folder_name'];
						};
						$call_2 = function( $s ){
							return $this->globals['theme_folder_name'];
						};
						add_filter('template', $call_1 );
						add_filter('stylesheet', $call_2 );
					
					}

				// Load for tablets
					if ( $detect_device->isTablet() ) {

						$call_1 = function( $t ){
							return $this->globals['theme_folder_name'];
						};
						$call_2 = function( $s ){
							return $this->globals['theme_folder_name'];
						};
						add_filter('template', $call_1 );
						add_filter('stylesheet', $call_2 );
					
					}
			}

		}
	}
}

DIGIX_Core::instance();
if( !function_exists( 'codepeople_theme_switch_register' ) )
{
	function codepeople_theme_switch_register( $new_name, $new_theme, $old_theme )
	{
		if(empty($GLOBALS['codepeople_mobile_switch_theme_flag']))
			set_transient( 'codepeople_theme_switch_registered', $new_theme->stylesheet, 0 );
	}
}

add_action('switch_theme', 'codepeople_theme_switch_register', 10, 3);
add_action( 'setup_theme', 'codepeople_mobile_switch_theme_by_device' );


/**
 * Tell Wordpress to switch the theme based in the device where the webpage is loaded.
 */
if(!function_exists("codepeople_mobile_switch_theme_by_device")){
	function codepeople_mobile_switch_theme_by_device()
	{
		if(is_admin()) return;

		$theme = wp_get_theme();
		if( get_transient( 'codepeople_theme_switch_registered' ) == false )
		{
			set_transient( 'codepeople_theme_switch_registered', $theme->stylesheet, 0 );
		}
		if(
			get_transient('codepeople_theme_switch_theme_'.$theme->stylesheet) == false &&
			function_exists('wp_get_sidebars_widgets')
		)
		{
			$sidebars_widgets = wp_get_sidebars_widgets();
			set_transient('codepeople_theme_switch_theme_'.$theme->stylesheet, $sidebars_widgets, 0);
		}
		if(empty($switch_stylesheet)) $switch_stylesheet = get_transient( 'codepeople_theme_switch_registered' );

		// Replaces the theme
		if(!empty($switch_stylesheet) && $theme->stylesheet != $switch_stylesheet)
		{
			switch_theme($switch_stylesheet);
			$sidebars_widgets = get_transient('codepeople_theme_switch_theme_'.$switch_stylesheet);
			if(
				$sidebars_widgets &&
				function_exists('wp_set_sidebars_widgets')
			) wp_set_sidebars_widgets($sidebars_widgets);
		}
		
	}
}