<?php
/**
* Plugin Name: MOBIX-SMS
* Plugin URI: https://avawp.com/mobix
* Author: Hosein Ghasemi
* Version: 2.9.1
* Text Domain: mobix
* Domain Path: /languages
* Author URI: https://avawp.com/
* Description: Allow users to login with OTP ( sent on their phone ) therefore removing the need to remember a password.
* Tags: woocommerce, OTP Login, mobile login woocommerce, phone login, signup
*/

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
if ( ! defined( 'MOBIX_DIR' ) ) {
	define( 'MOBIX_DIR', plugin_dir_path( __FILE__ ) );
}
if ( ! defined( 'MOBIX_URI' ) ) {
	define( 'MOBIX_URI', plugin_dir_url( __FILE__ ) );
}

if ( ! class_exists( 'MOBIX_Init' ) ) {
	/**
	 * This class is the main plugin file.
	 */
	class MOBIX_Init {

		/**
		 * The database version used.
		 *
		 * @var string $db_version Current Version.
		 */
		public $db_version = '1.0';

		/**
		 * MOBIX_Init constructor.
		 */
		public function __construct() {
			require_once 'includes/framework/codestar-framework.php';
			require_once 'includes/settings.php';
			$mobix_otp = get_option( 'mobixOtp' );
			global $mobix_otp;
            // common - use on backend and on frontend.
            require_once 'includes/mobix-functions.php';
            
            require_once 'includes/findMobileByUserMetas.php';
            
			add_action( 'plugins_loaded', array( $this, 'on_plugins_loaded' ) );
			/**
			 * Check if WooCommerce is installed and active.
			 */
			if ( in_array( 'woocommerce/woocommerce.php', apply_filters( 'active_plugins', get_option( 'active_plugins' ) ), true ) ) {
				$this->init();
			} else {
				add_action( 'admin_notices', array( $this, 'admin_notice' ) );
			}

			register_activation_hook( __FILE__, array( $this, 'setup_table' ) );
		}

		/**
		 * This function will create require extra table(s).
		 */
		public function setup_table() {
			$mobix_db_version = get_option( 'mobix_db_version' );

			if ( ! $mobix_db_version || empty( $mobix_db_version ) ) {
				mobix_create_user_phone_table();
				update_option( 'mobix_db_version', $this->db_version );
			}
		}

		/**
		 * Remove some extra hooks and add some hooks that are requires.
		 *
		 * @return bool Check the dependencies and return true or false.
		 */
		public function on_plugins_loaded() {
			if ( ! class_exists( 'woocommerce' ) ) {
				add_action( 'admin_notices', array( $this, 'admin_notice' ) );
				return false;
			}
			return true; // House Keeping.
		}

		/**
		 * This function will load all the required classes and files. Moreover, it will run only if dependency check is true.
		 */
		public function init() {
			/**
			* Load language.
			*/
			if ( function_exists( 'load_plugin_textdomain' ) ) {
				load_plugin_textdomain( 'mobix', false, dirname( plugin_basename( __FILE__ ) ) . '/languages/' );
			}

			if ( ! is_admin() ) {
				// For client only.
				require_once 'includes/class-mobix-frontend.php';
			}
		}

		/**
		 * Display notices for the plugin dependency.
		 */
		public function admin_notice() {
			global $pagenow;
			if ( 'plugins.php' === $pagenow ) {
				$class   = esc_attr( 'notice notice-error is-dismissible' );
				$message = esc_html__( 'Mobile Login and Registration needs WooCommerce to be installed and active.', 'mobix' );
				printf( '<div class="%1$s"><p>%2$s</p></div>', esc_attr( $class ), $message );
			}
		}
	}
	
	new MOBIX_Init();
}
