<?php

class Mobix_smsir extends MobixSms {
	public function send() {
		Global $mobix_otp;
		$messageContent = $this->message;	
		$to             = $this->to;
		$api      		= $mobix_otp['otp_smsir']['api'];
		$pid      		= $mobix_otp['otp_smsir']['pid'];
		$curl     		= curl_init();
		$api_url  		='https://api.sms.ir/v1/send/verify';
		curl_setopt_array($curl, array(
		CURLOPT_URL => $api_url,
		CURLOPT_RETURNTRANSFER => true,
		CURLOPT_ENCODING => '',
		CURLOPT_MAXREDIRS => 10,
		CURLOPT_TIMEOUT => 0,
		CURLOPT_FOLLOWLOCATION => true,
		CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
		CURLOPT_CUSTOMREQUEST => 'POST',
		CURLOPT_POSTFIELDS =>'{
			"mobile": "'.$to.'",
			"templateId": '.$pid.',
			"parameters": [
			  {
				"name": "otp",
				"value": "'.$messageContent.'"
			  }
			]
		  }',
			CURLOPT_HTTPHEADER => array(
			  "Content-Type: application/json",
			  "Accept: text/plain",
			  "x-api-key: $api"
			),
		  ));
		$response = json_decode(curl_exec($curl));
		if ( 1 === $response ->status ) {
			set_transient( $to, $messageContent, 600 );
			$status = 'success';
		} else {
			$status = 'failed';
			$msg    = '4' === $response ->status ? __(' : Bad Credentials', 'mobix') : __('error code: ','mobix') . $result;
		}
		wp_send_json_success(
			array(
				'status' => $status,
				'msg'    => $msg,
			)
		);
	}
}
