<?php
/**
 * Login form
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/global/form-login.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see         https://docs.woocommerce.com/document/template-structure/
 * @package     WooCommerce/Templates
 * @version     3.6.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

if ( is_user_logged_in() ) {
	return;
}
Global $mobix_otp;
?>
<form class="woocommerce-form ml-form woocommerce-form-login login" method="post" <?php echo ( $hidden ) ? 'style="display:none;"' : ''; ?> name="login">

	<?php do_action( 'woocommerce_login_form_start' ); ?>

    <?php echo ($message) ? wpautop(wptexturize($message)) : ''; // @codingStandardsIgnoreLine ?>

	<p class="form-row form-row-first wc-pv-phone wc-pv-intl">
		<label for="username"><?php esc_html_e( 'Phone Number', 'woocommerce' ); ?>&nbsp;<span
					class="required">*</span></label>
		<?php if ( $mobix_otp['register-country'] === '1' ):?>
			<?php $default_cc = $mobix_otp['register-country-custom'];$cc_list = include MOBIX_DIR.'/countries/phone.php'; ?>
			<select class="mobix-phone-cc" name="mobix-reg-phone-cc">

				<option disabled><?php echo __( 'Select Country Code', 'mobix' ); ?></option>

				<?php foreach( $cc_list as $country_code => $country_phone_code ): ?>

					<option value="<?php echo $country_phone_code; ?>" <?php echo $country_phone_code === $default_cc ? 'selected' : ''; ?> data-cc="<?php echo $country_code ?>"><?php echo $country_code.' '.$country_phone_code; ?></option>

				<?php endforeach; ?>

			</select>
		<?php else: ?>
			<input type="hidden" class="input-text" name="mobix-reg-phone-cc" id="mobix-reg-phone-cc" value="<?php echo $mobix_otp['register-country-custom']; ?>" placeholder="<?php echo $mobix_otp['register-country-custom']; ?>" />
		<?php endif; ?>
		<input type="text" class="input-text" name="phone" id="reg_phone" autocomplete="phone" value="<?php echo ( ! empty( $_POST['phone'] ) ) ? esc_attr( wp_unslash( $_POST['phone'] ) ) : ''; ?>" placeholder="شماره موبایل خود را وارد نمایید..."/>
	</p>
	<div class="clear"></div>

	<?php do_action( 'woocommerce_login_form' ); ?>

	<p class="form-row">
		<?php wp_nonce_field( 'woocommerce-login', 'woocommerce-login-nonce' ); ?>
		<input type="hidden" name="redirect" value="<?php echo esc_url( $redirect ); ?>"/>
	</p>
	<div class="clear"></div>
</form>
