<section class="digix-wc-login digix-form">

		<h2><?php esc_html_e( 'Login', 'woocommerce' ); ?></h2>
		<?php if ( isset( $options['general-logo'] ) && !empty( $options['general-logo'] ) ):?>
			<a href="<?php echo esc_url( home_url() ); ?>" class="im-uri" itemscope itemtype="http://schema.org/Organization" itemprop="url">
							
				<img src="<?php echo $options['general-logo']; ?>" alt="<?php echo $options['general-title']; ?>" class="img-fluid" itemprop="logo">
			
			</a>
		<?php endif; ?>
		<form class="woocommerce-form woocommerce-form-login login" method="post">

			<?php do_action( 'woocommerce_login_form_start' ); ?>

			<p class="woocommerce-form-row woocommerce-form-row--wide form-row form-row-wide">
				<label for="username"><?php esc_html_e( 'Username or email address', 'woocommerce' ); ?>&nbsp;<span class="required">*</span><i class="icon-user"></i></label>
				<input type="text" class="woocommerce-Input woocommerce-Input--text input-text" name="username" id="username" autocomplete="username" value="<?php echo ( ! empty( $_POST['username'] ) ) ? esc_attr( wp_unslash( $_POST['username'] ) ) : ''; ?>" /><?php // @codingStandardsIgnoreLine ?>
			</p>
			<p class="woocommerce-form-row woocommerce-form-row--wide form-row form-row-wide">
				<label for="password"><?php esc_html_e( 'Password', 'woocommerce' ); ?>&nbsp;<span class="required">*</span><i class="icon-key"></i></label>
				<input class="woocommerce-Input woocommerce-Input--text input-text" type="password" name="password" id="password" autocomplete="current-password" />
			</p>

			<?php do_action( 'woocommerce_login_form' ); ?>

			<p class="form-row remember">
				<label class="woocommerce-form__label woocommerce-form__label-for-checkbox woocommerce-form-login__rememberme">
					<input class="woocommerce-form__input woocommerce-form__input-checkbox" name="rememberme" type="checkbox" id="rememberme" value="forever" /> <span><?php esc_html_e( 'Remember me', 'woocommerce' ); ?></span>
				</label>
				<?php wp_nonce_field( 'woocommerce-login', 'woocommerce-login-nonce' ); ?>
				<button type="submit" class="woocommerce-button button woocommerce-form-login__submit<?php echo esc_attr( wc_wp_theme_get_element_class_name( 'button' ) ? ' ' . wc_wp_theme_get_element_class_name( 'button' ) : '' ); ?>" name="login" value="<?php esc_attr_e( 'Log in', 'woocommerce' ); ?>"><?php esc_html_e( 'Log in', 'woocommerce' ); ?></button>
			</p>
			<p class="woocommerce-LostPassword lost_password">
				<a href="<?php echo esc_url( wp_lostpassword_url() ); ?>"><?php esc_html_e( 'Lost your password?', 'woocommerce' ); ?></a>
			</p>
			

			<?php do_action( 'woocommerce_login_form_end' ); ?>

		</form>
		<div class="digix-default-form <?php echo $class; ?>">
			<?php 
			$register = get_permalink( get_option('woocommerce_myaccount_page_id') ) . '?action=register';
			$phone = get_permalink( get_option('woocommerce_myaccount_page_id') );
			if($mobix_otp['register-default-form'] === '1'){
				echo "<a class='lg' href='" . $register . "' style='color:".$mobix_otp['mobix_log_color'].";border-color:".$mobix_otp['mobix_log_color'].";'>" . $mobix_otp['mobix_reg_email']. "</a>";
			}
			echo "<a class='rg' href='" . $phone. "' style='color:".$mobix_otp['mobix_reg_color'].";border-color:".$mobix_otp['mobix_reg_color'].";'>" . $mobix_otp['mobix_phone']. "</a>";
			?>
		</div>
	</section>