<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( ! class_exists( 'WC_Shipping_Iran_Paskeraye' ) ) {
	class WC_Shipping_Iran_Paskeraye extends WC_Shipping_Method {
		
		/**
		 * Constructor for shipping class
		 *
		 * @access public
		 * @return void
		 */
		public function __construct() {
			$this->id                 = 'iran_paskeraye_shipping'; // Id for your shipping method. Should be uunique.
			$this->method_title       = 'پس کرایه';  // Title shown in admin
			$this->method_description = '<h3>روش حمل توسط شرکتهای ارسال مرسولات پستی به صورت پس کرایه</h3>
			<p style="text-align: justify;">توسط این روش شما می توانید بسته مورد نظر خود را توسط هر یک از شرکت های ارسال مرسولات پستی، که پرداخت حمل و نقل را به صورت پس کرایه قبول می کنند، ارسال نمایید. توجه داشته باشید که شرایط خدمات این شرکت ها را مطالعه و قبل از سفارش گیری در نظر داشته باشید.
			<a href="https://parsmizban.com" target="_blank">جهت مشاهده دیگر افزونه های ایجاد شده ما و دیگر سرویس های ما اینجا را کلیک نمائید.</a></p>'; // Description shown in admin
			$this->init();
		}

		/**
		 * Init your settings
		 *
		 * @access public
		 * @return void
		 */
		function init() {
			// Load the settings API
			$this->init_form_fields(); // This is part of the settings API. Override the method to add your own settings
			$this->init_settings(); // This is part of the settings API. Loads settings you previously init.

			// Define user set variables
			$this->enabled					= $this->get_option( 'enabled' );
			$this->title							= $this->get_option( 'title' );
			$this->minimum_weight		= $this->get_option( 'minimum_weight' );
			$this->current_weight_unit	= get_option('woocommerce_weight_unit'); // g or kg

			// Save settings in admin if you have any defined
			add_action( 'woocommerce_update_options_shipping_' . $this->id, array( $this, 'process_admin_options' ) );
		}

		/**
		 * Initialise Gateway Settings Form Fields
		 *
		 * @access public
		 * @return void
		 */
		public function init_form_fields() {
			$this->form_fields = array(
				'enabled' => array(
					'title' 		=> 'فعال/غیر فعال',
					'type' 			=> 'checkbox',
					'label' 		=> 'فعال کردن این روش حمل و نقل',
					'default' 		=> 'no',
				),
				'title' => array(
					'title' 		=> 'عنوان روش',
					'type' 			=> 'text',
					'description' 	=> 'این گزینه عنوان را کنترل می کند که کاربر در طول تسویه حساب مشاهده می کند. می توانید در این قسمت نام شرکت ارسال کننده مرسوله را ذکر نمایید.',
					'default'		=> 'نام شرکت (هزینه کرایه حمل، در هنگام تحویل، دریافت می شود)',
					'desc_tip'		=> true
				),
				'minimum_weight' => array(
					'title' 		=> 'فعال فقط برای وزن بیشتر یا برابر با این مقدار (مقدار به گرم)',
					'type' 			=> 'text',
					'description' 	=> 'اگر این مقدار را وارد نمایید، این روش حمل، فقط برای مجموع وزن بیشتر یا برابر با این مقدار فعال خواهد شد.',
					'default'		=> '',
					'desc_tip'		=> true
				)
			);
		}

		/**
		 * calculate_shipping function.
		 *
		 * @access public
		 * @param mixed $package
		 * @return void
		 */
		public function calculate_shipping( $package = array() ) {
			global $woocommerce;
			$shipping_total = 0;
			
			$cart_weight = $woocommerce->cart->cart_contents_weight;

			//convert current weight unit to gram
			if ($this->current_weight_unit == 'kg') {
				$cart_weight = $cart_weight * 1000;
			}
			
			// detect the weight plan
			if ( $this->minimum_weight == '' or ($this->minimum_weight = intval($this->minimum_weight) and $cart_weight >= $this->minimum_weight) ){

				// Register the rate
				$rate = array(
					'id' => $this->id,
					'label' => $this->title,
					'cost' => $shipping_total,
					'calc_tax' => 'per_order'
				);
				$this->add_rate( $rate );

			}
			
		}
	}
}

function iran_paskeraye_shipping( $methods ) {
	$methods[] = 'WC_Shipping_Iran_Paskeraye';
	return $methods;
}

add_filter( 'woocommerce_shipping_methods', 'iran_paskeraye_shipping' );
